const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
const request = require("request");
var app = express();
app.use(bodyparser.json());

const baseUrl = 'http://localhost:4219/';

function getAuthKey(idaccount, callback) {
    let qry = "SELECT `idaccount`, `authkey` FROM `session` WHERE `isDeleted` = 0 AND `idaccount` = "+idaccount+" ORDER BY `id` DESC LIMIT 1;";
    console.log("Get AuthKey Query :: ", qry);
    connection.execute(qry, (err, rows) => {
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error While Getting AuthKey", error: err.message });
        }
    });
}
function checkCampiKey(campaignid, callback) {
    let qry = "SELECT `idaccount`, `campaign_key` FROM `campaign` WHERE `campaign_key` = '"+campaignid+"' LIMIT 1;";
    console.log("Check Campaign Query :: ", qry);
    connection.execute(qry, (err, rows) => {
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error While Checking Campaign", error: err.message });
        }
    });
}

function getCampaignActivatedDID(campaignid, callback) {
    let qry = "SELECT `account_id`, `did`, `camp_registry` FROM `did_buy` WHERE `camp_registry`='" + campaignid + "' AND `sinch_status`='1' AND `disconnect_did_status`='1'";
    console.log("Get DID Query:: ", qry);
    connection.execute(qry, (err, rows) => {
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error While Getting DIDs", error: err.message });
        }    
    });
}

function httpReq(did, authkey, callback) {
    const options = {
        method: 'DELETE',
        url: baseUrl+'disablesms?DID='+did,
        headers: {
            'Content-Type': 'application/json',
            'Authorization': authkey,
        }
    };

    request(options, (err, response, body) => {
        if (err) {
            console.error("Request error:", err);
            return callback(0, { status:502, message: "Something went wrong with Disable SMS Service" });
        }
        try {
            const data = JSON.parse(body);
            console.log("Reponse Data ::", data);            
            if(data.status == 200 || data.status == 201 || data.status == 202){
                callback(1, {status: 200, message: data.message});
            }
            else{
                callback(0, {status: 504, message: data.message})
            }
        } catch (parseErr) {
            console.error("JSON parse error:", parseErr);
            callback(0, { status:505, message: "Invalid response received from Disable SMS" });
        }
    });
}

function execute(campaignid){
    checkCampiKey(campaignid, (err1, resCamp) => {
        console.log("err1 ::", err1);
        console.log("resCamp ::", resCamp);
        
        if (err1 == 1 && resCamp.length > 0) {
            getAuthKey(resCamp[0].idaccount, (err2, resAuth) => {
                console.log("err2 ::", err2);
                console.log("resAuth ::", resAuth);
                
                if (err2 == 1 && resAuth.length > 0) {                        
                    getCampaignActivatedDID(resCamp[0].campaign_key, (err3, resDID) => {
                        console.log("err3 ::", err3);
                        console.log("resDID ::", resDID);

                        if (err3 == 1 && resDID.length > 0) {
                            httpReq(resDID[0].did, resAuth[0].authkey, (err4, resHTTP) => {
                                console.log("err4 ::", err4);
                                console.log("resHTTP ::", resHTTP);
                                
                                res.send({ status: resHTTP.status, message: resHTTP.message });
                            })
                        }
                        else {
                            res.send({ status: resDID.status, message: resDID.message });
                        }
                    });
                }
                else {
                    res.send({ status: resAuth.status, message: resAuth.message });
                }
            });
        } 
        else {
            res.send({ status: resCamp.status, message: resCamp.message });
        }
    });
}

app.get('/disablesms/:campaignid', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        res.send({status: 502, message: "Something went wrong with disable sms service"});
        return false;
    }
    const campaignid = req.params.campaignid;
    console.log("Requested campaignid :: ", campaignid);

    let message = "";
    if (!campaignid) {
        message = "Invalid campaignid";
    }

    if (!message) {
        execute(campaignid);
    } 
    else {
        res.send({ status: 401, message: message });
    }
});

const campaignidd = 'C06TZTS';
app.listen(3005, () => {
    execute(campaignidd);
    console.log("Server is Connected at Port :: 3005");
});