/* const express = require("express"); */
const { connection, key } = require("../dbcon/db");
const fs = require('fs');
const path = require('path');
// const parquet = require('parquetjs-lite');
const parquet = require('parquetjs');
const basepath = "/var/www/html/panel/reports/details/";
/* const cron = require('node-cron'); */

function ensureString(value) {
    return typeof value === "string" ? value : String(value);
}

/* // Define schema for MDR */
const createParquetSchemaMdr = (includeMessageBody) => {
    const schemaDefinition = {
        "SAN": { type: 'INT32' },
        "iduser": { type: 'INT32' },
        "Direction": { type: 'UTF8' },
        "Message Count": { type: 'INT32' },
        "From Number": { type: 'UTF8' },
        "To Number": { type: 'UTF8' },
        "MT Rates": { type: 'DOUBLE' },
        "MO Rates": { type: 'DOUBLE' },
        "MT Surcharge": { type: 'DOUBLE' },
        "Status": { type: 'UTF8' },
        "Message Delivered To Operator": { type: 'UTF8' },
        "Message Accepted By Signalmash": { type: 'UTF8' },
        "Delivery Receipt Received By Signalmash": { type: 'UTF8' },
        "Delivery Receipt Delivered": { type: 'UTF8' },
        "Mobility": { type: 'UTF8' },
        "OCN": { type: 'UTF8' },
        "Lata": { type: 'UTF8' },
        "Date": { type: 'UTF8' },
        "Cost": { type: 'DOUBLE' },
        "Message Body": { type: 'UTF8' },
    };

    return new parquet.ParquetSchema(schemaDefinition);
};

const createCdrParquetSchema = () => {
    const cdrSchemaDefinition = {
        "SAN": { type: 'INT32' },
        "iduser": { type: 'INT32' },
        "COST": { type: 'DOUBLE' },
        "From Number": { type: 'UTF8' },
        "To Number": { type: 'UTF8' },
        "Direction": { type: 'UTF8' },
        "Duration": { type: 'UTF8' },
        "Billsec": { type: 'UTF8' },
        "Hangup Case": { type: 'UTF8' },
        "Progress Mediamsec": { type: 'UTF8' },
        "Start Stamp": { type: 'UTF8', logicalType: 'TIMESTAMP_MILLIS' },
        "Answer Stamp": { type: 'UTF8', logicalType: 'TIMESTAMP_MILLIS' },
        "End Stamp": { type: 'UTF8', logicalType: 'TIMESTAMP_MILLIS' },
        "Progress Media Stamp": { type: 'UTF8', logicalType: 'TIMESTAMP_MILLIS' },
        "Date": { type: 'UTF8' }
    };
    return new parquet.ParquetSchema(cdrSchemaDefinition);
};

const createParquetSchemaMmsMdr = (includeMessageBody) => {
    const schemaDefinition = {
        "SAN": { type: 'INT32' },
        "iduser": { type: 'INT32' },
        "Direction": { type: 'UTF8' },
        "Message Count": { type: 'INT32' },
        "From Number": { type: 'UTF8' },
        "To Number": { type: 'UTF8' },
        "MT Rates": { type: 'DOUBLE' },
        "MO Rates": { type: 'DOUBLE' },
        "MT Surcharge": { type: 'DOUBLE' },
        "Status": { type: 'INT32' },
        "Message Delivered To Operator": { type: 'UTF8' },
        "Message Accepted By Signalmash": { type: 'UTF8' },
        "Delivery Receipt Received By Signalmash": { type: 'UTF8' },
        "Delivery Receipt Delivered": { type: 'UTF8' },
        "Mobility": { type: 'UTF8' },
        "Message Body": { type: 'UTF8' },
        "OCN": { type: 'UTF8' },
        "Lata": { type: 'UTF8' },
        "Cost": { type: 'DOUBLE' },
        "Date": { type: 'UTF8' },
    };

    return new parquet.ParquetSchema(schemaDefinition);
};

const getLastProcessedId = (type) => {
    return new Promise((resolve, reject) => {
        const qry = `SELECT id_parquet, last_processed_id, last_processed_date FROM report_details_index WHERE type = '${type}' ORDER BY last_processed_date DESC LIMIT 1`;

        connection.execute(qry, (err, rows) => {
            if (!rows || rows.length === 0) {
                console.warn(`No data found for type: ${type}`);
                return resolve({ last_processed_id: 0, last_processed_date: new Date().toISOString().split('T')[0] });
            }

            resolve(rows[0]);
        });
    });
};

const updateLastProcessedId = (type, lastProcessedId, lastProcessedDate) => {
    return new Promise((resolve, reject) => {
        const qry = `INSERT INTO report_details_index (type, last_processed_id, last_processed_date) VALUES ('${type}', ${lastProcessedId}, '${lastProcessedDate}')`;
        connection.execute(qry, (status, rows) => {
            if (status === 0) {
                return reject(new Error('Failed to update last processed ID'));
            }
            resolve(rows);
        });
    });
};

const mdrParquet = async () => {
    const schema = createParquetSchemaMdr(true);
    const today = new Date().toISOString().split('T')[0];
    const { last_processed_id, last_processed_date } = await getLastProcessedId('mdr');
    const qry = "SELECT idmdr,iduser, idaccount, direction, msg_count, from_number, to_number, MT_rates, MO_rates, MT_surcharge, status, message_delivered_to_operator, message_accepted_by_signalmash, delivery_receipt_received_by_singnalmash, delivery_receipt_delivered, mobility, messsage_body, ocn, lata, created_at, cost FROM mdr WHERE idmdr > " + last_processed_id + " ORDER BY idmdr ASC";
    console.log("DID Query Load:: ", qry);

    connection.execute(qry, async (err, rows) => {

        if (rows.length === 0) {
            console.log("No new records found for MDR.");
            return;
        }

        const accountsData = rows.reduce((acc, row) => {
            const date = new Date(row.created_at).toISOString().split('T')[0];
            if (!acc[row.idaccount]) acc[row.idaccount] = {};
            if (!acc[row.idaccount][date]) acc[row.idaccount][date] = [];
            acc[row.idaccount][date].push(row);
            return acc;
        }, {});

        const BATCH_SIZE = 100000;

        for (const [idaccount, dateGroups] of Object.entries(accountsData)) {
            for (const [date, accountRows] of Object.entries(dateGroups)) {
                const san = 100000000 + parseInt(idaccount, 10) || 0;
                const dirPath = path.join(basepath, 'mdr', `${san}`);
                if (!fs.existsSync(dirPath)) {
                    fs.mkdirSync(dirPath, { recursive: true });
                }
                const filename = `${date.replace(/-/g, '')}.parquet`;
                const filePath = path.join(dirPath, filename);

                let writer;
                /* Check if the file exists */
                if (fs.existsSync(filePath)) {
                    writer = await parquet.ParquetWriter.openFile(schema, filePath, { append: true });
                } else {
                    writer = await parquet.ParquetWriter.openFile(schema, filePath);
                }

                for (let i = 0; i < accountRows.length; i += BATCH_SIZE) {
                    const batch = accountRows.slice(i, i + BATCH_SIZE);
                    for (const row of batch) {
                        await writer.appendRow({
                            "SAN": san ?? 0,
                            "iduser": row.iduser ?? 0,
                            "Direction": row.direction ?? "",
                            "Message Count": row.msg_count ?? 0,
                            "From Number": row.from_number ?? "",
                            "To Number": row.to_number ?? "",
                            "MT Rates": row.MT_rates ?? 0,
                            "MO Rates": row.MO_rates ?? 0,
                            "MT Surcharge": row.MT_surcharge ?? 0,
                            "Status": row.status ?? "",
                            "Message Delivered To Operator": row.message_delivered_to_operator ?? "",
                            "Message Accepted By Signalmash": row.message_accepted_by_signalmash ?? "",
                            "Delivery Receipt Received By Signalmash": row.delivery_receipt_received_by_singnalmash ?? "",
                            "Delivery Receipt Delivered": row.delivery_receipt_delivered ?? "",
                            "Mobility": row.mobility ?? "",
                            "OCN": row.ocn ?? "",
                            "Lata": row.lata ?? "",
                            "Date": row.created_at ?? "",
                            "Cost": row.cost ?? 0,
                            "Message Body": row.messsage_body ?? ""
                        });
                    }
                }

                await writer.close();
                console.log(`MDR Parquet file generated at ${filePath}`);
            }
        }

       /*  Update last processed id and date */
        const lastRow = rows[rows.length - 1];
        await updateLastProcessedId('mdr', lastRow.idmdr, today);
    });
};

const cdrParquet = async () => {
    const schema = createCdrParquetSchema();
    const today = new Date().toISOString().split('T')[0];
    const { last_processed_id, last_processed_date } = await getLastProcessedId('cdr');

    const qry = "SELECT san,iduser,accountcode,idcdr,cost, dialed_number, caller_id_number, direction, duration, billsec, hangup_cause, progress_mediamsec, start_stamp, answer_stamp, end_stamp, progress_media_stamp, created_at FROM cdr WHERE idcdr > " + last_processed_id + " ORDER BY idcdr ASC";
    console.log("DID Query Load:: ", qry);

    connection.execute(qry, async (err, rows) => {
        if (rows.length === 0) {
            console.log("No new records found for CDR.");
            return;
        }

        const accountsData = rows.reduce((acc, row) => {
            const date = new Date(row.created_at).toISOString().split('T')[0];
            if (!acc[row.accountcode]) acc[row.accountcode] = {};
            if (!acc[row.accountcode][date]) acc[row.accountcode][date] = [];
            acc[row.accountcode][date].push(row);
            return acc;
        }, {});

        const BATCH_SIZE = 100000; 

        for (const [accountcode, dateGroups] of Object.entries(accountsData)) {
            for (const [date, accountRows] of Object.entries(dateGroups)) {
                const san = 100000000 + parseInt(accountcode, 10) || 0;
                const dirPath = path.join(basepath, 'cdr', `${san}`);
                if (!fs.existsSync(dirPath)) {
                    fs.mkdirSync(dirPath, { recursive: true });
                }
                const filename = `${date.replace(/-/g, '')}.parquet`; 
                const filePath = path.join(dirPath, filename);

                let writer;
                /* // Check if the file exists */
                if (fs.existsSync(filePath)) {
                    writer = await parquet.ParquetWriter.openFile(schema, filePath, { append: true });
                } else {
                    writer = await parquet.ParquetWriter.openFile(schema, filePath);
                }

                for (let i = 0; i < accountRows.length; i += BATCH_SIZE) {
                    const batch = accountRows.slice(i, i + BATCH_SIZE);
                    for (const row of batch) {
                        // const startStamp = isNaN(new Date(row.start_stamp).getTime()) ? 0 : new Date(row.start_stamp).getTime();
                        // const answerStamp = isNaN(new Date(row.answer_stamp).getTime()) ? 0 : new Date(row.answer_stamp).getTime();
                        // const endStamp = isNaN(new Date(row.end_stamp).getTime()) ? 0 : new Date(row.end_stamp).getTime();
                        // const progressMediaStamp = isNaN(new Date(row.progress_media_stamp).getTime()) ? 0 : new Date(row.progress_media_stamp).getTime();


                        const startDate = new Date(row.start_stamp);
                        const answerDate = new Date(row.answer_stamp);
                        const endDate = new Date(row.end_stamp);
                        const progressMediaDate = new Date(row.progress_media_stamp);

                        // Validate dates and convert to timestamp (milliseconds) or fallback to 0 if invalid
                        const startStamp = isNaN(startDate.getTime()) ? 0 : startDate.getTime();
                        const answerStamp = isNaN(answerDate.getTime()) ? 0 : answerDate.getTime();
                        const endStamp = isNaN(endDate.getTime()) ? 0 : endDate.getTime();
                        const progressMediaStamp = isNaN(progressMediaDate.getTime()) ? 0 : progressMediaDate.getTime();
                        await writer.appendRow({
                            "SAN": ensureString(row.san ?? ""),
                            "iduser": row.iduser ?? 0,
                            "COST": row.cost ?? 0,
                            "From Number": row.caller_id_number ?? "",
                            "To Number": row.dialed_number ?? "",
                            "Direction": row.direction ?? "",
                            "Duration": ensureString(row.duration) ?? 0,
                            "Billsec": ensureString(row.billsec) ?? 0,
                            "Hangup Case": row.hangup_cause ?? "",
                            "Progress Mediamsec": ensureString(row.progress_mediamsec) ?? 0,
                            "Start Stamp": ensureString(startStamp),
                            "Answer Stamp": ensureString(answerStamp),
                            "End Stamp": ensureString(endStamp),
                            "Progress Media Stamp": ensureString(progressMediaStamp),
                            "Date": row.created_at ?? "",
                        });
                    }
                }

                await writer.close();
                console.log(`CDR Parquet file generated at ${filePath}`);
            }
        }

        /* // Update last processed id and date */
        const lastRow = rows[rows.length - 1];
        await updateLastProcessedId('cdr', lastRow.idcdr, today);
    });
};

const mmsMdrParquet = async () => {
    const schema = createParquetSchemaMmsMdr(true);
    const today = new Date().toISOString().split('T')[0];
    const { last_processed_id, last_processed_date } = await getLastProcessedId('mms');

    let qry = "SELECT idmdr,iduser,idaccount, direction, msg_count, from_number, to_number, MT_surcharge, MT_rates, MO_rates, status, message_delivered_to_operator, delivery_receipt_delivered, delivery_receipt_received_by_singnalmash, message_accepted_by_signalmash, mobility, messsage_body, ocn, lata, created_at, cost FROM mms_mdr WHERE idmdr > " + last_processed_id + " ORDER BY idmdr ASC";
    console.log("DID Query Load:: ", qry);

    connection.execute(qry, async (err, rows) => {
        if (rows.length === 0) {
            console.log("No new records found for MMS.");
            return;
        }

        const accountsData = rows.reduce((acc, row) => {
            const date = new Date(row.created_at).toISOString().split('T')[0];
            if (!acc[row.idaccount]) acc[row.idaccount] = {};
            if (!acc[row.idaccount][date]) acc[row.idaccount][date] = [];
            acc[row.idaccount][date].push(row);
            return acc;
        }, {});

        const BATCH_SIZE = 100000; 

        for (const [idaccount, dateGroups] of Object.entries(accountsData)) {
            for (const [date, accountRows] of Object.entries(dateGroups)) {
                const san = 100000000 + parseInt(idaccount, 10) || 0;
                const dirPath = path.join(basepath, 'mms', `${san}`);
                if (!fs.existsSync(dirPath)) {
                    fs.mkdirSync(dirPath, { recursive: true });
                }
                const filename = `${date.replace(/-/g, '')}.parquet`; 
                const filePath = path.join(dirPath, filename);

                let writer;
                /* // Check if the file exists */
                if (fs.existsSync(filePath)) {
                    writer = await parquet.ParquetWriter.openFile(schema, filePath, { append: true });
                } else {
                    writer = await parquet.ParquetWriter.openFile(schema, filePath);
                }

                for (let i = 0; i < accountRows.length; i += BATCH_SIZE) {
                    const batch = accountRows.slice(i, i + BATCH_SIZE);
                    for (const row of batch) {
                        await writer.appendRow({
                            "SAN": san ?? 0,
                            "iduser": row.iduser ?? 0,
                            "Direction": row.direction ?? "",
                            "Message Count": row.msg_count ?? 0,
                            "From Number": row.from_number ?? "",
                            "To Number": row.to_number ?? "",
                            "MT Rates": row.MT_rates ?? 0,
                            "MO Rates": row.MO_rates ?? 0,
                            "MT Surcharge": row.MT_surcharge ?? 0,
                            "Status": row.status ?? 0,
                            "Message Delivered To Operator": row.message_delivered_to_operator ?? "",
                            "Message Accepted By Signalmash": row.message_accepted_by_signalmash ?? "",
                            "Delivery Receipt Received By Signalmash": row.delivery_receipt_received_by_singnalmash ?? "",
                            "Delivery Receipt Delivered": row.delivery_receipt_delivered ?? "",
                            "Mobility": row.mobility ?? "",
                            "Message Body": row.messsage_body ?? "",
                            "OCN": row.ocn ?? "",
                            "Lata": row.lata ?? "",
                            "Cost": row.cost ?? 0,
                            "Date": row.created_at ?? ""
                        });
                    }
                }

                await writer.close();
                console.log(`MMS Parquet file generated at ${filePath}`);
            }
        }

        /* // Update last processed id and date */
        const lastRow = rows[rows.length - 1];
        await updateLastProcessedId('mms', lastRow.idmdr, today);
    });
};

/* // Run the script every hour
cron.schedule("0 * * * *", () => {
    console.log("Running scheduled tasks...");
    cdrParquet();
    mdrParquet();
    mmsMdrParquet();
});

// Run immediately on start */
// mdrParquet();
// cdrParquet();
// mmsMdrParquet();
