// Import required modules
const mysql = require('mysql2');
const cron = require('node-cron');

// Database configuration
const db = mysql.createConnection({
    host: "103.65.192.7",
    user: "signalmash_db",
    password: "Yn95ph4$#%A1AC0B",
    database: "signalmash_prod2",
    port: 3306
});

// Generate a random 10-digit number
const generateRandomNumber = () => Math.floor(Math.random() * 9000000000) + 1000000000;

// Create a function to insert 10,000 records into the `cdr` table
const insertCDRData = () => {
    // Create an array of data to insert
    const data = Array.from({ length: 10000 }).map(() => [
        'inbound',
        1,
        '98756e9a-ce8a-4161-804b-b7f1abf340d7',
        '286',
        '202',
        'CA',
        'NY',
        null,
        null,
        generateRandomNumber().toString(),
        generateRandomNumber().toString(),
        'NORMAL_CLEARING',
        16,
        Math.floor(Date.now() / 1000),
        Math.floor(Date.now() / 1000),
        Math.floor(Date.now() / 1000),
        Math.floor(Date.now() / 1000) + 60,
        60,
        60,
        1,
        1,
        100,
        1,
        'app',
        'arg',
        'NORMAL_CLEARING',
        generateRandomNumber().toString(),
        null,
        'app',
        new Date(),
        new Date(),
        new Date(),
        new Date(),
        0,
        '127.0.0.1',
        '127.0.0.1',
        null,
        0,
        'None',
        0,
        0,
        0,
        0,
        0,
        0,
        'NY',
        '212',
        'mobile',
        'OCN123',
        'LATA123',
        'category',
        0,
        1,
        '48',
        'SIP',
        0,
        0,
        1,
        0,
        new Date(),
    ]);

    // Insert data into the table
    const sql = `
    INSERT INTO cdr (direction, type, uuid, iduser, accountcode, from_state, to_state, presence_data, presence_id, caller_id_number, dialed_number, hangup_cause, hangup_cause_q850, start_epoch, answer_epoch, progress_media_epoch, end_epoch, duration, billsec, progresssec, answersec, progress_mediamsec, progress_media, last_app, last_arg, last_bridge_hangup_cause, last_sent_callee_id_number, current_application_data, current_application, start_stamp, progress_media_stamp, answer_stamp, end_stamp, playback_ms, from_host, to_host, sdp_str, invite_failure, invite_failure_phrase, leg_from, leg_to, leg_other, rec_rate, amd_rate, idsupplier, state, npa, mobility, ocn, lata, category, trates, idapi, zone, connection, rebil, cost, san, status, created_at)
    VALUES ?
  `;
    db.query(sql, [data], (err, result) => {
        if (err) throw err;
        console.log(`${result.affectedRows} records inserted`);
    });
};

// Insert 10,000 records into the `mdr` table
const insertMdrData = () => {
    const mdrData = Array.from({ length: 10000 }).map(() => [
        '202',
        '286', 
        Math.floor(Math.random() * 1000), 
        `batch-${Math.random().toString(36).substring(2)}`, 
        'mobile', 
        generateRandomNumber().toString(),
        generateRandomNumber().toString(), 
        'Test message body', 
        new Date(), 
        new Date(),
        '1',
        new Date(), 
        new Date(), 
        new Date(),
        new Date(), 
        '212',
        'NXX', 
        'NY',
        0,
        0,
        0,
        0, 
        'connection_key', 
        'sms_outbound_key',
        'inbound',
        1,
        1,
        'mobile', 
        'OCN123',
        'LATA123', 
        'category', 
        0, 
        0,
        'OperatorName', 
        0, 
        '0', 
        0, 
        123,
        456,
        'src_dcaid',
        'dsc_dcaid', 
        'dlr_err', 
        'dlr_stat', 
        'did_provider', 
        'dca', 
        'campaignId',
        'description', 
        0, 
        0,
        Math.floor(Math.random() * 1000), 
    ]);

    // Insert data into `mdr` table
    const mdrSql = `
    INSERT INTO mdr (idaccount, iduser, idapi, batch_id, number_type, to_number, from_number, messsage_body, created_at, modified_at, status, message_accepted_by_signalmash, message_delivered_to_operator, delivery_receipt_received_by_singnalmash, delivery_receipt_delivered, npa, nxx, state, MO_rates, MT_rates, MT_surcharge, MO_surcharge, connection_key, sms_outbound_key, direction, type, msg_count, mobility, ocn, lata, category, mdr_status, idoperator, operator, rebil, dlrs, scooped, mcc, mnc, src_dcaid, dsc_dcaid, dlr_err, dlr_stat, did_provider, dca, campaignId, description, cost, is_billable, idmdrlive)
    VALUES ?
  `;
    db.query(mdrSql, [mdrData], (err, result) => {
        if (err) throw err;
        console.log(`${result.affectedRows} records inserted into 'mdr' table`);
    });
};

// Insert 10,000 records into the `mms_mdr` table
const insertMmsMdrData = () => {
    const mmsMdrData = Array.from({ length: 10000 }).map(() => [
        '202',
        '286',
        `batch-${Math.random().toString(36).substring(2)}`,
        'mobile',
        generateRandomNumber().toString(),
        generateRandomNumber().toString(),
        'MMS message body',
        new Date(),
        new Date(),
        1,
        new Date(),
        new Date(),
        new Date(),
        new Date(),
        '212',
        'NY',
        0,
        0,
        0,
        0,
        'connection_key',
        'sms_outbound_key',
        'inbound',
        2,
        1,
        'mobile',
        'OCN123',
        'LATA123',
        'category',
        0,
        0,
        'OperatorName',
        0,
        'dlr_err',
        'dlr_stat',
        'service_id',
        'slide data',
        'idapi',
        'did_provider',
        'dca',
        0,
        0,
    ]);

    const mmsMdrSql = `
    INSERT INTO mms_mdr (
      idaccount, iduser, batch_id, number_type, to_number, from_number, 
      messsage_body, created_at, modified_at, status, message_accepted_by_signalmash, 
      message_delivered_to_operator, delivery_receipt_received_by_singnalmash, 
      delivery_receipt_delivered, npa, state, MO_rates, MT_rates, 
      MT_surcharge, MO_surcharge, connection_key, sms_outbound_key, 
      direction, type, msg_count, mobility, ocn, lata, category, 
      mdr_status, idoperator, operator, dlrs, dlr_err, dlr_stat, 
      service_id, slide, idapi, did_provider, dca, cost, is_billable
    ) VALUES ?
  `;

    // Execute the query with the prepared data
    db.query(mmsMdrSql, [mmsMdrData], (err, result) => {
        if (err) throw err;
        console.log(`${result.affectedRows} records inserted into 'mms_mdr' table`);
    });
};

// Schedule the cron job to run every minute
cron.schedule('* * * * *', () => {
    console.log('Running cron job to insert 10,000 records into `cdr` table');
    insertCDRData();
    console.log('Running cron job to insert 10,000 records into `mdr` table');
    insertMdrData();
    console.log('Running cron job to insert 10,000 records into `mms_mdr` table');
    insertMmsMdrData();
});

// Connect to the database
db.connect(err => {
    if (err) throw err;
    console.log('Database connected...');
});
