const fs = require("fs");
const path = require("path");
// const parquet = require("parquetjs-lite");
const parquet = require("parquetjs");
const express = require("express");
const app = express();

app.use(express.json());

const AUTH_KEY = "fd43e756b879d380a6528207b64e861a";
const basepath = "/var/www/html/panel/reports/details/";

class ParquetService {

  /* // Main method for handling requests */
  async getFilteredData(req, res) {
    const token = req.headers.authorization || req.headers.token;
    if (token !== AUTH_KEY) {
      return this.sendResponse(res, 401, "Unauthorized access", "Invalid authorization key!");
    }

    const { from_date, to_date, from_number, to_number, direction, fType } = req.body.data1;
    const accountType = req.body.accountType

    let idaccount = '';
    let iduser = ';'
    let san_number = ''
    if (accountType == 1) {
      let id = req.body.data1.iduser;
      let idacc = id.split("-")[1];
      iduser = id.split("-")[0];
      idaccount = Math.floor(100000000 + Math.floor(idacc));
      san_number = isNaN(idaccount) ? req.body.san : idaccount;
    } else {
      iduser = req.body.user_id;
      idaccount = req.body.idaccount;
      san_number = req.body.san;
    }
    let san = san_number.toString();
    /* // Validate query parameters */
    if (!san) {
      return this.sendResponse(res, 400, "Bad Request", "SAN number is required.");
    }

    try {
      const baseDir = this.getBaseDirectory(req);
      const sanFolders = this.getSanFolders(baseDir, accountType, san);
      const filters = { from_date, to_date, from_number, to_number, direction, idaccount, san, iduser, accountType };
      let allResults = [];
      for (const sanFolderPath of sanFolders) {
        const results = await this.readFilteredFiles(sanFolderPath, filters);
        allResults = allResults.concat(results);
      }
      allResults.sort((a, b) => new Date(b.created_at).getTime() - new Date(a.created_at).getTime());

      /* // Paging for large datasets */
      const limit = fType === "filter" ? 10000 : 10000;
      const paginatedResults = allResults.slice(0, limit);

      this.sendResponse(res, 200, "Data Fetched Successfully.", paginatedResults);
    } catch (err) {
      console.error("Error fetching data", err.message);
      this.sendResponse(res, 500, "Error fetching data", err.message);
    }
  }


  getBaseDirectory(req) {
    const baseDir = path.join(basepath);
    switch (req.path) {
      case "/getMMSMDR":
        return path.join(baseDir, 'mms');
      case "/getMDR":
        return path.join(baseDir, 'mdr');
      case "/getCdr":
        return path.join(baseDir, 'cdr');
      default:
        throw new Error("Invalid request path");
    }
  }

  getSanFolders(baseDir, accountType, san) {
    if (accountType == 1) {
      /* // Admin can access all folders under baseDir */
      return fs.readdirSync(baseDir)
        .filter(folder => fs.statSync(path.join(baseDir, folder)).isDirectory())
        .map(folder => path.join(baseDir, folder));
    } else {
      const sanFolderPath = path.join(baseDir, san);
      if (fs.existsSync(sanFolderPath)) {
        return [sanFolderPath];
      } else {
        throw new Error('SAN number folder not found.');
      }
    }
  }



  async readFilteredFiles(sanFolderPath, filters) {
    const files = fs.readdirSync(sanFolderPath);
    let allData = [];

    for (const file of files) {
      if (file.endsWith('.parquet')) {
        const filePath = path.join(sanFolderPath, file);
        try {
          const reader = await parquet.ParquetReader.openFile(filePath);
          const cursor = reader.getCursor();
          let record = null;

          while (record = await cursor.next()) {
            if (this.applyFilters(record, filters)) {
              allData.push(record);
            }
          }
          await reader.close();
        } catch (err) {
          console.error(`Error reading file ${file}`, err);
        }
      }
    }
    return allData;
  }

  applyFilters(record, filters) {
    const { idaccount, san, accountType, iduser } = filters;
    if (accountType == 1) {
      /* // Ensure idaccount is defined and matches the SAN */
      if (idaccount && String(record.SAN) !== String(idaccount)) {
        return false; 
      }
      if (filters.from_number && filters.from_number.trim() !== '' && filters.from_number !== "''") {
        if (record['From Number'] !== filters.from_number) {
          return false;
        }
      }
      if (filters.to_number && filters.to_number.trim() !== '' && filters.to_number !== "''") {
        if (record['To Number'] !== filters.to_number) {
          return false;
        }
      }
      if (filters.direction !== undefined && filters.direction.trim() !== '' && filters.direction !== "''") {
        if (record.Direction !== filters.direction) {
          return false;
        }
      }
    } else if (accountType == 2) {
      
      if (idaccount && san && idaccount.toString() === san) {
        
        if (record.SAN !== san) {
          return false;
        }
      }

      if (filters.from_number && filters.from_number.trim() !== '' && filters.from_number !== "''") {
        if (record['From Number'] !== filters.from_number) {
          return false;
        }
      }
      if (filters.to_number && filters.to_number.trim() !== '' && filters.to_number !== "''") {
        if (record['To Number'] !== filters.to_number) {
          return false;
        }
      }
      if (filters.direction !== undefined && filters.direction.trim() !== '' && filters.direction !== "''") {
        if (record.Direction !== filters.direction) {
          return false;
        }
      }
      if (filters.from_date && filters.from_date.trim() !== '' && filters.from_date !== "''") {
        const fromDate = new Date(filters.from_date).setHours(0, 0, 0, 0);
        const recordDate = new Date(record.Date).setHours(0, 0, 0, 0);
        if (isNaN(fromDate) || recordDate < fromDate) {
          return false;
        }
      }
      if (filters.to_date && filters.to_date.trim() !== '' && filters.to_date !== "''") {
        const toDate = new Date(filters.to_date).setHours(23, 59, 59, 999);
        const recordDate = new Date(record.Date).getTime();
        if (isNaN(toDate) || recordDate > toDate) {
          return false;
        }
      }

      if (filters.from_date && filters.to_date && new Date(filters.from_date).toDateString() === new Date(filters.to_date).toDateString()) {
        const recordDate = new Date(record.Date).toDateString();
        const filterDate = new Date(filters.from_date).toDateString();
        if (recordDate !== filterDate) {
          return false;
        }
      }
    }

    else {
      
      if (iduser && san && idaccount === san) {
        
        if (record.SAN !== san) {
          return false;
        }
      }
      if (iduser && record.iduser !== iduser) {
        return false;
      }

      if (filters.from_number && filters.from_number.trim() !== '' && filters.from_number !== "''") {
        if (record['From Number'] !== filters.from_number) {
          return false;
        }
      }
      if (filters.to_number && filters.to_number.trim() !== '' && filters.to_number !== "''") {
        if (record['To Number'] !== filters.to_number) {
          return false;
        }
      }
      if (filters.direction !== undefined && filters.direction.trim() !== '' && filters.direction !== "''") {
        if (record.Direction !== filters.direction) {
          return false;
        }
      }
      if (filters.from_date && filters.from_date.trim() !== '' && filters.from_date !== "''") {
        const fromDate = new Date(filters.from_date).setHours(0, 0, 0, 0);
        const recordDate = new Date(record.Date).setHours(0, 0, 0, 0);
        if (isNaN(fromDate) || recordDate < fromDate) {
          return false;
        }
      }
      if (filters.to_date && filters.to_date.trim() !== '' && filters.to_date !== "''") {
        const toDate = new Date(filters.to_date).setHours(23, 59, 59, 999);
        const recordDate = new Date(record.Date).getTime();
        if (isNaN(toDate) || recordDate > toDate) {
          return false;
        }
      }

      if (filters.from_date && filters.to_date && new Date(filters.from_date).toDateString() === new Date(filters.to_date).toDateString()) {
        const recordDate = new Date(record.Date).toDateString();
        const filterDate = new Date(filters.from_date).toDateString();
        if (recordDate !== filterDate) {
          return false;
        }
      }
    }

    return true;
  }



  sendResponse(res, status, message, data = null) {
    res.status(status).json({ message, data });
  }
}

const parquetService = new ParquetService();


app.get('/getMMSMDR', (req, res) => parquetService.getFilteredData(req, res));
app.get('/getMDR', (req, res) => parquetService.getFilteredData(req, res));
app.get('/getCdr', (req, res) => parquetService.getFilteredData(req, res));


app.listen(4506, () => {
  console.log('Parquet service running on port 4506');
});

