const express = require("express");
const bodyParser = require("body-parser");
const fs = require("fs");
const path = require("path");
// const parquet = require("parquetjs-lite");
const parquet = require("parquetjs");
const { createObjectCsvWriter } = require("csv-writer");
const AdmZip = require("adm-zip");
const mysql = require('mysql');
const { connection, key } = require("../dbcon/db");
const crypto = require("crypto"); 
const BASE_URL = "http://localhost:4505/microservices/parquet_scripts";
// const BASE_URL = "https://signalmash.gventure.info/api/microservices/parquet_scripts"; 
const app = express();
app.use(bodyParser.json());

const PORT = 4505;
const AUTH_KEY = "xdfwetydrhdynfihdthwiljdsb";

// MySQL connection setup
// const connection = mysql.createConnection({

//   //Local Db
//   // host: "103.65.192.7",
//   // user: "signalmash_db",
//   // password: "Yn95ph4$#%A1AC0B",
//   // database: "signalmash_prod2",
//   // port: 3306, 

// //Production DB
//   host: "10.128.0.2",
//   user: "signalmash",
//   password: "lAq3@HbzYllQFsuC",
//   database: "signalmash",
//   port: 3306, 
// });



// connection.connect(error => {
//   if (error) {
//       console.error('Error connecting to MySQL:', error);
//       return;
//   }
//   console.log('Connected to MySQL database');
// });

// Serve static files from the 'uploads' directory
app.use(
  "/microservices/parquet_scripts/uploads",
  express.static(path.join(__dirname, "uploads"))
);

app.post("/getdetails/", async (req, res) => {
  console.log("Received a request!");

  const token = req.headers.authorization || req.headers.token;
  if (token !== AUTH_KEY) {
    return res.status(401).json({
      message: "Invalid Session you are trying to access",
      error: "Invalid session is called to access!",
    });
  }

  const data = req.body;

  try {
    if (!data.data1 || !data.san || !data.accountType || !data.user_id) {
      return res.status(400).json({
        message: "Missing required fields",
        error:
          "The 'data1', 'san', 'accountType', and 'user_id' fields are required in the request body",
      });
    }

    const { type, from_date, to_date, directions, fromnumber, tonumber } =
      data.data1;
    const san = data.san.toString();
    const accountType = data.accountType;
    const iduser = data.user_id;
    let baseDir, zipName;

    const today = new Date().toISOString().split("T")[0];
    const uniqueSuffix = crypto.randomBytes(4).toString("hex"); // Generate a unique identifier

    // Determine file paths based on type
    switch (type) {
      case 0:
        baseDir = path.join(__dirname, "uploads", "parquet_files", "cdr");
        zipName = `${today}-${uniqueSuffix}-CDRZIP.zip`;
        break;
      case 1:
        baseDir = path.join(__dirname, "uploads", "parquet_files", "mdr");
        zipName = `${today}-${uniqueSuffix}-MDRZIP.zip`;
        break;
      case 2:
        baseDir = path.join(__dirname, "uploads", "parquet_files", "mmsmdr");
        zipName = `${today}-${uniqueSuffix}-MMSMDRZIP.zip`;
        break;
      default:
        return res.status(400).json({
          message: "Invalid data type provided",
          error: "The provided type does not match any valid case",
        });
    }

    const folderPath = path.join(baseDir, san);
    if (!fs.existsSync(folderPath)) {
      return res.status(404).json({ message: "Folder not found!" });
    }

    const matchingFiles = getMatchingParquetFiles(folderPath, from_date, to_date);
    if (matchingFiles.length === 0) {
      return res.status(404).json({ message: "No matching Parquet files found!" });
    }

    const csvFiles = await convertParquetToCsv(folderPath, matchingFiles, {
      directions: directions ? directions.toLowerCase() : null,
      fromnumber,
      tonumber,
      accountType,
      iduser,
    });

    if (csvFiles.length === 0) {
      return res
        .status(404)
        .json({ message: "No records matched the specified filters!" });
    }

    const zipFilePath = await compressCsvToZip(folderPath, csvFiles, zipName);
    cleanupFiles(csvFiles);

    await updateDownloadReportStatus(data.id, zipFilePath)
    .then(result => console.log('Download Report Status Updated successfully:', result))
    .catch(console.error);

    return res.status(200).json({
      message: "ZIP file created successfully",
      zipFilePath: zipFilePath,
    });
  } catch (error) {
    console.error("Error occurred:", error);
    
    await updatestatus(data.id)
    .then(result => console.log('Status Updated successful:', result))
    .catch(console.error);

    return res.status(500).json({
      message: "Error processing files",
      error: error.message,
    });
  }
});

// Helper function to get parquet files within date range
function getMatchingParquetFiles(folderPath, fromDateStr, toDateStr) {
  const allFiles = fs
    .readdirSync(folderPath)
    .filter((file) => file.endsWith(".parquet"));

  const fromDate = new Date(fromDateStr);
  const toDate = toDateStr ? new Date(toDateStr) : new Date();

  const normalizeDate = (date) =>
    new Date(date.getFullYear(), date.getMonth(), date.getDate());

  const normalizedFromDate = normalizeDate(fromDate);
  const normalizedToDate = normalizeDate(toDate);

  return allFiles.filter((file) => {
    const dateMatch = file.match(/^(\d{8})\.parquet$/);
    if (!dateMatch) return false;

    const fileDateStr = dateMatch[1];
    const fileDate = new Date(
      fileDateStr.slice(0, 4),
      parseInt(fileDateStr.slice(4, 6), 10) - 1,
      fileDateStr.slice(6, 8)
    );

    const normalizedFileDate = normalizeDate(fileDate);

    return (
      normalizedFileDate >= normalizedFromDate &&
      normalizedFileDate <= normalizedToDate
    );
  });
}

// Helper function to convert parquet files to CSV with filters
async function convertParquetToCsv(folderPath, parquetFiles, filters) {
  const csvFiles = [];

  for (const file of parquetFiles) {
    const parquetFilePath = path.join(folderPath, file);
    const csvFilePath = parquetFilePath.replace(".parquet", ".csv");

    try {
      const reader = await parquet.ParquetReader.openFile(parquetFilePath);
      const cursor = reader.getCursor();
      const records = [];
      let record = null;

      while ((record = await cursor.next())) {
        if (applyFilters(record, filters)) {
          const { SAN, iduser, ...filteredRecord } = record;
          records.push(filteredRecord);
        }
      }

      await reader.close();

      if (records.length > 0) {
        const csvWriter = createObjectCsvWriter({
          path: csvFilePath,
          header: Object.keys(records[0]).map((key) => ({ id: key, title: key })),
        });

        await csvWriter.writeRecords(records);
        csvFiles.push(csvFilePath);
      }
    } catch (error) {
      console.error(`Error processing file ${parquetFilePath}:`, error);
    }
  }

  return csvFiles;
}

// Helper function to apply filters to a single record
function applyFilters(record, filters) {
  const { directions, fromnumber, tonumber, accountType, iduser } = filters;

  if (accountType === 22) {
    if (!iduser || record.iduser !== iduser) {
      return false;
    }
    if (directions && record["Direction"] !== directions) {
      return false;
    }
    if (fromnumber && record["From Number"] !== fromnumber) {
      return false;
    }
    if (tonumber && record["To Number"] !== tonumber) {
      return false;
    }
  }

  if (accountType === 2) {
    if (directions && record["Direction"] !== directions) {
      return false;
    }
    if (fromnumber && record["From Number"] !== fromnumber) {
      return false;
    }
    if (tonumber && record["To Number"] !== tonumber) {
      return false;
    }
  }

  return true;
}

// Helper function to compress CSV files into a ZIP archive
function compressCsvToZip(folderPath, csvFiles, zipName) {
  return new Promise((resolve, reject) => {
    try {
      const zip = new AdmZip();

      csvFiles.forEach((file) => {
        zip.addLocalFile(file);
      });

      const zipFilePath = path.join(folderPath, zipName);
      zip.writeZip(zipFilePath);

      const relativePath = path.relative(__dirname, zipFilePath).replace(/\\/g, "/");
      const zipFileUrl = `${BASE_URL}/${relativePath}`;

      resolve(zipFileUrl);
    } catch (error) {
      reject(error);
    }
  });
}

// Helper function to delete temporary CSV files
function cleanupFiles(files) {
  files.forEach((file) => {
    try {
      fs.unlinkSync(file);
    } catch (error) {
      console.error(`Error deleting file ${file}:`, error);
    }
  });
}

// // Function to update the download_report table
// async function updateDownloadReportStatus(id, zipFileUrl) {
//   try {
//     const updateQuery = `UPDATE download_report SET status = '1', download_file_link = '${zipFileUrl}' WHERE request_id = '${id}'`;
//     await connection.query(updateQuery);
//   } catch (error) {
//     console.error("Error updating download report status:", error);
//     throw error;
//   }
// }


// // Function to mark status as 2 in case of errors
// async function updatestatus(id) {
//   try {
//     const updateQuery = `UPDATE download_report SET status = '2' WHERE request_id = '${id}'`;
//     await connection.query(updateQuery);
//   } catch (error) {
//     console.error("Error updating status:", error);
//     throw error;
//   }
// }

// Function to update the download_report table
function updateDownloadReportStatus(id, zipFileUrl) {
  return new Promise((resolve, reject) => {
    const updateQuery = `UPDATE download_report SET status = '1', download_file_link = '${zipFileUrl}' WHERE request_id = '${id}'`;
    connection.execute(updateQuery, (error, results) => {
      if (error) {
        reject(error);
      } else {
        if (results.affectedRows > 0) {
          resolve(true);
        } else {
          resolve(false);
        }
      }
    });
  });
}

// Function to mark status as 2 in case of errors
function updatestatus(id) {
  return new Promise((resolve, reject) => {
    const updateQuery = `UPDATE download_report SET status = '2' WHERE request_id = '${id}'`;
    connection.execute(updateQuery, (error, results) => {
      if (error) {
        reject(error);
      } else {
        if (results.affectedRows > 0) {
          resolve(true);
        } else {
          resolve(false);
        }
      }
    });
  });
}

app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`);
});
