const cron = require('node-cron');
const { connection } = require("./dbcon/db");

    const activateScheduledSubscriptions = () => {
        getSubscription((err, result) => {
            if (err == 1) {
                subscriptionProrationCalculator(result, (err, dataProrate3) => {
                    if (err == 1) {
                        console.log("dataProrate :: ", dataProrate3);                        
                        subscriptionWalletDeduction(dataProrate3, (err, subscriptionData) => {
                            if (err == 1 && dataProrate3.length > 0) {
                                console.log("Subscription balance updated successfully.",err);
                            } else {
                                console.log("Error in balance deduction:", err);
                            }
                        });
                    }
                    else {
                        console.log("Error in proration calculation:", err);
                    }
                });            
            }
            else {
                console.log("No subscriptions to activate.", err);
            }
        });
    };
    function subscriptionProrationCalculator(result, callback) {
        let errors = [];
        let dataProrate3 = [];
        result.forEach((entry) => {
            const parsedRates = parseFloat(entry.mrc);
            const parsedQuantity = parseInt(entry.quantity);
            const prorateFlag = parseInt(entry.proration);
            if (isNaN(parsedRates)) errors.push("mrc");
            if (isNaN(parsedQuantity)) errors.push("quantity");
            if (isNaN(prorateFlag)) errors.push("proration");
            if (errors.length > 0) return;
            let dateObj = new Date(entry.start_date);
            let day = dateObj.getUTCDate();
            let nDate = new Date(entry.start_date);
            let lDate = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0).getDate();
            let totalDays = lDate - day + 1;
            let prorate;
            let prate = (parsedQuantity * parsedRates);
            if (entry.proration == "1") {
                prorate = (totalDays * prate) / lDate;
            } else {
                prorate = prate;
            }
            console.log("prorate :: ", prorate);
            
            dataProrate3.push({
                subscription_id: entry.subscription_id,
                act_sub_id: entry.act_sub_id,
                idaccount: entry.idaccount,
                mrc: entry.mrc,
                quantity: entry.quantity,
                proration: entry.proration,
                prorate1:parseFloat(prorate).toFixed(3)
            });            
        });

        if (errors.length > 0) {
            console.log(" Something went wrong with [" + errors.join(", ") + "]");
            callback("Error in input data", 0, 0);
            return;
        }
        callback(1, dataProrate3);
    }
    function getSubscription(callback) {
        let query = "SELECT sa.`subscription_id`, sa.`act_sub_id`, sa.`idaccount`, s.`proration`, s.`mrc`, sa.`quantity`, sa.`start_date` FROM `subscription` s JOIN `subscription_account` sa ON sa.`subscription_id` = s.`subscription_id` WHERE sa.`status` = 2 AND DATE(sa.`start_date`) = CURRENT_DATE";
        console.log("getSubscription query :: ",query);    
        connection.execute(query, (err, result) => {
            if (err == 1) {
                console.log("getSubscription result :: ",result);
                if (result.length > 0) {
                    callback(1, result);
                }
                else {
                    console.log("No subscriptions to activate..");
                    callback(0, '');
                }
            }
            else{
                callback(0, err);
            }
        });
    }
    function subscriptionWalletDeduction(dataProrate3, callback) {
        dataProrate3.forEach(sub => {
            console.log("subscriptionWalletDeduction sub :: ", sub);
            walleUpdate(sub, (err, result) => {
                if (err == 1) {
                    walletRechargeLog(sub, 1, "Scheduled Subscription balance deduction success", (err2, result2)=>{
                        if(err2==1){
                            updateSubscriptionAccount(sub, (err3, result3) => {
                                if (err3 == 1) {
                                    subscriptionlog(sub, (err4, result4) => {
                                        if (err4 == 1) {
                                            callback(1, result4);
                                        } else {
                                            callback(0, err4);
                                            console.log("Error in log creation:", err4);
                                        }
                                    });
                                } 
                                else {
                                    callback(0, err3);
                                    console.log("Error in subscription account update:", err3);
                                }
                            });
                        }
                        else{
                            walletRechargeLog(sub, 2, "Scheduled Subscription balance deduction failed", (err2, result2)=>{
                                if(err2==1){
                                    callback(0, result2);
                                }else{
                                    callback(0, err2);
                                }
                            })
                        }
                    })
                } 
                else {
                    callback(0, err);
                }
            });
        });
    }

    function updateSubscriptionAccount(subscriptionData, callback) {
        let updateSubQuery = "UPDATE `subscription_account` SET status = 1 WHERE `act_sub_id` = '" + subscriptionData.act_sub_id + "'";
        console.log("updateSubscriptionAccount query :: ", updateSubQuery);                
        connection.execute(updateSubQuery, (err, result) => {
            if (err == 1) {
                callback(1, result);
            } else {
                callback(0, err);
            }
        });
    }

    function walleUpdate(subscriptionData, callback){
        let query = "UPDATE `wallet` SET `balance` = balance - " + subscriptionData.prorate1 + " WHERE `idaccount` = '" + subscriptionData.idaccount + "'";
        console.log("walleUpdate Query :: ", query);    
        connection.execute(query, (err, result) => {
            if (err == 1) {
                callback(1, result);
            } else {
                callback(0, err);
            }
        });
    }

    function subscriptionlog(subscriptionData, callback) {
        console.log("subscriptionlog subscriptionData :: ", subscriptionData);        
        let userQuery = "SELECT `iduser`, `idaccount` FROM `user` WHERE `idaccount` = " + subscriptionData.idaccount + " AND `type`=2";
        console.log("subscriptionlog user query :: ", userQuery);
        connection.execute(userQuery, (err, users) => {            
            if (err == 1 && users.length > 0) {                
                let query = "INSERT INTO `subscription_log` (`subscription_id`, `cost`, `quantity`, `iduser`, `idaccount`) VALUES ('" + subscriptionData.subscription_id + "', '" + subscriptionData.prorate1 + "', '" + subscriptionData.quantity + "', '" + users[0].iduser + "', '" + subscriptionData.idaccount + "')";
                console.log("subscriptionlog insert query :: ", query);
                connection.execute(query, (err, result) => {
                    if (err == 1) {
                        callback(1, result);
                    } else {
                        callback(0, err);
                    }
                });                
            } else {
                callback(err);
            }
        });
    }

    function walletRechargeLog(subscriptionData, status, purpose, callback) {
        let query = "INSERT INTO `wallet_recharge_log` (`idaccount`, `amount`, `purpose`, `status`) VALUES ('" + subscriptionData.idaccount + "', '-" + subscriptionData.prorate1 + "', '"+purpose+"', '"+status+"')";
        console.log("walletRechargeLog query :: ", query);
        connection.execute(query, (err, result) => {
            if(err == 1){
                callback(1, result);
            }
            else{
                callback(0, err);
            }            
        });
    }
// Scheduled at every hour
// cron.schedule('0 * * * *', () => { 
// Scheduled at morning 1 AM
cron.schedule('0 1 * * *', () => {
    activateScheduledSubscriptions();
    console.log("Running daily cron job for subscription activation and wallet check...");
});

    
