const parquet = require('parquetjs-lite');
const path = require('path');

// Function to check if a record's date matches any of the given dates
function matchesDateFilter(recordDate, dateFilters) {
  return dateFilters.includes(recordDate);
}

// Function to fetch records with filters from a Parquet file
async function fetchRecordsWithFilters(parquetFilePath, filters) {
  try {
    // Open the Parquet file
    const reader = await parquet.ParquetReader.openFile(parquetFilePath);
    const cursor = reader.getCursor();

    let record;
    const results = [];

    // Iterate over the records in the Parquet file
    while (record = await cursor.next()) {
      let includeRecord = true;

      // Apply filters
      for (const [key, value] of Object.entries(filters)) {
        if (key === 'date') {
          // Handle multiple date filters
          if (!matchesDateFilter(record[key], value)) {
            includeRecord = false;
            break;
          }
        } else if (record[key] !== value) {
          includeRecord = false;
          break;
        }
      }

      // If the record matches all filters, add it to the results
      if (includeRecord) {
        results.push(record);
      }
    }

    await reader.close();
    return results;
  } catch (error) {
    console.error('Error fetching records with filters:', error);
    throw error;
  }
}

// Example usage
(async () => {
  const parquetFilePath = path.join(__dirname, 'cdr_summary_reports', '12345', '2024-08-21', 'cdr_summary_2024-08-21.parquet');

  // Define filters
  const filters = {
    date: ['2024-08-21', '2024-08-22'], // Multiple dates
    direction: 'outbound',
    san: 'some_san',
    // Add more filters as needed
  };

  try {
    const filteredRecords = await fetchRecordsWithFilters(parquetFilePath, filters);
    console.log('Filtered Records:', filteredRecords);
  } catch (error) {
    console.error('Error:', error);
  }
})();



/* const parquet = require('parquetjs-lite');
const path = require('path');
const fs = require('fs');

async function fetchRecordsWithFilters(parquetFilePath, filters) {
  // (Same as previous implementation)
}

async function exportToJSON(records, outputFilePath) {
  try {
    fs.writeFileSync(outputFilePath, JSON.stringify(records, null, 2), 'utf8');
    console.log(`Data exported successfully to ${outputFilePath}`);
  } catch (error) {
    console.error('Error exporting to JSON:', error);
    throw error;
  }
}

(async () => {
  const parquetFilePath = path.join(__dirname, 'cdr_summary_reports', '12345', '2024-08-21', 'cdr_summary_2024-08-21.parquet');

  const filters = {
    date: ['2024-08-21', '2024-08-22'],
    direction: 'outbound',
    san: 'some_san'
  };

  try {
    const filteredRecords = await fetchRecordsWithFilters(parquetFilePath, filters);

    const outputFilePath = path.join(__dirname, 'filtered_data.json');
    await exportToJSON(filteredRecords, outputFilePath);
  } catch (error) {
    console.error('Error:', error);
  }
})(); */