//const mysql = require('mysql2/promise');
const parquet = require('parquetjs-lite');
const fs = require('fs');
const path = require('path');
const { connection } = require("./db");


async function getMDRMaxid(connection) {
  try {
    const query = `SELECT MAX(idmdr)idmdr FROM mdr`

    const [rows] = await connection.execute(query);

    if(rows.length>0)
      return rows[0].idmdr;
    else
      return 0;
  } catch (error) {
    console.error('Error MDR Max ID:', error);
    throw error;
  }
}

async function getMDRFromid(connection) {
  try {
    const query = `SELECT idrecord FROM summary_report_index WHERE rtype=2, status=1 LIMIT 1`;

    const [rows] = await connection.execute(query);
    if(rows.length>0){
        await updateIndexStatus(connection, 0);
        return rows[0].idrecord;
    }      
    else
      return 0;
  } catch (error) {
    console.error('Error MDR From ID:', error);
    throw error;
  }
}

async function updateIndex(connection, maxid) {
  try {
    const query = `UPDATE summary_report_index SET idrecord='${maxid}', status=1 WHERE rtype=2`;

    const [rows] = await connection.execute(query);

    return rows;
  } catch (error) {
    console.error('Error update mdr Last Index:', error);
    throw error;
  }
}

async function updateIndexStatus(connection, status) {
    try {
      const query = `UPDATE summary_report_index SET status=${status} WHERE rtype=2`;
  
      const [rows] = await connection.execute(query);
  
      return rows;
    } catch (error) {
      console.error('Error update mdr Last Index:', error);
      throw error;
    }
  }

// Function to generate the MDR summary report from the database without filters
async function generateMdrSummaryReport(connection, from, to) {
  try {
    // SQL query to fetch summary data, grouped by account_id, date, san, and direction
    const query = `SELECT DATE(created_at)date, direction, idaccount , CASE WHEN direction='inbound' THEN COUNT(messsage_body) WHEN direction='outbound' THEN COUNT(messsage_body)ELSE 0 END total_message ,CASE direction WHEN 'outbound' THEN SUM(MT_rates) WHEN 'inbound' THEN SUM(MT_rates) END total_cost, MAX(status) AS status, idaccount, iduser FROM mdr WHERE idmdr>='${from}' AND idmdr<'${to}' "GROUP BY direction, DATE(created_at), idaccount, iduser`;

    const [rows] = await connection.execute(query);

    return rows;
  } catch (error) {
    console.error('Error generating MDR summary report:', error);
    throw error;
  }
}

// Function to write the summary data to a Parquet file in a dynamic directory
async function writeSummaryToParquet(summary) {
  try {
    const schema = new parquet.ParquetSchema({
      date: { type: 'UTF8' },
      idaccount: { type: 'UTF8' },
      iduser: { type: 'UTF8' },
      direction: { type: 'UTF8' },
      total_message: { type: 'INT64' },
      total_cost: { type: 'DOUBLE' },
      status: { type: 'UTF8' },
    });

    const { date, idaccount } = summary;
    const outputDir = path.join(__dirname, 'mdr_summary_reports', idaccount);
    
    if (!fs.existsSync(outputDir)) {
      fs.mkdirSync(outputDir, { recursive: true });
    }

    const outputFilePath = path.join(outputDir, `mdr_summary_${date}.parquet`);

    const writer = await parquet.ParquetWriter.openFile(schema, outputFilePath);
    await writer.appendRow(summary);
    await writer.close();

    console.log(`Summary report for account ${idaccount} on ${date} written to ${outputFilePath}`);
  } catch (error) {
    console.error('Error writing summary to Parquet file:', error);
    throw error;
  }
}

// Main function to execute the script
async function main() {
  try {

    const maxid = await getMDRMaxid(connection);
    const fromid = await getMDRFromid(connection);

    if(fromid>0){
      // Generate the MDR summary report without filters
      const summaries = await generateMdrSummaryReport(connection, maxid, fromid);

      const uindex = await updateIndex(connection, maxid);
      // Iterate through each summary record and write it to the corresponding Parquet file
      for (const summary of summaries) {
        await writeSummaryToParquet(summary);
      }
    }
    else{
        await updateIndexStatus(connection, 1);
      console.log("MDR summary are under process");
    }
  } catch (error) {
    console.error('Error in main execution:', error);
  } finally {
    if (connection) {
      // Close the database connection
      await connection.end();
    }
  }
}

// Run the script
main();