const express = require("express");
const { connection } = require("./dbcon/db");
var app = express();
const cron = require('node-cron');
const PORT = 4001;

// Function to check & update suspensions
async function updateSuspensions() {
    console.log("Checking temporary suspensions...");
    try {
        // Get all TEMP_SUSPENDED users
        let qry1 = "SELECT `suspended_id`, `suspended_at`, `username` FROM `failed_login_account_suspension` WHERE `suspension_status` = '1' AND `idaccount` > 0";
        console.log("Query Get all TEMP_SUSPENDED users:::::::", qry1);
        connection.execute(qry1, (err1, rows1) => {
            console.log("rows1", rows1);
            if (err1 == 1) {
                if (rows1 && rows1.length > 0) {
                    for (let row of rows1) {
                        const suspendID = row.suspended_id;
                        const username = row.username;
                        const suspendedAt = new Date(row.suspended_at);
                        const reactivationTime = new Date(suspendedAt.getTime() + 24 * 60 * 60 * 1000); // +24 hours
                        const now = new Date();
                        console.log("check get value", suspendID, suspendedAt, "Reactivation At:", reactivationTime, "Now:", now);
                        if (now >= reactivationTime) {
                            // Create raw SQL update
                            const updateQry = "UPDATE `failed_login_account_suspension` SET `suspension_status` = '0',`updated_at`=NOW() WHERE `suspended_id` = '"+suspendID+"'";
                            console.log("Query Update ::", updateQry);
                            connection.execute(updateQry, (err, result) => {
                                if (err == 1) {
                                    console.log(`Suspended_id ${suspendID} of username: ${username} is reactivated.`);
                                } else {
                                    console.error(`Error updating failed login account suspension for suspended_id ${suspendID} of username: ${username}`, err);
                                }
                            });
                        } else {
                            console.log(`⏳ Suspension Account ${suspendID} of username: ${username} still suspended until ${reactivationTime}`);
                        }
                    }
                }
            } else {
                console.error("Error fetching suspensions customer:", err1);
                return;
            }
        });
    } catch (err) {
        console.error("Error updating suspensions customer:", err);
    }
}

async function checkcustomerattempt() {
    console.log("Checking customer failed attempts...");
    try {
        // Get all users with exactly 2 failed attempts
        const qry2 = "SELECT `suspended_id`, `updated_at`, `username` FROM `failed_login_account_suspension` WHERE `suspension_status`='0' AND `idaccount` > 0";
        console.log("Query Get all 2 count failed attempt users with idaccount > 0:::::::", qry2);
        connection.execute(qry2, (err2, rows2) => {
            if (err2 == 1) {
                if (rows2 && rows2.length > 0) {
                    for (let row of rows2) {
                        const failedAt = new Date(row.updated_at);
                        const resetTime = new Date(failedAt.getTime() + 24 * 60 * 60 * 1000); // +24 hours
                        const now = new Date();
                        // If 24 hours have passed since the last failed attempt
                        if (now >= resetTime) {
                            const updateQry1 = "UPDATE `failed_login_account_suspension` SET `failed_attempt` = '0',`updated_at`=NOW() WHERE `suspended_id` = '" + row.suspended_id + "'";
                            console.log("Query Update ::", updateQry1);
                            connection.execute(updateQry1, (err3, result1) => {
                                if (err3 == 1) {
                                    console.log(`Reset failed_Attempt = 0 for ${row.username} (ID ${row.suspended_id})`);
                                } else {
                                    console.error(`Error resetting failed attempts for ${row.username} (ID ${row.suspended_id}):`, err3);
                                }
                            });
                        } else {
                            console.log(`User ${row.username} (ID ${row.suspended_id}) still within 24h — attempts remain`);
                        }
                    }
                } else {
                    console.log("No users with 2 failed attempts found.");
                }
            } else {
                console.error("Error fetching failed attempts:", err2);
                return;
            }
        });
    } catch (err) {
        console.error("Error updating customer attempt:", err);
    }
}

// Run every 1 minute
cron.schedule("* * * * *", () => {
    updateSuspensions();
});

cron.schedule("* * * * *", () => {
    checkcustomerattempt();
});
app.listen(PORT, () => {
    console.log(`🚀 Suspension Updater Microservice running on port ${PORT}`);
    updateSuspensions(); // Run once on startup
    checkcustomerattempt(); // Run once on startup
});
