"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMS = void 0;
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const path_1 = __importDefault(require("path"));
const setting_config_1 = require("../config/setting.config");
const APIBase_1 = require("./APIBase");
const markError_1 = require("./markError");
const dir = new setting_config_1.UploadDirectory();
const Str = require('@supercharge/strings').Str;
const axios_1 = require("./axios");
const crypto = require('crypto');
const AuthUrl = new setting_config_1.apismsbase();
class SMS {
    _key;
    _secret;
    _priority;
    _account;
    req;
    res;
    constructor() {
        this._key = "";
        this._secret = "";
        this._priority = "";
        this._account = "";
    }
    get key() {
        return this._key;
    }
    set key(val) {
        this._key = val;
    }
    get secret() {
        return this._secret;
    }
    set secret(val) {
        this._secret = val;
    }
    get priority() {
        return this._priority;
    }
    set priority(val) {
        this._priority = val;
    }
    get account() {
        return this._account;
    }
    set account(val) {
        this._account = val;
    }
    getType(did) {
        let rate_type = "";
        did = "" + did + "";
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == 800 || digit == 822 || digit == 833 || digit == 844 || digit == 855 || digit == 866 || digit == 877 || digit == 888) && number.length == 10) {
            rate_type = "toll_free";
        }
        else if (number.length == 10) {
            rate_type = "10_dlc";
        }
        else {
            rate_type = "short_code";
        }
        return rate_type;
    }
    getRate(req, res, tariff, type, subcategory, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT IFNULL(`MT_rates`,0)`MT_rates` FROM `sms_rate` WHERE `id_tariff`='" + tariff + "' AND `category`='" + type + "'  AND `subcategory`='" + subcategory + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, sms_rate) => {
            console.log(err, sms_rate);
            if (err == 1) {
                let sr = [];
                sr = sms_rate.length > 0 ? sms_rate : [Object.assign({ MT_rates: 0 }, sms_rate[0])];
                callback(err, sr);
            }
            else {
                callback(err, "");
            }
        });
    }
    getLrnDetails(req, res, did, callback) {
        console.log("Did::=>", did);
        did = "" + did + "";
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let npa = number.slice(0, 3);
        let nxx = number.slice(3, 6);
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT npa,block, lata, ocn, lata, state, co_name_spec_c, li.category, IFNULL(o.id,0) idoperator, IFNULL(sr.rates,0) rates,IFNULL(o.name,'') `name` FROM (SELECT * FROM `lerg_info` WHERE npa='" + npa + "' AND nxx='" + nxx + "') li LEFT JOIN `lerg_operator` lo  ON lo.operator=li.co_name_spec_c AND lo.category=li.category LEFT JOIN `operator_mapping` om ON om.idlerg_operator=lo.idlerg_operator LEFT JOIN `operator` o ON om.idoperator=o.id LEFT JOIN (SELECT * FROM `surcharge_rates` WHERE direction='outbound' AND subtype='SMS' AND category='none' AND TYPE='10DLC') sr ON sr.idoperator=o.id";
        obj1.prepare();
        obj1.execute((err, lrn_details) => {
            console.log("====", err, lrn_details);
            if (err == 1) {
                callback('', { message: "LRN Found Successfully", status: 200, data: lrn_details });
            }
            else {
                callback({ message: "Query Error", status: 502 }, '');
            }
        });
    }
    saveSMS(req, res, next, Data, DIDData, callback) {
        let sessdata = Data.sessdata;
        let lerg_data = Data.lergData;
        let number_type = Data.nType;
        let sms_rate_cate = Data.trfType;
        const uuid = Str.random(30);
        let sdata = req.body;
        let FROM = DIDData.type == 'SC'
            ? (typeof sdata.FROM === 'string' ? sdata.FROM.trim() : '')
            : "+1" + (typeof sdata.FROM === 'string' ? sdata.FROM.trim() : '');
        let To = "+1" + (typeof sdata.TO === 'string' ? sdata.TO.trim() : '');
        // let number_type = this.getType(sdata.TO);
        //let msg_data = sdata.BODY.replace(/"/g, '\\"').replace(/'/g, "\\'");
        let msg_data = sdata.BODY;
        this.getRate(req, res, sessdata.idtariff, sms_rate_cate, "SMS", (error, sms_rate) => {
            // To check MT Rates
            if (sms_rate || sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                console.log("sms_rate::", sms_rate);
                let msgcount = Math.ceil((typeof sdata.BODY === 'string' ? sdata.BODY.length : 0) / 159);
                let cost = msgcount * (sms_rate[0].MT_rates + lerg_data[0].rates);
                let encsms = encodeURI(sdata.BODY);
                //encsms = encsms.replace(/"/g, '\\"').replace(/'/g, "\\'");
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `mdrlive` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`connection_key`,`sms_outbound_key`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`msg_count`,`cost`,`direction`,`did_provider`,`dca`,`campaignId`) VALUES('" + uuid + "','" + sdata.TO + "','" + sms_rate[0].MT_rates * msgcount + "','" + sdata.FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','dispatched','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + (0, markError_1.parseBody)(lerg_data[0].co_name_spec_c) + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates * msgcount + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + (0, markError_1.setToZero)(msgcount) + "','" + cost + "','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "','" + DIDData.campaignId + "')";
                obj.prepare();
                obj.execute((error, responce) => {
                    if (error == 1) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`,`coding`) VALUES('" + FROM + "','" + To + "','" + (0, markError_1.parseBody)(encsms) + "',UNIX_TIMESTAMP(),'" + DIDData.SmsProvider + "','11'," + (0, markError_1.setToZero)(responce.insertId) + ",'0');";
                        obj.prepare();
                        obj.execute((error, responce) => {
                            if (error == 1) {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 201, message: "SMS Submit Successfully", batch_id: uuid });
                                obj.execute();
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 501, message: "Something went wrong with sent SMS!" });
                                obj.execute();
                            }
                        });
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        });
    }
    saveMMS(req, res, next, Data, sms_provider, callback) {
        let sessdata = Data.sessdata;
        let lerg_data = Data.lergData;
        let didData = Data.DIDdata;
        let fType = Data.fileType;
        let file = Data.file;
        let number_type = Data.nType;
        let sms_rate_cate = Data.trfType;
        var sdata = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
        let msg_data = "";
        if (sdata.BODY != null && sdata.BODY != undefined)
            msg_data = sdata.BODY;
        let TO = (typeof sdata.TO === 'string' ? sdata.TO.trim().slice(-10) : '');
        let FROM = (typeof sdata.FROM === 'string' ? sdata.FROM.trim().slice(-10) : '');
        // let number_type = this.getType(sdata.FROM.trim());
        this.getRate(req, res, sessdata.idtariff, sms_rate_cate, "MMS", (error, mms_rate) => {
            if (mms_rate) {
                let cost = (mms_rate[0].MT_rates + lerg_data[0].rates);
                var options = {
                    'method': 'POST',
                    'url': AuthUrl.saveMmsUrl,
                    // 'url': 'https://api.ci.mblox.com/ep/v2/',
                    'headers': {
                        'Content-Type': 'application/json',
                        'x-api-key': AuthUrl.saveAuthkey
                        // 'x-api-key': '4ZFnGzsQnEspkuOsUWxMHY5FSBaqmue0'
                    },
                    body: JSON.stringify({
                        "action": "sendMMS",
                        "service-id": didData.camp_registry,
                        "to": "1" + TO,
                        "from": "1" + FROM,
                        "from-mask": "1" + FROM,
                        "fallback-sms-text": "MMS",
                        "disable-fallback-sms-link": false,
                        "disable-fallback-sms": false,
                        "slide": fType
                    })
                };
                (0, axios_1.request)(options, (error, response) => {
                    console.log("Sinch MMS Response :: ", response.body);
                    if (!error) {
                        try {
                            let dStatus = JSON.parse(response.body);
                            if (dStatus['status'] == 'success') {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `mms_dlr` (`idaccount`,`iduser`,`status`,`from`,`to`,`tracking_id`,`status_details`,`dca`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "','" + dStatus['status'] + "','" + FROM + "','" + TO + "','" + dStatus['tracking-id'] + "','" + dStatus['status-details'] + "','" + didData.SmsProvider + "')";
                                obj1.prepare();
                                obj1.execute((errord, responced) => {
                                    if (errord == 1) {
                                        console.log("Sinch mms_dlr Data Inserted Successfully!");
                                    }
                                    else {
                                        console.log("Sinch mms_dlr Data Not Inserted Successfully!");
                                    }
                                });
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`, `slide`, `direction`,`dca`,`did_provider`,`service_id`,`cost`,`type`) VALUES('" + dStatus['tracking-id'] + "','" + TO + "','" + mms_rate[0].MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','3','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + file + "', 'outbound','" + didData.SmsProvider + "','" + didData.DIDProvider + "','" + didData.camp_registry + "','" + cost + "','2')";
                                obj.prepare();
                                obj.execute((error, responce) => {
                                    if (error == 1) {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 201, message: "MMS sent successfully", batch_id: dStatus['tracking-id'] });
                                        obj.execute();
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                });
                            }
                            else {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`, `operator`, `slide`, `direction`,`dca`,`did_provider`,`service_id`,`cost`,`type`) VALUES('0','" + TO + "','" + mms_rate[0].MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','0','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + file + "','outbound','" + didData.SmsProvider + "','" + didData.DIDProvider + "','" + didData.camp_registry + "','0','2')";
                                obj.prepare();
                                obj.execute((error, responce) => {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 400, message: "MMS sent failed" });
                                    obj.execute();
                                });
                            }
                        }
                        catch (e) {
                            console.log("Error :: saveMMS Sinch::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ result: "MMS sent failed!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        });
    }
    getId() {
        return [
            { length: 3, maxBytes: 2 },
            { length: 3, maxBytes: 2 },
            { length: 3, maxBytes: 2 },
            { length: 14, maxBytes: 3 }
        ].reduce((prev, { length, maxBytes }) => {
            const bytes = Math.min(maxBytes, Math.ceil(length / 2));
            return prev + '-' + crypto.randomBytes(bytes).toString('hex').substr(0, length);
        }, crypto.randomBytes(2).toString('hex'));
    }
    saveSynivMMS(req, res, next, Data, sms_provider, callback) {
        let sessdata = Data.sessdata;
        let lerg_data = Data.lergData;
        let didData = Data.DIDdata;
        let fType = Data.fileType;
        let file = Data.file;
        let file_path = Data.file_path;
        let number_type = Data.nType;
        let sms_rate_cate = Data.trfType;
        //let sdata = req.body;
        //let uuid: any = this.getId();
        var sdata = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
        let msg_data = "";
        if (sdata.BODY != null && sdata.BODY != undefined)
            msg_data = sdata.BODY;
        let TO = (typeof sdata.TO === 'string' ? sdata.TO.trim().slice(-10) : '');
        let FROM = (typeof sdata.FROM === 'string' ? sdata.FROM.trim().slice(-10) : '');
        let uuid = this.getId() + "-" + FROM;
        this.getRate(req, res, sessdata.idtariff, sms_rate_cate, "MMS", (error, mms_rate) => {
            if (mms_rate) {
                let cost = (mms_rate[0].MT_rates + lerg_data[0].rates);
                let rate = new APIBase_1.APIBase();
                rate.checkBalance(req, res, sessdata.idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        this.createFiles(req, res, file, file_path, msg_data, (errorr, fData) => {
                            if (errorr == 1 && fData) {
                                var options = {
                                    'method': 'POST',
                                    'url': AuthUrl.SynivMMSUrl,
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': AuthUrl.SynivAuthkey
                                    },
                                    body: JSON.stringify({
                                        "to": "+1" + TO,
                                        "from": "+1" + FROM,
                                        "batch_id": uuid,
                                        "mms_body": msg_data,
                                        "attachment": fData.uploadPath,
                                        "attachmentwithurl": fData.urlPath,
                                        "smiltext": fData.smilFileText,
                                        "filename": fData.fileName
                                    })
                                };
                                console.log("Syniv MMS Request :: ", options);
                                (0, axios_1.request)(options, (error, response) => {
                                    if (!error) {
                                        try {
                                            if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                let result = JSON.parse(response.body);
                                                console.log("MMS API Response :: ", result);
                                                let send_status = '', status_detail = '', status_code = '', is_billable = 0;
                                                if (result.status == 201 || result.status == 405) {
                                                    // 3 success  // 5 resend
                                                    send_status = result.status == 201 ? 3 : 5;
                                                    status_detail = 'MMS Sent Successfully';
                                                    status_code = 201;
                                                    is_billable = 1;
                                                    let payload = {
                                                        idaccount: sessdata.idaccount,
                                                        amount: cost,
                                                        purpose: 'Syniv MMS Sent'
                                                    };
                                                    rate.walletDeductionWithoutLog(req, res, payload, (errorD, dataD) => {
                                                        console.log(errorD, dataD);
                                                    });
                                                    if (result.status == 201) {
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `mms_dlr` (`idaccount`,`iduser`,`status`,`from`,`to`,`tracking_id`,`status_details`,`dca`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "','success','" + FROM + "','" + TO + "','" + uuid + "','" + status_detail + "','" + sms_provider + "')";
                                                        obj1.prepare();
                                                        obj1.execute((errord, responced) => {
                                                            if (errord == 1) {
                                                                console.log("Syniv mms_dlr Data Inserted Successfully!");
                                                            }
                                                            else {
                                                                console.log("Syniv mms_dlr Data Not Inserted Successfully!");
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    cost = 0;
                                                    send_status = 0; // Failed
                                                    status_detail = 'MMS sent failed';
                                                    status_code = 400;
                                                    is_billable = 0;
                                                }
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`, `slide`,`direction`,`dca`,`did_provider`,`service_id`,`cost`,`type`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`,`is_billable`) VALUES('" + uuid + "','" + TO + "','" + mms_rate[0].MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','" + send_status + "','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + fData.urlPath + "','outbound','" + sms_provider + "','" + didData.DIDProvider + "','" + didData.camp_registry + "','" + cost + "','2',NOW(),NOW(),NOW(),NOW()," + is_billable + ")";
                                                obj.prepare();
                                                obj.execute((__error, responce) => {
                                                    if (__error == 1) {
                                                        let resData = result.status == 201 ? { status: status_code, message: status_detail, batch_id: uuid } : { status: status_code, message: status_detail };
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare(resData);
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 401, message: "Something went wrong with MMS insertion" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 402, message: "MMS Sent Failed!" });
                                                objv.execute();
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: saveSynivMMS::", e);
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({ status: 403, message: "MMS Sent Failed!" });
                                            obj.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 405, message: "MMS Sent Failed!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 503, message: "MMS Sent Failed!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 504, message: "You have insufficient funds in your account. Kindly add funds to your account!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        });
    }
    createFiles(req, res, fileUrl, filePathUplo, msg_data, callback) {
        let fName = path_1.default.basename(filePathUplo);
        let fNameP;
        const lastDotIndex = fName.lastIndexOf('.');
        fNameP = lastDotIndex === -1 ? fName : fName.substring(0, lastDotIndex);
        let upTextPath = '', urlTextPath;
        if (msg_data) {
            upTextPath = msg_data ? dir.MMSUPLOADS + '/' + fNameP + '.txt' : '';
            urlTextPath = msg_data ? dir.MMSMEDIAFILE + fNameP + '.txt' : '';
        }
        let mediaFiles = [
            filePathUplo,
            upTextPath // text file path
        ];
        let mediaUrlFiles = [
            fileUrl,
            urlTextPath // text file path
        ];
        function constructMediaElement(filePath, index) {
            const fileExtension = path_1.default.extname(filePath).toLowerCase();
            let mediaFileName = path_1.default.basename(filePath);
            switch (fileExtension) {
                //Image
                case '.bmp':
                case '.webp':
                case '.jpg':
                case '.jpeg':
                case '.png':
                case '.gif':
                    return [`<par dur="5s"><img src="${mediaFileName}" region="Image"></img></par>`,
                        `<region id="Image" height="100%" width="100%" fit="meet"></region>`];
                // Audio 
                case '.weba':
                case '.qcelp':
                case '.qcp':
                case '.xwav':
                case '.midi':
                case '.mid':
                case '.amr':
                case '.aac':
                case '.aacp':
                case '.mp3':
                case '.wav':
                    return [`<par dur="5s"><audio src="${mediaFileName}" region="Audio"></audio></par>`,
                        `<region id="Audio" height="100%" width="100%" fit="meet"></region>`];
                // Video 
                case '.h263':
                case '.h264':
                case '.jpgv':
                case '.3gp':
                case '.3g2':
                case '.mov':
                case '.mp4':
                case '.avi':
                    return [`<par dur="5s"><video src="${mediaFileName}" region="Video"></video></par>`,
                        `<region id="Video" height="100%" width="100%" fit="meet"></region>`];
                //Text
                case '.pdf':
                case '.vcf':
                case '.txt':
                case '.ical':
                case '.ics':
                case '.html':
                    return [`<par dur="5s"><text src="${mediaFileName}" region="Text"></text></par>`,
                        `<region id="Text" height="100%" width="100%" fit="scroll"></region>`];
                case '.gz':
                case '.rtf':
                case '.zip':
                    return [`<par dur="5s"><text src="${mediaFileName}" region="Application"></text></par>`,
                        `<region id="Application" height="100%" width="100%" fit="scroll"></region>`];
                default:
                    return '';
            }
        }
        const regionMedia = mediaFiles.map((filePath, index) => constructMediaElement(filePath, index)[0]);
        const region = mediaFiles.map((filePath, index) => constructMediaElement(filePath, index)[1]).sort((a, b) => b - a).reverse();
        //const region = mediaFiles.map((filePath: any, index: any) => constructMediaElement(filePath, index)[1]);
        const smilContent = `<smil><head><layout><root-layout/>${region}</layout></head><body>${regionMedia}</body></smil>`;
        let mediaAllFiles = [
            mediaFiles[0] !== undefined && mediaFiles[0] ? mediaFiles[0] : '' // file path            
        ];
        let mediaAllURLs = [
            mediaUrlFiles[0] !== undefined && mediaUrlFiles[0] ? mediaUrlFiles[0] : '' // file path  
        ];
        const allfiles = mediaAllFiles.filter((element) => element !== '');
        const uploadPath = allfiles.join(';');
        const fPathUp = mediaAllURLs.filter((element) => element !== '');
        const fPathUrl = fPathUp.join(';');
        callback(1, { uploadPath: uploadPath, urlPath: fPathUrl, smilFileText: smilContent.replace(/>(,)/g, '>'), fileName: fNameP });
    }
    saveSCSMS(req, res, next, sessdata, lerg_data, DIDData, callback) {
        const uuid = Str.random(30);
        let sdata = req.body;
        let FROM = (typeof sdata.FROM === 'string' ? "1" + sdata.FROM.trim() : '');
        let To = (typeof sdata.TO === 'string' ? "+1" + sdata.TO.trim() : '');
        let number_type = this.getType(sdata.TO);
        let msg_data = sdata.BODY;
        // let obj = new ModelRawQuery(req, res);
        // obj.qrysql = "SELECT IFNULL(`MT_rates`,0)`MT_rates` FROM `sms_rate` WHERE `id_tariff`=" + sessdata.idtariff + "  AND category='short_code' AND `subcategory`='SMS' LIMIT 1";
        // obj.prepare();
        // obj.execute((error: any, sms_rate: any) => {
        this.getRate(req, res, sessdata.idtariff, number_type, "SMS", (error, sms_rate) => {
            // To check MT Rates
            if (sms_rate || sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                console.log("sms_rate::", sms_rate);
                let msgcount = Math.ceil((typeof sdata.BODY === 'string' ? sdata.BODY.length : 0) / 159);
                let cost = msgcount * (sms_rate[0].MT_rates + lerg_data[0].rates);
                let encsms = encodeURI(sdata.BODY);
                //encsms = encsms.replace(/"/g, '\\"').replace(/'/g, "\\'");
                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj0.nonqrysql = "INSERT INTO `mdrlive` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`connection_key`,`sms_outbound_key`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`msg_count`,`cost`,`direction`,`did_provider`,`dca`,`campaignId`) VALUES('" + uuid + "','" + sdata.TO + "','" + sms_rate[0].MT_rates * msgcount + "','" + sdata.FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','dispatched','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + (0, markError_1.parseBody)(lerg_data[0].co_name_spec_c) + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates * msgcount + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + (0, markError_1.setToZero)(msgcount) + "','" + cost + "','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "','" + DIDData.campaignId + "')";
                obj0.prepare();
                obj0.execute((error, responce) => {
                    if (error == 1) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`,`coding`) VALUES('" + FROM + "','" + To + "','" + (0, markError_1.parseBody)(encsms) + "',UNIX_TIMESTAMP(),'" + DIDData.SmsProvider + "','11',LAST_INSERT_ID(),'0')";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            if (error == 1) {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 201, message: "SMS Sent Successfully", batch_id: uuid });
                                obj.execute();
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        });
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        });
    }
    saveSCMMS(req, res, next, sessdata, lerg_data, sms_provider, didData, fType, file, callback) {
        var sdata = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
        let msg_data = "";
        if (sdata.BODY != null && sdata.BODY != undefined)
            msg_data = sdata.BODY;
        let TO = (typeof sdata.TO === 'string' ? sdata.TO.trim().slice(-10) : '');
        let FROM = (typeof sdata.FROM === 'string' ? sdata.FROM.trim().slice(-10) : '');
        let number_type = this.getType(TO);
        // let obj = new ModelRawQuery(req, res);
        // obj.qrysql = "SELECT IFNULL(`MT_rates`,0)`MT_rates` FROM `sms_rate` WHERE `id_tariff`=" + sessdata.idtariff + "  AND category='short_code' AND `subcategory`='MMS' LIMIT 1";
        // obj.prepare();
        // obj.execute((error: any, mms_rate: any) => {
        this.getRate(req, res, sessdata.idtariff, number_type, "MMS", (error, mms_rate) => {
            if (mms_rate) {
                let cost = (mms_rate[0].MT_rates + lerg_data[0].rates);
                var options = {
                    'method': 'POST',
                    'url': AuthUrl.saveMmsUrl,
                    // 'url': 'https://api.ci.mblox.com/ep/v2/',
                    'headers': {
                        'Content-Type': 'application/json',
                        'x-api-key': AuthUrl.saveAuthkey
                        // 'x-api-key': '4ZFnGzsQnEspkuOsUWxMHY5FSBaqmue0'
                    },
                    body: JSON.stringify({
                        "action": "sendMMS",
                        "service-id": didData.camp_registry,
                        "to": "1" + TO,
                        "from": "1" + FROM,
                        "from-mask": "1" + FROM,
                        "fallback-sms-text": "MMS",
                        "disable-fallback-sms-link": false,
                        "disable-fallback-sms": false,
                        "slide": fType
                    })
                };
                (0, axios_1.request)(options, (error, response) => {
                    if (!error) {
                        try {
                            let dStatus = JSON.parse(response.body);
                            if (dStatus['status'] == 'success') {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `mms_dlr` (`idaccount`,`iduser`,`status`,`from`,`to`,`tracking_id`,`status_details`,`dca`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "','" + dStatus['status'] + "','" + FROM + "','" + TO + "','" + dStatus['tracking-id'] + "','" + dStatus['status-details'] + "','" + didData.SmsProvider + "')";
                                obj1.prepare();
                                obj1.execute((errord, responced) => {
                                    if (errord == 1) {
                                        console.log("Sinch mms_dlr Data Inserted Successfully!");
                                    }
                                    else {
                                        console.log("Sinch mms_dlr Data Not Inserted Successfully!");
                                    }
                                });
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`, `slide`, `direction`,`dca`,`did_provider`,`service_id`,`cost`,`type`) VALUES('" + dStatus['tracking-id'] + "','" + TO + "','" + mms_rate[0].MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','3','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + file + "', 'outbound','" + didData.SmsProvider + "','" + didData.DIDProvider + "','" + didData.camp_registry + "','" + cost + "','2')";
                                obj.prepare();
                                obj.execute((error, responce) => {
                                    if (error == 1) {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 201, message: "MMS sent successfully", batch_id: dStatus['tracking-id'] });
                                        obj.execute();
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                });
                            }
                            else {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`, `operator`, `slide`, `direction`,`dca`,`did_provider`,`service_id`,`cost`,`type`) VALUES('0','" + TO + "','" + mms_rate[0].MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','0','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(sessdata.idapi) + "','" + lerg_data[0].rates + "','" + (0, markError_1.setToZero)(lerg_data[0].idoperator) + "','" + lerg_data[0].name + "','" + file + "','outbound','" + didData.SmsProvider + "','" + didData.DIDProvider + "','" + didData.camp_registry + "','0','2')";
                                obj.prepare();
                                obj.execute((error, responce) => {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 400, message: "MMS sent failed" });
                                    obj.execute();
                                });
                            }
                        }
                        catch (e) {
                            console.log("Error :: saveMMS Sinch::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        });
    }
}
exports.SMS = SMS;
