"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LergApi = void 0;
var mysql = require('mysql');
const setting_config_1 = require("../config/setting.config");
const APIBase_1 = require("./APIBase");
const lrnUrlAuth = new setting_config_1.lrnApi();
let base = new APIBase_1.APIBase();
const axios_1 = require("./axios");
/* let LRNDBCred: any = {
    host: "38.95.11.29",
    user: "xnign",
    password: "8TL7Jey2p2JKt5A",
    database: "lrn"
} */
const pool = mysql.createPool({
    connectionLimit: 1000,
    waitForConnections: true,
    connectTimeout: 10000,
    host: "208.78.161.30",
    user: "xnign",
    password: "8TL7Jey2p2JKt5A",
    database: "lrn"
});
const pooldnc = mysql.createPool({
    connectionLimit: 1000,
    waitForConnections: true,
    connectTimeout: 10000,
    host: "208.78.161.30",
    user: "xnign",
    password: "8TL7Jey2p2JKt5A",
    database: "lrn"
});
class LergApi {
    auth_token;
    LrnURL;
    constructor(proirity, account) {
        this.auth_token = "";
        // for development
        this.LrnURL = "http://127.0.0.1:4264/get_lrn_details";
        // for production
        // this.LrnURL = "https://api.signalmash.com/lrn/get_lrn_details"
    }
    signIn(req, res, callback) {
        var headers = {
            'accept': 'application/json'
        };
        var options = {
            url: lrnUrlAuth.signInOutUrl + 'sign_in?user[email]=' + lrnUrlAuth.email + '&user[password]=' + lrnUrlAuth.password,
            // url: 'https://api-iplink.peeredge.com/api/v1/users/sign_in?user[email]=' + email + '&user[password]=' + password,
            method: 'POST',
            headers: headers
        };
        (0, axios_1.request)(options, (error, responce) => {
            if (!error) {
                let data = JSON.parse(responce.body);
                this.auth_token = data.auth_token;
                callback('', data);
            }
            else {
                callback(error, '');
            }
        });
    }
    lrnDetails(req, res, auth_token, callback) {
        let number;
        if (req.body.CALLEE !== undefined) {
            number = req.body.CALLEE;
        }
        else {
            number = req.body.TO == undefined ? req.body.Number : req.body.TO;
        }
        let token = auth_token == undefined ? this.auth_token : auth_token;
        var headers = {
            'accept': 'application/json',
            'Token': token
        };
        var options = {
            url: lrnUrlAuth.lrnDetailUrl + number,
            // url: 'https://api-iplink.peeredge.com/api/v1/reportings/get_lrn?lrn=' + number,
            method: 'GET',
            headers: headers
        };
        console.log("options", options);
        (0, axios_1.request)(options, (error, responce) => {
            if (!error) {
                let data = JSON.parse(responce.body);
                callback("", data);
            }
            else {
                let Error = JSON.parse(error);
                callback(Error, '');
            }
        });
    }
    lrnDetailsM1(req, res, PayLoad, callback) {
        console.log("PayLoadPayLoad :: ", PayLoad);
        console.log("PayLoadPayLoad TO:: ", PayLoad.TO);
        if (PayLoad.TO && PayLoad.TO.length == 10 && isNaN(PayLoad.TO) === false) {
            pool.getConnection((__error, connection) => {
                if (!__error) {
                    connection.query("CALL sqlrnx(" + PayLoad.TO.trim() + ");", (error, result) => {
                        if (!error) {
                            let LrnData = Array.isArray(result[0]) && (result[0].length > 0) ? result[0][0] : "";
                            let LrnNumber = (LrnData.hasOwnProperty('lrn') && LrnData.lrn) ? LrnData.lrn : PayLoad.TO;
                            if (!LrnData) {
                                let did = "" + LrnNumber + "";
                                let len = did.length - 10;
                                let number1 = did.slice(len, did.length);
                                let npa = number1.slice(0, 3);
                                let nxx = number1.slice(3, 6);
                                base.checkLergInfoDetail(req, res, parseInt(npa), parseInt(nxx), (lrn_err, lrn_details) => {
                                    console.log("lrnDetailsM1 -> lrn_details :: ", lrn_details);
                                    if (lrn_err == 1) {
                                        if (lrn_details) {
                                            let lrndata = {
                                                lrn: LrnNumber,
                                                LATA: lrn_details.lata,
                                                OCN: lrn_details.ocn,
                                                ST: lrn_details.state
                                            };
                                            callback("", { lrn: LrnNumber, data: lrndata });
                                        }
                                        else {
                                            callback("", { lrn: "", data: "" });
                                        }
                                    }
                                    else {
                                        callback("", { lrn: "", data: "" });
                                    }
                                });
                            }
                            else {
                                callback("", { lrn: LrnNumber, data: LrnData });
                            }
                        }
                        else {
                            console.log(`[${new Date().toISOString()}]`, " Mysql Query Error:: ", "Calling lrnDetailsM1, Secondary DB :: \n ", error);
                            this.lrnDetailsM2(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                callback(lrn_err, lrn_detail);
                            });
                        }
                        connection.release();
                    });
                }
                else {
                    console.log(`[${new Date().toISOString()}]`, " Mysql Connection Error :: ", "Calling lrnDetailsM1, Secondary DB :: \n", __error);
                    this.lrnDetailsM2(req, res, PayLoad, (lrn_err, lrn_detail) => {
                        callback(lrn_err, lrn_detail);
                    });
                }
            });
        }
        else {
            console.log("Invalid Number ::", PayLoad.TO);
            callback("Invalid Number!", { lrn: "", data: "" });
        }
    }
    lrnDetailsM2(req, res, PayLoad, callback) {
        if (PayLoad.TO && PayLoad.TO.length == 10 && isNaN(PayLoad.TO) === false) {
            pooldnc.getConnection((__error, connection) => {
                if (!__error) {
                    connection.query("CALL diddata_multiple_fast(" + PayLoad.TO.trim() + ");", (error, result) => {
                        if (!error) {
                            let LrnData = Array.isArray(result[0]) && (result[0].length > 0) ? result[0][0] : "";
                            let LrnNumber = (LrnData.hasOwnProperty('lrn') && LrnData.lrn) ? LrnData.lrn : PayLoad.TO;
                            if (!LrnData) {
                                let did = "" + LrnNumber + "";
                                let len = did.length - 10;
                                let number1 = did.slice(len, did.length);
                                let npa = number1.slice(0, 3);
                                let nxx = number1.slice(3, 6);
                                base.checkLergInfoDetail(req, res, parseInt(npa), parseInt(nxx), (lrn_err, lrn_details) => {
                                    console.log("lrnDetailsM2 -> lrn_details :: ", lrn_details);
                                    if (lrn_err == 1) {
                                        if (lrn_details) {
                                            let lrndata = {
                                                lrn: LrnNumber,
                                                LATA: lrn_details.lata,
                                                OCN: lrn_details.ocn,
                                                ST: lrn_details.state
                                            };
                                            callback("", { lrn: LrnNumber, data: lrndata });
                                        }
                                        else {
                                            callback("", { lrn: "", data: "" });
                                        }
                                    }
                                    else {
                                        callback("", { lrn: "", data: "" });
                                    }
                                });
                            }
                            else {
                                callback("", { lrn: LrnNumber, data: LrnData });
                            }
                        }
                        else {
                            console.log(`[${new Date().toISOString()}]`, " Mysql Query Error [lrnDetailsM2] ::\n", error);
                            let did = "" + PayLoad.TO + "";
                            let len = did.length - 10;
                            let number1 = did.slice(len, did.length);
                            let npa = number1.slice(0, 3);
                            let nxx = number1.slice(3, 6);
                            base.checkLergInfoDetail(req, res, parseInt(npa), parseInt(nxx), (lrn_err, lrn_details) => {
                                console.log("lrnDetailsM2 -> lrn_details :: ", lrn_details);
                                if (lrn_err == 1) {
                                    if (lrn_details) {
                                        let lrndata = {
                                            lrn: PayLoad.TO,
                                            LATA: lrn_details.lata,
                                            OCN: lrn_details.ocn,
                                            ST: lrn_details.state
                                        };
                                        callback(error, { lrn: PayLoad.TO, data: lrndata });
                                    }
                                    else {
                                        callback("", { lrn: "", data: "" });
                                    }
                                }
                                else {
                                    callback("", { lrn: "", data: "" });
                                }
                            });
                        }
                        connection.release();
                    });
                }
                else {
                    console.log(`[${new Date().toISOString()}]`, " Mysql Connection Error [lrnDetailsM2] ::\n", __error);
                    let did = "" + PayLoad.TO + "";
                    let len = did.length - 10;
                    let number1 = did.slice(len, did.length);
                    let npa = number1.slice(0, 3);
                    let nxx = number1.slice(3, 6);
                    base.checkLergInfoDetail(req, res, parseInt(npa), parseInt(nxx), (lrn_err, lrn_details) => {
                        console.log("lrnDetailsM2 -> lrn_details :: ", lrn_details);
                        if (lrn_err == 1) {
                            if (lrn_details) {
                                let lrndata = {
                                    lrn: PayLoad.TO,
                                    LATA: lrn_details.lata,
                                    OCN: lrn_details.ocn,
                                    ST: lrn_details.state
                                };
                                callback("", { lrn: PayLoad.TO, data: lrndata });
                            }
                            else {
                                callback(__error, { lrn: "", data: "" });
                            }
                        }
                        else {
                            callback(__error, { lrn: "", data: "" });
                        }
                    });
                }
            });
        }
        else {
            console.log("Invalid Number ::", PayLoad.TO);
            callback("Invalid Number!", { lrn: "", data: "" });
        }
    }
    /* public lrnDetailsM1(req: Request, res: Response, PayLoad: any, callback: (err: any, data: any) => void) {
        if (PayLoad.TO && PayLoad.TO.length == 10 && isNaN(PayLoad.TO)===false) {
            let Conn: any = mysql.createConnection(LRNDBCred);
            Conn.connect((error: any) => {
                if (!error) {
                    Conn.query("CALL sqlrnx(" + PayLoad.TO.trim() + ");", (error: any, result: any) => {
                        if (!error) {
                            let LrnData: any = Array.isArray(result[0]) && (result[0].length > 0) ? result[0][0] : ""
                            let LrnNumber: any = (LrnData.hasOwnProperty('lrn') && LrnData.lrn) ? LrnData.lrn : ""
                            callback("", { lrn: LrnNumber, data: LrnData })
                        }
                        else {
                            console.log("Mysql Query Error::\n", error)
                            callback(error, { lrn: "", data: "" })
                        }
                        Conn.end()
                    })
                }
                else {
                    console.log("Mysql Connection Error::\n", error)
                    callback(error, { lrn: "", data: "" })
                }
            });
        }
        else {
            console.log("Invalid Number!")
            callback("Invalid Number!", { lrn: "", data: "" })
        }
    } */
    signOut(req, res, callback) {
        var headers = {
            'accept': 'application/json',
            'Token': ''
        };
        var options = {
            url: lrnUrlAuth.signInOutUrl + 'sign_out',
            // url: 'https://api-iplink.peeredge.com/api/v1/users/sign_out',
            method: 'POST',
            headers: headers
        };
        (0, axios_1.request)(options, (error, responce) => {
            if (!error) {
                let data = JSON.parse(responce.body);
                callback('', data);
            }
            else {
                callback(error, '');
            }
        });
    }
    lrnDetails_Old(req, res, auth_token, callback) {
        let number;
        if (req.body.CALLEE !== undefined) {
            number = req.body.CALLEE;
        }
        else {
            number = req.body.TO == undefined ? req.body.Number : req.body.TO;
        }
        let token = auth_token == undefined ? this.auth_token : auth_token;
        var headers = {
            'accept': 'application/json',
            'Token': token
        };
        var options = {
            url: lrnUrlAuth.lrnDetailUrl + number,
            // url: 'https://api-iplink.peeredge.com/api/v1/reportings/get_lrn?lrn=' + number,
            method: 'GET',
            headers: headers
        };
        console.log("options", options);
        (0, axios_1.request)(options, (error, responce) => {
            if (!error) {
                let data = JSON.parse(responce.body);
                callback("", data);
            }
            else {
                let Error = JSON.parse(error);
                callback(Error, '');
            }
        });
    }
}
exports.LergApi = LergApi;
