"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uploadTollFreeSingle = exports.uploadTollFreeMultiple = exports.uploadKYC = exports.uploadFEDERAL = exports.uploadCARD = exports.uploadMMS = exports.SaveNotesUpload = void 0;
const multer_1 = __importDefault(require("multer"));
const path_1 = __importDefault(require("path"));
const setting_config_1 = require("../config/setting.config");
/* -----------------------------------------------------
   COMMON MIME TYPES USED BY MOST MODULES
----------------------------------------------------- */
const COMMON_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "image/gif": "gif",
    "image/webp": "webp",
    "text/csv": "csv",
    "application/pdf": "pdf",
    "text/plain": "txt",
    "audio/mpeg": "mp3",
    "audio/wav": "wav",
    "audio/webm": "weba",
    "video/mp4": "mp4",
    "application/vnd.ms-excel": "xls",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
};
/* -----------------------------------------------------
   NOTES EXTRA MIME
----------------------------------------------------- */
const NOTE_EXTRA_MIME = {
    "audio/3gpp": "3ga",
    "video/3gpp": "3gp",
    "audio/amr": "amr",
    "video/x-msvideo": "avi",
    "application/x-bzip2": "bz2",
    "application/calendar": "cal",
    "text/css": "css",
    "image/dib": "dib",
    "audio/flac": "flac",
    "video/x-flv": "flv",
    "application/x-gzip": "gz",
    "image/x-icon": "ico",
    "application/javascript": "js",
    "application/json": "json",
    "audio/x-mp3": "mp3",
    "video/x-ms-wmv": "wmv",
    "application/xml": "xml",
    "application/zip": "zip"
};
/* -----------------------------------------------------
   COMPLETE MIME USED BY NOTES
----------------------------------------------------- */
const NOTE_MIME = { ...COMMON_MIME, ...NOTE_EXTRA_MIME };
/* -----------------------------------------------------
   MMS / CARD / FEDERAL / KYC – ONLY COMMON MIME
----------------------------------------------------- */
const MMS_MIME = { ...COMMON_MIME };
const CARD_MIME = { ...COMMON_MIME };
const FEDERAL_MIME = { ...COMMON_MIME };
const KYC_MIME = { ...COMMON_MIME };
/* -----------------------------------------------------
   TOLLFREE MIME GROUPS (as per your old code)
----------------------------------------------------- */
const TOLLFREE_MIME1 = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx',
    'application/zip': 'zip'
};
const TOLLFREE_MIME2 = {
    ...TOLLFREE_MIME1,
    "image/svg+xml": "svg",
    "image/heic": "heic",
    "image/bmp": "bmp",
    "image/avif": "avif",
    "video/webm": "webm",
    "video/3gpp": "3gp",
    "video/x-msvideo": "avi",
    "video/x-flv": "flv",
    "video/x-ms-wmv": "wmv",
    "video/mpeg": "mpeg",
    "audio/aac": "aac",
    "audio/amr": "amr",
    "application/json": "json",
    "application/javascript": "js",
    "application/xml": "xml",
    "audio/flac": "flac"
};
const TOLLFREE_MIME3 = {
    "video/quicktime": "mov",
    "application/vnd.ms-powerpoint": "ppt",
    "application/vnd.visio": "visio",
    "application/rtf": "rtf",
    "application/msword": "doc",
    "application/vnd.oasis.opendocument.text": "odt",
    "application/x-zip-compressed": "zip",
    "application/vnd.openxmlformats-officedocument.presentationml.presentation": "pptx",
};
/* -----------------------------------------------------
   UNIVERSAL STORAGE ENGINE
----------------------------------------------------- */
const storage = multer_1.default.diskStorage({
    destination: (req, file, cb) => {
        const dirs = new setting_config_1.UploadDirectory();
        const route = req.route?.path;
        let valid = false;
        let folder = "";
        /* --------------------------------------------------
           NOTES
        -------------------------------------------------- */
        if (route === "/add_user_note" || route === "/saveusernotefile") {
            valid = !!NOTE_MIME[file.mimetype];
            folder = dirs.SAVENOTES;
        }
        /* --------------------------------------------------
           MMS MEDIA
        -------------------------------------------------- */
        else if (route === "/uploadmmsmedia" || route === "/uploadMedia" || route === "/updateMediaFile") {
            valid = !!MMS_MIME[file.mimetype];
            folder = route === "/uploadmmsmedia"
                ? dirs.MMSUPLOADS
                : dirs.MEDIAUPLOAD;
        }
        /* --------------------------------------------------
           CARD
        -------------------------------------------------- */
        else if (route === "/uploads/card_pdf" || route === "/uploads/card_pdf_onboarding") {
            valid = !!CARD_MIME[file.mimetype];
            folder = dirs.CARDFILEUPLOAD;
        }
        /* --------------------------------------------------
           FEDERAL
        -------------------------------------------------- */
        else if (route === "/savefederalpdf") {
            valid = !!FEDERAL_MIME[file.mimetype];
            folder = dirs.FEDERALFILEUPLOAD;
        }
        /* --------------------------------------------------
           KYC
        -------------------------------------------------- */
        else if (route === "/kyc_upload") {
            valid = !!KYC_MIME[file.mimetype];
            folder = dirs.KYCFILEUPLOAD;
        }
        /* --------------------------------------------------
           TOLL-FREE EMAIL
        -------------------------------------------------- */
        else if (route === "/savenotifyemail") {
            valid = !!TOLLFREE_MIME2[file.mimetype];
            folder = dirs.EMAILNOTIFICATION;
        }
        /* --------------------------------------------------
           SHORT CODE
        -------------------------------------------------- */
        else if (route === "/saveShortCodeCampaign" ||
            route === "/updateshortcampaign" ||
            route === "/sc_sendMail" ||
            route === "/sendshortcoderequest" ||
            route === "/Saverandomvanity" ||
            route === "/updateSCRequest") {
            valid = !!TOLLFREE_MIME3[file.mimetype];
            folder = dirs.SHORTCODECAMPAIGN;
        }
        /* --------------------------------------------------
           NORMAL TOLL-FREE
        -------------------------------------------------- */
        else {
            valid = !!TOLLFREE_MIME1[file.mimetype];
            folder = dirs.TOLLFREEUPLOADS;
        }
        if (!folder)
            return cb(new Error("Upload route not registered"));
        if (!valid)
            return cb(new Error("Invalid file type"));
        cb(null, folder);
    },
    filename: (req, file, cb) => {
        const ext = path_1.default.extname(file.originalname);
        const rnd = Math.random().toString(36).substring(2, 12);
        cb(null, `${Date.now()}-${rnd}${ext}`);
    }
});
/* -----------------------------------------------------
   EXPORT UPLOADS (NO ROUTES CHANGED)
----------------------------------------------------- */
exports.SaveNotesUpload = (0, multer_1.default)({ storage }).array("ATTACHMENTS");
exports.uploadMMS = (0, multer_1.default)({ storage }).single("UPLOAD");
exports.uploadCARD = (0, multer_1.default)({ storage }).single("UPLOAD");
exports.uploadFEDERAL = (0, multer_1.default)({ storage }).single("UPLOAD");
exports.uploadKYC = (0, multer_1.default)({ storage }).single("UPLOAD");
/* TOLLFREE UPLOADS */
exports.uploadTollFreeMultiple = (0, multer_1.default)({ storage }).array("ATTACHMENTS");
exports.uploadTollFreeSingle = (0, multer_1.default)({ storage }).single("ATTACHMENT");
