"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.errorHandler = exports.appeal = exports.taxDetailMuler = exports.SaveNotesUpload = exports.invoicePdf = exports.campaignMulter = exports.uploadKYC = exports.uploadFEDERAL = exports.uploadCARD = exports.tollfreemulter = exports.extractImage = exports.uploadMMS = exports.extMMS = void 0;
const multer_1 = __importDefault(require("multer"));
const path_1 = __importDefault(require("path"));
const setting_config_1 = require("../config/setting.config");
/* =====================================================
   UNIFIED MULTER CONFIGURATION - ALL ROUTES COMBINED
   ===================================================== */
const dirs = new setting_config_1.UploadDirectory();
/* =====================================================
   MIME TYPE MAPPINGS BY MODULE
   ===================================================== */
/* APPEAL UPLOADS */
const APPEAL_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "application/pdf": "pdf",
    "text/plain": "txt",
    "image/bmp": "bmp",
    "image/tiff": "tiff",
    "text/html": "htm",
    "application/vnd.oasis.opendocument.text": "odt",
    "application/rtf": "rtf",
    "application/xml": "xml",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx"
};
/* MMS UPLOADS - From multerlib.ts */
const MMS_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "image/gif": "gif",
    "image/webp": "webp",
    "text/csv": "csv",
    "application/pdf": "pdf",
    "text/plain": "txt",
    "audio/mpeg": "mp3",
    "audio/wav": "wav",
    "audio/webm": "weba",
    "video/mp4": "mp4",
    "application/vnd.ms-excel": "xls",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
    "image/bmp": "bmp",
    "image/gif; version=\"87a\"": "gif",
    "image/gif; version=\"89a\"": "gif",
    "audio/qcelp": "qcelp",
    "audio/QCELP": "qcp",
    "audio/midi": "midi",
    "audio/mid": "mid",
    "audio/amr": "amr",
    "audio/aac": "aac",
    "audio/aacp": "aacp",
    "video/h263": "h263",
    "video/h264": "h264",
    "video/jpeg": "jpgv",
    "video/3gpp": "3gp",
    "video/3gpp2": "3g2",
    "video/mp4v-es": "mp4",
    "video/mp4-es": "mp4",
    "video/quicktime": "mov",
    "application/gzip": "gz",
    "application/zip": "zip",
    "application/x-zip-compressed": "zip",
    "text/x-vcard": "vcf",
    "text/vcard": "vcf",
    "text/v-card": "vcf",
    "text/calendar": "ics",
    "text/html": "html",
    "text/xml": "xml",
    "audio/3gpp": "3gp",
    "audio/3gpp2": "3g2",
    "audio/evrc": "3g2",
    "audio/mp3": "mp3",
    "audio/mp4": "mp4",
    "audio/ogg": "ogg",
    "audio/vnd.qcelp": "qcp",
    "audio/x-ms-wma": "wma",
    "audio/x-wav": "wav",
    "video/ogg": "ogg",
    "video/x-flx": "flv",
    "video/x-ms-asf": "asx",
    "video/x-ms-wmv": "wmv",
    "video/x-sgi-movie": "movie",
    "multipart/related": "txt",
    "application/ogg": "ogg",
    "application/smil": "smil",
    "application/vnd ms-outlook": "msg"
};
/* PROFILE IMAGE UPLOADS */
const PROFILE_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "image/gif": "gif",
    "image/webp": "webp",
    "text/csv": "csv",
    "application/pdf": "pdf",
    "text/plain": "txt",
    "audio/mpeg": "mp3",
    "video/mp4": "mp4",
    "application/vnd.ms-excel": "xls",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx"
};
/* TOLL FREE & SHORT CODE UPLOADS */
const TOLLFREE_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "image/gif": "gif",
    "image/webp": "webp",
    "text/csv": "csv",
    "application/pdf": "pdf",
    "text/plain": "txt",
    "audio/mpeg": "mp3",
    "audio/wav": "wav",
    "audio/webm": "weba",
    "video/mp4": "mp4",
    "application/vnd.ms-excel": "xls",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
    "application/zip": "zip"
};
/* EMAIL NOTIFICATION UPLOADS */
const EMAIL_NOTIFICATION_MIME = {
    "image/png": "png",
    "image/jpg": "jpg",
    "image/jpeg": "jpeg",
    "image/svg+xml": "svg",
    "image/heic": "heic",
    "image/webp": "webp",
    "image/gif": "gif",
    "image/gif; version=\"87a\"": "gif",
    "image/gif; version=\"89a\"": "gif",
    "image/avif": "avif",
    "image/bmp": "bmp",
    "image/dib": "dib",
    "image/x-icon": "ico",
    "image/pjpeg": "pjpeg",
    "video/mp4": "mp4",
    "video/mp4v-es": "mp4",
    "video/mp4-es": "mp4",
    "video/mpeg": "mpeg",
    "video/webm": "webm",
    "video/3gpp": "3gp",
    "video/x-msvideo": "avi",
    "video/x-flv": "flv",
    "video/m1v": "m1v",
    "video/mpg": "mpg",
    "video/quicktime": "qt",
    "video/x-ms-wmv": "wmv",
    "video/h263": "h263",
    "video/h264": "h264",
    "video/jpeg": "jpgv",
    "video/3gpp2": "3g2",
    "audio/x-mp3": "mp3",
    "audio/webm": "weba",
    "audio/x-wav": "wav",
    "audio/3gpp": "3ga",
    "audio/amr": "amr",
    "audio/wav": "wav",
    "audio/flac": "flac",
    "audio/mpeg": "mp3",
    "audio/m2a": "m2a",
    "audio/x-m4a": "m4a",
    "audio/m4b": "m4b",
    "audio/x-ms-wma": "mpa",
    "audio/qcelp": "qcelp",
    "audio/QCELP": "qcp",
    "audio/midi": "midi",
    "audio/mid": "mid",
    "audio/aac": "aac",
    "audio/aacp": "aacp",
    "audio/vnd.dlna.adts": "aac",
    "audio/ogg": "ogg",
    "text/csv": "csv",
    "text/plain": "txt",
    "text/css": "css",
    "text/rtf": "rtf",
    "text/html": "html",
    "text/javascript": "js",
    "text/x-vcard": "vcf",
    "application/x-bzip2": "bz2",
    "application/calendar": "cal",
    "application/x-gzip": "gz",
    "application/javascript": "js",
    "application/json": "json",
    "application/pdf": "pdf",
    "application/xml": "xml",
    "application/zip": "zip",
    "application/x-zip-compressed": "zip",
    "application/x-msdownload": "exe",
    "application/vnd.ms-excel": "xls",
    "application/octet-stream": "rar",
    "application/vnd.ms-powerpoint": "ppt",
    "application/msword": "doc",
    "application/x-freearc": "arc",
    "application/java-archive": "jar",
    "application/vnd.openxmlformats-officedocument.presentationml.presentation": "pptx",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
    "application/gzip": "gz",
    "application/rtf": "rtf"
};
/* SHORT CODE CAMPAIGN UPLOADS */
const SHORT_CODE_MIME = {
    "video/quicktime": "mov",
    "application/vnd.ms-powerpoint": "ppt",
    "application/vnd.visio": "visio",
    "text/plain": "txt",
    "application/rtf": "rtf",
    "image/tiff": "tif",
    "image/jpg": "jpg",
    "image/jpeg": "jpeg",
    "image/gif": "gif",
    "application/zip": "zip",
    "application/x-zip-compressed": "zip",
    "application/vnd.ms-excel": "excel",
    "text/csv": "csv",
    "image/png": "png",
    "application/msword": "doc",
    "application/vnd.oasis.opendocument.text": "odt",
    "application/pdf": "pdf",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx"
};
/* MMS & MEDIA UPLOADS */
const MEDIA_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "image/gif": "gif",
    "image/webp": "webp",
    "image/bmp": "bmp",
    "image/gif; version=\"87a\"": "gif",
    "image/gif; version=\"89a\"": "gif",
    "audio/mpeg": "mp3",
    "audio/wav": "wav",
    "audio/wave": "wav",
    "audio/webm": "weba",
    "audio/qcelp": "qcelp",
    "audio/QCELP": "qcp",
    "audio/x-wav": "xwav",
    "audio/midi": "midi",
    "audio/mid": "mid",
    "audio/amr": "amr",
    "audio/aac": "aac",
    "audio/aacp": "aacp",
    "audio/vnd.dlna.adts": "aac",
    "video/h263": "h263",
    "video/h264": "h264",
    "video/jpeg": "jpgv",
    "video/3gpp": "3gp",
    "video/mp4": "mp4",
    "video/3gpp2": "3g2",
    "video/mp4v-es": "mp4",
    "video/mp4-es": "mp4",
    "video/quicktime": "mov",
    "application/gzip": "gz",
    "application/rtf": "rtf",
    "application/zip": "zip",
    "application/x-zip-compressed": "zip",
    "application/pdf": "pdf",
    "application/msword": "rtf",
    "application/x-gzip": "gz",
    "text/x-vcard": "vcf",
    "text/vcard": "vcf"
};
/* USER NOTES & CAMPAIGN UPLOADS */
const NOTES_CAMPAIGN_MIME = {
    "text/csv": "csv",
    "audio/3gpp": "3ga",
    "video/3gpp": "3gp",
    "text/plain": "txt",
    "audio/amr": "amr",
    "video/x-msvideo": "avi",
    "image/bmp": "bmp",
    "application/x-bzip2": "bz2",
    "application/calendar": "cal",
    "text/css": "css",
    "image/dib": "dib",
    "audio/flac": "flac",
    "video/x-flv": "flv",
    "image/gif": "gif",
    "application/x-gzip": "gz",
    "image/x-icon": "ico",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "application/javascript": "js",
    "application/json": "json",
    "audio/mpeg": "m1a",
    "video/m1v": "m1v",
    "audio/m2a": "m2a",
    "audio/x-m4a": "m4a",
    "audio/m4b": "m4b",
    "audio/x-mp3": "mp3",
    "video/mp4": "mp4",
    "audio/x-ms-wma": "mpa",
    "video/mpeg": "mpeg",
    "video/mpg": "mpg",
    "application/pdf": "pdf",
    "image/pjpeg": "pjpeg",
    "image/png": "png",
    "video/quicktime": "qt",
    "text/rtf": "rtf",
    "audio/x-wav": "wav",
    "video/webm": "webm",
    "image/webp": "webp",
    "video/x-ms-wmv": "wmv",
    "application/xml": "xml",
    "application/zip": "zip"
};
/* KYC, CARD & FEDERAL UPLOADS */
const BASIC_MIME = {
    "image/png": "png",
    "image/jpeg": "jpeg",
    "image/jpg": "jpg",
    "image/gif": "gif",
    "image/webp": "webp",
    "text/csv": "csv",
    "application/pdf": "pdf",
    "text/plain": "txt",
    "audio/mpeg": "mp3",
    "audio/wav": "wav",
    "audio/webm": "weba",
    "video/mp4": "mp4",
    "application/vnd.ms-excel": "xls",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx"
};
/* TAX DETAILS UPLOADS */
const TAX_MIME = BASIC_MIME;
/* INVOICE/CLOSE ACCOUNT UPLOADS */
const INVOICE_MIME = BASIC_MIME;
/* =====================================================
   UNIVERSAL STORAGE ENGINE WITH ROUTE DETECTION
   ===================================================== */
const unifiedStorage = multer_1.default.diskStorage({
    destination: (req, file, cb) => {
        // Try multiple ways to get the route
        const route = req.route?.path || req.baseUrl || req.originalUrl?.split('?')[0];
        // route detection values are available via req.route, req.baseUrl, req.originalUrl
        let valid = false;
        let folder = "";
        let mimeMap = BASIC_MIME;
        /* APPEAL UPLOADS - appealRequest, appealVettingRequest, appealEvidence, brandAppeal, brandVettingAppeal */
        if (route === "/appealRequest" ||
            route === "/appealVettingRequest" ||
            route === "/appealEvidence" ||
            route === "/brandAppeal" ||
            route === "/brandVettingAppeal") {
            valid = !!APPEAL_MIME[file.mimetype];
            mimeMap = APPEAL_MIME;
            folder = dirs.APPEALUPLOADS;
        }
        /* MMS UPLOADS - From multerlib.ts - /messages, /mms, /post_mms */
        else if (route === "/messages" ||
            route === "/mms" ||
            route === "/post_mms" ||
            route === "/sendMMSTemplate") {
            valid = !!MMS_MIME[file.mimetype];
            mimeMap = MMS_MIME;
            folder = dirs.MMSUPLOADS;
        }
        /* PROFILE IMAGE UPLOADS - user, updateTheme, profile-pic, removeProfile-pic, getMultiSearch, upload_lerg, upload_zone, uploadDid */
        else if (route === "/user" ||
            route === "/updateTheme" ||
            route === "/profile-pic" ||
            route === "/removeProfile-pic" ||
            route === "/getMultiSearch" ||
            route === "/upload_lerg" ||
            route === "/upload_zone" ||
            route === "/uploadDid") {
            valid = !!PROFILE_MIME[file.mimetype];
            mimeMap = PROFILE_MIME;
            folder = "uploads";
        }
        /* TOLL FREE UPLOADS - saveVefiySender, sentMailtoIntq, updateVerifySender */
        else if (route === "/saveVefiySender" ||
            route === "/sentMailtoIntq" ||
            route === "/updateVerifySender") {
            valid = !!TOLLFREE_MIME[file.mimetype];
            mimeMap = TOLLFREE_MIME;
            folder = dirs.TOLLFREEUPLOADS;
        }
        /* SHORT CODE CAMPAIGN UPLOADS - saveShortCodeCampaign, updateshortcampaign, sc_sendMail, sendshortcoderequest, updateSCRequest, Saverandomvanity - Uses SHORT_CODE_MIME */
        else if (route === "/saveShortCodeCampaign" ||
            route === "/updateshortcampaign" ||
            route === "/sc_sendMail" ||
            route === "/sendshortcoderequest" ||
            route === "/updateSCRequest" ||
            route === "/Saverandomvanity") {
            valid = !!SHORT_CODE_MIME[file.mimetype];
            mimeMap = SHORT_CODE_MIME;
            folder = dirs.SHORTCODECAMPAIGN;
        }
        /* EMAIL NOTIFICATION UPLOADS - savenotifyemail */
        else if (route === "/savenotifyemail") {
            valid = !!EMAIL_NOTIFICATION_MIME[file.mimetype];
            mimeMap = EMAIL_NOTIFICATION_MIME;
            folder = dirs.EMAILNOTIFICATION;
        }
        /* SHORT CODE CAMPAIGN UPLOADS - handled under TOLL FREE above */
        /* MMS & MEDIA UPLOADS - uploadmmsmedia, uploadMedia, updateMediaFile */
        else if (route === "/uploadmmsmedia" ||
            route === "/uploadMedia" ||
            route === "/updateMediaFile") {
            valid = !!MEDIA_MIME[file.mimetype];
            mimeMap = MEDIA_MIME;
            folder =
                route === "/uploadmmsmedia" ? dirs.MMSUPLOADS : dirs.MEDIAUPLOAD;
        }
        /* KYC UPLOADS - kyc_upload */
        else if (route === "/kyc_upload") {
            valid = !!BASIC_MIME[file.mimetype];
            mimeMap = BASIC_MIME;
            folder = dirs.KYCFILEUPLOAD;
        }
        /* CARD UPLOADS - uploads/card_pdf, uploads/card_pdf_onboarding */
        else if (route === "/uploads/card_pdf" ||
            route === "/uploads/card_pdf_onboarding") {
            valid = !!BASIC_MIME[file.mimetype];
            mimeMap = BASIC_MIME;
            folder = dirs.CARDFILEUPLOAD;
        }
        /* FEDERAL UPLOADS - savefederalpdf */
        else if (route === "/savefederalpdf") {
            valid = !!BASIC_MIME[file.mimetype];
            mimeMap = BASIC_MIME;
            folder = dirs.FEDERALFILEUPLOAD;
        }
        /* USER NOTES UPLOADS - add_user_note, saveusernotefile */
        else if (route === "/add_user_note" ||
            route === "/saveusernotefile") {
            valid = !!NOTES_CAMPAIGN_MIME[file.mimetype];
            mimeMap = NOTES_CAMPAIGN_MIME;
            folder = dirs.SAVENOTES;
        }
        /* CAMPAIGN UPLOADS - registercampaign, campaign_register, campaignMultimediaFileUpload, campaignPanelFileUploader, CNPcampApproveByAdmin, campApproveByAdmin, copycampaign, redundantcampaign */
        else if (route === "/registercampaign" ||
            route === "/campaign_register" ||
            route === "/campaignMultimediaFileUpload" ||
            route === "/campaignPanelFileUploader" ||
            route === "/CNPcampApproveByAdmin" ||
            route === "/campApproveByAdmin" ||
            route === "/copycampaign" ||
            route === "/redundantcampaign") {
            valid = !!NOTES_CAMPAIGN_MIME[file.mimetype];
            mimeMap = NOTES_CAMPAIGN_MIME;
            folder = dirs.CAMPAIGNUPLOAD;
        }
        /* TAX DETAILS UPLOADS - updatetax */
        else if (route === "/updatetax") {
            valid = !!TAX_MIME[file.mimetype];
            mimeMap = TAX_MIME;
            folder = dirs.TAXDETAILS;
        }
        /* INVOICE/CLOSE ACCOUNT UPLOADS - sendInvoicePdf */
        else if (route === "/sendInvoicePdf") {
            valid = !!INVOICE_MIME[file.mimetype];
            mimeMap = INVOICE_MIME;
            folder = dirs.CLOSEACCOUNTPDF;
        }
        /* If route not matched */
        if (!folder) {
            return cb(new Error("Upload route not registered"));
        }
        /* MIME invalid */
        if (!valid) {
            return cb(new Error("Invalid file type"));
        }
        cb(null, folder);
    },
    filename: (req, file, cb) => {
        const fileExt = path_1.default.extname(file.originalname);
        const randomName = Math.random().toString(36).substring(2, 12);
        const fileName = `${Date.now()}-${randomName}${fileExt}`;
        cb(null, fileName);
    }
});
/* =====================================================
   ERROR HANDLER MIDDLEWARE
   ===================================================== */
const errorHandler = (err, req, res, next) => {
    if (err) {
        res.status(502).json({ status: 404, message: err.message });
    }
    else {
        next();
    }
};
exports.errorHandler = errorHandler;
/* =====================================================
   EXPORT MULTER INSTANCES - MATCHES routes.class.ts IMPORTS
   ===================================================== */
// From multerlib.ts -> routes.class.ts uses: const extMMS
exports.extMMS = [
    (0, multer_1.default)({ storage: unifiedStorage }).single("ATTACHMENT"),
    errorHandler
];
// From uploadMulter.ts -> routes.class.ts uses: const uploadMMS
exports.uploadMMS = [
    (0, multer_1.default)({ storage: unifiedStorage }).single("UPLOAD"),
    errorHandler
];
// From multerImage.ts -> routes.class.ts uses: const extractImage
exports.extractImage = (0, multer_1.default)({ storage: unifiedStorage }).single("profile_pic");
// From tollfreemulter.ts -> routes.class.ts uses: const tollfreemulter
exports.tollfreemulter = [
    (0, multer_1.default)({ storage: unifiedStorage }).array("ATTACHMENTS")
];
// From uploadCardMulter.ts -> routes.class.ts uses: const uploadCARD
exports.uploadCARD = (0, multer_1.default)({ storage: unifiedStorage }).single("UPLOAD");
// From uploadFederalMulter.ts -> routes.class.ts uses: const uploadFEDERAL
exports.uploadFEDERAL = (0, multer_1.default)({ storage: unifiedStorage }).single("UPLOAD");
// From uploadKycMulter.ts -> routes.class.ts uses: const uploadKYC
exports.uploadKYC = (0, multer_1.default)({ storage: unifiedStorage }).single("UPLOAD");
// From campaignMulter.ts -> routes.class.ts uses: const campaignMulter
exports.campaignMulter = [
    (0, multer_1.default)({ storage: unifiedStorage }).array("ATTACHMENTS")
];
// From InvoiceMulter.ts -> routes.class.ts uses: const invoicePdf
exports.invoicePdf = (0, multer_1.default)({ storage: unifiedStorage }).single("UPLOAD");
// From UserNotesMulter.ts -> routes.class.ts uses: const SaveNotesUpload
exports.SaveNotesUpload = [
    (0, multer_1.default)({ storage: unifiedStorage }).array("ATTACHMENTS")
];
// From TaxDetailDocMulter.ts -> routes.class.ts uses: const taxDetailMuler
exports.taxDetailMuler = (0, multer_1.default)({ storage: unifiedStorage }).single("UPLOAD");
/* =====================================================
   ADDITIONAL NAMED EXPORTS FOR FLEXIBILITY
   ===================================================== */
// Appeal uploads
exports.appeal = [
    (0, multer_1.default)({ storage: unifiedStorage }).array("ATTACHMENTS"),
    errorHandler
];
/* =====================================================
   MODULE EXPORTS FOR BACKWARD COMPATIBILITY
   ===================================================== */
// CommonJS exports matching variable names from routes.class.ts
module.exports = unifiedStorage;
module.exports.extMMS = exports.extMMS;
module.exports.uploadMMS = exports.uploadMMS;
module.exports.extractImage = exports.extractImage;
module.exports.tollfreemulter = exports.tollfreemulter;
module.exports.uploadCARD = exports.uploadCARD;
module.exports.uploadFEDERAL = exports.uploadFEDERAL;
module.exports.uploadKYC = exports.uploadKYC;
module.exports.campaignMulter = exports.campaignMulter;
module.exports.invoicePdf = exports.invoicePdf;
module.exports.SaveNotesUpload = exports.SaveNotesUpload;
module.exports.taxDetailMuler = exports.taxDetailMuler;
module.exports.appeal = exports.appeal;
module.exports.errorHandler = errorHandler;
