"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Webhook = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
let validuser = new APIBase_1.APIBase();
class Webhook {
    constructor() {
        // super();
    }
    Webhookcategory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `webhookCategory` FROM `webhook_roles` GROUP BY `webhookCategory`";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Webhook Category Fetched",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    geteventType(req, res, next) {
        let sdata = req.query;
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request query not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `eventType` FROM `webhook_roles` where `webhookCategory`='" + sdata.type + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Hook Url Fetched Successfully",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Something Went Wrong With Connection!",
                                status: 502,
                                error: result
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
    }
    getWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let sdata = req.query;
            let msg = '';
            let typeValue = sdata?.type; // 🟢 Step 1: store user input in a local variable
            let accountId = '';
            switch (true) {
                case !sdata:
                    msg = 'Request query not found!';
                    break;
                case !typeValue:
                    msg = 'type not found in request!';
                    break;
                case typeof typeValue !== 'string':
                    msg = 'Invalid type format! Expected a string.';
                    break;
                case typeValue.indexOf('-') === -1:
                    msg = 'Invalid type format! Missing "-" separator.';
                    break;
                case typeValue.split('-').length < 2 || !typeValue.split('-')[1]:
                    msg = 'Invalid type format! Expected something like "prefix-123".';
                    break;
                default:
                    // 🟢 Step 2: safe to use split() after all validations
                    accountId = typeValue.split('-')[1].trim();
                    break;
            }
            if (msg) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 404, message: msg });
                objv.execute();
                return;
            }
            else {
                let ext_field;
                let con = '';
                if (sessdata.type == 1) {
                    con = "WHERE we.`idaccount`= '" + accountId + "'";
                    ext_field = "we.`iduser`, we.`idaccount`";
                }
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    con = "WHERE `idaccount`= '" + sessdata.idaccount + "'";
                }
                if (sessdata.type == 22) {
                    con = "WHERE `iduser`= '" + sessdata.iduser + "'";
                }
                if (error == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    // obj.qrysql = "SELECT `webhook_id`,`iduser`, `idaccount`, `webhookCategory`,`eventType`,`webhookUrl`,`created_at` FROM `webhook_endpoint` "+con+"";
                    obj.qrysql = "SELECT " + ext_field + " we.`webhook_id`,up.`firstname`,up.`lastname`, we.`webhookCategory`,we.`eventType`,we.`webhookUrl`,we.`created_at`,we.`updated_at` FROM `webhook_endpoint` we INNER JOIN `user_profile` up ON we.iduser=up.iduser  " + con + "";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Webhook Fetched Successfully",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Something Went Wrong With Connection!",
                                status: 502,
                                error: result
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            }
        });
    }
    addWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `webhookCategory` FROM `webhook_endpoint` WHERE `webhookCategory`='" + sdata.webhookCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                    obj0.prepare();
                    obj0.execute((__error, resWebhook) => {
                        if (__error == 1 && resWebhook.length < 1) {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = " INSERT INTO `webhook_endpoint` (`iduser`,`idaccount`,`webhookCategory`, `eventType`,`webhookUrl`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.webhookCategory + "', '" + sdata.eventType + "', '" + (0, markError_1.parseBody)(sdata.webhookUrl) + "')";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Webhook Inserted Successfully",
                                        status: 200
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With Webhook!",
                                        status: 502,
                                        error: result
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Already Exits Webhook Endpoint",
                                status: 502,
                            });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `webhook_endpoint` WHERE `webhook_id`='" + sdata.id + "';";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Webhook Deleted Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Webhook!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `webhook_endpoint` SET `webhookCategory`='" + sdata.webhookCategory + "',`eventType`='" + sdata.eventType + "',`webhookUrl`='" + (0, markError_1.parseBody)(sdata.webhookUrl) + "', `updated_at`=NOW() WHERE `webhook_id`='" + sdata.webhook_id + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Webhook Updated Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Webhook Update!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    addWebhookForSwagger(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        const urlPattern = /^(https?:\/\/)?([a-zA-Z0-9.-]+)(:\d+)?(\/[^\s#?]*)?(\?[^\s#]*)?(#[^\s]*)?$/;
                        let message = "";
                        switch (true) {
                            case (!sdata):
                                message = "Request body not found!";
                                break;
                            case (!sdata.eventCategory && !sdata.webhookEndpoint):
                                message = "Webhook Category and Webhook Url is required!";
                                break;
                            case (sdata.eventCategory == '' || sdata.eventCategory == 'null' || sdata.eventCategory == 'undefined'):
                                message = "Webhook Category is required!";
                                break;
                            case (!sdata.eventCategory):
                                message = "Webhook Category is required1!";
                                break;
                            case (sdata.eventCategory && sdata.eventCategory != 'A2P Campaign'):
                                message = "Webhook Category should be A2P Campaign!";
                                break;
                            case (!sdata.webhookEndpoint):
                                message = "Webhook Url is required!";
                                break;
                            case (!urlPattern.test(sdata.webhookEndpoint)):
                                message = "Invalid Webhook Url!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: message });
                            objv.execute();
                        }
                        else {
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT `webhookCategory` FROM `webhook_endpoint` WHERE `webhookCategory`='" + sdata.eventCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                            obj0.prepare();
                            obj0.execute((__error, resWebhook) => {
                                if (__error == 1 && resWebhook.length < 1) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `webhook_endpoint` (`iduser`,`idaccount`,`webhookCategory`,`webhookUrl`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.eventCategory + "', '" + (0, markError_1.parseBody)(sdata.webhookEndpoint) + "')";
                                    obj.prepare();
                                    obj.execute((error, result) => {
                                        if (error == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                data: sdata,
                                                message: "Webhook Subscribed Successfully.",
                                                status: 200
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Webhook Not Subscribed!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `webhook_endpoint` SET `webhookCategory`='" + sdata.eventCategory + "',`webhookUrl`='" + (0, markError_1.parseBody)(sdata.webhookEndpoint) + "',`updated_at`=NOW() WHERE `webhookCategory`='" + sdata.eventCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((_error, result) => {
                                        if (_error == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ data: sdata, message: "Webhook Subscribed Successfully!", status: 200 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Webhook Update!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Webhook = Webhook;
