"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InfobipAPI = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const markError_1 = require("./markError");
const axios_1 = require("./axios");
const crypto = require('crypto');
const setting_config_1 = require("../config/setting.config");
const path = require('path');
const infobip = new setting_config_1.InfoBip();
const GSM_7_BASIC = "@£$¥èéùìòÇ\nØø\rÅåΔ_ΦΓΛΩΠΨΣΘΞÆæÉ !\"#¤%&'()*+,-./0123456789:;<=>?¡ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÑÜ§¿abcdefghijklmnopqrstuvwxyzäöñüà";
const GSM_7_EXT = "^{}\\[~]|€";
class InfobipAPI extends APIBase_1.APIBase {
    /* private key: string; */
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        this.timekey = timekey,
            this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }
    rpad(name, size) {
        let ret = name;
        for (let i = name.length; i < size; i++)
            ret += "x";
        return ret;
    }
    getMediaType(url) {
        const ext = path.extname(url).toLowerCase().replace('.', '');
        const typeMap = {
            IMAGE: ['jpg', 'jpeg', 'png', 'gif', 'webp'],
            VIDEO: ['mp4', '3gp', '3g2', 'mov', 'flv', 'wmv', 'avi', 'mkv', 'webm'],
            DOCUMENT: ['xml', 'txt', 'smil', 'msg', 'html', 'ical', 'ics', 'vcf', 'pdf', 'mp3', 'ogg', 'wav', 'wma', 'amr', 'qcp', 'asx']
        };
        for (const [type, extensions] of Object.entries(typeMap)) {
            if (extensions.includes(ext)) {
                return type;
            }
        }
        return 'UNKNOWN';
    }
    getId() {
        return [2, 2, 2, 6].reduce((prev, len) => prev + '-' + crypto.randomBytes(len).toString('hex'), crypto.randomBytes(4).toString('hex'));
    }
    /**
     * Check if message is GSM-7 encodable
     */
    isGSM7(text) {
        for (const ch of text) {
            if (GSM_7_BASIC.includes(ch))
                continue;
            if (GSM_7_EXT.includes(ch))
                continue;
            return false; // Non GSM-7 character found
        }
        return true;
    }
    /**
    * Get message part count with GSM-7 vs UCS-2 rules
    */
    calculateParts(text) {
        const isGSM = this.isGSM7(text);
        let length = 0;
        if (isGSM) {
            for (const ch of text) {
                if (GSM_7_BASIC.includes(ch)) {
                    length += 1;
                }
                else if (GSM_7_EXT.includes(ch)) {
                    length += 2; // escape + char
                }
            }
        }
        else {
            // UCS-2 count (using code points, not UTF-16 units)
            for (const ch of text) {
                length += 1;
            }
        }
        const singlePart = isGSM ? 160 : 70;
        const perPart = isGSM ? 153 : 67;
        const msgCount = length <= singlePart ? 1 : Math.ceil(length / perPart);
        return {
            encoding: isGSM ? "GSM-7" : "UCS-2 (Unicode)",
            messageType: isGSM ? 1 : 2,
            parts: msgCount,
            perPartLimit: perPart,
            singlePartLimit: singlePart,
            length
        };
    }
    saveSCSMS(req, res, Data, DIDData, callback) {
        let uuid = this.getId();
        let sdata = req.body;
        let TO = (typeof sdata?.TO === 'string') ? sdata.TO.replace(/\D/g, '').slice(-10) : String(sdata.TO || '').trim().slice(-10);
        let FROM = (typeof sdata?.FROM === 'string') ? sdata.FROM.replace(/\D/g, '').slice(-10) : String(sdata.FROM || '').trim().slice(-10);
        let iduser = Data.sessdata.type == 1 ? sdata.iduser : Data.sessdata.iduser;
        let idaccount = Data.sessdata.type == 1 ? sdata.idaccount : Data.sessdata.idaccount;
        let rate = new APIBase_1.APIBase();
        rate.getTollfreeSMSRate(req, res, Data.sessdata.idtariff, "SMS", "short_code", (err, message_rate) => {
            if (err == 1 && message_rate.length > 0) {
                let msg_data = sdata.BODY;
                const smsInfo = this.calculateParts(sdata.BODY);
                let msgcount = smsInfo.parts;
                let cost = msgcount * (message_rate[0].MT_rates + Data.lergData[0].rates);
                let MT_rates = msgcount * message_rate[0].MT_rates;
                let MT_surcharge = msgcount * Data.lergData[0].rates;
                console.log("Actual MSG Body :: ", msg_data);
                // console.log("SMS Actual length :: ", msg_data.length);
                console.log("SMS msgcount :: ", msgcount);
                console.log("SMS MT_rates :: ", message_rate[0].MT_rates);
                console.log("SMS Lerg rates :: ", Data.lergData[0].rates);
                console.log("SMS Cost :: ", cost);
                console.log("Encoding :: ", smsInfo.encoding);
                console.log("Msgcount :: ", smsInfo.parts);
                console.log("Length After Caculate :: ", smsInfo.length);
                rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        var options = {
                            'method': 'POST',
                            'url': `${infobip.baseUrl}/messages-api/1/messages`,
                            headers: {
                                'Authorization': 'App ' + infobip.apiKey,
                                'Content-Type': 'application/json',
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                messages: [
                                    {
                                        channel: 'SMS',
                                        sender: FROM,
                                        destinations: [
                                            {
                                                to: "1" + TO
                                            }
                                        ],
                                        content: {
                                            body: {
                                                text: msg_data,
                                                type: 'TEXT'
                                            }
                                        }
                                    }
                                ]
                            })
                        };
                        console.log("SMS request :: ", options);
                        (0, axios_1.request)(options, function (error, response) {
                            if (!error) {
                                try {
                                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                        let data = JSON.parse(response.body);
                                        console.log("SMS response :: ", data);
                                        console.log("data.messages :: ", data.messages);
                                        /* let data:any = {
                                            "bulkId": "1688025180464000013",
                                            "messages": [
                                                {
                                                    "messageId": "1688025180464000014",
                                                    "status": {
                                                        "groupId": 1,
                                                        "groupName": "PENDING",
                                                        "id": 26,
                                                        "name": "MESSAGE_ACCEPTED",
                                                        "description": "Message sent to next instance"
                                                    },
                                                    "destination": "48600700800"
                                                }
                                            ]
                                        } // Real Third Party Response
                                        console.log("data.messages[0].status.groupName",data.messages[0].status.groupName); */
                                        if (data.messages && data.messages[0].status.groupName == 'PENDING') {
                                            let payload = {
                                                idaccount: idaccount,
                                                amount: cost,
                                                purpose: 'SMS Send'
                                            };
                                            rate.walletDeductionWithoutLog(req, res, payload, (errorD, dataD) => {
                                                console.log("saveSCSMS => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `mdrlive_shortcode` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`is_billable`,`campaignId`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`) VALUES('" + data.messages[0].messageId + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "',4,'" + idaccount + "','" + iduser + "','short_code','" + smsInfo.messageType + "','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + Data.lergData[0].npa + "','" + Data.lergData[0].state + "','" + Data.lergData[0].ocn + "','" + Data.lergData[0].lata + "','" + Data.lergData[0].category + "','" + Data.lergData[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(Data.sessdata.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(Data.lergData[0].idoperator) + "','" + Data.lergData[0].name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',1,'" + DIDData.campaignId + "',NOW(),NOW(),NOW(),NOW())";
                                            obj0.prepare();
                                            obj0.execute((error, result) => {
                                                if (error == 1) {
                                                    console.log("Message Send Successfully!");
                                                    callback(1, { status: 201, message: "SMS Sent Successfully", batch_id: data.messages[0].messageId });
                                                }
                                                else {
                                                    console.log("Message Send Successfully But Something Went Wrong With Insertion!");
                                                    callback(1, { status: 401, message: "Something went wrong!", batch_id: data.messages[0].messageId });
                                                }
                                            });
                                        }
                                        else {
                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `mdrlive_shortcode` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`campaignId`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`) VALUES('" + uuid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "',2,'" + idaccount + "','" + iduser + "','short_code','" + smsInfo.messageType + "','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + Data.lergData[0].npa + "','" + Data.lergData[0].state + "','" + Data.lergData[0].ocn + "','" + Data.lergData[0].lata + "','" + Data.lergData[0].category + "','" + Data.lergData[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(Data.sessdata.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(Data.lergData[0].idoperator) + "','" + Data.lergData[0].name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "','" + DIDData.campaignId + "',NOW(),NOW(),NOW(),NOW())";
                                            obj0.prepare();
                                            obj0.execute((error, result) => {
                                                console.log("SMS not Sent!!");
                                                callback(0, { status: 402, message: "SMS not Sent!" });
                                            });
                                        }
                                    }
                                    else {
                                        callback(0, { message: "SMS not Sent Successfully!", status: 507 });
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: Infobip->saveSCSMS::", e);
                                    callback(0, { message: "Something Went Wrong with the server!", status: 504 });
                                }
                            }
                            else {
                                callback(0, { message: "Something went wrong!", status: 502 });
                            }
                        });
                    }
                    else {
                        callback(0, { message: "Please add funds to your account or contact support.", status: 503 });
                    }
                });
            }
            else {
                callback(0, { status: 502, message: "MT Rates not Found!" });
            }
        });
    }
    saveSCMMS(req, res, Data, DIDData, callback) {
        let uuid;
        let dlr_status;
        let mediaurl = Data.file;
        let sdata = req.body;
        let iduser = Data.sessdata.type == 1 ? sdata.iduser : Data.sessdata.iduser;
        let idaccount = Data.sessdata.type == 1 ? sdata.idaccount : Data.sessdata.idaccount;
        let TO = (typeof sdata?.TO === 'string') ? sdata.TO.replace(/\D/g, '').slice(-10) : String(sdata.TO || '').trim().slice(-10);
        let FROM = (typeof sdata?.FROM === 'string') ? sdata.FROM.replace(/\D/g, '').slice(-10) : String(sdata.FROM || '').trim().slice(-10);
        let rate = new APIBase_1.APIBase();
        rate.getTollfreeSMSRate(req, res, Data.sessdata.idtariff, "MMS", "short_code", (err, message_rate) => {
            if (err == 1 && message_rate.length > 0) {
                let msgcount = 1;
                let cost = msgcount * (message_rate[0].MT_rates + Data.lergData[0].rates);
                let MT_rates = msgcount * message_rate[0].MT_rates;
                let MT_surcharge = msgcount * Data.lergData[0].rates;
                let msg_data = sdata.BODY;
                console.log("MMS msgcount :: ", msgcount);
                console.log("MMS MT_rates :: ", message_rate[0].MT_rates);
                console.log("MMS Lerg rates :: ", Data.lergData[0].rates);
                console.log("MMS Cost :: ", cost);
                rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        const body1 = msg_data ? {
                            text: msg_data,
                            url: mediaurl,
                            type: this.getMediaType(mediaurl),
                        } : {
                            url: mediaurl,
                            type: this.getMediaType(mediaurl),
                        };
                        var options = {
                            'method': 'POST',
                            'url': `${infobip.baseUrl}/messages-api/1/messages`,
                            headers: {
                                'Authorization': 'App ' + infobip.apiKey,
                                'Content-Type': 'application/json',
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                messages: [
                                    {
                                        channel: 'MMS',
                                        sender: FROM,
                                        destinations: [{ to: `1${TO}` }],
                                        header: { type: "TEXT", text: "IPLINK" },
                                        content: { body: body1 }
                                    }
                                ]
                            })
                        };
                        console.log("MMS request :: ", options);
                        (0, axios_1.request)(options, (error, response) => {
                            if (!error) {
                                try {
                                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                        let send_status = '', status_detail = '', status_code = '', is_billable = 0;
                                        let data = JSON.parse(response.body);
                                        console.log("MMS response :: ", data);
                                        console.log("MMS data.messages :: ", data.messages);
                                        /* let data:any = {
                                            "bulkId": "1688025180464000013",
                                            "messages": [
                                                {
                                                    "messageId": "1688025180464000014",
                                                    "status": {
                                                        "groupId": 1,
                                                        "groupName": "PENDING",
                                                        "id": 26,
                                                        "name": "MESSAGE_ACCEPTED",
                                                        "description": "Message sent to next instance"
                                                    },
                                                    "destination": "48600700800"
                                                }
                                            ]
                                        } // Real Third Party Response
                                        console.log("data.messages[0].status.groupName",data.messages[0].status.groupName); */
                                        if (data.messages && data.messages[0].status.groupName == 'PENDING') {
                                            send_status = 4; // Sent 
                                            status_detail = 'MMS Sent Successfully';
                                            status_code = 201;
                                            is_billable = 1;
                                            uuid = data.messages[0].messageId;
                                            dlr_status = data.messages[0].status.groupName; // PENDING
                                            let payload = {
                                                idaccount: Data.sessdata.idaccount,
                                                amount: cost,
                                                purpose: 'MMS Send'
                                            };
                                            rate.walletDeductionWithoutLog(req, res, payload, (errorD, dataD) => {
                                                console.log("saveSCMMS => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                        }
                                        else {
                                            cost = 0;
                                            send_status = 2; // Failed
                                            status_detail = 'MMS sent failed';
                                            status_code = 400;
                                            is_billable = 0;
                                            uuid = this.getId();
                                            dlr_status = "Failed";
                                        }
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`, `slide`,`direction`,`did_provider`,`service_id`,`cost`,`type`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`,`is_billable`,`dca`) VALUES('" + uuid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "','" + send_status + "','" + Data.lergData[0].npa + "','" + Data.lergData[0].state + "','" + idaccount + "','" + iduser + "','short_code','" + Data.lergData[0].ocn + "','" + Data.lergData[0].lata + "','" + Data.lergData[0].category + "','" + Data.lergData[0].co_name_spec_c + "','" + (0, markError_1.setToZero)(Data.sessdata.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(Data.lergData[0].idoperator) + "','" + Data.lergData[0].name + "','" + mediaurl + "','outbound','" + DIDData.DIDProvider + "','" + DIDData.campaignId + "','" + cost + "','2',NOW(),NOW(),NOW(),NOW()," + is_billable + ", '" + DIDData.SmsProvider + "')";
                                        obj.prepare();
                                        obj.execute((errorr, responce) => {
                                            if (errorr == 1) {
                                                let resData = data.success == true ? { status: status_code, message: status_detail, batch_id: uuid } : { status: status_code, message: status_detail };
                                                callback(1, resData);
                                            }
                                            else {
                                                callback(0, { status: 401, message: "Something went wrong with MMS insertion" });
                                            }
                                        });
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `mms_dlr` (`idaccount`,`iduser`,`status`,`from`,`to`,`tracking_id`,`status_details`,`dca`) VALUES('" + idaccount + "','" + iduser + "','" + dlr_status + "','" + FROM + "','" + TO + "','" + uuid + "','" + status_detail + "', '" + DIDData.SmsProvider + "')";
                                        obj1.prepare();
                                        obj1.execute((errord, responced) => {
                                            if (errord == 1) {
                                                console.log("SC mms_dlr Data Inserted Successfully!");
                                            }
                                            else {
                                                console.log("SC mms_dlr Data Not Inserted Successfully!");
                                            }
                                        });
                                    }
                                    else {
                                        callback(0, { status: 402, message: "MMS Sent Failed!" });
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: Infobip->saveSCMMS::", e);
                                    callback(0, { status: 403, message: "MMS Sent Failed!" });
                                }
                            }
                            else {
                                callback(0, { status: 405, message: "MMS Sent Failed!" });
                            }
                        });
                    }
                    else {
                        callback(0, { status: 504, message: "Please add funds to your account or contact support." });
                    }
                });
            }
            else {
                callback(0, { status: 502, result: "MT Rates Not Found!" });
            }
        });
    }
}
exports.InfobipAPI = InfobipAPI;
