"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SinchSMS = void 0;
const APISMSBase_1 = require("./APISMSBase");
const RawView_1 = require("../lib/view/RawView");
const Inteliquent_1 = require("./Inteliquent");
class SinchSMS extends APISMSBase_1.SMS {
    constructor() {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
    }
    SendSms(req, res, next, Data, DIDData, callback) {
        this.saveSMS(req, res, next, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    // Not in Use. it may be changed as per requirement
    SendTFSms(req, res, next, sessdata, DIDData, callback) {
        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }
    SendTFMms(req, res, next, sessdata, DIDData, callback) {
        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }
    SendMms(req, res, next, Data, sms_provider, callback) {
        this.saveMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        });
    }
    SendSynivMms(req, res, next, Data, sms_provider, callback) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        });
    }
    SendSCSms(req, res, next, Data, DIDData, callback) {
        let sessdata = Data.sessdata;
        let lergData = Data.lergData;
        // To set the data for final SMS
        this.saveSCSMS(req, res, next, sessdata, lergData, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    SendSCMms(req, res, next, Data, DIDData, callback) {
        let sessdata = Data.sessdata;
        let lergData = Data.lergData;
        let didData = Data.DIDdata;
        let fType = Data.fileType;
        let file = Data.file;
        // To set the data for final SMS
        this.saveSCMMS(req, res, next, sessdata, lergData, DIDData, didData, fType, file, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
}
exports.SinchSMS = SinchSMS;
