"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewCampaign = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const setting_config_1 = require("../config/setting.config");
const APIBase_1 = require("./APIBase");
const markError_1 = require("./markError");
const common_class_1 = require("./common.class");
const fs = require('fs');
const FromSmtpMail = new setting_config_1.SMTPDetails();
const FromEmail = FromSmtpMail.from;
const appealEvidence = new setting_config_1.AppealEvidence();
let appealDir = new setting_config_1.UploadDirectory();
// const request = require("request");
const axios_1 = require("./axios");
const cspSetting = new setting_config_1.CSPApiConfig();
const authKey = cspSetting.AUTHKEY;
const apiUrl = cspSetting.APIURL;
let rate = new APIBase_1.APIBase();
let checkuser = new common_class_1.CommonClass();
const setDefaultFalse = (value) => value === null || value === undefined || value === '' ? false : value;
const MIME_TYPE_MAP = {
    'text/csv': 'csv',
    'audio/3gpp': '3ga',
    'video/3gpp': '3gp',
    'text/plain': 'txt',
    'audio/amr': 'amr',
    'video/x-msvideo': 'avi',
    'image/bmp': 'bmp',
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'text/css': 'css',
    'image/dib': 'dib',
    'audio/flac': 'flac',
    'video/x-flv': 'flv',
    'application/octet-stream': 'flv',
    'image/gif': 'gif',
    'application/x-gzip': 'gz',
    'image/x-icon': 'ico',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'application/javascript': 'js',
    'application/json': 'json',
    'audio/mpeg': ['m1a', 'mp1', 'mp2', 'mp3'],
    'video/m1v': 'm1v',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-mp3': 'mp3',
    'video/mp4': 'mp4',
    'audio/x-ms-wma': 'mpa',
    'video/mpeg': 'mpeg',
    'video/mpg': 'mpg',
    'application/pdf': 'pdf',
    'image/pjpeg': 'pjpeg',
    'image/png': 'png',
    'video/quicktime': 'qt',
    'text/rtf': 'rtf',
    'audio/x-wav': 'wav',
    'video/webm': 'webm',
    'image/webp': 'webp',
    'video/x-ms-wmv': 'wmv',
    'application/xml': 'xml',
    'application/zip': 'zip',
    'application/x-zip-compressed': 'zip',
    'audio/ogg': ['oga', 'ogg', 'ogm', 'ogv', 'ogx'],
    'video/ogg': ['ogv'],
    'image/tiff': ['tif', 'tiff'],
    'audio/mp4': ['m4a', 'm4p', 'm4r', 'm4v'],
    'application/vnd.ms-vcard': ['vcard', 'vcf'],
    'text/calendar': 'cal',
    'application/smil+xml': 'smil',
    'image/svg+xml': 'svg'
};
const mnoTrial = {
    "data": {
        "10017": {
            "tpmScope": "CAMPAIGN",
            "minMsgSamples": 1,
            "msgClass": "A",
            "reqSubscriberOptout": true,
            "mnoReview": false,
            "mmsTpm": 6,
            "noEmbeddedPhone": false,
            "mno": "AT&T",
            "tpm": 6,
            "reqSubscriberHelp": true,
            "reqSubscriberOptin": true,
            "mnoSupport": true,
            "noEmbeddedLink": false,
            "qualify": true
        },
        "10035": {
            "minMsgSamples": 1,
            "reqSubscriberHelp": true,
            "reqSubscriberOptout": false,
            "brandDailyCap": 200,
            "reqSubscriberOptin": true,
            "mnoReview": false,
            "mnoSupport": true,
            "brandTier": "UNCAPPED",
            "noEmbeddedLink": false,
            "noEmbeddedPhone": false,
            "qualify": true,
            "mno": "T-Mobile"
        }
    }
};
class NewCampaign {
    constructor() { }
    /****************************************************************************
    * Start Brand Functionality  ************************************************
    ****************************************************************************/
    /**************************
    * Get Brand Relationship  *
    **************************/
    brandRelationship(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'GET',
                            'url': apiUrl + 'enum/brandRelationship',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Brand Relationship Types!", data: data, status: 200 });
                                    objv.execute();
                                }
                                catch (e) {
                                    console.log("Error :: getBrandFeedback ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getBrandFeedback(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                var options = {
                    'method': 'GET',
                    'url': apiUrl + 'brand/feedback/' + req.query.type,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Brand feedback Status!", data: JSON.parse(response.body), status: 200 });
                            objv.execute();
                        }
                        catch (e) {
                            console.log("Error :: getBrandFeedback ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /***************************
    * Get Brand Vertical Type  *
    ***************************/
    brandVertical(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'Get',
                            'url': apiUrl + 'enum/vertical',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response) => {
                            if (!error) {
                                try {
                                    if (response) {
                                        let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Brand Vertical Fetched!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: brandVertical ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************
    * Brand Entity Type  *
    **********************/
    // public brandEntityType(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((_error: any, sessdata: any) => {
    //         if (_error == 1) {
    //             // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
    //             rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
    //                 if (err == 1) {
    //                     let options: any = {
    //                         'method': 'Get',
    //                         'url': apiUrl + 'enum/entityType',
    //                         'headers': {
    //                             'Content-Type': 'application/json',
    //                             'Authorization': 'Basic ' + authKey
    //                         }
    //                     };
    //                     request(options, (error: any, response: any, body: any) => {
    //                         if (!error) {
    //                             try {
    //                                 if (response.body) {
    //                                     let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
    //                                     let objv = new RawView(res);
    //                                     objv.prepare({ message: "Brand Entity Types!", data: data, status: 200 });
    //                                     objv.execute();
    //                                 } else {
    //                                     let objv = new RawView(res);
    //                                     objv.prepare({ message: "Something Went Wrong With Entity Type Fetching!", error: error, status: 502 });
    //                                     objv.execute();
    //                                 }
    //                             }
    //                             catch (e) {
    //                                 console.log("Error :: brandEntityType ::", e);
    //                                 let obj = new RawView(res);
    //                                 obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
    //                                 obj.execute();
    //                             }
    //                         }
    //                         else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
    //                             objv.execute();
    //                         }
    //                     });
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare(dt);
    //                     objv.execute();
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare({ status: 401, message: "Unauthorized User" });
    //             objv.execute();
    //         }
    //     });
    // }
    brandEntityType(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                        obj5.qrysql = "SELECT `brand_entitytype_id`,`brand_entity_name`,`brand_entity_value` FROM `brand_entitytype`";
                        obj5.prepare();
                        obj5.execute((error, brandentity) => {
                            if (error == 1) {
                                let data;
                                if (sessdata.sessionType == 'API' || sessdata.sessionType == 'SAPI') {
                                    data = brandentity
                                        .filter((b) => b.brand_entity_value != 'PFT_BRAND')
                                        .map((b) => b.brand_entity_value);
                                }
                                else {
                                    data = brandentity.map((b) => b.brand_entity_value);
                                    ;
                                }
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Brand Entity Types!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With get brand entitytype!", error: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*************************
    * Brand DCAs List  *
    *************************/
    brandDCA(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let options = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/dca',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Brand DCA Fetched!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went Wrong With Fetch DCAs List!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: brandDCA ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*************************
    * Brand Identity Status  *
    *************************/
    brandIdentityStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if ( sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'GET',
                            'url': apiUrl + 'enum/brandIdentityStatus',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response) => {
                            if (!error) {
                                try {
                                    if (response) {
                                        let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Identity Status Fetched!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Identity Status Fetching!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: brandIdentityStatus ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**************************
    * Brand Alt Business Type *
    **************************/
    altBusinessIdType(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 1 || sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'GET',
                            'url': apiUrl + 'enum/altBusinessIdType',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 200, message: "Brand Business Type Fetched!", data: data });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something went Wrong With Get Brand Business Type Id List!" });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: altBusinessIdType ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went Wrong With Connection!", error: error });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**********************
    * Brand stockExchange *
    **********************/
    stockExchange(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 1 || sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'GET',
                            'url': apiUrl + 'enum/stockExchange',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 200, message: "Brand stockExchange List!", data: data });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something went Wrong With Get stockExchange List!" });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: stockExchange ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went Wrong With Connection!", error: error });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*****************
    * Add Brand      *
    *****************/
    addBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let brandData = req.body;
                let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                obj5.qrysql = "SELECT * FROM `brand` WHERE `brandId` = '" + brandData.brand_key + "'";
                obj5.prepare();
                obj5.execute((error, brand) => {
                    if (error == 1) {
                        try {
                            if (brand.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Brand Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_relation`,`vertical_type`,`website`, `city`,`country`,`brand_name`, `brandId`, `brandType`) VALUES(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + (0, markError_1.parseBody)(brandData.companyName) + "','" + brandData.brandRelationship + "','" + brandData.vertical + "','" + (0, markError_1.parseBody)(brandData.website) + "','" + (0, markError_1.parseBody)(brandData.city) + "','" + brandData.country + "', '" + (0, markError_1.parseBody)(brandData.companyName) + "','" + brandData.brand_key + "', 'add')";
                                obj4.execute((_error, result) => {
                                    if (_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 201, data: result, message: "Brand Added Successfully!" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ error: result, message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        catch (e) {
                            console.log("Error :: addBrand ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: brand, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /******************************
    * Brand Register Normal       *
    ******************************/
    BrandRegister(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let brates = '4.50';
                let brandData = req.body;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let objv = new RawView_1.RawView(res);
                if (brandData.displayName && brandData.firstName && brandData.lastName && brandData.phone && brandData.street && brandData.city && brandData.state && brandData.postalCode && brandData.country && brandData.email && brandData.referenceId) {
                    let options = {
                        'method': 'POST',
                        'url': apiUrl + 'brand',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify(brandData)
                    };
                    (0, axios_1.request)(options, (error, response, body) => {
                        if (!error) {
                            try {
                                let resData = JSON.parse(response.body);
                                let escapedLog = JSON.stringify([response.body, datasess]);
                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                if (resData.brandId) {
                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT into `brand` (`iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `brandId`, `cspId`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`) VALUES(" + sessdata.iduser + ", '" + (0, markError_1.parseBody)(brandData.companyName) + "', '" + (0, markError_1.parseBody)(brandData.displayName) + "', '" + brandData.entityType + "', '" + brandData.ein + "', '" + brandData.brandRelationship + "', '" + (0, markError_1.parseBody)(brandData.street) + "', '" + (0, markError_1.parseBody)(brandData.city) + "', '" + brandData.state + "', '" + brandData.postalCode + "', '" + (0, markError_1.parseBody)(brandData.website) + "', '" + brandData.vertical + "', '" + brandData.country + "', '" + brandData.email + "', '" + brandData.phone + "', '" + resData.brandId + "', '" + resData.cspId + "', " + (0, markError_1.setToZero)(resData.registrationScore) + ", '" + resData.universalEin + "',  '" + (0, markError_1.parseBody)(resData.referenceId) + "', '" + resData.entityType + "', '" + resData.identityStatus + "', '" + resData.einIssuingCountry + "', '" + resData.mock + "', '" + (0, markError_1.parseBody)(brandData.firstName) + "', '" + (0, markError_1.parseBody)(brandData.lastName) + "', '" + brandData.ipAddress + "')";
                                    obj3.execute((error, result) => {
                                        if (result) {
                                            let payload = {
                                                idaccount: sessdata.idaccount,
                                                amount: brates,
                                                purpose: 'brand registration',
                                                type: '-'
                                            };
                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("BrandRegister => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `date`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + resData.brandId + "',4,'" + Date.now() + "', 'Brand_Rate','" + combinedLog + "')";
                                            obj3.prepare();
                                            obj3.execute((__error, resp) => {
                                                if (__error == 1) {
                                                    objv.prepare({
                                                        data: {
                                                            brandId: resData.brandId,
                                                            cspId: resData.cspId
                                                        },
                                                        message: "Brand Register Successfully!",
                                                        status: 201
                                                    });
                                                    objv.execute();
                                                }
                                                else {
                                                    objv.prepare({
                                                        error: resp,
                                                        message: "Something Went Wrong With Connection!",
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            objv.prepare({
                                                error: error,
                                                message: "Something Went Wrong!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    objv.prepare({
                                        message: resData[0].field + " " + resData[0].description,
                                        error: error,
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: BrandRegister ::", e);
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        }
                    });
                }
                else {
                    objv.prepare({
                        status: 502,
                        error: "displayName, firstName, lastName, phone, street, city, state, postalCode, country, email, and referenceId are mendatory fields!"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /******************************
    * Brand Register None Blocking*
    ******************************/
    brandRegisterNonBlocking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        checkuser.checkKycStatus(req, res, sessdata.idaccount, (err, dt) => {
                            if (err == 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: dt.status, message: dt.message });
                                objv.execute();
                                return;
                            }
                            else {
                                let checkService = new APIBase_1.APIBase();
                                checkService.serviceActivation(req, res, sessdata, "6", (err, resp) => {
                                    if (resp.status == 200) {
                                        let brandData = req.body;
                                        if (!brandData || Object.keys(brandData).length == 0) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 501, message: "Brand Register Data Is Required!" });
                                            objv.execute();
                                        }
                                        else {
                                            /* const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
                                            if(brandData.displayName && !prgmch.test(brandData.displayName)){
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 502, message: "displayName is Invalid" });
                                                objv.execute();
                                                return;
                                            } */
                                            if (brandData.entityType && brandData.entityType == "PFT_BRAND") {
                                                let fun = new NewCampaign();
                                                fun.inbrandRegisterPFT(req, res, next);
                                            }
                                            else if (brandData.entityType && brandData.entityType == "SOLE_PROPRIETOR") {
                                                /* let message: any = '';
                                                const isEmpty = (value: any): boolean => value == undefined || value == null || value == '' || value == 'null' || value == 'undefined';
                                                const isTwoUppercaseLetters = (value: string): boolean => /^[A-Z]{2}$/.test(value);
                                                const isValidPhone = (value: string): boolean => /^[0-9]+$/.test(value);
                                                const isValidEmail = (value: string): boolean => /^(?!.*\.\.)(?!\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,10}(?<!\.)$/.test(value);
                                                const requiredFields = ['street', 'city', 'country', 'state', 'postalCode', 'phone', 'email'];
                                                switch (true) {
                                                    case (!brandData || requiredFields.every(f => isEmpty(brandData[f]))):
                                                        message = "Missing request body!";
                                                        break;
                                                    case requiredFields.some(f => isEmpty(brandData[f])):
                                                        const missingFields = requiredFields.filter(f => isEmpty(brandData[f]));
                                                        message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                                                        break;
                                                    case !isEmpty(brandData.country) && !isTwoUppercaseLetters(brandData.country):
                                                        message = "Country is invalid! It must be exactly two uppercase letters.";
                                                        break;
                                                    case !isEmpty(brandData.postalCode) && !isAlphanumeric(brandData.postalCode):
                                                        message = "Postal code is invalid!";
                                                        break;
                                                    case !isEmpty(brandData.phone) && !isValidPhone(brandData.phone):
                                                        message = "Phone is invalid!";
                                                        break;
                                                    case !isEmpty(brandData.email) && !isValidEmail(brandData.email):
                                                        message = "Email is invalid!";
                                                        break;
                                                    case (brandData.displayName && !prgmch.test(brandData.displayName)):
                                                        message = "displayName is Invalid";
                                                        break;
                                                    default:
                                                        message = "";
                                                }
     
                                                if (message) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 502, message: message });
                                                    objv.execute();
                                                } else{ */
                                                let ObjA = new RawQuery_1.ModelRawQuery(req, res);
                                                ObjA.qrysql = "SELECT address,city,state,postal_code,country FROM `brand` WHERE `address`='" + (0, markError_1.parseBody)(brandData.street) + "' AND `city`='" + (0, markError_1.parseBody)(brandData.city) + "' AND `state`='" + brandData.state + "' AND `postal_code`='" + brandData.postalCode + "' AND `country`='" + brandData.country + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                                                ObjA.prepare();
                                                ObjA.execute((adErr, addressRes) => {
                                                    if (addressRes.length < 10) {
                                                        let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                        Obj0.qrysql = "SELECT email FROM `brand` WHERE `email`='" + brandData.email + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                                                        Obj0.prepare();
                                                        Obj0.execute((brErr, brandRes) => {
                                                            if (brandRes.length < 3) {
                                                                let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                                                                Obj00.qrysql = "SELECT phone FROM `brand` WHERE `phone`='" + brandData.phone + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                                                                Obj00.prepare();
                                                                Obj00.execute((brPhErr, brandPhRes) => {
                                                                    if (brandPhRes.length < 3) {
                                                                        let fun = new NewCampaign();
                                                                        fun.inbrandRegisterNonBlocking(req, res, next);
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ error: brPhErr, message: "Phone No. Already Exits 3 Times", status: 502 });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Email Id Already Exits 3 Times", status: 502 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ error: adErr, message: "Address Already Exits 10 Times", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                                /* } */
                                            }
                                            else {
                                                let fun = new NewCampaign();
                                                fun.inbrandRegisterNonBlocking(req, res, next);
                                            }
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: err,
                                            status: resp.status,
                                            message: resp.message.replace(/::SN::/g, "Brand Registration")
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inbrandRegisterNonBlocking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let rateS = '4.50';
                let brandData = req.body;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                // let Obj = new ModelRawQuery(req, res);
                // Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 4";
                // Obj.prepare();
                // Obj.execute((crErr: any, crRes) => {
                //     if (crErr == 1 && crRes.length > 0) {
                rate.checkBalance(req, res, sessdata.idaccount, rateS, (crErr, crRes) => {
                    if (crErr == 1) {
                        let options = {
                            'method': 'POST',
                            'url': apiUrl + 'brand/nonBlocking',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            body: JSON.stringify(brandData)
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    let resultData = JSON.parse(response.body);
                                    let escapedLog = JSON.stringify([response.body, datasess]);
                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                    if (resultData.brandId && resultData.brandId !== undefined) {
                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `mobilePhone`, `brandId`,`cspId`, `altBusinessId`, `altBusinessIdType`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `stockSymbol`, `stockExchange`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`,`optionalAttributes`,`createDate`,`evpVettingScore`,`mobilePhoneVerifiedDate`, `brandType`,`cost`,`business_contact_email`) VALUES(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + (0, markError_1.parseBody)(resultData.companyName) + "', '" + (0, markError_1.parseBody)(resultData.displayName) + "', '" + resultData.entityType + "', '" + resultData.ein + "', '" + resultData.brandRelationship + "', '" + (0, markError_1.parseBody)(resultData.street) + "', '" + (0, markError_1.parseBody)(resultData.city) + "', '" + resultData.state + "', '" + resultData.postalCode + "', '" + resultData.website + "', '" + resultData.vertical + "', '" + resultData.country + "', '" + (0, markError_1.parseBody)(resultData.email) + "', '" + brandData.phone + "','" + brandData.mobilePhone + "', '" + resultData.brandId + "', '" + resultData.cspId + "', '" + brandData.altBusinessId + "', '" + brandData.altBusinessIdType + "', " + (0, markError_1.setToZero)(resultData.registrationScore) + ", '" + resultData.universalEin + "',  '" + (0, markError_1.parseBody)(resultData.referenceId) + "', '" + resultData.entityType + "', '" + resultData.identityStatus + "', '" + resultData.stockSymbol + "', '" + resultData.stockExchange + "', '" + resultData.einIssuingCountry + "', '" + resultData.mock + "', '" + (0, markError_1.parseBody)(brandData.firstName) + "', '" + (0, markError_1.parseBody)(resultData.lastName) + "', '" + resultData.ipAddress + "', '" + JSON.stringify(resultData.optionalAttributes) + "', '" + resultData.createDate + "', '" + (0, markError_1.setToZero)(resultData.evpVettingScore) + "', '" + resultData.mobilePhoneVerifiedDate + "', 'register', '" + rateS + "','" + brandData.businessContactEmail + "')";
                                        obj3.execute((__error, result) => {
                                            if (__error == 1) {
                                                let swaggerResChn = resultData;
                                                delete swaggerResChn.cspId;
                                                delete swaggerResChn.mock;
                                                let swaggerResponse = swaggerResChn;
                                                if (resultData.entityType == "SOLE_PROPRIETOR") {
                                                    let otp = new BrandManager();
                                                    otp.smsOTPBrand(req, res, resultData.brandId, (smsErr, smsOtp) => {
                                                        if (smsErr == 1) {
                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `iduser`=" + sessdata.iduser + " AND `brandId`='" + resultData.brandId + "' AND `deleted`=0";
                                                            obj.prepare();
                                                            obj.execute((___error, resp) => { });
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "New Brand Created Successfully And " +
                                                                    smsOtp.message
                                                            });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 201, brandId: resultData.brandId, data: swaggerResponse, message: "New Brand Created Successfully." });
                                                    objv.execute();
                                                }
                                                let payload = {
                                                    idaccount: sessdata.idaccount,
                                                    amount: rateS,
                                                    purpose: 'brand registration',
                                                    type: '-'
                                                };
                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                    console.log("inbrandRegisterNonBlocking => walletDeduction Wallet deduction response:", errorD, dataD);
                                                });
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + resultData.brandId + "','" + rateS + "','" + Date.now() + "',1, 'Brand Registered','" + combinedLog + "')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 504, brandId: resultData.brandId, message: "Result Not Saved Successfully!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + resultData.brandId + "','" + rateS + "','" + Date.now() + "',2, 'Brand Register Failed','" + combinedLog + "')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: resultData[0].description, status: resultData[0].code });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: inBrandRegisterNOnBlocking ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 505, message: "Something Went Wrong. Brand Not Created Successfully!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: crErr, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inbrandRegisterPFT(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error1, sessdata) => {
            if (error1 == 1) {
                let rateS = '4.50';
                let brandData = req.body;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                rate.checkBalance(req, res, sessdata.idaccount, rateS, (crErr, crRes) => {
                    if (crErr == 1) {
                        let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                        obj5.qrysql = "SELECT `brandId`,`company_type` FROM `brand` WHERE `company_type`='PFT_BRAND' AND `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `deleted`=0";
                        obj5.prepare();
                        obj5.execute((error2, brandentity) => {
                            if (error2 == 1) {
                                if (brandentity && brandentity.length > 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "PFT entity type brand created only once per user", status: 501 });
                                    objv.execute();
                                }
                                else {
                                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                                    const alphabetLength = alphabet.length;
                                    const length = 6;
                                    let BrandID = 'B';
                                    for (let i = 0; i < length; i++) {
                                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                                        const isDigit = randomIndex >= 52;
                                        BrandID += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                                    }
                                    req.body.brandId = BrandID;
                                    req.body.universalEin = brandData.einIssuingCountry + '_' + brandData.ein;
                                    req.body.optionalAttributes = {};
                                    brandData = req.body;
                                    let escapedLog = JSON.stringify([req.body, datasess]);
                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `mobilePhone`, `brandId`,`cspId`, `altBusinessId`, `altBusinessIdType`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `stockSymbol`, `stockExchange`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`,`optionalAttributes`,`createDate`,`evpVettingScore`,`mobilePhoneVerifiedDate`, `brandType`,`cost`,`business_contact_email`) VALUES(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + (0, markError_1.parseBody)(brandData.companyName) + "', '" + (0, markError_1.parseBody)(brandData.displayName) + "', '" + brandData.entityType + "', '" + brandData.ein + "', '" + brandData.brandRelationship + "', '" + (0, markError_1.parseBody)(brandData.street) + "', '" + (0, markError_1.parseBody)(brandData.city) + "', '" + brandData.state + "', '" + brandData.postalCode + "', '" + brandData.website + "', '" + brandData.vertical + "', '" + brandData.country + "', '" + (0, markError_1.parseBody)(brandData.email) + "', '" + brandData.phone + "','', '" + brandData.brandId + "', '', '" + brandData.altBusinessId + "', '" + brandData.altBusinessIdType + "', '0', '" + brandData.universalEin + "',  '" + (0, markError_1.parseBody)(brandData.referenceId) + "', '" + brandData.entityType + "', 'VERIFIED', '" + brandData.stockSymbol + "', '" + brandData.stockExchange + "', '" + brandData.einIssuingCountry + "', 'false', '', '', '" + sysInfo.ipAddress[0] + "', '" + JSON.stringify(brandData.optionalAttributes) + "', NOW(), '0', '', 'register', '" + rateS + "','" + brandData.businessContactEmail + "')";
                                    obj3.execute((error3, result) => {
                                        if (error3 == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 201, brandId: brandData.brandId, message: "New Brand Created Successfully." });
                                            objv.execute();
                                            let payload = {
                                                idaccount: sessdata.idaccount,
                                                amount: rateS,
                                                purpose: 'brand registration',
                                                type: '-'
                                            };
                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("inbrandRegisterPFT => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandData.brandId + "','" + rateS + "','" + Date.now() + "',1, 'Brand Registered','" + combinedLog + "')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 504, brandId: brandData.brandId, message: "Result Not Saved Successfully!" });
                                            objv.execute();
                                        }
                                    });
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 505, message: "Something Went Wrong. Brand Not Created Successfully!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "You have insufficient funds in your account. Kindly add funds to your account!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**********************
    * Start Update Brand  *
    **********************/
    updateBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rateS = "4.50";
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
                        let brandId = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
                        rate.checkcharValid(brandId, 502, 'BrandId', (err1, msg1) => {
                            if (err1 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(msg1);
                                objv.execute();
                            }
                            else {
                                if (!data || Object.keys(data).length == 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 501, message: "Brand Update Data Is Required!" });
                                    objv.execute();
                                }
                                else {
                                    /* const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
                                    if (data.displayName && !prgmch.test(data.displayName)) {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 502, message: "displayName is Invalid" });
                                        objv.execute();
                                        return;
                                    } */
                                    let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                    Obj0.qrysql = "SELECT identityStatus FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                                    Obj0.prepare();
                                    Obj0.execute((_err, resStatus) => {
                                        if (data.entityType == 'PFT_BRAND') {
                                            let fun = new NewCampaign();
                                            fun.inUpdatePFTBrand(req, res, next);
                                        }
                                        else {
                                            if (resStatus[0].identityStatus == 'UNVERIFIED') {
                                                // let Obj00 = new ModelRawQuery(req, res);
                                                // Obj00.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 4";
                                                // Obj00.prepare();
                                                // Obj00.execute((crErr: any, crRes) => {
                                                //     if (crErr == 1 && crRes.length > 0) {
                                                rate.checkBalance(req, res, sessdata.idaccount, rateS, (crErr, crRes) => {
                                                    if (crErr == 1) {
                                                        let fun = new NewCampaign();
                                                        fun.inUpdateBrand(req, res, next);
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4.50!" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let fun = new NewCampaign();
                                                fun.inUpdateBrand(req, res, next);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inUpdateBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rateS = "4.50";
                let data = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
                let brandId = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
                let iduser = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                Obj0.qrysql = "SELECT identityStatus,entityType FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                Obj0.prepare();
                Obj0.execute((_err, resStatus) => {
                    var resultAllBrand = [];
                    for (var i in data) {
                        (i == "referenceId" && (data[i] == '' || data[i] == null)) ? '' : data[i] !== 'undefined' ? resultAllBrand.push([i, data[i]]) : '';
                    }
                    let brandData = Object.fromEntries(resultAllBrand);
                    let options = {
                        'method': 'PUT',
                        'url': apiUrl + 'brand/' + brandId,
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify(brandData)
                    };
                    (0, axios_1.request)(options, (__error, response, body) => {
                        if (!__error) {
                            try {
                                let resultData = JSON.parse(response.body);
                                let escapedLog = JSON.stringify([response.body, datasess]);
                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                if (resultData.brandId && resultData.brandId !== undefined) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `brand` SET `company_name`='" + (0, markError_1.parseBody)(resultData.companyName) + "',`brand_name`='" + (0, markError_1.parseBody)(resultData.displayName) + "',`entityType`='" + resultData.entityType + "',`ein`='" + resultData.ein + "',`einIssuingCountry`='" + resultData.einIssuingCountry + "', `identityStatus`='" + resultData.identityStatus + "', `cspId`='" + resultData.cspId + "',`address`='" + (0, markError_1.parseBody)(resultData.street) + "',`city`='" + (0, markError_1.parseBody)(resultData.city) + "',`state`='" + resultData.state + "',`postal_code`='" + resultData.postalCode + "',`country`='" + resultData.country + "',`website`='" + resultData.website + "',`stockSymbol`='" + resultData.stockSymbol + "',`stockExchange`='" + resultData.stockExchange + "',`vertical_type`='" + resultData.vertical + "',`referenceId`='" + resultData.referenceId + "',`brand_relation`='" + resultData.brandRelationship + "',`email`='" + (0, markError_1.parseBody)(resultData.email) + "',`phone`='" + resultData.phone + "',`mobilePhone`='" + resultData.mobilePhone + "',`firstName`='" + (0, markError_1.parseBody)(resultData.firstName) + "',`lastName`='" + (0, markError_1.parseBody)(resultData.lastName) + "',`altBusinessId`='" + resultData.altBusinessId + "',`altBusinessIdType`='" + resultData.altBusinessIdType + "',`ipAddress`='" + resultData.ipAddress + "',`optionalAttributes`='" + JSON.stringify(resultData.optionalAttributes) + "',`mock`='" + resultData.mock + "',`createDate`='" + resultData.createDate + "',`evpVettingScore`='" + (0, markError_1.setToZero)(resultData.evpVettingScore) + "',`mobilePhoneVerifiedDate`='" + resultData.mobilePhoneVerifiedDate + "',`business_contact_email` = '" + (0, markError_1.parseBody)(resultData.businessContactEmail) + "' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                                    obj.prepare();
                                    obj.execute((___error, result) => {
                                        let swaggerResChn = resultData;
                                        delete swaggerResChn.cspId;
                                        delete swaggerResChn.mock;
                                        let swaggerResponse = swaggerResChn;
                                        if (___error == 1) {
                                            if (resStatus[0].entityType !== 'SOLE_PROPRIETOR' && resStatus[0].identityStatus == 'UNVERIFIED' && resultData.identityStatus == "VERIFIED") {
                                                let payload = {
                                                    idaccount: sessdata.idaccount,
                                                    amount: rateS,
                                                    purpose: 'brand identity status changed',
                                                    type: '-'
                                                };
                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                    console.log("inUpdateBrand => walletDeduction Wallet deduction response:", errorD, dataD);
                                                });
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "','" + rateS + "','" + Date.now() + "',3, 'Brand Updated','" + combinedLog + "')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });
                                            }
                                            if (resStatus[0].entityType == 'SOLE_PROPRIETOR' && (!resStatus[0].identityStatus || resStatus[0].identityStatus == '' || resStatus[0].identityStatus == 'undefined' || resStatus[0].identityStatus == null || resStatus[0].identityStatus == undefined || resStatus[0].identityStatus == 'UNDEFINED' || resStatus[0].identityStatus == 'SELF_DECLARED')) {
                                                let otp = new BrandManager();
                                                otp.smsOTPBrand(req, res, resultData.brandId, (smsErr, smsOtp) => {
                                                    if (smsErr == 1) {
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `iduser`=" + sessdata.iduser + " AND `brandId`='" + resultData.brandId + "'";
                                                        obj.prepare();
                                                        obj.execute((___error, resp) => { });
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "Brand Updated Successfully And " +
                                                                smsOtp.message
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                        objv.execute();
                                                    }
                                                });
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", '" + sessdata.iduser + "','" + brandId + "','" + rateS + "', '" + Date.now() + "',3, 'Brand Updated','" + combinedLog + "')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Brand Updated Successfully!", data: swaggerResponse, status: 201
                                                });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With Brand Update!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "',0, '" + Date.now() + "',4, 'Brand Update Failed','" + combinedLog + "')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: resultData[0].description,
                                        status: resultData[0].code
                                    });
                                    objv.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: inUpdateBrand ::", e);
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 505, message: "Something Went Wrong. Brand Not Created Successfully!" });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inUpdatePFTBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rateS = "4.50";
                let resultData = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
                let brandId = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
                let iduser = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                Obj0.qrysql = "SELECT `identityStatus`,`brand_relation`,`company_name` FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                Obj0.prepare();
                Obj0.execute((eror1, resStatus) => {
                    if (eror1 == 1 && resStatus.length > 0) {
                        if (resultData.brandRelationship) {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `brand` SET `brand_relation`='" + resultData.brandRelationship + "' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                            obj.prepare();
                            obj.execute((berror1, bresult) => {
                                if (berror1 == 1) {
                                    let obj1 = new RawView_1.RawView(res);
                                    obj1.prepare({ status: 201, message: 'Brand relationship updated successfully!' });
                                    obj1.execute();
                                }
                                else {
                                    let obj2 = new RawView_1.RawView(res);
                                    obj2.prepare({ status: 502, message: 'Something went wrong with updating brand relationship!' });
                                    obj2.execute();
                                }
                            });
                        }
                        else {
                            rate.checkBalance(req, res, sessdata.idaccount, rateS, (crErr, crRes) => {
                                if (crErr == 1) {
                                    resultData.identityStatus = 'UNVERIFIED';
                                    resultData.companyName = resultData.companyName ? resultData.companyName : resStatus[0].company_name;
                                    resultData.optionalAttributes = {};
                                    resultData.evpVettingScore = '0';
                                    resultData.mobilePhoneVerifiedDate = '';
                                    resultData.ipAddress = sysInfo.ipAddress[0];
                                    resultData.brandRelationship = resultData.brandRelationship ? resultData.brandRelationship : resStatus[0].brand_relation;
                                    let escapedLog = JSON.stringify([resultData, datasess]);
                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `brand` SET `company_name`='" + (0, markError_1.parseBody)(resultData.companyName) + "',`brand_name`='" + (0, markError_1.parseBody)(resultData.displayName) + "',`entityType`='" + resultData.entityType + "',`ein`='" + resultData.ein + "',`einIssuingCountry`='" + resultData.einIssuingCountry + "', `identityStatus`='" + resultData.identityStatus + "',`address`='" + (0, markError_1.parseBody)(resultData.street) + "',`city`='" + (0, markError_1.parseBody)(resultData.city) + "',`state`='" + resultData.state + "',`postal_code`='" + resultData.postalCode + "',`country`='" + resultData.country + "',`website`='" + resultData.website + "',`stockSymbol`='" + resultData.stockSymbol + "',`stockExchange`='" + resultData.stockExchange + "',`vertical_type`='" + resultData.vertical + "',`referenceId`='" + resultData.referenceId + "',`brand_relation`='" + resultData.brandRelationship + "',`email`='" + (0, markError_1.parseBody)(resultData.email) + "',`phone`='" + resultData.phone + "',`mobilePhone`='" + resultData.mobilePhone + "',`firstName`='" + (0, markError_1.parseBody)(resultData.firstName) + "',`lastName`='" + (0, markError_1.parseBody)(resultData.lastName) + "',`altBusinessId`='" + resultData.altBusinessId + "',`altBusinessIdType`='" + resultData.altBusinessIdType + "',`optionalAttributes`='" + JSON.stringify(resultData.optionalAttributes) + "',`evpVettingScore`='" + (0, markError_1.setToZero)(resultData.evpVettingScore) + "',`mobilePhoneVerifiedDate`='" + resultData.mobilePhoneVerifiedDate + "',`ipAddress`='" + resultData.ipAddress + "',`business_contact_email` = '" + (0, markError_1.parseBody)(resultData.businessContactEmail) + "' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                                    obj.prepare();
                                    obj.execute((error1, result) => {
                                        if (error1 == 1) {
                                            let payload = {
                                                idaccount: sessdata.idaccount,
                                                amount: rateS,
                                                purpose: 'brand identity status changed',
                                                type: '-'
                                            };
                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("inUpdatePFTBrand => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + iduser + "','" + brandId + "','" + rateS + "','" + Date.now() + "',3, 'Brand Updated','" + combinedLog + "')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Brand Updated Successfully!", data: resultData, status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let escapedLog1 = JSON.stringify([result, datasess]);
                                            let combinedLog1 = escapedLog1.replace(/'/g, "\\'");
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + iduser + ",'" + brandId + "',0, '" + Date.now() + "',4, 'Brand Update Failed','" + combinedLog1 + "')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With Brand Update!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4.50!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Brand expired!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /********************
    * End Update Brand  *
    ********************/
    /************************************
    * Start Revet Brand Identity Status *
    *************************************/
    brandRvtForIdenSttsUp(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let rateS = "4.50";
                        rate.checkBalance(req, res, sessdata.idaccount, rateS, (crErr, crRes) => {
                            if (crErr == 1) {
                                let brandId = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.body.brandId;
                                let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                Obj0.qrysql = "SELECT identityStatus,brandId,entityType FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                                Obj0.prepare();
                                Obj0.execute((_err, resStatus) => {
                                    if (_err == 1 && resStatus.length > 0) {
                                        if (resStatus[0].entityType == 'PFT_BRAND') {
                                            let fun = new NewCampaign();
                                            fun.inRevetPFT(req, res, next);
                                        }
                                        else {
                                            let fun = new NewCampaign();
                                            fun.inRevet(req, res, next);
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Brand Expired!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inRevet(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let brates = "4.50";
                let brandId = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.body.brandId;
                let iduser = (req.body.data !== undefined && req.body.data !== 'undefined') ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                rate.checkcharValid(brandId, 502, 'BrandId', (err1, msg1) => {
                    if (err1 == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(msg1);
                        objv.execute();
                    }
                    else {
                        let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT identityStatus,brandId FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                        Obj0.prepare();
                        Obj0.execute((_err, resStatus) => {
                            if (resStatus.length > 0) {
                                let options = {
                                    'method': 'PUT',
                                    'url': apiUrl + 'brand/' + brandId + '/revet',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': 'Basic ' + authKey
                                    },
                                    //body: JSON.stringify({ nonBlocking: true })
                                };
                                (0, axios_1.request)(options, (error, response, body) => {
                                    if (!error) {
                                        try {
                                            let escapedLog = JSON.stringify([response.body, datasess]);
                                            let combinedLog = escapedLog.replace(/'/g, "\\'");
                                            if (response.body) {
                                                let resultData = JSON.parse(response.body);
                                                if (resStatus[0].identityStatus == "UNVERIFIED" && resultData.identityStatus == "UNVERIFIED") {
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='" + resultData.identityStatus + "' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                                                    obj.prepare();
                                                    obj.execute((___error, resp) => {
                                                        if (___error == 1) {
                                                            let payload = {
                                                                idaccount: sessdata.idaccount,
                                                                amount: brates,
                                                                purpose: 'identity status changed',
                                                                type: '-'
                                                            };
                                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                console.log("inRevet => walletDeduction Wallet deduction response:", errorD, dataD);
                                                            });
                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + iduser + "','" + brandId + "','" + brates + "','" + Date.now() + "',7, 'Brand Re-Submitted','" + combinedLog + "')";
                                                            obj3.prepare();
                                                            obj3.execute((log_error, _resp) => {
                                                                if (log_error == 1) {
                                                                    console.log("Brand Log Updated.");
                                                                }
                                                                else {
                                                                    console.log("Brand Log Not Updated.");
                                                                }
                                                            });
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Brand Status Updated Successfully.", data: resStatus.identityStatus, status: 200 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong With Brand Status!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + iduser + ",'" + brandId + "','" + brates + "','" + Date.now() + "',8, 'Brand Re-Submit Failed','" + combinedLog + "')";
                                                    obj3.prepare();
                                                    obj3.execute((log_error, _resp) => {
                                                        if (log_error == 1) {
                                                            console.log("Brand Log Updated.");
                                                        }
                                                        else {
                                                            console.log("Brand Log Not Updated.");
                                                        }
                                                    });
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "No Change in Brand Identity Status.", data: resStatus.identityStatus, data1: resultData[0], status: 502 });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + iduser + ",'" + brandId + "', '" + brates + "','" + Date.now() + "',8, 'Brand Re-Submit Failed','" + combinedLog + "')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: resStatus[0].field + ' ' + resStatus[0].description,
                                                    status: resStatus[0].code
                                                });
                                                objv.execute();
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: inRevet ::", e);
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                            obj.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Brand Expired!", status: 503 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Brand Expired!", status: 503 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inRevetPFT(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let brates = "4.50";
                let brandId = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.body.brandId;
                let iduser = (req.body.data !== undefined && req.body.data !== 'undefined') ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                rate.checkcharValid(brandId, 502, 'BrandId', (err1, msg1) => {
                    if (err1 == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(msg1);
                        objv.execute();
                    }
                    else {
                        let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT identityStatus,brandId FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                        Obj0.prepare();
                        Obj0.execute((_err, resStatus) => {
                            if (resStatus.length > 0) {
                                let escapedLog = JSON.stringify([req.body, datasess]);
                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                if (resStatus[0].identityStatus == "UNVERIFIED") {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='VERIFIED' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                                    obj.prepare();
                                    obj.execute((error1, resp) => {
                                        if (error1 == 1) {
                                            let payload = {
                                                idaccount: sessdata.idaccount,
                                                amount: brates,
                                                purpose: 'identity status changed',
                                                type: '-'
                                            };
                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("inRevetPFT => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + iduser + "','" + brandId + "','" + brates + "','" + Date.now() + "',7, 'Brand Re-Submitted','" + combinedLog + "')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Brand Status Updated Successfully.", data: resStatus.identityStatus, status: 200 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Brand Status in RevetPFT!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let escapedLog1 = JSON.stringify(['[{\"code\":525,\"description\":\"You cannot initiate this request as the brand is already in higher identity status\"}', datasess]);
                                    let combinedLog1 = escapedLog1.replace(/'/g, "\\'");
                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + iduser + ",'" + brandId + "','" + brates + "','" + Date.now() + "',8, 'Brand Re-Submit Failed','" + combinedLog1 + "')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 525, message: "No Change in Brand Identity Status.", data: resStatus.identityStatus });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Brand Expired!", status: 503 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /***********************************
    * End Identtity Status Of Brand  *
    ***********************************/
    /****************
    * Delete Brand  *
    ****************/
    deleteBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let brandId = req.query.data !== undefined ? req.query.data : req.query.brandId;
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        rate.checkcharValid(brandId, 502, 'BrandId', (err1, msg1) => {
                            if (err1 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(msg1);
                                objv.execute();
                            }
                            else {
                                let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                Obj0.qrysql = "SELECT identityStatus,brandId,entityType FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                                Obj0.prepare();
                                Obj0.execute((_err, resStatus) => {
                                    if (_err == 1 && resStatus.length > 0) {
                                        if (resStatus[0].entityType == 'PFT_BRAND') {
                                            let fun = new NewCampaign();
                                            fun.deletePFTBrand(req, res, next);
                                        }
                                        else {
                                            let options = {
                                                'method': 'DELETE',
                                                'url': apiUrl + 'brand/' + brandId,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            (0, axios_1.request)(options, (__error, response, body) => {
                                                if (!__error) {
                                                    try {
                                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                        if ((response.statusCode == 405) || (response.statusCode == 204 && response.statusCode !== undefined) || (JSON.parse(body)[0].code == 502 && JSON.parse(body)[0].code !== undefined)) {
                                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj0.nonqrysql = "UPDATE `brand` SET `deleted`=1, `delete_date`=NOW() WHERE `brandId`='" + brandId + "' AND `idaccount`=" + sessdata.idaccount + " ";
                                                            obj0.prepare();
                                                            obj0.execute((__errorb, resbrand) => {
                                                                if (__errorb == 1) {
                                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 0, '" + Date.now() + "',5, 'Brand Removed','" + combinedLog + "')";
                                                                    obj3.prepare();
                                                                    obj3.execute((log_error, _resp) => {
                                                                        if (log_error == 1) {
                                                                            console.log("Brand Log Updated.");
                                                                        }
                                                                        else {
                                                                            console.log("Brand Log Not Updated.");
                                                                        }
                                                                    });
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "Brand Deleted Successfully!",
                                                                        status: 201
                                                                    });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 0, '" + Date.now() + "',6, 'Brand Remove Failed','" + combinedLog + "')";
                                                                    obj3.prepare();
                                                                    obj3.execute((log_error, _resp) => {
                                                                        if (log_error == 1) {
                                                                            console.log("Brand Log Updated.");
                                                                        }
                                                                        else {
                                                                            console.log("Brand Log Not Updated.");
                                                                        }
                                                                    });
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "Something Went Wrong With Delete Brand!",
                                                                        error: resbrand,
                                                                        status: 502
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let data = JSON.parse(body);
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                //message: data[0].field + ' ' + data[0].description,
                                                                message: data[0].description,
                                                                status: data[0].code
                                                            });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: deleteBrand ::", e);
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        message: "Brand Can't be Delete!",
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Brand Expired!" });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deletePFTBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let brandId = req.query.data !== undefined ? req.query.data : req.query.brandId;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let escapedLog = JSON.stringify([req.body, datasess]);
                let combinedLog = escapedLog.replace(/'/g, "\\'");
                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `brand` SET `deleted`=1, `delete_date`=NOW() WHERE `brandId`='" + brandId + "' AND `idaccount`=" + sessdata.idaccount + " ";
                obj0.prepare();
                obj0.execute((errorb, resbrand) => {
                    if (errorb == 1) {
                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 0, '" + Date.now() + "',5, 'Brand Removed','" + combinedLog + "')";
                        obj3.prepare();
                        obj3.execute((log_error, _resp) => {
                            if (log_error == 1) {
                                console.log("Brand Log Updated.");
                            }
                            else {
                                console.log("Brand Log Not Updated.");
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Brand Deleted Successfully!",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 0, '" + Date.now() + "',6, 'Brand Remove Failed','" + combinedLog + "')";
                        obj3.prepare();
                        obj3.execute((log_error, _resp) => {
                            if (log_error == 1) {
                                console.log("Brand Log Updated.");
                            }
                            else {
                                console.log("Brand Log Not Updated.");
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Delete Brand!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*****************
    * Get All Brand  *
    *****************/
    getAllBrands(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let iduser = sessdata.iduser;
                        let condition = '';
                        if (sessdata.type == 1) {
                            condition += '';
                        }
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                            condition += "AND `idaccount`=" + sessdata.idaccount + " ";
                        }
                        if (sessdata.type == 22) {
                            condition += "AND `iduser`=" + sessdata.iduser + " ";
                        }
                        let ext_field = req.query.type ? "idbrand,iduser, idaccount,cspId,registrationScore,CONCAT(brand_name,' - ',brandId)brand_name_with_key, DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On, deleted, delete_date, mock,company_type," : '';
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        // obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`,created_at FROM brand WHERE `status`=0 AND `deleted`=0 " + condition + " ORDER BY `idbrand` DESC";
                        obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`,created_at,business_contact_email,business_email_verified_date,business_contact_firstname,business_contact_lastname,business_contact_title FROM brand WHERE `status`=0 AND `deleted`=0 " + condition + " ORDER BY `idbrand` DESC";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                const filteredResult = result.map((item) => {
                                    if (item.entityType != 'PUBLIC_PROFIT') {
                                        delete item.business_contact_email;
                                        delete item.business_email_verified_date;
                                        delete item.business_contact_firstname;
                                        delete item.business_contact_lastname;
                                        delete item.business_contact_title;
                                    }
                                    return item;
                                });
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: filteredResult,
                                    message: "Brand Fetched Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Connection!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /****************
    * Brand Filter  *
    ****************/
    brandFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid1_2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let message = "", ext_field;
                        switch (true) {
                            case (!data || !('data' in req.body)):
                                message = "Missing request body";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        let condition = "";
                        let conditionU = '';
                        let idaccount = '';
                        if (sessdata.type == 1) {
                            conditionU += '';
                        }
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                            conditionU += "`idaccount`=" + sessdata.idaccount + "  AND";
                        }
                        if (sessdata.type == 22) {
                            conditionU += "`iduser`=" + sessdata.iduser + "  AND";
                        }
                        if (sessdata.type == 1) {
                            ext_field = "iduser, idaccount,";
                        }
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        if (data.brandId)
                            condition += '`brandId` LIKE "%' + (0, markError_1.parseBody)(data.brandId) + '%" AND ';
                        if (data.brand_name)
                            condition += '`brand_name` LIKE "%' + (0, markError_1.parseBody)(data.brand_name) + '%" AND ';
                        if (data.country)
                            condition += '`country`="' + data.country + '" AND ';
                        if (data.entityType)
                            condition += '`entityType` LIKE "%' + data.entityType + '%" AND ';
                        if (data.ein)
                            condition += '`ein` LIKE "%' + data.ein + '%" AND ';
                        if (data.identityStatus)
                            condition += '`identityStatus` LIKE "' + data.identityStatus + '%" AND ';
                        if (data.referenceId)
                            condition += '`referenceId` LIKE "%' + (0, markError_1.parseBody)(data.referenceId) + '%" AND ';
                        if (data.idaccount)
                            idaccount += "`idaccount`= " + data.idaccount + "  AND";
                        // obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE deleted='0' AND " + condition + " " + conditionU + " ";
                        obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE " + idaccount + " " + conditionU + " " + condition + " deleted=0";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: result,
                                    message: "Brand Fetched Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Connection!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /****************
    * CNP Brand Filter  *
    ****************/
    cnpBrandFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = "";
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += '';
                }
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    conditionU += "`idaccount`=" + sessdata.idaccount + " AND";
                }
                if (sessdata.type == 22) {
                    conditionU += "`iduser`=" + sessdata.iduser + " AND";
                }
                if (data.brandId)
                    condition += '`brandId` LIKE "%' + (0, markError_1.parseBody)(data.brandId) + '%" AND ';
                if (data.displayName)
                    condition += '`displayName` LIKE "%' + (0, markError_1.parseBody)(data.displayName) + '%" AND ';
                if (data.company_name)
                    condition += '`company_name` LIKE "%' + (0, markError_1.parseBody)(data.company_name) + '" AND ';
                if (data.website)
                    condition += '`website` LIKE "%' + (0, markError_1.parseBody)(data.website) + '%" AND ';
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE deleted='0' AND " + condition + " " + conditionU + " ";
                obj.qrysql = "SELECT iduser, idaccount, brandId, company_name, displayName, website , status, DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE " + conditionU + " " + condition + " deleted=0 AND `status`=1 ORDER BY `idbrand` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*******************
    * Campaign Filter  *
    *******************/
    campaignFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid1_2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let condition = "";
                        let parent_campaign_id = "";
                        let deleted_status = '';
                        let message = "";
                        switch (true) {
                            case (!data || !('data' in req.body)):
                                message = "Missing request body";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        let conditionU = '';
                        let idaccount = '';
                        let campaign_status = '', ext_field, orderby = 'c.`start_date` DESC';
                        if (sessdata.type == 1) {
                            conditionU += data.idaccount !== '' && data.idaccount !== null ? "c.`idaccount`='" + data.idaccount + "' AND" : '';
                            // idaccount += 'c.idaccount ,';
                            ext_field = 'c.id_campaign, c.camp_reseller_unique_id, c.idaccount, c.iduser, ';
                        }
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                            conditionU += "c.`idaccount`='" + sessdata.idaccount + "' AND";
                        }
                        if (sessdata.type == 22) {
                            conditionU += "c.`iduser`='" + sessdata.iduser + "' AND";
                        }
                        if (data.filter_type == "All")
                            condition += '';
                        if (data.shorting == "created_asc")
                            orderby = 'c.`start_date` ASC';
                        if (data.shorting == "created_desc")
                            orderby = 'c.`start_date` DESC';
                        if (data.shorting == "updated_asc")
                            orderby = 'c.`updated_at` ASC';
                        if (data.shorting == "updated_desc")
                            orderby = 'c.`updated_at` DESC';
                        if (data.brandId)
                            condition += '`brandId` LIKE "%' + (0, markError_1.parseBody)(data.brandId) + '%" AND ';
                        if (data.brand_name)
                            condition += '`brand_name` LIKE "%' + (0, markError_1.parseBody)(data.brand_name) + '%" AND ';
                        if (data.campaign_key)
                            condition += '`campaign_key` LIKE "%' + (0, markError_1.parseBody)(data.campaign_key) + '%" AND ';
                        if (data.sm_reference_no)
                            condition += '`sm_reference_no` LIKE "%' + (0, markError_1.parseBody)(data.sm_reference_no) + '%" AND ';
                        if (data.parent_campaign_id)
                            condition += '`parent_campaign_id` LIKE "%' + (0, markError_1.parseBody)(data.parent_campaign_id) + '%" AND ';
                        if (data.usecase)
                            condition += '`usecase`="' + data.usecase + '" AND ';
                        if (data.tcrStatus == 'Both' || data.tcrStatus == null || data.tcrStatus == '') {
                            condition += '';
                        }
                        else {
                            condition += 'c.`deleted`="' + data.tcrStatus + '" AND ';
                        }
                        if (data.filter_type == "DCA Submission")
                            condition += 'c.`provisioning_status`="0" AND ';
                        if (data.filter_type == "Shared")
                            condition += 'c.`provisioning_status`="1" AND ';
                        if (data.filter_type == "Completed")
                            condition += 'c.`provisioning_status`="3" AND ';
                        if (data.filter_type == "Failed")
                            condition += 'c.`provisioning_status`="4" AND ';
                        if (data.filter_type == "Customer Action Required")
                            condition += 'c.`provisioning_status`="5" AND ';
                        if (data.filter_type == "Save")
                            condition += 'c.`provisioning_status`="6" AND ';
                        if (data.filter_type == "Pending for Profile Approval")
                            condition += 'c.`provisioning_status`="7" AND ';
                        if (data.provisioning_status == "0")
                            condition += 'c.`provisioning_status`="0" AND ';
                        if (data.provisioning_status == "1")
                            condition += 'c.`provisioning_status`="1" AND ';
                        if (data.provisioning_status == "2")
                            condition += 'c.`provisioning_status`="2" AND ';
                        if (data.provisioning_status == "3")
                            condition += 'c.`provisioning_status`="3" AND ';
                        if (data.provisioning_status == "4")
                            condition += 'c.`provisioning_status`="4" AND ';
                        if (data.provisioning_status == "5")
                            condition += 'c.`provisioning_status`="5" AND ';
                        if (data.provisioning_status == "6")
                            condition += 'c.`provisioning_status`="6" AND ';
                        if (data.provisioning_status == "7")
                            condition += 'c.`provisioning_status`="7" AND ';
                        if (data.filter_type == "Redundant Campaign" || data.filter_type == "DCA Submission")
                            parent_campaign_id += 'c.`parent_campaign_id`, ';
                        if (data.filter_type == "Pending for Profile Approval" || data.filter_type == "Customer Action Required")
                            deleted_status += 'c.`deleted`= "0" AND';
                        if (sessdata.type == 1 && data.filter_type == "Redundant Campaign")
                            deleted_status += 'c.`deleted`= "0" AND';
                        if (data.filter_type != "Pending for Profile Approval")
                            campaign_status += 'c.`status` IN (0, 2,3)';
                        if (data.filter_type == "Pending for Profile Approval")
                            campaign_status += 'c.`status`=0';
                        obj.qrysql = "SELECT b.brandId, b.brand_name,c.status ,c.requestextension_status,c.extended_date , c.sm_reference_no,c.campaign_key,c.usecase, c.start_date,c.did_count,c.did_limit, c.parent_campaign_id, " + ext_field + " c.upstreamCnpId,c.parent_sm_reference_no,c.deleted,c.provisioning_status," + parent_campaign_id + " ( SELECT upstreamCnpId FROM campaign WHERE campaign_key = c.parent_campaign_id AND status = 0 LIMIT 1 ) AS parent_dca FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + deleted_status + " " + conditionU + " " + condition + " " + campaign_status + "  GROUP BY c.`sm_reference_no` ORDER BY " + orderby + "";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: result,
                                    message: "Campaign List Fetched Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Fetched Campaign List!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*******************
    * Campaign Filter  *
    *******************/
    /********************
    * Get Brand Detail  *
    ********************/
    getBrandsDetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let gdata = req.query;
                        let data = gdata.type !== undefined ? JSON.parse(gdata.type) : gdata;
                        let ext_field = gdata.type ? "idbrand,iduser, idaccount,cspId,registrationScore,mock,deleted, delete_date , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On,createDate,company_type," : '';
                        if (!data) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "BrandId is required" });
                            objv.execute();
                        }
                        else {
                            rate.checkcharValid(data.brandId, 502, 'BrandId', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT " + ext_field + " brandType, brand_name, brandId, brand_relation,altBusinessId, altBusinessIdType, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes,mobilePhoneVerifiedDate, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`, created_at,business_contact_email FROM brand WHERE `deleted`=0 AND brandId='" + data.brandId + "'";
                                    obj.prepare();
                                    obj.execute((_error, result) => {
                                        if (_error == 1) {
                                            if (result.length > 0) {
                                                if (result[0].entityType == 'PFT_BRAND') {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ data: result, message: "Brand Fetched Successfully!", status: 200 });
                                                    objv.execute();
                                                }
                                                else {
                                                    var options = {
                                                        'method': 'GET',
                                                        'url': apiUrl + 'brand/' + data.brandId,
                                                        'headers': {
                                                            'Content-Type': 'application/json',
                                                            'Authorization': 'Basic ' + authKey
                                                        }
                                                    };
                                                    (0, axios_1.request)(options, (error, response, body) => {
                                                        if (!error) {
                                                            try {
                                                                let responseData = JSON.parse(response.body);
                                                                let businessEmailVerifiedDate = responseData.businessContactEmailVerifiedDate ? new Date(responseData.businessContactEmailVerifiedDate).toISOString().slice(0, 19).replace('T', ' ') : 'NULL';
                                                                result.map((item) => {
                                                                    item.businessContactEmailVerifiedDate = responseData.businessContactEmailVerifiedDate;
                                                                    item.businessContactTitle = responseData.businessContactTitle;
                                                                    item.businessContactFirstName = responseData.businessContactFirstName;
                                                                    item.businessContactLastName = responseData.businessContactLastName;
                                                                });
                                                                if (responseData.identityStatus == 'VERIFIED' && responseData.entityType == 'PUBLIC_PROFIT' && responseData.businessContactEmailVerifiedDate) {
                                                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                                    obj1.qrysql = "UPDATE `brand` SET `business_email_verified_date` = '" + businessEmailVerifiedDate + "' , `business_contact_lastname` = '" + responseData.businessContactLastName + "' , `business_contact_firstname` = '" + responseData.businessContactFirstName + "' , `business_contact_title` = '" + responseData.businessContactTitle + "' WHERE brandId = '" + data.brandId + "'";
                                                                    obj1.prepare();
                                                                    obj1.execute((__err, campDetails) => { });
                                                                }
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ data: result, message: "Brand Fetched Successfully!", status: 200 });
                                                                objv.execute();
                                                            }
                                                            catch (e) {
                                                                console.log("Error :: getBrandsDetail ::", e);
                                                                let obj = new RawView_1.RawView(res);
                                                                obj.prepare({ error: 1, status: 505, message: "Something went wrong!" });
                                                                obj.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ error: 1, message: "Something went wrong with get brand detail!", status: 503 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                // var options = {
                                                //     'method': 'GET',
                                                //     'url': apiUrl + 'brand/' + data.brandId,
                                                //     'headers': {
                                                //         'Content-Type': 'application/json',
                                                //         'Authorization': 'Basic ' + authKey
                                                //     }
                                                // };
                                                // request(options, (error: any, response: any, body: any) => {
                                                //     if (!error) {
                                                //         try {
                                                //             let responseData = JSON.parse(response.body);
                                                //             let businessEmailVerifiedDate = responseData.businessContactEmailVerifiedDate ? new Date(responseData.businessContactEmailVerifiedDate).toISOString().slice(0, 19).replace('T', ' ') : 'NULL';
                                                //             result.map((item: any) => {
                                                //                 item.businessContactEmailVerifiedDate = responseData.businessContactEmailVerifiedDate;
                                                //                 item.businessContactTitle = responseData.businessContactTitle;
                                                //                 item.businessContactFirstName = responseData.businessContactFirstName;
                                                //                 item.businessContactLastName = responseData.businessContactLastName;
                                                //             })
                                                //             if (responseData.identityStatus == 'VERIFIED' && responseData.entityType == 'PUBLIC_PROFIT' && responseData.businessContactEmailVerifiedDate) {
                                                //                 let obj1 = new ModelRawQuery(req, res);
                                                //                 obj1.qrysql = "UPDATE `brand` SET `business_email_verified_date` = '" + businessEmailVerifiedDate + "' , `business_contact_lastname` = '" + responseData.businessContactLastName + "' , `business_contact_firstname` = '" + responseData.businessContactFirstName + "' , `business_contact_title` = '" + responseData.businessContactTitle + "' WHERE brandId = '" + data.brandId + "'";
                                                //                 obj1.prepare();
                                                //                 obj1.execute((__err: any, campDetails: any) => { });
                                                //             }
                                                //             let objv = new RawView(res);
                                                //             objv.prepare({ data: result, message: "Brand Fetched Successfully!", status: 200 });
                                                //             objv.execute();
                                                //         }
                                                //         catch (e) {
                                                //             console.log("Error :: getBrandsDetail ::", e);
                                                //             let obj = new RawView(res);
                                                //             obj.prepare({ error: 1, status: 505, message: "Something went wrong!" });
                                                //             obj.execute();
                                                //         }
                                                //     }
                                                //     else {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ error: 1, message: "Something went wrong with get brand detail!", status: 503 });
                                                //         objv.execute();
                                                //     }
                                                // });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ error: 1, message: "No Result Found!", status: 502 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 504,
                                                error: 1
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /***************************
    * Get OTP Status For Brand *
    ***************************/
    sendOTPforBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        rate.checkcharValid(sdata.brandId, 502, 'BrandId', (err1, msg1) => {
                            if (err1 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(msg1);
                                objv.execute();
                            }
                            else {
                                let otp = new BrandManager();
                                otp.smsOTPBrand(req, res, sdata.brandId, (smsErr, smsOtp) => {
                                    if (smsErr == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: smsOtp.status, data: smsOtp.data, message: smsOtp.message });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: smsOtp.status, brandId: sdata.brandId, message: smsOtp.message });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***************************
    * Get OTP Status For Brand *
    ***************************/
    verifyBrandOTP(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = req.body;
                let otpdata = {
                    otpPin: sdata.brandOTP,
                };
                let options = {
                    'method': 'PUT',
                    'url': apiUrl + 'brand/' + sdata.brandId + '/smsOtp',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(otpdata)
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            let data = JSON.stringify(response.body);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: 'OTP Updated !', data: data, status: 200 });
                            objv.execute();
                        }
                        catch (e) {
                            console.log("Error :: verifyBrandOTP ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "OTP Not Updated!", data: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /*********************
    * Send OTP For Brand *
    *********************/
    getOTPStatusForBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let options = {
                            'method': 'GET',
                            'url': apiUrl + 'brand/smsOtp/' + sdata.referenceId,
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    let resData = JSON.parse(response.body);
                                    if (resData.referenceId && resData.referenceId !== undefined) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: 'Brand OTP Status!', data: resData, status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: resData[0].field + ' ' + resData[0].description, status: resData[0].code });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: getOTPStatusForBrand ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "No Status Available!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /****************
    * Vetting Class *
    *****************/
    brandVettingClass(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'GET',
                            'url': apiUrl + 'enum/vettingClass',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Brand Vetting Fetched!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went Wrong With Brand Vetting Fetching!", error: error, status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: BrandVettingClass ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***********************
    * Get Vetting Provider *
    ***********************/
    brandVettingProvider(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 1 || sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'Get',
                            'url': apiUrl + 'enum/extVettingProvider',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Brand Vetting Provider Fetched!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went Wrong With Brand Vetting Provider Fetching!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: BrandVettingProvider ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***********************
    * Get Vetting Status   *
    ***********************/
    brandVettingStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'Get',
                            'url': apiUrl + 'enum/vettingStatus',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let data = JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Brand Vetting Status Fetched!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went Wrong With Brand Vetting Status Fetching!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: BrandVettingStatus ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /*****************************************
    * Get Vetting Class Class By Entity Type *
    *****************************************/
    getVettingClassByEtype(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let data = JSON.parse(sdata.type);
                let entityType = data.entityType;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT vettingClass,VC_displayName,evpId,EI_displayName,price,waitTime FROM `brand_vetting_additional` WHERE entityType='" + entityType + "' GROUP BY `vettingClass`";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Vetting Class and Provider Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Vetting Class and Provider Not Fetched!", data: [], status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /**************************************
    * Get Vetting Provider By Entity Type *
    **************************************/
    getVettingPartner(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let data = JSON.parse(sdata.type);
                let entityType = data.entityType;
                let vettingClass = data.vettingClass;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT vettingClass,VC_displayName,evpId,EI_displayName,price,waitTime FROM `brand_vetting_additional` WHERE entityType='" + entityType + "' AND `vettingClass`='" + vettingClass + "'";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Vetting Class and Provider Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Vetting Class and Provider Not Fetched!", data: [], status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /****************************
    * Get Vetting List By Brand *
    ****************************/
    getBrandsVettingList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let data = JSON.parse(sdata.type);
                let ext_field;
                if (sessData.type == 1) {
                    ext_field = "iduser, ";
                }
                let brandId = data.brandId;
                // let iduser: any = data.iduser;
                let idaccount = sessData.type == 1 ? data.idaccount : sessData.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " brandID, validUntil, type,filepath,filename,evpId,vettingId,vettingToken,vettingScore,vettingClass,vettingStatus,reasons,vettingDetails,VettedDate,createdDate FROM `brand_vetting` WHERE brandId='" + brandId + "' AND idaccount=" + idaccount + " GROUP BY `vettingId`";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Vetting Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "NO Vetting available in this Brand!", data: [], status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /****************
    * Apply Vetting *
    ****************/
    applyVetting(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let vettingData = req.body;
                        let vettingData1 = req.query;
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let brandId = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT entityType, website, business_contact_email, einIssuingCountry FROM `brand` WHERE brandId='" + brandId + "' AND `idaccount` = " + sessdata.idaccount + " ";
                        obj.prepare();
                        obj.execute((errBrand, resultBrand) => {
                            if (errBrand == 1 && resultBrand.length > 0) {
                                if (((0, markError_1.isMissing)(resultBrand[0].website) || (0, markError_1.isMissing)(resultBrand[0].business_contact_email)) && resultBrand[0].entityType == 'PUBLIC_PROFIT' && vettingData.vettingClass == 'AUTHPLUS') {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 501, message: "For AUTHPLUS vetting please update Website and business contact email from brand detail." });
                                    objv.execute();
                                }
                                else {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `vettingStatus` FROM `brand_vetting` WHERE evpId='" + vettingData.evpId + "' AND vettingClass='" + vettingData.vettingClass + "' AND vettingStatus='PENDING' AND `brandId`='" + brandId + "' AND `idaccount` = " + sessdata.idaccount + " ";
                                    obj.prepare();
                                    obj.execute((errDplctVtng, duplicateVetting) => {
                                        if (errDplctVtng == 1 && duplicateVetting.length > 0) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 525, message: "Vetting re-submission not allowed with same brand information." });
                                            objv.execute();
                                        }
                                        else {
                                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                                            obj.qrysql = "SELECT vettingClass,evpId,price,waitTime,failedPrice FROM `brand_vetting_additional` WHERE evpId='" + vettingData.evpId + "' AND vettingClass='" + vettingData.vettingClass + "' AND entityType='" + resultBrand[0].entityType + "'";
                                            obj.prepare();
                                            obj.execute((errV, resulttV) => {
                                                let resultV = resulttV.length > 0 ? resulttV : [0];
                                                // For pinPreference (swagger side request)
                                                let price = 0;
                                                if ((resultBrand[0].entityType == "NON_PROFIT" && resultBrand[0].einIssuingCountry == "US" && resultV[0].vettingClass == "POLITICAL" && resultV[0].evpId == "AEGIS") || (resultBrand[0].entityType == "SOLE_PROPRIETOR" && resultBrand[0].einIssuingCountry == "US" && resultV[0].vettingClass == "POLITICAL" && resultV[0].evpId == "AEGIS")) {
                                                    let pinPre = JSON.parse(vettingData.additionalRequestPayload).pinPreference;
                                                    switch (pinPre) {
                                                        case "Regular":
                                                            price = 66;
                                                            break;
                                                        case "Email":
                                                            price = 66;
                                                            break;
                                                        default: // Express
                                                            price = 96;
                                                    }
                                                }
                                                else {
                                                    price = resultV[0].price !== undefined ? resultV[0].price : 0;
                                                }
                                                let deductPrice = price;
                                                let waittime = resultV[0].waitTime !== undefined ? resultV[0].waitTime : '';
                                                let Obj = new RawQuery_1.ModelRawQuery(req, res);
                                                Obj.qrysql = "SELECT balance,min_balance,topup_amount,credit_limit FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= '" + deductPrice + "'";
                                                Obj.prepare();
                                                Obj.execute((bErr, bRes) => {
                                                    if (bErr == 1 && bRes.length > 0) {
                                                        let options = {
                                                            'method': 'POST',
                                                            'url': apiUrl + 'brand/' + brandId + '/externalVetting/',
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'Authorization': 'Basic ' + authKey
                                                            },
                                                            body: JSON.stringify({
                                                                "evpId": vettingData.evpId,
                                                                "vettingClass": vettingData.vettingClass,
                                                                "additionalRequestPayload": vettingData.additionalRequestPayload
                                                            })
                                                        };
                                                        (0, axios_1.request)(options, (error, response, body) => {
                                                            let escapedLog = JSON.stringify([response.body, datasess]);
                                                            let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                            if (!error) {
                                                                try {
                                                                    let resData = JSON.parse(response.body);
                                                                    if (resData.vettingId && resData.vettingId !== undefined) {
                                                                        let payload = {
                                                                            idaccount: sessdata.idaccount,
                                                                            amount: deductPrice,
                                                                            purpose: 'vetting apply',
                                                                            type: '-'
                                                                        };
                                                                        rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                            console.log("applyVetting => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                        });
                                                                        //To insert brand vetting detail
                                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj.nonqrysql = "INSERT INTO `brand_vetting` (`idaccount`, `iduser`, `brandId`,`type`, `evpId`, `vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate`,`priceDeducted`, `validUntil`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + brandId + "', 'applyVetting', '" + resData.evpId + "', '" + resData.vettingId + "','" + resData.vettingToken + "'," + (0, markError_1.setToZero)(resData.vettingScore) + ",'" + resData.vettingClass + "','" + resData.vettingStatus + "','" + (0, markError_1.parseBody)(JSON.stringify(resData.reasons)) + "','" + (0, markError_1.parseBody)(JSON.stringify(resData.vettingDetails)) + "','" + resData.vettedDate + "','" + resData.createDate + "'," + (0, markError_1.setToZero)(deductPrice) + ", '" + resData.validUntil + "')";
                                                                        obj.prepare();
                                                                        obj.execute((___error, resp) => {
                                                                            if (___error == 1) {
                                                                                //To update vetting log 
                                                                                let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "','" + sessdata.iduser + "','" + brandId + "'," + (0, markError_1.setToZero)(deductPrice) + "," + (0, markError_1.setToZero)(deductPrice) + ",'" + resData.evpId + "','" + resData.vettingId + "',1,'Vetting Apply','" + combinedLog + "')";
                                                                                objh.prepare();
                                                                                objh.execute((vetting_error, vetting_success) => {
                                                                                    console.log("Vetting log updated");
                                                                                });
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 200, message: "Vetting Applied Successfully.Vetting Price " + deductPrice + " and Estimated Time for Vetting: " + waittime + "", data: resData });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                //To update vetting log 
                                                                                let objhk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                objhk.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "'," + (0, markError_1.setToZero)(deductPrice) + "," + (0, markError_1.setToZero)(deductPrice) + ",'" + resData.evpId + "','" + resData.vettingId + "',2,'Vetting Apply Failed','" + combinedLog + "')";
                                                                                objhk.prepare();
                                                                                objhk.execute((vetting_error, vetting_success) => {
                                                                                    console.log("Vetting log updated");
                                                                                });
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 501, message: "Vetting Data Not Saved!", data: resData });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        // objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                                        objv.prepare({ status: resData[0].code, message: resData[0].description });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: applyVetting ::", e);
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            }
                                                            else {
                                                                //To update vetting log 
                                                                let objhk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                objhk.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','0','0','" + vettingData.evpId + "','',2,'Vetting Apply Failed','" + combinedLog + "')";
                                                                objhk.prepare();
                                                                objhk.execute((vetting_error, vetting_success) => {
                                                                    console.log("Vetting log updated");
                                                                });
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ error: error, message: "Your Current Balance is Low From $" + price + "!", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                    });
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ error: error, message: "Brand Does Not Exist!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /****************************************************************
    * Enhanced Vetting Report Download API, it will be hit from PHP *
    ****************************************************************/
    enhancedVettingReportDownload(req, res, next) {
        if (req.headers.authorization == 'Basic ' + authKey) {
            let sdata = req.body;
            let brandId = sdata.brandId;
            if (brandId[0] == 'B' && sdata.evpId && sdata.vettingId && sdata.vettingClass) {
                let Obj = new RawQuery_1.ModelRawQuery(req, res);
                Obj.qrysql = "SELECT iduser, idaccount, brandId, vettingId, evpId, vettingClass FROM `brand_vetting` WHERE `evpId`='" + sdata.evpId + "' AND `vettingId`='" + sdata.vettingId + "' AND `brandId`='" + brandId + "' AND `vettingClass`='" + sdata.vettingClass + "'";
                Obj.prepare();
                Obj.execute((Err, Res) => {
                    if (Err == 1) {
                        if (Res.length > 0) {
                            var options = {
                                'method': 'GET',
                                'url': apiUrl + 'brand/' + brandId + '/externalVetting/enhancedVettingReport',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                }
                            };
                            (0, axios_1.request)(options, function (error, response) {
                                if (!error) {
                                    try {
                                        let resp = JSON.parse(response.body);
                                        if (resp[0].uuid) {
                                            let uuid = resp[0].uuid.replace(/\//g, '%2F');
                                            var options1 = {
                                                'method': 'GET',
                                                'url': apiUrl + 'attachment/' + uuid,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            (0, axios_1.request)(options1, function (error1, response1) {
                                                if (!error1) {
                                                    try {
                                                        const index = response1.body.indexOf('%PDF');
                                                        if (index !== -1) {
                                                            let fName = 'evr-' + Date.now() + '-' + resp[0].fileName, filePath = appealEvidence.fileEnhanced + fName, fileUpload = appealDir.ENHANCEDUPLOADS + '/' + fName;
                                                            fs.writeFile(fileUpload, response1.body, 'binary', (err) => {
                                                                if (!err) {
                                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj.nonqrysql = "UPDATE `brand_vetting` SET `uuid`= '" + resp[0].uuid + "',`mimeType`='" + resp[0].mimeType + "',`fileName`='" + resp[0].fileName + "', `filepath`='" + filePath + "'  WHERE `iduser`=" + Res[0].iduser + " AND `brandId`='" + brandId + "' AND `evpId`='" + Res[0].evpId + "' AND `vettingId`='" + Res[0].vettingId + "' AND `vettingClass`='" + Res[0].vettingClass + "'";
                                                                    obj.prepare();
                                                                    obj.execute((_err, result) => {
                                                                        if (_err == 1) {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "File inserted successfully!", status: 200 });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong With Update!", status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With File Writing", status: 403 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            if (response1.body == "Credentials are required to access this resource.") {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Request Format is wrong!", status: 503 });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let resp1 = JSON.parse(response1.body);
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: resp1[0].description, status: resp1[0].code });
                                                                objv.execute();
                                                            }
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: enhancedVettingReportDownload ::", e);
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Attachment API!", status: 506 });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Report!", status: 504 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: resp[0].code, message: resp[0].description });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: enhancedVettingReportDownload ::", e);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Enhanced Vetting API!", status: 507 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Report!!", status: 505 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Data Not Found!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went wrong with data founding!", status: 508 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something is Missing from brandId, evpId, vettingId or vettingClass!", status: 506 });
                objv.execute();
            }
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ message: "Invalid Authorization!", status: 401 });
            objv.execute();
        }
    }
    /*****************
    * Import Vetting *
    *****************/
    importVetting(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let vettingData = req.body;
                        let vettingData1 = req.query;
                        let brandId = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
                        rate.checkcharValid(brandId, 502, 'BrandId', (err2, msg2) => {
                            if (err2 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(msg2);
                                objv.execute();
                            }
                            else {
                                let Obj = new RawQuery_1.ModelRawQuery(req, res);
                                Obj.qrysql = "SELECT evpId FROM `brand_vetting` WHERE `evpId`='" + vettingData.evpId + "' AND `vettingId`='" + vettingData.vettingId + "' AND `idaccount`=" + sessdata.idaccount + " ";
                                Obj.prepare();
                                Obj.execute((VErr, VRes) => {
                                    let options = {
                                        'method': 'PUT',
                                        'url': apiUrl + 'brand/' + brandId + '/externalVetting/',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + authKey
                                        },
                                        body: JSON.stringify({
                                            "evpId": vettingData.evpId,
                                            "vettingId": vettingData.vettingId,
                                            "vettingToken": vettingData.vettingToken
                                        })
                                    };
                                    (0, axios_1.request)(options, (error, response, body) => {
                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                        if (!error) {
                                            try {
                                                let resData = JSON.parse(response.body);
                                                if (resData.vettingId && resData.vettingId !== undefined) {
                                                    let qry = '';
                                                    if (VRes.length > 0) {
                                                        qry = "UPDATE `brand_vetting` SET `evpId`='" + resData.evpId + "',`vettingToken`='" + resData.vettingToken + "', `vettingScore`=" + (0, markError_1.setToZero)(resData.vettingScore) + ",`vettingClass`='" + resData.vettingClass + "',`vettingStatus`='" + resData.vettingStatus + "',`reasons`='" + (0, markError_1.parseBody)(JSON.stringify(resData.reasons)) + "',`type`='importVetting',`vettingDetails`='" + JSON.stringify(resData.vettingDetails) + "',`vettedDate`='" + resData.vettedDate + "',`createdDate`='" + resData.createDate + "' WHERE `idaccount`= " + sessdata.idaccount + "  AND `brandId`='" + brandId + "' AND `vettingId`='" + vettingData.vettingId + "'";
                                                    }
                                                    else {
                                                        qry = "INSERT INTO `brand_vetting` (`idaccount`, `iduser`, `brandId`,`type`, `evpId`, `vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + brandId + "', 'importVetting', '" + resData.evpId + "', '" + resData.vettingId + "','" + resData.vettingToken + "'," + (0, markError_1.setToZero)(resData.vettingScore) + ",'" + resData.vettingClass + "','" + resData.vettingStatus + "','" + (0, markError_1.parseBody)(JSON.stringify(resData.reasons)) + "','" + (0, markError_1.parseBody)(JSON.stringify(resData.vettingDetails)) + "','" + resData.vettedDate + "','" + resData.createDate + "')";
                                                    }
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = qry;
                                                    obj.prepare();
                                                    obj.execute((___error, resp) => {
                                                        if (___error == 1) {
                                                            //To update vetting log 
                                                            let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','0','0','" + resData.evpId + "','" + resData.vettingId + "',5,'Vetting Import','" + combinedLog + "')";
                                                            objh.prepare();
                                                            objh.execute((vetting_error, vetting_success) => {
                                                                console.log("Vetting log updated");
                                                            });
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Vetting Imported Successfully!", data: resData, status: 200 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            //To update vetting log 
                                                            let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','0','0','" + resData.evpId + "','" + resData.vettingId + "',6,'Vetting Import Failed','" + combinedLog + "')";
                                                            objh.prepare();
                                                            objh.execute((vetting_error, vetting_success) => {
                                                                console.log("Vetting log updated");
                                                            });
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Vetting Not Inserted", status: 501 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    //To update vetting log 
                                                    let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','0','0','" + resData.evpId + "','" + resData.vettingId + "',6,'Vetting Import Failed','" + combinedLog + "')";
                                                    objh.prepare();
                                                    objh.execute((vetting_error, vetting_success) => {
                                                        console.log("Vetting log updated");
                                                    });
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: resData[0].code, message: resData[0].fields + ' ' + resData[0].description });
                                                    objv.execute();
                                                }
                                            }
                                            catch (e) {
                                                console.log("Error :: importVetting ::", e);
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                        }
                                        else {
                                            //To update vetting log 
                                            let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','0','0','','',6,'Vetting Import Failed','" + combinedLog + "')";
                                            objh.prepare();
                                            objh.execute((vetting_error, vetting_success) => {
                                                console.log("Vetting log updated");
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*****************************************************************
    * Get Single External Vetting List By Brand Id And Status Update *
    *****************************************************************/
    externalVettingList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let vettingData = req.query;
                        let condition = "";
                        // To Check Brand Exist Or Not
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + vettingData.brandId + "' AND `idaccount` = " + sessdata.idaccount + " ";
                        obj.prepare();
                        obj.execute((errBrand, resultBrand) => {
                            if (errBrand == 1 && resultBrand.length > 0) {
                                // To Get Brand Vetting List
                                if (vettingData.evpId !== '' && vettingData.evpId !== undefined) {
                                    condition += " AND `evpId`='" + vettingData.evpId + "'";
                                }
                                if (vettingData.vettingClass !== '' && vettingData.vettingClass !== undefined) {
                                    condition += " AND `vettingClass`='" + vettingData.vettingClass + "'";
                                }
                                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                obj0.qrysql = "SELECT `validUntil`, `evpId`,`vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate` FROM `brand_vetting` WHERE brandId='" + vettingData.brandId + "' AND  `vettingStatus` = '" + vettingData.vettingStatus + "' " + condition + "";
                                obj0.prepare();
                                obj0.execute((errBV, resultBV) => {
                                    if (errBV == 1) {
                                        if (resultBV.length > 0) {
                                            // To Show Brand Vetting Response
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 200, message: "Record Fetched Successfully!", data: resultBV });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 404, message: "No Record Found!" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 503, message: "Something went wrong with External Vetting list" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*******************************************************************
    * Get Multiple External Vetting List By Brand Id And Status Update *
    *******************************************************************/
    externalVettingBulkUpdate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = JSON.parse(req.body.data);
                let brandId = data.brandId;
                let idaccount = sessdata.type == 1 ? data.idaccount : sessdata.idaccount;
                // To Check Brand Exist Or Not
                if (brandId) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + brandId + "' AND `idaccount` = " + idaccount + " ";
                    obj.prepare();
                    obj.execute((errBrand, resultBrand) => {
                        if (errBrand == 1 && resultBrand.length > 0) {
                            // To Get All Vetting Detail By Brand
                            let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                            obj00.qrysql = "SELECT vettingStatus,brandId,vettingClass,evpId,paid_time FROM `brand_vetting` WHERE brandId='" + brandId + "' AND `idaccount` = " + idaccount + " ";
                            obj00.prepare();
                            obj00.execute((errAll, resultAll) => {
                                if (errAll == 1 && resultAll.length > 0) {
                                    resultAll.forEach((ele) => {
                                        // To Get Brand Vetting List
                                        let options = {
                                            'method': 'GET',
                                            'url': apiUrl + 'brand/' + ele.brandId + '/externalVetting',
                                            'headers': {
                                                'Content-Type': 'application/json',
                                                'Authorization': 'Basic ' + authKey
                                            },
                                        };
                                        (0, axios_1.request)(options, (error, response) => {
                                            if (!error) {
                                                try {
                                                    let resData = JSON.parse(response.body);
                                                    if (resData.length == 0) {
                                                        console.log({ message: "No Record Found!", status: 502 });
                                                        /* let objv = new RawView(res);
                                                        objv.prepare({ message: "No Record Found!", status: 502 });
                                                        objv.execute(); */
                                                    }
                                                    else if (resData[0].code && resData[0].code !== undefined && resData.length > 0) {
                                                        console.log({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                        /* let objv = new RawView(res);
                                                        objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                        objv.execute(); */
                                                    }
                                                    else {
                                                        resData.forEach((element) => {
                                                            // To Update Brand Vetting with Price Deduction
                                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj0.nonqrysql = "UPDATE `brand_vetting` SET `evpId`='" + element.evpId + "', `vettingId`='" + element.vettingId + "',`vettingToken`='" + element.vettingToken + "',`vettingScore`=" + (0, markError_1.setToZero)(element.vettingScore) + ",`vettingClass`='" + element.vettingClass + "',`vettingStatus`='" + element.vettingStatus + "',`reasons`='" + (0, markError_1.parseBody)(JSON.stringify(element.reasons)) + "',`vettingDetails`='" + (0, markError_1.parseBody)(JSON.stringify(element.vettingDetails)) + "',`vettedDate`='" + element.vettedDate + "',`createdDate`='" + element.createDate + "' WHERE `vettingId` = '" + element.vettingId + "' AND `idaccount`=" + idaccount + " ";
                                                            obj0.prepare();
                                                            obj0.execute((___error, resp) => { });
                                                        });
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error :: externalVettingBulkUpdate ::", e);
                                                    // let obj = new RawView(res);
                                                    // obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    // obj.execute();
                                                }
                                            }
                                            else {
                                                console.log({ status: 503, message: "Something went wrong with external vetting" });
                                            }
                                        });
                                    });
                                    // To Show Brand Vetting Response
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Record Updated!", data: resultAll });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "No Record Found!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Brand ID Not Found!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /***************
    * Revet Brand  *
    ***************/
    revetBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let reqQry = req.query;
                        let rateS = 4.50;
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        rate.checkcharValid(reqQry.brandId, 500, 'BrandId', (err2, msg2) => {
                            if (err2 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(msg2);
                                objv.execute();
                            }
                            else {
                                rate.checkBalance(req, res, sessdata.idaccount, rateS, (crErr, crRes) => {
                                    if (crErr == 1) {
                                        let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                        Obj0.qrysql = "SELECT identityStatus,brandId,entityType FROM `brand` WHERE `brandId`='" + reqQry.brandId + "' AND `deleted`=0";
                                        Obj0.prepare();
                                        Obj0.execute((_err, resStatus) => {
                                            if (resStatus.length > 0) {
                                                if (resStatus[0].entityType == 'PFT_BRAND') {
                                                    let cmp = new NewCampaign();
                                                    cmp.pftrevetBrand(req, res, resStatus, next);
                                                }
                                                else {
                                                    let options = {
                                                        'method': 'PUT',
                                                        'url': apiUrl + 'brand/' + reqQry.brandId + '/revet',
                                                        'headers': {
                                                            'Content-Type': 'application/json',
                                                            'Authorization': 'Basic ' + authKey
                                                        },
                                                    };
                                                    (0, axios_1.request)(options, (error, response, body) => {
                                                        if (!error) {
                                                            try {
                                                                let escapedLog = JSON.stringify([response.body, datasess]);
                                                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                                if (response.body) {
                                                                    let resultData = JSON.parse(response.body);
                                                                    if (resStatus[0].identityStatus == "UNVERIFIED" && resultData.identityStatus == "UNVERIFIED") {
                                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='" + resultData.identityStatus + "' WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`='" + reqQry.brandId + "' AND `deleted`=0";
                                                                        obj.prepare();
                                                                        obj.execute((___error, resp) => {
                                                                            if (___error == 1) {
                                                                                let payload = {
                                                                                    idaccount: sessdata.idaccount,
                                                                                    amount: rateS,
                                                                                    purpose: 'Resubmit Brand',
                                                                                    type: '-'
                                                                                };
                                                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                    console.log("revetBrand => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                                });
                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "','" + rateS + "','" + Date.now() + "',7, 'Brand Re-Submitted','" + combinedLog + "')";
                                                                                obj3.prepare();
                                                                                obj3.execute((log_error, _resp) => {
                                                                                    if (log_error == 1) {
                                                                                        console.log("Brand Log Updated.");
                                                                                    }
                                                                                    else {
                                                                                        console.log("Brand Log Not Updated.");
                                                                                    }
                                                                                });
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "Brand Revet Successfully.", data: resStatus.identityStatus, status: 200 });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "',0, '" + Date.now() + "',8, 'Brand Re-Submit Failed','" + combinedLog + "')";
                                                                                obj3.prepare();
                                                                                obj3.execute((log_error, _resp) => {
                                                                                    if (log_error == 1) {
                                                                                        console.log("Brand Log Updated.");
                                                                                    }
                                                                                    else {
                                                                                        console.log("Brand Log Not Updated.");
                                                                                    }
                                                                                });
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "Something Went Wrong With Brand Revet!", status: 502 });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "',0, '" + Date.now() + "',8, 'Brand Re-Submit Failed','" + combinedLog + "')";
                                                                        obj3.prepare();
                                                                        obj3.execute((log_error, _resp) => {
                                                                            if (log_error == 1) {
                                                                                console.log("Brand Log Updated.");
                                                                            }
                                                                            else {
                                                                                console.log("Brand Log Not Updated.");
                                                                            }
                                                                        });
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ message: resultData[0].description, data: resStatus.identityStatus, status: 502 });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: resStatus[0].field + ' ' + resStatus[0].description,
                                                                        status: resStatus[0].code
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            }
                                                            catch (e) {
                                                                console.log("Error :: revetBrand ::", e);
                                                                let obj = new RawView_1.RawView(res);
                                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                obj.execute();
                                                            }
                                                        }
                                                        else {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                            obj.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Brand Expired!", status: 503 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    pftrevetBrand(req, res, revtdata, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let reqQry = req.query;
                let rateS = 4.50;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let escapedLog = JSON.stringify([datasess]);
                let combinedLog = escapedLog.replace(/'/g, "\\'");
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='VERIFIED' WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`='" + reqQry.brandId + "' AND `deleted`=0";
                obj.prepare();
                obj.execute((___error, resp) => {
                    if (___error == 1) {
                        let payload = {
                            idaccount: sessdata.idaccount,
                            amount: rateS,
                            purpose: 'Resubmit Brand',
                            type: '-'
                        };
                        rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                            console.log("revetBrand => walletDeduction Wallet deduction response:", errorD, dataD);
                        });
                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "','" + rateS + "','" + Date.now() + "',7, 'Brand Re-Submitted','" + combinedLog + "')";
                        obj3.prepare();
                        obj3.execute((log_error, _resp) => {
                            if (log_error == 1) {
                                console.log("Brand Log Updated.");
                            }
                            else {
                                console.log("Brand Log Not Updated.");
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Brand Revet Successfully.", data: revtdata[0].identityStatus, status: 200 });
                        objv.execute();
                    }
                    else {
                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "',0, '" + Date.now() + "',8, 'Brand Re-Submit Failed','" + combinedLog + "')";
                        obj3.prepare();
                        obj3.execute((log_error, _resp) => {
                            if (log_error == 1) {
                                console.log("Brand Log Updated.");
                            }
                            else {
                                console.log("Brand Log Not Updated.");
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Brand Revet!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /****************************************
    * Get campaing's DID limit and counting *
    ****************************************/
    getCampaignDIDCount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let camp_key = sdata.type;
                let idaccount = sdata.filter;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT did_limit, did_count FROM `campaign` WHERE campaign_key='" + camp_key + "' AND idaccount=" + idaccount + " GROUP BY `campaign_key`";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'DID Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /*********************
    * Get campaing's DID *
    **********************/
    getCampaignDID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // let sdata = req.query;
                let sdata = req.query;
                let camp_key = sdata.type;
                let filter = (sdata && typeof sdata.filter === 'string' && sdata.filter.trim() !== '') ? sdata.filter : '';
                let idaccount;
                let message = "";
                switch (true) {
                    case !camp_key:
                        message = "'type' (campaign_key) is required!";
                        break;
                    case !/^C[A-Z0-9]{6}$/.test(camp_key):
                        message = "Invalid 'type' (campaign_key). Must start with 'C' followed by 6 uppercase letters or digits!";
                        break;
                    case sessData.type == 1 && !filter:
                        message = "'filter' (account_id) is required for admin!";
                        break;
                    case sessData.type == 1 && !!filter:
                        idaccount = filter;
                        break;
                    default:
                        idaccount = sessData.idaccount;
                        break;
                }
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message, status: 502 });
                    objv.execute();
                }
                else {
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `master_iduser`,`slave_iduser` FROM `customer_group_mapping` where `slave_idaccount` = '" + idaccount + "'";
                    obj0.prepare();
                    obj0.execute((err0, result0) => {
                        if (result0.length > 0) {
                            let masterIDUser = [];
                            result0.forEach((row) => {
                                masterIDUser.push(row.master_iduser);
                            });
                            let masterIds = result0.map((row) => row.master_iduser);
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = `SELECT did_buy.did FROM did_buy WHERE (did_buy.account_id = ${idaccount} OR did_buy.iduser IN (${masterIds.join(',')})) AND did_buy.camp_registry = '${camp_key}' AND did_buy.disconnect_did_status = '1' AND did_buy.osr_status = 'register' AND did_buy.sinch_status = '1' GROUP BY did_buy.did`;
                            obj.prepare();
                            obj.execute((err, result) => {
                                if (err == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: 'DID Fetched Successfully!', data: result, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 501 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong with Campaign DIDs", data: [], status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = `SELECT did_buy.did FROM did_buy WHERE did_buy.account_id = ${idaccount} AND did_buy.camp_registry = '${camp_key}' AND did_buy.disconnect_did_status = '1' AND did_buy.osr_status = 'register' AND did_buy.sinch_status = '1' GROUP BY did_buy.did`;
                            obj.prepare();
                            obj.execute((err, result) => {
                                if (err == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: 'DID Fetched Successfully!', data: result, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 501 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong with Campaign DIDs", data: [], status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /****************
    * Update CSP ID *
    ****************/
    updateCSPID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                let sdata = req.body;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `account` SET `csp_id`= '" + sdata.csp_id + "' WHERE idaccount= " + sessdata.idaccount + " ";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "CSP ID Updated Successfully", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    /****************
    * Get CSP ID *
    ****************/
    getCspId(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `csp_id` FROM `account` WHERE idaccount=" + sessData.idaccount + " ";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'CSP ID Fatched', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /************************
    * CNP Campaigns Filters *
    ************************/
    CNPcampaignFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = "", ext_field, orderby = 'c.`start_date` DESC';
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== '' && data.idaccount !== null ? " AND c.`idaccount`='" + data.idaccount + "'" : '';
                    ext_field = 'c.idaccount,c.id_campaign, c.camp_reseller_unique_id, ';
                }
                // if (sessdata.type == 1) {
                //     conditionU += data.idaccount !== '' && data.idaccount !== null ? " AND c.`idaccount`=" + data.idaccount + " " : '';
                // }
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    conditionU += " AND c.`idaccount`=" + sessdata.idaccount + " ";
                if (sessdata.type == 22)
                    conditionU += " AND c.`iduser`= " + sessdata.iduser + " ";
                if (data.brandId)
                    condition += 'b.`brandId` LIKE "%' + (0, markError_1.parseBody)(data.brandId) + '%" AND ';
                if (data.brand_name)
                    condition += 'b.`brand_name` LIKE "%' + (0, markError_1.parseBody)(data.brand_name) + '%" AND ';
                if (data.campaign_key)
                    condition += 'c.`campaign_key` LIKE "%' + (0, markError_1.parseBody)(data.campaign_key) + '%" AND ';
                if (data.usecase)
                    condition += 'c.`usecase`="' + data.usecase + '" AND ';
                if (data.shorting == "created_asc")
                    orderby = 'c.`start_date` ASC';
                if (data.shorting == "created_desc")
                    orderby = 'c.`start_date` DESC';
                if (data.shorting == "updated_asc")
                    orderby = 'c.`updated_at` ASC';
                if (data.shorting == "updated_desc")
                    orderby = 'c.`updated_at` DESC';
                if (data.sm_reference_no)
                    condition += '`sm_reference_no` LIKE "%' + (0, markError_1.parseBody)(data.sm_reference_no) + '%" AND ';
                if (data.tcrStatus == 'Both' || data.tcrStatus == null || data.tcrStatus == '') {
                    condition += 'c.`deleted` IN (0, 1) AND';
                }
                else if (data.tcrStatus == '0' || data.tcrStatus == '1') {
                    condition += 'c.`deleted`="' + data.tcrStatus + '" AND ';
                }
                if (data.filter_type == "All")
                    condition += '';
                if (data.filter_type == "DCA Submission")
                    condition += 'c.`provisioning_status`="0" AND ';
                if (data.filter_type == "DCA Shared")
                    condition += 'c.`provisioning_status`="1" AND ';
                if (data.filter_type == "Campaign Provisioned")
                    condition += 'c.`provisioning_status`="3" AND ';
                if (data.filter_type == "Provisioning Failed")
                    condition += 'c.`provisioning_status`="4" AND ';
                if (data.filter_type == "Customer Action Required")
                    condition += 'c.`provisioning_status`="5" AND ';
                if (data.filter_type == "Pending for Profile Approval")
                    condition += 'c.`provisioning_status`="7" AND ';
                if (data.provisioning_status == "1")
                    condition += 'c.`provisioning_status`="1" AND ';
                if (data.provisioning_status == "2")
                    condition += 'c.`provisioning_status`="2" AND ';
                if (data.provisioning_status == "3")
                    condition += 'c.`provisioning_status`="3" AND ';
                if (data.provisioning_status == "4")
                    condition += 'c.`provisioning_status`="4" AND ';
                if (data.provisioning_status == "5")
                    condition += 'c.`provisioning_status`="5" AND ';
                if (data.provisioning_status == "0")
                    condition += 'c.`provisioning_status`="0" AND ';
                if (data.provisioning_status == "7")
                    condition += 'c.`provisioning_status`="7" AND ';
                if (!data.provisioning_status || data.filter_type == "All")
                    condition += '';
                obj.qrysql = "SELECT b.entityType, b.brandId, b.brand_name," + ext_field + " c.sm_reference_no,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.provisioning_status,c.did_count,c.did_limit,c.`status`,c.deleted, c.updated_at,c.parent_campaign_id,c.upstreamCnpId,c.parent_sm_reference_no FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + " c.`status`= 1 " + conditionU + " GROUP BY c.`campaign_key` ORDER BY " + orderby + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Campaign List Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched CNP Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    rejectFormByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let message = "";
                        switch (true) {
                            case (!data || !('data' in req.body)):
                                message = "Missing request body";
                                break;
                            case (!data?.campId || ["", "null", "undefined"].includes(data.campId)):
                                message = "campId is required";
                                break;
                            case (!data?.iduser || ["", "null", "undefined"].includes(data.iduser) || !/^[1-9]\d*$/.test(data.iduser)):
                                message = "Iduser is required";
                                break;
                            case (!data?.idaccount || ["", "null", "undefined"].includes(data.idaccount) || !/^[1-9]\d*$/.test(data.idaccount)):
                                message = "Idaccount is required";
                                break;
                            case (!/^SM[A-Z0-9]{5}$/.test(data.campId)):
                                message = "campId must be exactly 7 characters long and start with 'SM'!";
                                break;
                            case (!data?.desc_details):
                                message = "Reject reason is required";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                        }
                        else {
                            if (data.desc_details && /^\s/.test(data.desc_details)) {
                                data.desc_details = data.desc_details.trimLeft();
                            }
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessdata.iduser,
                                idaccount: sessdata.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                            Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `sm_reference_no`='" + data.campId + "' AND `deleted` = 0 ";
                            Obj00.prepare();
                            Obj00.execute((_Err, campRes) => {
                                if (_Err == 1 && campRes.length > 0) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`sm_reference_no`,`event_type`,`webhook_event_type`,`description`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',29,'CAMPAIGN_REJECTED_BY_ADMIN','Campaign Rejected By Admin','" + (0, markError_1.parseBody)(data.desc_details) + "',3,'" + JSON.stringify(datasess) + "')";
                                    obj.prepare();
                                    obj.execute((_error, result) => {
                                        if (_error == 1) {
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5', `updated_at`=NOW() WHERE `sm_reference_no`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                            obj1.prepare();
                                            obj1.execute((___error, UpRes) => {
                                                let fun = new NewCampaign();
                                                fun.sendMailForRejectMail(req, res, data, next);
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong!",
                                                status: 502,
                                                error: result
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Campaign Expired" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    rejectPFTbyadmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let message = "";
                        switch (true) {
                            case (!data || !('data' in req.body)):
                                message = "Missing request body";
                                break;
                            case (!data?.campId || (0, markError_1.isMissing)(data.campId)):
                                message = "campId is required";
                                break;
                            case (!data?.iduser || ["", "null", "undefined"].includes(data.iduser) || !/^[1-9]\d*$/.test(data.iduser)):
                                message = "Iduser is required";
                                break;
                            case (!data?.idaccount || ["", "null", "undefined"].includes(data.idaccount) || !/^[1-9]\d*$/.test(data.idaccount)):
                                message = "Idaccount is required";
                                break;
                            case (!/^SM[A-Z0-9]{5}$/.test(data.campId)):
                                message = "campId must be exactly 7 characters long and start with 'SM'!";
                                break;
                            case (!data?.desc_details):
                                message = "Reject reason is required";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                        }
                        else {
                            if (data.desc_details && /^\s/.test(data.desc_details)) {
                                data.desc_details = data.desc_details.trimLeft();
                            }
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessdata.iduser,
                                idaccount: sessdata.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                            Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `sm_reference_no`='" + data.campId + "' AND `deleted` = 0 ";
                            Obj00.prepare();
                            Obj00.execute((_Err, campRes) => {
                                if (_Err == 1 && campRes.length > 0) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`sm_reference_no`,`event_type`,`webhook_event_type`,`description`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',29,'CAMPAIGN_REJECTED_BY_ADMIN','Campaign Rejected By Admin','" + (0, markError_1.parseBody)(data.desc_details) + "',3,'" + JSON.stringify(datasess) + "')";
                                    obj.prepare();
                                    obj.execute((_error, result) => {
                                        if (_error == 1) {
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5', `updated_at`=NOW() WHERE `sm_reference_no`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                            obj1.prepare();
                                            obj1.execute((___error, UpRes) => {
                                                let fun = new NewCampaign();
                                                fun.sendMailForRejectMail(req, res, data, next);
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong!",
                                                status: 502,
                                                error: result
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Campaign Expired" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    failedFormByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0 ";
                Obj00.prepare();
                Obj00.execute((_Err, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',30,'Admin Reject After Failed','ADMIN_REJECT_AFTER_FAILED','" + (0, markError_1.parseBody)(data.desc_details) + "',3,'" + JSON.stringify(datasess) + "')";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5', `updated_at`=NOW() WHERE `campaign_key`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                obj1.prepare();
                                obj1.execute((___error, UpRes) => {
                                    let fun = new NewCampaign();
                                    fun.sendMailForFailedMail(req, res, data, next);
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    RequestEdit(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0";
                Obj00.prepare();
                Obj00.execute((_Err, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,webhook_description_detail,`description`, webhook_event_type, event_type,`request_type`,`webhook_full_log`) VALUES (" + data.idaccount + ", " + data.iduser + ", " + data.campaign_key + ", '" + (0, markError_1.parseBody)(data.description) + "','Admin Reject CNP Campaign','ADMIN_REJECT_CNP_CAMPAIGN',31,3,'" + JSON.stringify(datasess) + "')";
                        obj0.prepare();
                        obj0.execute((error, result) => {
                            if (error == 1) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5', `updated_at`=NOW() WHERE `idaccount`=" + data.idaccount + " AND `campaign_key`='" + data.campaign_key + "'";
                                obj1.prepare();
                                obj1.execute((_error, result) => {
                                    let fun = new NewCampaign();
                                    fun.sendMailForRejectMail(req, res, data, next);
                                });
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    failedCnpFormByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let condition = "";
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                        Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0";
                        Obj00.prepare();
                        Obj00.execute((_Err, campRes) => {
                            if (_Err == 1 && campRes.length > 0) {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',32,'Admin Reject CNP Campaign After Failed','ADMIN_REJECT_CNP_CAMPAIGN_AFTER_FAILED','" + (0, markError_1.parseBody)(data.desc_details) + "',3,'" + JSON.stringify(datasess) + "')";
                                obj.prepare();
                                obj.execute((_error, result) => {
                                    if (_error == 1) {
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5', `updated_at`=NOW() WHERE `campaign_key`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                        obj1.prepare();
                                        obj1.execute((___error, UpRes) => {
                                            let fun = new NewCampaign();
                                            fun.sendMailForFailedMail(req, res, data, next);
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Something Went Wrong!",
                                            status: 501,
                                            error: _error
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Campaign Expired" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    rejectCNPadmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let description = (0, markError_1.parseBody)(data.desc_details);
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: data.iduser,
                            idaccount: data.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let options = {
                            'method': 'DELETE',
                            'url': apiUrl + 'partnerCampaign/' + data.campId + '/sharing?explanation=' + description,
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        console.log("rejectCNPadmin request :: ", options);
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    let data1 = JSON.parse(response.body);
                                    if (data1.downstreamCnpId != undefined && data1.downstreamCnpId) {
                                        console.log("rejectCNPadmin response :: ", data1);
                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                        let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                                        Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0";
                                        Obj00.prepare();
                                        Obj00.execute((_Err, campRes) => {
                                            if (_Err == 1 && campRes.length > 0) {
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,webhook_description_detail,`description`, webhook_event_type, event_type,`request_type`,`webhook_full_log`) VALUES (" + data.idaccount + ", " + data.iduser + ", '" + data.campId + "', '" + (0, markError_1.parseBody)(data.desc_details) + "','Admin Reject CNP Campaign','ADMIN_REJECT_CNP_CAMPAIGN',31,3,'" + combinedLog + "')";
                                                obj.prepare();
                                                obj.execute((_error, result) => {
                                                    if (_error == 1) {
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "UPDATE `campaign` SET `downstreamCnpId`='" + data1.downstreamCnpId + "',`sharingStatus`='" + data1.sharingStatus + "',`provisioning_status`='5', `updated_at`=NOW() WHERE `idaccount`=" + data.idaccount + " AND `campaign_key`='" + data.campId + "'";
                                                        obj1.prepare();
                                                        obj1.execute((___error, UpRes) => {
                                                            let fun = new NewCampaign();
                                                            fun.sendMailForFailedMail(req, res, data, next);
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: "Something Went Wrong CNP Campaign Rejected!",
                                                            status: 502,
                                                            error: _error
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 501, message: "Campaign Expired" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: data1[0].code, message: data1[0].description });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: rejectCNPadmin ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 501, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something Went Wrong rejectCNPadmin request!", error: error });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    sendMailForRejectMail(req, res, data, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                if (data.iduser !== '' && data.iduser !== 'null' && data.iduser !== 'undefined') {
                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT firstname,lastname,email FROM `user_profile` WHERE iduser = " + data.iduser + " ";
                    obj2.prepare();
                    obj2.execute((_err, customerDetail) => {
                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                        obj3.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='Admin_reject_campaign'";
                        obj3.prepare();
                        obj3.execute((emlErr, emlRes) => {
                            if (emlErr == 1) {
                                if (emlRes.length > 0) {
                                    let tmpData = emlRes[0].template;
                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, customerDetail[0].firstname);
                                    tmpData = tmpData.replace(/{LAST_NAME}/g, customerDetail[0].lastname);
                                    tmpData = tmpData.replace(/{CAMPAIGN_KEY}/g, data.campId);
                                    // var smtpTransport = nodemailer.createTransport({
                                    //     service: "gmail",
                                    //     host: "smtp.gmail.com",
                                    //     port: 587,
                                    //     secure: true,
                                    //     auth: {
                                    //         user: "mailto:donotreply@nglcommunications.com",
                                    //         pass: "yr%5V9GB"
                                    //     }
                                    // });
                                    // var mailOptions = {
                                    //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                    //     to: customerDetail[0].email,
                                    //     email: customerDetail[0].email,
                                    //     subject: `${emlRes[0].subject}`,
                                    //     text: "Campaign Rejected",
                                    //     html: `${tmpData}`
                                    // }
                                    // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                    //     if (_emailError) {
                                    //         console.log("Mail Not Sent Successfully!");
                                    //     } else {
                                    //         console.log("Mail Sent Successfully!");
                                    //     }
                                    // });
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES (" + data.iduser + "," + data.idaccount + ",'" + FromEmail + "','" + customerDetail[0].email + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Campaign Rejected','Mail Send for Campaign Rejected',14,'" + (0, markError_1.parseBody)(tmpData) + "')";
                                    obj1.prepare();
                                    obj1.execute((_emailError, emailRes) => {
                                        if (_emailError == 1) {
                                            console.log("Mail Sent Successfully!");
                                        }
                                        else {
                                            console.log("Mail Not Sent Successfully!");
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 401, errMessage: "Template Data Not Found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                objv.execute();
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "Campaign Rejected Successfully" });
                        objv.execute();
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ errMessage: "Iduser Not Found!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    sendMailForFailedMail(req, res, data, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((__error, sessdata) => {
            if (__error == 1) {
                if (data.iduser !== '' && data.iduser !== 'null' && data.iduser !== 'undefined') {
                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT firstname,lastname,email FROM `user_profile` WHERE iduser = " + data.iduser + " ";
                    obj2.prepare();
                    obj2.execute((_err, customerDetail) => {
                        if (data.mailCheck) {
                            let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                            obj3.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='Admin_reject_after_failed'";
                            obj3.prepare();
                            obj3.execute((emlErr, emlRes) => {
                                if (emlErr == 1) {
                                    if (emlRes.length > 0) {
                                        let tmpData = emlRes[0].template;
                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, customerDetail[0].firstname);
                                        tmpData = tmpData.replace(/{LAST_NAME}/g, customerDetail[0].lastname);
                                        tmpData = tmpData.replace(/{CAMPAIGN_KEY}/g, data.campId);
                                        // var smtpTransport = nodemailer.createTransport({
                                        //     service: "gmail",
                                        //     host: "smtp.gmail.com",
                                        //     port: 587,
                                        //     secure: true,
                                        //     auth: {
                                        //         user: "mailto:donotreply@nglcommunications.com",
                                        //         pass: "yr%5V9GB"
                                        //     }
                                        // });
                                        // var mailOptions = {
                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                        //     to: customerDetail[0].email,
                                        //     email: customerDetail[0].email,
                                        //     subject: `${emlRes[0].subject}`,
                                        //     text: "Campaign Rejected",
                                        //     html: `${tmpData}`
                                        // }
                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                        //     if (_emailError) {
                                        //         let objv = new RawView(res);
                                        //         objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                        //         objv.execute();
                                        //     } else {
                                        //         let objv = new RawView(res);
                                        //         objv.prepare({ iduser: data.iduser, status: 201, data: emailRes, message: "Campaign Rejected Succesfully!" });
                                        //         objv.execute();
                                        //     }
                                        // });
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES (" + data.iduser + "," + data.idaccount + ",'" + FromEmail + "','" + customerDetail[0].email + "', '" + emlRes[0].subject + "','Campaign Rejected','Admin Campaign Reject After Failed',15,'" + (0, markError_1.parseBody)(tmpData) + "')";
                                        obj1.prepare();
                                        obj1.execute((_emailError, emailRes) => {
                                            if (_emailError == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ iduser: data.iduser, status: 201, data: emailRes, message: "Campaign Rejected Succesfully!" });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 401, errMessage: "Template Data Not Found!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 201, message: "Campaign Rejected Successfully!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ errMessage: "Iduser Not Found!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    finalUpdateForCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            //let campid = req.body.data;
            if (error == 1) {
                let data = JSON.parse(req.body.data);
                let condition = "";
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='7', `updated_at`=NOW() WHERE `sm_reference_no`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                obj.prepare();
                obj.execute((___error, UpRes) => {
                    if (___error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Campaign Update Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong",
                            status: 502,
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // pft campaign start code
    updateCampaignExtension(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `campaign` SET `requestextension_status`='1', `updated_at`=NOW() WHERE (`campaign_key`='" + data + "' OR `sm_reference_no`='" + data + "') AND `iduser`=" + sessdata.iduser + " ";
                        obj.prepare();
                        obj.execute((error, UpRes) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Campaign Request Extension Apply Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong with Request Extension Apply",
                                    status: 502,
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    rejectExntededbyadmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.body.data;
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `campaign` SET `requestextension_status`='0', `updated_at`=NOW() WHERE (`campaign_key`='" + data.campId + "' OR `sm_reference_no`='" + data.campId + "') AND `iduser`=" + data.iduser + " ";
                        obj.prepare();
                        obj.execute((error, UpRes) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Campaign Request Extension Rejected!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong with Request Extension Rejected!",
                                    status: 502,
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    ExtensionCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        console.log(req.body, "request payload");
                        let data = req.body.data;
                        let createdAt = new Date(data.createdate); // original created date
                        let extensionDays = Number(data.extensiondays);
                        // STEP 1: Final date = createdAt + extensionDays
                        let finalDate = new Date(createdAt);
                        finalDate.setDate(finalDate.getDate() + extensionDays);
                        // STEP 2: Max allowed = createdAt + 485 days
                        let maxLimitDate = new Date(createdAt);
                        maxLimitDate.setDate(maxLimitDate.getDate() + 485);
                        // Remaining days user can extend
                        let remainingDays = Math.ceil((maxLimitDate.getTime() - createdAt.getTime()) /
                            (1000 * 60 * 60 * 24));
                        // STEP 3: If finalDate > max limit → return error
                        if (finalDate > maxLimitDate) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 422,
                                message: "Limit Exceeded. You can extend only for " + remainingDays + " days."
                            });
                            return objv.execute();
                        }
                        // Convert to yyyy-mm-dd
                        let finalDateISO = finalDate.toISOString().split("T")[0];
                        // STEP 4: DB Update
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `campaign` SET `requestextension_status` = 0, `extended_date` = '" + finalDateISO + "' WHERE (`campaign_key`='" + data.smkey + "' OR `sm_reference_no`='" + data.smkey + "') AND deleted='0'";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 201,
                                    message: "Campaign Extended Successfully!",
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Something Went Wrong!"
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({
                    status: 401,
                    message: "Unauthorized User!"
                });
                objv.execute();
            }
        });
    }
    // ended here 
    /********************
    * Get CNP Campaigns *
    ********************/
    getCNPCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let condition = '', ext_field;
                if (sessdata.type == 1) {
                    condition += '';
                    ext_field = 'c.id_campaign, c.camp_reseller_unique_id, ';
                }
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    condition += "AND c.`idaccount`=" + sessdata.idaccount + " ";
                }
                if (sessdata.type == 22) {
                    condition += "AND c.`iduser`=" + sessdata.iduser + " ";
                }
                ext_field += "c.iduser, c.idaccount, ";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId, b.brand_name,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + sessdata.iduser + "' AND c.`status`= 1 GROUP BY campaign_key";
                obj.qrysql = "SELECT b.entityType," + ext_field + " c.sm_reference_no,c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.provisioning_status,c.did_count,c.did_limit,c.`status`,c.deleted, c.updated_at,c.parent_campaign_id,c.upstreamCnpId,c.parent_sm_reference_no FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`status`= 1 " + condition + "  GROUP BY c.campaign_key ORDER BY c.`id_campaign` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /********************
    * Get PFT Campaigns *
    ********************/
    getPFTCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let condition = '', ext_field;
                if (sessdata.type == 1) {
                    condition += '';
                    ext_field = 'c.id_campaign, c.camp_reseller_unique_id, ';
                }
                ext_field += "c.iduser, c.idaccount, ";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT b.entityType," + ext_field + " c.sm_reference_no,c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.provisioning_status,c.did_count,c.did_limit,c.`status`,c.deleted, c.updated_at,c.parent_campaign_id,c.upstreamCnpId,c.parent_sm_reference_no,c.requestextension_status,c.extended_date FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`status`= 3 " + condition + " ORDER BY c.`id_campaign` DESC";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "PFT Campaign Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With PFT Campaign List!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    PFTcampaignFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = "", ext_field, orderby = 'c.`start_date` DESC';
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== '' && data.idaccount !== null ? " AND c.`idaccount`='" + data.idaccount + "'" : '';
                    ext_field = 'c.iduser,c.idaccount,c.id_campaign, c.camp_reseller_unique_id, ';
                }
                if (data.brandId)
                    condition += 'b.`brandId` LIKE "%' + (0, markError_1.parseBody)(data.brandId) + '%" AND ';
                if (data.brand_name)
                    condition += 'b.`brand_name`= "' + (0, markError_1.parseBody)(data.brand_name) + '" AND ';
                if (data.campaign_key)
                    condition += 'c.`campaign_key` LIKE "%' + (0, markError_1.parseBody)(data.campaign_key) + '%" AND ';
                if (data.sm_reference_no)
                    condition += '`sm_reference_no` LIKE "%' + (0, markError_1.parseBody)(data.sm_reference_no) + '%" AND ';
                if (data.tcrStatus == 'Both' || data.tcrStatus == null || data.tcrStatus == '') {
                    condition += 'c.`deleted` IN (0, 1) AND ';
                }
                else if (data.tcrStatus == '0' || data.tcrStatus == '1') {
                    condition += 'c.`deleted`="' + data.tcrStatus + '" AND ';
                }
                if (data.filter_type == "DCA Submission")
                    condition += 'c.`provisioning_status`="0" AND ';
                if (data.filter_type == "Campaign Provisioned")
                    condition += 'c.`provisioning_status`="3" AND ';
                if (data.filter_type == "Request Extension")
                    condition += 'c.`requestextension_status`="1" AND ';
                if (data.filter_type == "Customer Action Required")
                    condition += 'c.`provisioning_status`="5" AND ';
                if (data.filter_type == "Pending for Profile Approval")
                    condition += 'c.`provisioning_status`="7" AND ';
                obj.qrysql = "SELECT b.entityType," + ext_field + " c.sm_reference_no,c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.provisioning_status,c.did_count,c.did_limit,c.`status`,c.deleted, c.updated_at,c.parent_campaign_id,c.upstreamCnpId,c.parent_sm_reference_no,c.requestextension_status,c.extended_date FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + " c.`status`= 3 " + conditionU + "  ORDER BY " + orderby + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "PFT Campaign List Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetched PFT Campaign List!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    SaveRecepentNumber(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let campData = req.body;
                        let campId = req.query.campaignId;
                        let condition = '';
                        let message = '';
                        switch (true) {
                            case (!campData):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(campId)):
                                message = "Campaign Key/SM Reference No is required!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(campId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            case (campData.pftnumber.some((item) => item.length != 10)):
                                let wrong = campData.pftnumber.find((item) => item.length != 10);
                                message = wrong + " must be 10 digits";
                                break;
                            default:
                                message = '';
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `campaign_key`,`sm_reference_no` FROM `campaign` WHERE (`campaign_key`='" + campId + "' OR `sm_reference_no`= '" + campId + "') AND `status`='3' AND `deleted`='0'";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                if (result.length > 0) {
                                    let types = "";
                                    if (campId.startsWith("SM")) {
                                        types = "sm_reference_no";
                                    }
                                    else if (campId.startsWith("C")) {
                                        types = "campaign_id";
                                    }
                                    condition += "`" + types + "`='" + campId + "'";
                                    let objp = new RawQuery_1.ModelRawQuery(req, res);
                                    objp.qrysql = "SELECT `iduser`,`idaccount`,`pft_id`,`campaign_id`,`sm_reference_no` FROM `did_pft` WHERE " + condition + "";
                                    objp.prepare();
                                    objp.execute((error1, result1) => {
                                        if (error1 == 1 && result1.length > 0) {
                                            let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj11.nonqrysql = "DELETE FROM `did_pft` WHERE " + condition + "";
                                            obj11.prepare();
                                            obj11.execute((__error, lastid) => {
                                                let did = campData.pftnumber.length;
                                                let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`" + types + "`,`did`) VALUES";
                                                for (let i = 0; i < did; i++) {
                                                    let entry1 = campData.pftnumber[i];
                                                    numberqry += "('" + sessData.iduser + "','" + sessData.idaccount + "', '" + campId + "','" + entry1 + "'),";
                                                }
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = numberqry.slice(0, -1);
                                                obj1.prepare();
                                                obj1.execute((error2, data) => {
                                                    if (error2 == 1) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 201, message: "Recipient Number Added successfully!" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: "Something went wrong with saved number" });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let did = campData.pftnumber.length;
                                            let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`" + types + "`, `did`) VALUES";
                                            for (let i = 0; i < did; i++) {
                                                let entry1 = campData.pftnumber[i];
                                                numberqry += "('" + sessData.iduser + "','" + sessData.idaccount + "', '" + campId + "','" + entry1 + "'),";
                                            }
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = numberqry.slice(0, -1);
                                            obj1.prepare();
                                            obj1.execute((error3, data) => {
                                                if (error3 == 1) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 201, message: "Recipient Number Added successfully!" });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 502, message: "Something went wrong with saved number" });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 404, message: "Campaign Expired" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with get campaign!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getRecepentNumber(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        console.log(sdata);
                        let message = '';
                        switch (true) {
                            case (!sdata || !('campaignId' in req.query)):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(sdata.campaignId)):
                                message = "Campaign Key/SM Reference No is required!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(sdata.campaignId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            default:
                                message = '';
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `campaign_key` FROM `campaign` WHERE (`sm_reference_no`='" + req.query.campaignId + "' OR `campaign_key`= '" + req.query.campaignId + "') AND `status`='3' AND `deleted`='0'";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                if (result.length > 0) {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `iduser`, `idaccount`, `did`, `campaign_id`, `created_at`,`sm_reference_no` FROM `did_pft` WHERE (`sm_reference_no`='" + req.query.campaignId + "' OR `campaign_id` = '" + req.query.campaignId + "') AND `idaccount`= '" + sessData.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((error1, result1) => {
                                        if (error1 == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 200, message: "Recipient Number fetched Successfully!", data: result1 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With get recipient number!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 404, message: "campaign Expired Or No Record Available" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with campaign!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /*****************
 * Get CNP Brand LIST *
 *****************/
    getBrandCnpList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let iduser = sessdata.iduser;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `brandId`,`iduser`,`company_name`,`website`,`displayName`,`status` FROM `brand` WHERE `status`= 1 ORDER BY `idbrand` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /****************************************
    * Send a mock webhook to your endpoint  *
    ****************************************/
    mockWebhookEndpoint(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let reqQry = req.query;
                let iduser = sessdata.iduser;
                let options = {
                    'method': 'PUT',
                    'url': apiUrl + 'webhook/subscription/eventType/' + reqQry.eventType + '/mock',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            let resData = JSON.parse(response.body);
                            if (resData.brandId && resData.brandId !== undefined) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Revet Successfully!", data: resData, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: mockWbhookEndpoint ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                    // if (!error) {
                    //     let resData = JSON.parse(response.body);
                    //     if (resData.campaignId && resData.campaignId !== undefined) {
                    //         let obj = new ModelRawNonQuery(req, res);
                    //         obj.nonqrysql = "UPDATE `campaign` SET `campaign_description`='" + resData.description + "',`sample1`='" + resData.sample1 + "',`sample2`='" + resData.sample2 + "',`sample3`='" + resData.sample3 + "',`sample4`='" + resData.sample4 + "',`sample5`='" + resData.sample5 + "',`messageFlow`='" + resData.messageFlow + "',`helpMessage`='" + resData.helpMessage + "',`optinKeywords`='" + resData.optinKeywords + "',`optoutKeywords`='" + resData.optoutKeywords + "',`helpKeywords`='" + resData.helpKeywords + "',`optinMessage`='" + resData.optinMessage + "',`optoutMessage`='" + resData.optoutMessage + "',`autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "' WHERE `campaign_key`='" + campId + "' AND `iduser`='" + iduser + "'";
                    //         obj.prepare();
                    //         obj.execute((___error, resp) => {
                    //             if (!error) {
                    //                 let objv = new RawView(res);
                    //                 objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: resData });
                    //                 objv.execute();
                    //             }
                    //             else {
                    //                 let objv = new RawView(res);
                    //                 objv.prepare({ message: "Campaign details Not updated", data: resData, status: 501 });
                    //                 objv.execute();
                    //             }
                    //         })
                    //     }
                    //     else {
                    //         let objv = new RawView(res);
                    //         objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                    //         objv.execute();
                    //     }
                    // }
                    // else {
                    //     let objv = new RawView(res);
                    //     objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                    //     objv.execute();
                    // }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    CNPcampApproveByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        // console.log("gggggggggggggggggggggggggggggggggg",sdata);
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        checkuser.checkKycStatus(req, res, sdata.idaccount, (err, dt) => {
                            if (err == 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: dt.status, message: dt.message });
                                objv.execute();
                                return;
                            }
                            else {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='0', `updated_at`=NOW() WHERE `campaign_key`='" + sdata.campId + "' AND `idaccount`=" + sdata.idaccount + " AND `deleted`=0";
                                obj.prepare();
                                obj.execute((error, resp) => {
                                    if (error == 1) {
                                        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj7.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sdata.idaccount + "', '" + sdata.iduser + "','2','" + sdata.campId + "','40','Campaign Approved By Admin','CAMPAIGN_APPROVED_BY_ADMIN','Campaign Approved By Admin','" + datasess + "')";
                                        obj7.prepare();
                                        obj7.execute((campErr, respBl) => {
                                            console.log("Campaign Log Inserted Successfully!");
                                        });
                                        let objW = new RawView_1.RawView(res);
                                        objW.prepare({ message: "Campaign Approved Successfully!", status: 200 });
                                        objW.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong with campaign status!", status: 501 });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**************************************************************************
    * End Brand Functionality  ************************************************
    **************************************************************************/
    /***************************************************************************
    * Start Campaign Functionality *********************************************
    ***************************************************************************/
    campaignFilterForBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let Cdata = JSON.parse(req.body.data);
                let data = Cdata.companyFilter;
                let condition = "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                if (data.usecase)
                    condition += '`usecase`="' + data.usecase + '" AND ';
                if (data.description)
                    condition += '`campaign_description` LIKE "%' + (0, markError_1.parseBody)(data.description) + '%" AND ';
                if (data.campaignId)
                    condition += '`campaign_key` LIKE "%' + data.campaignId + '%" AND ';
                obj.qrysql = "SELECT `campaign_key`,`usecase`,`campaign_description`,DATE_FORMAT(start_date,'%Y-%m-%d')`start_date` FROM `campaign` WHERE " + condition + " `idbrand` = '" + Cdata.brandId + "'AND idaccount=" + Cdata.idaccount + " AND `deleted`=0 GROUP BY campaign_key";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCampaignByBrandId(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let ext_field;
                if (sessdata.type == 1) {
                    ext_field = "`iduser`,`idaccount`,";
                }
                let brandId = req.query.type !== undefined ? JSON.parse(data.type).brandId : req.query.brandId;
                let idaccount = sessdata.type == 1 ? JSON.parse(data.type).idaccount : sessdata.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " `campaign_key`,`sm_reference_no`,`usecase`,`campaign_description`,DATE_FORMAT(start_date,'%Y-%m-%d')`start_date` FROM `campaign` WHERE `idbrand` = '" + brandId + "'AND idaccount=" + idaccount + " AND (`status` = 0 OR `status` = 2 OR `status` = 3) GROUP BY sm_reference_no";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getSwaggerCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.sm_reference_no FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`idaccount` = " + sessdata.idaccount + " AND c.`status` IN (0,2,3) AND c.`deleted` = 0 GROUP BY c.`sm_reference_no` ORDER BY c.`start_date` DESC";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: result,
                                    message: "Campaign Fetched Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Connection!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let condition = '', ext_field;
                if (sessdata.type == 1) {
                    condition += 'c.provisioning_status != 6';
                    ext_field = 'c.id_campaign, c.camp_reseller_unique_id, ';
                }
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    condition += "c.`idaccount`='" + sessdata.idaccount + "'";
                }
                if (sessdata.type == 22) {
                    condition += "c.`iduser`='" + sessdata.iduser + "'";
                }
                ext_field += "c.iduser, c.idaccount, ";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT b.entityType, b.brandId, b.brand_name, " + ext_field + " c.campaign_key, c.usecase, c.start_date, c.did_count, c.did_limit, c.provisioning_status, c.sm_reference_no, c.status, c.parent_campaign_id,c.upstreamCnpId,c.parent_sm_reference_no, c.deleted, c.updated_at,c.requestextension_status,c.extended_date FROM `brand` b INNER JOIN `campaign` c ON c.idbrand = b.brandId";
                if (condition !== '') {
                    obj.qrysql += " WHERE c.`status` IN (0,2,3) AND " + condition;
                }
                else {
                    obj.qrysql += " WHERE c.`status` IN (0,2,3)";
                }
                obj.qrysql += " GROUP BY c.`sm_reference_no` ORDER BY c.`start_date` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCampaignForReview(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let ext_field, message = "", idaccount;
                        if (!sdata || (Array.isArray(sdata) && sdata.length === 0) || !('type' in req.query)) {
                            message = "Missing request params: type";
                        }
                        else {
                            if (message)
                                return;
                            try {
                                if (typeof sdata.type === "string") {
                                    idaccount = JSON.parse(sdata.type).idaccount;
                                }
                                else {
                                    idaccount = sdata.type.idaccount;
                                }
                            }
                            catch (e) {
                                idaccount = sdata.type.idaccount;
                            }
                            switch (true) {
                                case (sessdata.type == 1 && (!idaccount || (0, markError_1.isMissing)(idaccount))):
                                    message = "idaccount is required for admin";
                                    break;
                                case (sessdata.type == 1 && idaccount && !/^\d+$/.test(idaccount.toString())):
                                    message = "idaccount must be numeric";
                                    break;
                                default:
                                    message = "";
                            }
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        }
                        else {
                            // let idaccount = JSON.parse(sdata.type).idaccount;
                            if (sessdata.type == 1) {
                                ext_field = "c.iduser,c.idaccount,";
                            }
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            // obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, "+ext_field+" c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                            obj.qrysql = "SELECT " + ext_field + " MAX(b.brandId) AS brandId,MAX(b.brand_name) AS brand_name,MAX(b.referenceId) AS referenceId, MAX(c.iduser) AS iduser,c.idaccount, c.campaign_key, MAX(c.id_campaign) AS id_campaign,MAX(c.usecase) AS usecase,MAX(DATE_FORMAT(c.`start_date`, '%Y-%m-%d'))`start_date`,MAX(c.did_count) AS did_count,MAX(c.did_limit) AS did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`idaccount` = " + idaccount + " AND c.`deleted` = 0 GROUP BY c.campaign_key ORDER BY `start_date` DESC";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Campaign Fetched Successfully!",
                                        status: 200
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With Connection!",
                                        status: 502,
                                        error: result
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // Get Campaign For Admin
    getCampaignForAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT campaign_key FROM `campaign` WHERE `deleted`=0 AND `status`=0 AND `provisioning_status` = 3 GROUP BY `campaign_key`";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Loaded Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCampaignCases(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let id;
                        let options = {
                            'method': 'Get',
                            'url': apiUrl + 'enum/usecase',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (_err, response, body) => {
                            if (!_err) {
                                try {
                                    let data = JSON.parse(response.body);
                                    if (data) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Campaign Cases Fetched!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", error: data, status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: getCampaignCases ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                                /*
                                let tmp:any=[];
                                Object.entries(data).forEach((ele:any)=>{
                                    let t=ele[1];
                                    t["isDisable"] = false;
                                    t["name"]=ele[0];
                                    tmp.push(t);
                                });
    
                                console.log(tmp);
    
                                let tmpqurty="INSERT INTO `campaign_cases` (`name`, `displayName`, `minSubUsecases`, `maxSubUsecases`, `validSubUsecase`, `classification`) VALUES ";
                                tmp.forEach((campaignData: any) => {
                                    console.log(campaignData, "campData");
                                    tmpqurty += "('"+campaignData.name+"', '"+campaignData.displayName+"', '"+campaignData.minSubUsecases+"', '"+campaignData.maxSubUsecases+"', '"+campaignData.validSubUsecase+"', '"+campaignData.classification+"'),";
                                });
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql =tmpqurty.slice(0, -1);
                                obj.prepare();
                                obj.execute((_error: any, data: any) => {
                                    if(data.length > 0){
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Cases Fetched Successfully!", data: data });
                                        objv.execute();
                                    }
                                    else{
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong!", error: _error });
                                        objv.execute();
                                    }
                                });*/
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    campaignCases(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idcamp_cases`,`name`,`displayName`,`minSubUsecases`,`validSubUsecase`,`maxSubUsecases`,`rate`,`classification`,`nrc_rates`,`service_limit`,`description` FROM `campaign_cases`";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Case Fetches",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    addCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let campData = req.body;
                let id;
                let options = {
                    'method': 'Get',
                    'url': apiUrl + 'partnerCampaign/' + campData.campaign_key + '/sharing',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (_err, response, body) => {
                    if (!_err) {
                        try {
                            let data = JSON.parse(response.body);
                            if (response.statusCode == 200) {
                                if (!_err) {
                                    let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT * FROM `campaign` WHERE `campaign_key` = '" + campData.campaign_key + "'";
                                    obj5.prepare();
                                    obj5.execute((_error, campaign) => {
                                        if (_error == 1) {
                                            //-- Get SMS Provider 
                                            // obj5.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                                            obj5.qrysql = "SELECT p.`priority`, UPPER(s.`provider`)`provider` FROM preference p LEFT JOIN `service_provider` s ON p.idsupplier=s.idsupplier WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                                            obj5.prepare();
                                            obj5.execute((proerr, provider) => {
                                                if (proerr == 1 && provider.length > 0) {
                                                    if (campaign.length > 0) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: "Campaign Already Exists!",
                                                            status: 404
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let tmp = [];
                                                        let options = {
                                                            'method': 'PUT',
                                                            'url': apiUrl + 'partnerCampaign/' + data.campaignId + '/sharing/' + provider[0].provider,
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'Authorization': 'Basic ' + authKey
                                                            }
                                                        };
                                                        (0, axios_1.request)(options, (err, response, body) => {
                                                            if (!err) {
                                                                try {
                                                                    let partnerCampaign = JSON.parse(response.body);
                                                                    if (response.statusCode == 200) {
                                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idbrand`,`campaign_key`, `campaign_name`, `status`, `updated_at`) VALUES ('" + sessdata.iduser + "','" + campData.brandId + "', '" + campData.campaign_key + "', '" + (0, markError_1.parseBody)(campData.campaignName) + "', '1',NOW())";
                                                                        obj.prepare();
                                                                        obj.execute((__error, data) => {
                                                                            if (__error == 1) {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "Campaign Added Successfully!", result: data, status: 201 });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "Something Went Wrong With Connection!", error: data, status: 502 });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ message: data[0].field + " " + data[0].description, error: error, status: 502 });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: addcampaign ::", e);
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    status: 502,
                                                                    message: "Service Profile not found!",
                                                                    error: proerr,
                                                                    campaignId: null
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 502,
                                                        message: "Service Profile not found!",
                                                        error: proerr,
                                                        campaignId: null
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Connection!", error: campaign, status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: data[0].field + " " + data[0].description, status: 502 });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: data[0].field + " " + data[0].description, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: addcampaign ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    registerCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        checkuser.checkKycStatus(req, res, sessdata.idaccount, (err1, dt1) => {
                            if (err1 == 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: dt1.status, message: dt1.message });
                                objv.execute();
                                return;
                            }
                            else {
                                let checkService = new APIBase_1.APIBase();
                                checkService.serviceActivation(req, res, sessdata, "7", (err3, resp) => {
                                    if (resp.status == 200) {
                                        let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                                        let fun = new NewCampaign();
                                        console.log("Campaign Request Data ::", campData);
                                        /* let message: any = '';
                                        const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
                                        const booleanFields = ["embeddedLink", "embeddedPhone", "affiliateMarketing", "termsAndConditions", "numberPool", "ageGated", "directLending", "subscriberOptin", "subscriberOptout", "subscriberHelp", "autoRenewal"]; */
                                        /* switch (true) {
                                            case (!campData.brandId || campData.brandId.trim() == '' || campData.brandId == 'null' || campData.brandId == 'undefined'):
                                                message = "brandId is required.";
                                                break;
                                            case (!/^B[A-Z0-9]{6}$/.test(campData.brandId)):
                                                message = "brandId must be upper-case alphanumeric characters with prefix letter 'B'.";
                                                break;
                                            case (booleanFields.some(key => key in campData && typeof campData[key] != 'boolean')):
                                                {
                                                    for (const key of booleanFields) {
                                                        if (key in campData && typeof campData[key] !== 'boolean') {
                                                            message = `Invalid value for "${key}". Must be true or false.`;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            case (Object.keys(campData).some(key => typeof campData[key] == 'string' && campData[key].trim() != '' && !prgmch.test(campData[key]))):
                                                {
                                                    for (const key in campData) {
                                                        if (typeof campData[key] == 'string' && campData[key].trim() != '' && !prgmch.test(campData[key])) {
                                                            message = `Invalid value for "${key}".`;
                                                            break;
                                                        }
                                                    }
                                                }
                                                break;
                                            case (Object.keys(campData).some(key =>
                                                Array.isArray(campData[key]) && campData[key].some((item: any) => typeof item == 'string' && item.trim() !== '' && !prgmch.test(item)))):
                                                {
                                                    for (const key in campData) {
                                                        if (Array.isArray(campData[key])) {
                                                            for (let i = 0; i < campData[key].length; i++) {
                                                                const item = campData[key][i];
                                                                if (typeof item === 'string' && item.trim() !== '' && !prgmch.test(item)) {
                                                                    message = `Invalid value of "${key}".`;
                                                                    break;
                                                                }
                                                            }
                                                            if (message) break;
                                                        }
                                                    }
                                                }
                                                break;
                                            default:
                                                message = '';
                                        }
                                        if (message) {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 501, message: message });
                                            objv.execute();
                                        } else { */
                                        let objjj = new RawQuery_1.ModelRawQuery(req, res);
                                        objjj.qrysql = "SELECT identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `deleted`=0";
                                        objjj.prepare();
                                        objjj.execute((errr, respp) => {
                                            if (errr == 1 && respp.length > 0) {
                                                if (respp[0].identityStatus != 'PENDING') {
                                                    if (campData.usecase == 'TRIAL') {
                                                        fun.registerpftcamp(req, res, sessdata, next);
                                                    }
                                                    else {
                                                        if (campData.provisionStatus == 6) {
                                                            fun.inCompleteCampaign(req, res, next);
                                                        }
                                                        else {
                                                            console.log("Save & Submit Campaign ::");
                                                            let objb = new RawQuery_1.ModelRawQuery(req, res);
                                                            objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                                            objb.prepare();
                                                            objb.execute((bError, bRes) => {
                                                                if (bError == 1 && bRes.length > 0) {
                                                                    let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                                    objc.qrysql = "SELECT idbrand FROM `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0 AND provisioning_status != 6";
                                                                    objc.prepare();
                                                                    objc.execute((cError, cRes) => {
                                                                        if (cError == 1 && cRes.length < 1) {
                                                                            fun.inRegisterCampaign(req, res, next);
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({
                                                                                error: cError,
                                                                                message: "Active campaign per brand, per usecase limit exceeded for " + campData.brandId,
                                                                                status: 502
                                                                            });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    fun.inRegisterCampaign(req, res, next);
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 502,
                                                        message: "Brand Status is Pending"
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    status: 502,
                                                    message: "Brand Not Found"
                                                });
                                                objv.execute();
                                            }
                                        });
                                        /* } */
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: err3,
                                            status: resp.status,
                                            message: resp.message.replace(/::SN::/g, "Campaign Registration")
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    status: 401,
                    message: "Unauthorized User"
                });
                objv.execute();
            }
        });
    }
    inRegisterCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                // let sm_reference_no = 'SM';
                // const alphabetLength = 5;
                // for (let i = 0; i < 5; i++) {
                //     sm_reference_no += alphabet.charAt(Math.floor(Math.random() * alphabetLength));
                // }
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                    campData.optinKeywords = typeof campData.optinKeywords === 'string' ? campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                    campData.optoutKeywords = typeof campData.optoutKeywords === 'string' ? campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                    campData.helpKeywords = typeof campData.helpKeywords === 'string' ? campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                let provisioning_status = campData.provisionStatus ? campData.provisionStatus : '7';
                let sm_reference_no = '';
                if (campData.smCampaignKey) {
                    sm_reference_no = campData.smCampaignKey;
                }
                else {
                    // const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    // sm_reference_no = 'SM';
                    // const alphabetLength = 5;
                    // for (let i = 0; i < 5; i++) {
                    //     sm_reference_no += alphabet.charAt(Math.floor(Math.random() * alphabetLength));
                    // }
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    const alphabetLength = alphabet.length;
                    const length = 5;
                    sm_reference_no = 'SM';
                    for (let i = 0; i < length; i++) {
                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                        const isDigit = randomIndex >= 52;
                        sm_reference_no += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                    }
                }
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                obj0.prepare();
                obj0.execute((campError, camp) => {
                    if (campError == 1 && camp.length > 0) {
                        //-- Get SMS Provider 
                        let CRate = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0;
                        let __rate = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0;
                        let __nrc_rates = typeof camp[0].nrc_rates != 'undefined' && camp[0].nrc_rates > 0 ? camp[0].nrc_rates : 0;
                        if (CRate > 0) {
                            // let Obj = new ModelRawQuery(req, res);
                            // Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + CRate + "'";
                            // Obj.prepare();
                            // Obj.execute((bErr: any, bRes) => {
                            //     if (bErr == 1) {
                            rate.checkBalance(req, res, sessdata.idaccount, CRate, (bErr, bRes) => {
                                if (bErr == 1) {
                                    //if (bRes.length > 0) {
                                    // let options: any = {
                                    //     'method': 'POST',
                                    //     'url': apiUrl + 'campaignBuilder',
                                    //     'headers': {
                                    //         'Content-Type': 'application/json',
                                    //         'Authorization': 'Basic ' + authKey
                                    //     },
                                    //     body: JSON.stringify(campData)
                                    // };
                                    // request(options, async (error: any, response: any, body: any) => {
                                    //     if (!error) {
                                    //         try {
                                    // let resData = JSON.parse(response.body);
                                    // if (resData.campaignId) {
                                    //     let tmp: any = [];
                                    //     Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                                    //         let t = ele[1];
                                    //         t["class"] = ele[0];
                                    //         tmp.push(t);
                                    //     });
                                    //     let campaignData1 = tmp;
                                    let referenceId = campData.referenceId ? campData.referenceId : '';
                                    let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`sm_reference_no`,`provisioning_status`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`cost`,`referenceId`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`, `updated_at`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + campData.brandId + "', '" + sm_reference_no + "', '" + provisioning_status + "','" + campData.campaignName + "', '" + setDefaultFalse(campData.embeddedLink) + "', '" + setDefaultFalse(campData.embeddedPhone) + "','" + (0, markError_1.parseBody)(campData.description) + "', '" + (0, markError_1.parseBody)(campData.messageFlow) + "', '" + (0, markError_1.parseBody)(campData.optinMessage) + "', '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', '" + (0, markError_1.parseBody)(campData.helpMessage) + "', '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', '" + campData.vertical + "', '" + (0, markError_1.parseBody)(campData.sample1) + "', '" + (0, markError_1.parseBody)(campData.sample2) + "', '" + (0, markError_1.parseBody)(campData.sample3) + "', '" + (0, markError_1.parseBody)(campData.sample4) + "', '" + (0, markError_1.parseBody)(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + setDefaultFalse(campData.termsAndConditions) + "', '" + setDefaultFalse(campData.numberPool) + "', '" + setDefaultFalse(campData.ageGated) + "', '" + setDefaultFalse(campData.directLending) + "', '" + (0, markError_1.setToZero)(camp[0].service_limit) + "','" + setDefaultFalse(campData.subscriberOptin) + "','" + setDefaultFalse(campData.subscriberOptout) + "','" + setDefaultFalse(campData.subscriberHelp) + "', '" + __rate + "','" + referenceId + "','" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "','" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "','" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "',NOW())";
                                    obj00.prepare();
                                    obj00.execute((_errorr, data) => {
                                        if (_errorr == 1) {
                                            let mnoCampaign = new NewCampaign();
                                            mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'inRegisterCampaign', (errorr, resp) => {
                                                if (resp.data) {
                                                    let tmp = [];
                                                    Object.entries(resp.data).forEach((ele) => {
                                                        let t = ele[1];
                                                        t["class"] = ele[0];
                                                        tmp.push(t);
                                                    });
                                                    let campaignData1 = tmp;
                                                    let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                    if (Array.isArray(campData.mnoIds) && campData.mnoIds.length > 0) {
                                                        campData.mnoIds.forEach((mnoId) => {
                                                            let campaignData = campaignData1.find((data) => data.class == mnoId);
                                                            if (campaignData) {
                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "', '" + campaignData.class + "','" + (0, markError_1.setToZero)(campaignData.minMsgSamples) + "', '" + campaignData.mno + "', '" + setDefaultFalse(campaignData.mnoReview) + "', '" + setDefaultFalse(campaignData.mnoSupport) + "', '" + campaignData.msgClass + "','" + setDefaultFalse(campaignData.noEmbeddedLink) + "','" + setDefaultFalse(campaignData.noEmbeddedPhone) + "','" + setDefaultFalse(campaignData.qualify) + "', '" + setDefaultFalse(campaignData.reqSubscriberHelp) + "', '" + setDefaultFalse(campaignData.reqSubscriberOptin) + "', '" + setDefaultFalse(campaignData.reqSubscriberOptout) + "','" + campaignData.brandTier + "','" + (0, markError_1.setToZero)(campaignData.tpm) + "','" + (0, markError_1.setToZero)(campaignData.mmsTpm) + "','" + campaignData.tpmScope + "','" + campaignData.brandDailyCap + "','" + (0, markError_1.setToZero)(campaignData.surcharge) + "','" + (0, markError_1.setToZero)(campaignData.tpn) + "','REGISTERED','0'),";
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "', '0', '0', '', 'false', 'false', '', 'false', 'false', 'false', 'false', 'false', 'false', '', '0', '0', '', '', '0', '0', 'REGISTERED', '0'),";
                                                    }
                                                    let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj01.nonqrysql = campMno.slice(0, -1);
                                                    obj01.prepare();
                                                    obj01.execute((_errorr, campMnoData) => {
                                                    });
                                                }
                                            });
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `sm_reference_no`,`cost`,`nrc_rates`,`event_type`,`description`,`request_type`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + sm_reference_no + "', '" + __rate + "','" + __nrc_rates + "','1','Campaign Request Submitted for Approval','2','CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','Campaign " + sm_reference_no + " for brand " + campData.brandId + " is submitted for approval.','" + JSON.stringify(datasess) + "')";
                                            obj4.prepare();
                                            obj4.execute((campErr, __resp) => {
                                                if (campErr == 1) {
                                                    console.log("Campaign Log Updated Successfully.");
                                                }
                                                else {
                                                    console.log("Campaign Log Not Updated!");
                                                }
                                            });
                                            // To brand Log Update
                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj5.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `sm_reference_no`,`cost`,`nrc_rates`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + sm_reference_no + "', '" + (0, markError_1.setToZero)(__rate) + "','" + (0, markError_1.setToZero)(__nrc_rates) + "','Campaign Rate','" + JSON.stringify(datasess) + "')";
                                            obj5.prepare();
                                            obj5.execute((campErr, __resp) => {
                                                if (campErr == 1) {
                                                    console.log("Brand Log Updated Successfully.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated!");
                                                }
                                            });
                                            let payload = {
                                                idaccount: sessdata.idaccount,
                                                amount: CRate,
                                                purpose: 'campaign registration',
                                                type: '-'
                                            };
                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("inRegisterCampaign => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                            let newDataRegister = Object.assign(campData, { "sm_reference_no": sm_reference_no });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 201, message: "Campaign Registered Successfully!", data: newDataRegister });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Campaign Not Registered Successfully", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: bErr, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            rate.walletRechargeLog(req, res, {
                                idaccount: sessdata.idaccount,
                                amount: "+" + CRate,
                                purpose: 'Billing prorate should be greater then 0 to register a campaign'
                            }, 2, '-', (err, data) => {
                                console.log("inRegisterCampaign => walletRechargeLog Wallet recharge log response:", err, data);
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Billing prorate should be greater then 0 to register a campaign!",
                                error: ""
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Please Select Correct Usecase!",
                            error: camp,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    registerpftcamp(req, res, sessdata, next) {
        let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
        console.log(campData, "registerpftcamp rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr");
        let objc = new RawQuery_1.ModelRawQuery(req, res);
        objc.qrysql = "SELECT pftcampaign_limit, idaccount FROM account WHERE idaccount='" + sessdata.idaccount + "' AND deleted=0";
        objc.prepare();
        objc.execute((err1, res1) => {
            if (err1 == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT status, usecase, provisioning_status,sm_reference_no,campaign_key FROM campaign WHERE idaccount='" + sessdata.idaccount + "' AND usecase='TRIAL' AND deleted=0 AND provisioning_status != 6";
                obj1.prepare();
                obj1.execute((err2, resp2) => {
                    if (err2 == 1) {
                        if ((resp2.length >= res1[0].pftcampaign_limit) && campData.provisionStatus != 6) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 502, message: "campaign limit exceeded for platform free trail usecase"
                            });
                            objv.execute();
                        }
                        else {
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessdata.iduser,
                                idaccount: sessdata.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                                campData.optinKeywords = typeof campData.optinKeywords === 'string' ? campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                            }
                            if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                                campData.optoutKeywords = typeof campData.optoutKeywords === 'string' ? campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                            }
                            if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                                campData.helpKeywords = typeof campData.helpKeywords === 'string' ? campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                            }
                            let sm_reference_no = "";
                            if (campData.smCampaignKey) {
                                sm_reference_no = campData.smCampaignKey;
                            }
                            else {
                                const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                                const alphabetLength = alphabet.length;
                                const length = 5;
                                sm_reference_no = 'SM';
                                for (let i = 0; i < length; i++) {
                                    const randomIndex = Math.floor(Math.random() * alphabetLength);
                                    const isDigit = randomIndex >= 52;
                                    sm_reference_no += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                                }
                            }
                            let files = req.files;
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                            obj0.prepare();
                            obj0.execute((campError, camp) => {
                                if (campError == 1 && camp.length > 0) {
                                    let CRate = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0;
                                    let __rate = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0;
                                    let __nrc_rates = typeof camp[0].nrc_rates != 'undefined' && camp[0].nrc_rates > 0 ? camp[0].nrc_rates : 0;
                                    if (campData.provisionStatus == 6) {
                                        //-- Get SMS Provider 
                                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj2.qrysql = "SELECT `campaign_name`,`sm_reference_no` FROM `campaign` WHERE `idaccount` = '" + sessdata.idaccount + "' AND `sm_reference_no` = '" + sm_reference_no + "'";
                                        obj2.prepare();
                                        obj2.execute((err, result) => {
                                            if (err == 1 && result.length > 0) {
                                                let conn = {
                                                    "noEmbeddedPhone": campData.embeddedPhone,
                                                    "noEmbeddedLink": campData.embeddedLink, "termsAndConditions": campData.termsAndConditions,
                                                    "numberPool": campData.numberPool, "ageGated": campData.ageGated, "directLending": campData.directLending, "subscriberOptin": campData.subscriberOptin, "subscriberOptout": campData.subscriberOptout, "subscriberHelp": campData.subscriberHelp, "affiliateMarketing": campData.affiliateMarketing
                                                };
                                                Object.keys(conn).forEach((key) => {
                                                    if (conn[key] === '' || conn[key] === null || conn[key] === undefined) {
                                                        delete conn[key];
                                                    }
                                                });
                                                let setQuery = Object.keys(conn).map(key => `${key} = '${conn[key]}'`).join(", ");
                                                if (setQuery) {
                                                    setQuery += ", ";
                                                }
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='" + campData.provisionStatus + "' , " + setQuery + " `campaign_name`='" + campData.campaignName + "',  `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "', `messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "', `optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "', `optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "', `optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "', `optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', `helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "', `helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "', `vertical`='" + campData.vertical + "', `sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "', `sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "', `sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "', `sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "', `sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`usecase`='" + campData.usecase + "',`subUsecases`='" + campData.subUsecases + "',`autoRenewal`='" + campData.autoRenewal + "',`did_limit`='" + (0, markError_1.setToZero)(camp[0].service_limit) + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW(),`status`='3' WHERE `sm_reference_no`='" + campData.smCampaignKey + "'";
                                                obj3.prepare();
                                                obj3.execute((errcamp, respcamp) => {
                                                    // if (campData.pftmnoId) {
                                                    let tmp = [];
                                                    if (mnoTrial.data) {
                                                        Object.entries(mnoTrial.data).forEach((ele) => {
                                                            let t = ele[1];
                                                            t["class"] = ele[0];
                                                            tmp.push(t);
                                                        });
                                                    }
                                                    let campaignData2 = tmp;
                                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj.qrysql = "SELECT `iduser`,`idaccount`,`campMnoId` FROM campaign_mno WHERE sm_reference_no ='" + campData.smCampaignKey + "'";
                                                    obj.prepare();
                                                    obj.execute((error, result) => {
                                                        if (error == 1 && result.length > 0) {
                                                            let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj11.nonqrysql = "DELETE FROM `campaign_mno` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                            obj11.prepare();
                                                            obj11.execute((__error, lastid) => {
                                                                let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                for (let key of campData.mnoIds) {
                                                                    campaignData2.forEach((mnoData) => {
                                                                        if (key == mnoData.class) {
                                                                            campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                        }
                                                                    });
                                                                }
                                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj1.nonqrysql = campMno.slice(0, -1);
                                                                obj1.prepare();
                                                                obj1.execute((_error, data) => {
                                                                    if (_error == 1) {
                                                                        console.log("mno update successfully!");
                                                                    }
                                                                });
                                                            });
                                                        }
                                                        else {
                                                            let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                            for (let key of campData.mnoIds) {
                                                                campaignData2.forEach((mnoData) => {
                                                                    if (key == mnoData.class) {
                                                                        campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                    }
                                                                });
                                                            }
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = campMno.slice(0, -1);
                                                            obj1.prepare();
                                                            obj1.execute((_error, data) => {
                                                                if (_error == 1) {
                                                                    console.log("mno insert successfully!");
                                                                }
                                                            });
                                                        }
                                                    });
                                                    // }
                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + campData.smCampaignKey + "','28','Campaign Details Updated','CAMPAIGN_DETAILS_UPDATED','Campaign Details Updated','" + JSON.stringify(datasess) + "')";
                                                    obj4.prepare();
                                                    obj4.execute((campErr, __resp) => {
                                                        if (campErr == 1) {
                                                            console.log("Campaign Log Updated Successfully.");
                                                        }
                                                        else {
                                                            console.log("Campaign Log Not Updated!");
                                                        }
                                                    });
                                                    if (files && files.length > 0) {
                                                        let copycampfile = new NewCampaign();
                                                        copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                                            console.log("copycampfile", resp.status);
                                                        });
                                                    }
                                                    if (campData.pftnumber.length > 0) {
                                                        let objp = new RawQuery_1.ModelRawQuery(req, res);
                                                        objp.qrysql = "SELECT `iduser`,`idaccount`,`pft_id` FROM `did_pft` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                        objp.prepare();
                                                        objp.execute((error, result) => {
                                                            if (error == 1 && result.length > 0) {
                                                                let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj11.nonqrysql = "DELETE FROM `did_pft` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                                obj11.prepare();
                                                                obj11.execute((__error, lastid) => {
                                                                    let did = campData.pftnumber.length;
                                                                    let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                                    for (let i = 0; i < did; i++) {
                                                                        let entry1 = campData.pftnumber[i];
                                                                        numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + entry1 + "'),";
                                                                    }
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = numberqry.slice(0, -1);
                                                                    obj1.prepare();
                                                                    obj1.execute((_error, data) => {
                                                                        if (_error == 1) {
                                                                            console.log("Number update successfully!");
                                                                        }
                                                                    });
                                                                });
                                                            }
                                                            else {
                                                                let did = campData.pftnumber.length;
                                                                let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                                for (let i = 0; i < did; i++) {
                                                                    let entry1 = campData.pftnumber[i];
                                                                    numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + entry1 + "'),";
                                                                }
                                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj1.nonqrysql = numberqry.slice(0, -1);
                                                                obj1.prepare();
                                                                obj1.execute((_error, data) => {
                                                                    if (_error == 1) {
                                                                        console.log("number insert successfully!");
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 201, message: "Campaign Saved Successfully!" });
                                                    objv.execute();
                                                });
                                            }
                                            else {
                                                let conn = {
                                                    "noEmbeddedPhone": campData.embeddedPhone,
                                                    "noEmbeddedLink": campData.embeddedLink, "termsAndConditions": campData.termsAndConditions,
                                                    "numberPool": campData.numberPool, "ageGated": campData.ageGated, "directLending": campData.directLending,
                                                    "subscriberOptin": campData.subscriberOptin, "subscriberOptout": campData.subscriberOptout,
                                                    "subscriberHelp": campData.subscriberHelp, "affiliateMarketing": campData.affiliateMarketing,
                                                };
                                                Object.keys(conn).forEach((key) => {
                                                    if (conn[key] === '' || conn[key] === null || conn[key] === undefined) {
                                                        delete conn[key];
                                                    }
                                                });
                                                let setQuery = Object.keys(conn).map(key => `${key} = '${conn[key]}'`).join(", ");
                                                if (setQuery) {
                                                    setQuery += ", ";
                                                }
                                                let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj01.nonqrysql = "INSERT INTO `campaign` SET " + setQuery + " iduser = '" + sessdata.iduser + "', idaccount = '" + sessdata.idaccount + "', idbrand = '" + campData.brandId + "', sm_reference_no = '" + sm_reference_no + "', provisioning_status = '" + campData.provisionStatus + "', campaign_name = '" + campData.campaignName + "', campaign_description = '" + (0, markError_1.parseBody)(campData.description) + "', messageFlow = '" + (0, markError_1.parseBody)(campData.messageFlow) + "', optinMessage = '" + (0, markError_1.parseBody)(campData.optinMessage) + "', optinKeywords = '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', optoutMessage = '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', optoutKeywords = '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', helpMessage = '" + (0, markError_1.parseBody)(campData.helpMessage) + "', helpKeywords = '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', vertical = '" + campData.vertical + "', sample1 = '" + (0, markError_1.parseBody)(campData.sample1) + "', sample2 = '" + (0, markError_1.parseBody)(campData.sample2) + "', sample3 = '" + (0, markError_1.parseBody)(campData.sample3) + "', sample4 = '" + (0, markError_1.parseBody)(campData.sample4) + "', sample5 = '" + (0, markError_1.parseBody)(campData.sample5) + "', usecase = '" + campData.usecase + "', subUsecases = '" + campData.subUsecases + "', autoRenewal = '" + campData.autoRenewal + "', did_limit = '" + (0, markError_1.setToZero)(camp[0].service_limit) + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW(),`status`='3'";
                                                obj01.prepare();
                                                obj01.execute((_errorr, data) => {
                                                    if (_errorr == 1) {
                                                        // if (campData.pftmnoId) {
                                                        let tmp = [];
                                                        Object.entries(mnoTrial.data).forEach((ele) => {
                                                            let t = ele[1];
                                                            t["class"] = ele[0];
                                                            tmp.push(t);
                                                        });
                                                        let campaignData2 = tmp;
                                                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                        for (let key of campData.mnoIds) {
                                                            campaignData2.forEach((mnoData) => {
                                                                if (key == mnoData.class) {
                                                                    campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                }
                                                            });
                                                        }
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = campMno.slice(0, -1);
                                                        obj1.prepare();
                                                        obj1.execute((_error, data) => {
                                                            if (_error == 1) {
                                                                console.log("mno insert successfully!");
                                                            }
                                                        });
                                                        // }
                                                        if (files && files.length > 0) {
                                                            let copycampfile = new NewCampaign();
                                                            copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                                            });
                                                        }
                                                        if (campData.pftnumber.length > 0) {
                                                            let did = campData.pftnumber.length;
                                                            let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                            for (let i = 0; i < did; i++) {
                                                                let entry1 = campData.pftnumber[i];
                                                                numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + entry1 + "'),";
                                                            }
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = numberqry.slice(0, -1);
                                                            obj1.prepare();
                                                            obj1.execute((_error, data) => {
                                                                if (_error == 1) {
                                                                    console.log("number insert successfully!");
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + sm_reference_no + "','39','Campaign Details Saved','CAMPAIGN_DETAILS_SAVED','Campaign Details Saved','" + JSON.stringify(datasess) + "')";
                                                obj4.prepare();
                                                obj4.execute((campErr, __resp) => {
                                                    if (campErr == 1) {
                                                        console.log("Campaign Log Updated Successfully.");
                                                    }
                                                    else {
                                                        console.log("Campaign Log Not Updated!");
                                                    }
                                                });
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 201, message: "Campaign Saved Successfully!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj2.qrysql = "SELECT `campaign_name`,`sm_reference_no` FROM `campaign` WHERE `idaccount` = '" + sessdata.idaccount + "' AND `sm_reference_no` = '" + sm_reference_no + "'";
                                        obj2.prepare();
                                        obj2.execute((err, result) => {
                                            if (err == 1 && result.length > 0) {
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='" + campData.provisionStatus + "' , `campaign_name`='" + campData.campaignName + "', `noEmbeddedLink`='" + setDefaultFalse(campData.embeddedLink) + "', `noEmbeddedPhone`='" + setDefaultFalse(campData.embeddedPhone) + "', `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "', `messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "', `optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "', `optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "', `optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "', `optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', `helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "', `helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "', `vertical`='" + campData.vertical + "', `sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "', `sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "', `sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "', `sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "', `sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`usecase`='" + campData.usecase + "',`subUsecases`='" + campData.subUsecases + "',`autoRenewal`='" + campData.autoRenewal + "',`termsAndConditions`='" + setDefaultFalse(campData.termsAndConditions) + "',`numberPool`='" + setDefaultFalse(campData.numberPool) + "' ,`ageGated`='" + setDefaultFalse(campData.ageGated) + "',`directLending`='" + setDefaultFalse(campData.directLending) + "',`did_limit`='" + (0, markError_1.setToZero)(camp[0].service_limit) + "',`subscriberOptin`='" + setDefaultFalse(campData.subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(campData.subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(campData.subscriberHelp) + "',`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW(),`status`='3' WHERE `sm_reference_no`='" + campData.smCampaignKey + "'";
                                                obj3.prepare();
                                                obj3.execute((__error, resp) => {
                                                    if (__error == 1) {
                                                        // To brand Log Update
                                                        let fun = new NewCampaign();
                                                        fun.wallletDeduct(req, res, sessdata, CRate, next);
                                                        // if (campData.pftmnoId) {
                                                        let tmp = [];
                                                        if (mnoTrial.data) {
                                                            Object.entries(mnoTrial.data).forEach((ele) => {
                                                                let t = ele[1];
                                                                t["class"] = ele[0];
                                                                tmp.push(t);
                                                            });
                                                        }
                                                        let campaignData2 = tmp;
                                                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                        obj.qrysql = "SELECT `iduser`,`idaccount`,`campMnoId` FROM campaign_mno WHERE sm_reference_no ='" + campData.smCampaignKey + "'";
                                                        obj.prepare();
                                                        obj.execute((error, result) => {
                                                            if (error == 1 && result.length > 0) {
                                                                let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj11.nonqrysql = "DELETE FROM `campaign_mno` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                                obj11.prepare();
                                                                obj11.execute((__error, lastid) => {
                                                                    let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                    for (let key of campData.mnoIds) {
                                                                        campaignData2.forEach((mnoData) => {
                                                                            if (key == mnoData.class) {
                                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                            }
                                                                        });
                                                                    }
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = campMno.slice(0, -1);
                                                                    obj1.prepare();
                                                                    obj1.execute((_error, data) => {
                                                                        if (_error == 1) {
                                                                            console.log("mno update successfully!");
                                                                        }
                                                                    });
                                                                });
                                                            }
                                                            else {
                                                                let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                for (let key of campData.mnoIds) {
                                                                    campaignData2.forEach((mnoData) => {
                                                                        if (key == mnoData.class) {
                                                                            campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                        }
                                                                    });
                                                                }
                                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj1.nonqrysql = campMno.slice(0, -1);
                                                                obj1.prepare();
                                                                obj1.execute((_error, data) => {
                                                                    if (_error == 1) {
                                                                        console.log("mno insert successfully!");
                                                                    }
                                                                });
                                                            }
                                                        });
                                                        // }
                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_description_detail`,`webhook_event_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + campData.smCampaignKey + "','1','Campaign Request Submitted for Approval','Campaign " + sm_reference_no + " for brand " + campData.brandId + " is submitted for approval.', 'CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','" + JSON.stringify(datasess) + "')";
                                                        obj4.prepare();
                                                        obj4.execute((campErr, __resp) => {
                                                            if (campErr == 1) {
                                                                console.log("Campaign Log Updated Successfully.");
                                                            }
                                                            else {
                                                                console.log("Campaign Log Not Updated!");
                                                            }
                                                        });
                                                        if (files && files.length > 0) {
                                                            let copycampfile = new NewCampaign();
                                                            copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                                                console.log("copycampfile", resp.status);
                                                            });
                                                        }
                                                        if (campData.pftnumber.length > 0) {
                                                            let objp = new RawQuery_1.ModelRawQuery(req, res);
                                                            objp.qrysql = "SELECT `iduser`,`idaccount`,`pft_id` FROM `did_pft` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                            objp.prepare();
                                                            objp.execute((error, result) => {
                                                                if (error == 1 && result.length > 0) {
                                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj11.nonqrysql = "DELETE FROM `did_pft` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                                    obj11.prepare();
                                                                    obj11.execute((__error, lastid) => {
                                                                        let did = campData.pftnumber.length;
                                                                        let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                                        for (let i = 0; i < did; i++) {
                                                                            let entry1 = campData.pftnumber[i];
                                                                            numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + entry1 + "'),";
                                                                        }
                                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = numberqry.slice(0, -1);
                                                                        obj1.prepare();
                                                                        obj1.execute((_error, data) => {
                                                                            if (_error == 1) {
                                                                                console.log("Number update successfully!");
                                                                            }
                                                                        });
                                                                    });
                                                                }
                                                                else {
                                                                    let did = campData.pftnumber.length;
                                                                    let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                                    for (let i = 0; i < did; i++) {
                                                                        let entry1 = campData.pftnumber[i];
                                                                        numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + entry1 + "'),";
                                                                    }
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = numberqry.slice(0, -1);
                                                                    obj1.prepare();
                                                                    obj1.execute((_error, data) => {
                                                                        if (_error == 1) {
                                                                            console.log("number insert successfully!");
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        }
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 201, message: "Campaign Registered Successfully!" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Campaign Not Registered!", status: 504 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let provisioning_status = campData.provisionStatus ? campData.provisionStatus : '7';
                                                if (CRate > 0) {
                                                    rate.checkBalance(req, res, sessdata.idaccount, CRate, (bErr, bRes) => {
                                                        if (bErr == 1) {
                                                            let referenceId = campData.referenceId ? campData.referenceId : '';
                                                            let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`sm_reference_no`,`provisioning_status`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`cost`,`referenceId`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`,`status`,`updated_at`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + campData.brandId + "', '" + sm_reference_no + "', '" + provisioning_status + "','" + campData.campaignName + "', '" + setDefaultFalse(campData.embeddedLink) + "', '" + setDefaultFalse(campData.embeddedPhone) + "','" + (0, markError_1.parseBody)(campData.description) + "', '" + (0, markError_1.parseBody)(campData.messageFlow) + "', '" + (0, markError_1.parseBody)(campData.optinMessage) + "', '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', '" + (0, markError_1.parseBody)(campData.helpMessage) + "', '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', '" + campData.vertical + "', '" + (0, markError_1.parseBody)(campData.sample1) + "', '" + (0, markError_1.parseBody)(campData.sample2) + "', '" + (0, markError_1.parseBody)(campData.sample3) + "', '" + (0, markError_1.parseBody)(campData.sample4) + "', '" + (0, markError_1.parseBody)(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + setDefaultFalse(campData.termsAndConditions) + "', '" + setDefaultFalse(campData.numberPool) + "', '" + setDefaultFalse(campData.ageGated) + "', '" + setDefaultFalse(campData.directLending) + "', '" + (0, markError_1.setToZero)(camp[0].service_limit) + "','" + setDefaultFalse(campData.subscriberOptin) + "','" + setDefaultFalse(campData.subscriberOptout) + "','" + setDefaultFalse(campData.subscriberHelp) + "', '" + __rate + "','" + referenceId + "','" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "','" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "','" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "','3',NOW())";
                                                            obj00.prepare();
                                                            obj00.execute((_errorr, data) => {
                                                                if (_errorr == 1) {
                                                                    // if (campData.pftmnoId) {
                                                                    let tmp = [];
                                                                    if (mnoTrial.data) {
                                                                        Object.entries(mnoTrial.data).forEach((ele) => {
                                                                            let t = ele[1];
                                                                            t["class"] = ele[0];
                                                                            tmp.push(t);
                                                                        });
                                                                    }
                                                                    let campaignData2 = tmp;
                                                                    let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                    for (let key of campData.mnoIds) {
                                                                        campaignData2.forEach((mnoData) => {
                                                                            if (key == mnoData.class) {
                                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                            }
                                                                        });
                                                                    }
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = campMno.slice(0, -1);
                                                                    obj1.prepare();
                                                                    obj1.execute((_error, data) => {
                                                                        if (_error == 1) {
                                                                            console.log("mno insert successfully!");
                                                                        }
                                                                    });
                                                                    // }
                                                                    if (campData.pftnumber.length > 0) {
                                                                        let did = campData.pftnumber.length;
                                                                        let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                                        for (let i = 0; i < did; i++) {
                                                                            let entry1 = campData.pftnumber[i];
                                                                            numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + entry1 + "'),";
                                                                        }
                                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = numberqry.slice(0, -1);
                                                                        obj1.prepare();
                                                                        obj1.execute((_error, data) => {
                                                                            if (_error == 1) {
                                                                                console.log("number insert successfully!");
                                                                            }
                                                                        });
                                                                    }
                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `sm_reference_no`,`cost`,`nrc_rates`,`event_type`,`description`,`request_type`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + sm_reference_no + "', '" + __rate + "','" + __nrc_rates + "','1','Campaign Request Submitted for Approval','2','CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','Campaign " + sm_reference_no + " for brand " + campData.brandId + " is submitted for approval.','" + JSON.stringify(datasess) + "')";
                                                                    obj4.prepare();
                                                                    obj4.execute((campErr, __resp) => {
                                                                        if (campErr == 1) {
                                                                            console.log("Campaign Log Updated Successfully.");
                                                                        }
                                                                        else {
                                                                            console.log("Campaign Log Not Updated!");
                                                                        }
                                                                    });
                                                                    // To brand Log Update
                                                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj5.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `sm_reference_no`,`cost`,`nrc_rates`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + sm_reference_no + "', '" + (0, markError_1.setToZero)(__rate) + "','" + (0, markError_1.setToZero)(__nrc_rates) + "','Campaign Rate','" + JSON.stringify(datasess) + "')";
                                                                    obj5.prepare();
                                                                    obj5.execute((campErr, __resp) => {
                                                                        if (campErr == 1) {
                                                                            console.log("Brand Log Updated Successfully.");
                                                                        }
                                                                        else {
                                                                            console.log("Brand Log Not Updated!");
                                                                        }
                                                                    });
                                                                    let payload = {
                                                                        idaccount: sessdata.idaccount,
                                                                        amount: CRate,
                                                                        purpose: 'campaign registration',
                                                                        type: '-'
                                                                    };
                                                                    rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                        console.log("registerpftcamp => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                    });
                                                                    let newDataRegister = Object.assign(campData, { "sm_reference_no": sm_reference_no });
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 201, message: "Campaign Registered Successfully!", data: newDataRegister });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Campaign Not Registered Successfully", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ error: bErr, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    rate.walletRechargeLog(req, res, {
                                                        idaccount: sessdata.idaccount,
                                                        amount: "+" + CRate,
                                                        purpose: 'Billing prorate should be greater then 0 to register a campaign'
                                                    }, 2, '-', (err, data) => {
                                                        console.log("registerpftcamp => walletRechargeLog Wallet recharge log response:", err, data);
                                                    });
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 502,
                                                        message: "Billing prorate should be greater then 0 to register a campaign!",
                                                        error: ""
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Please Select Correct Usecase!", error: camp, campaignId: null });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "something went wrong with wrong with get campaign" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "something went wrong with wrong with get account" });
                objv.execute();
            }
        });
    }
    RedundantCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                checkuser.checkKycStatus(req, res, sessdata.idaccount, (err, dt) => {
                    if (err == 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: dt.status, message: dt.message });
                        objv.execute();
                        return;
                    }
                    else {
                        let checkService = new APIBase_1.APIBase();
                        checkService.serviceActivation(req, res, sessdata, "7", (err, resp) => {
                            if (resp.status == 200) {
                                console.log("req", req.body.campaignData);
                                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                                let fun = new NewCampaign();
                                if (campData.provisionStatus == 6) {
                                    fun.inCompleteRedundantCampaign(req, res, next);
                                }
                                else {
                                    fun.inRedundantCampaign(req, res, next);
                                }
                                /* let objb = new ModelRawQuery(req, res);
                                objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                objb.prepare();
                                objb.execute((bError, bRes) => {
                                    if (bError == 1 && bRes.length > 0) {
                                        let objc = new ModelRawQuery(req, res);
                                        objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0";
                                        objc.prepare();
                                        objc.execute((cError, cRes) => {
                                            if (cError == 1 && cRes.length < 1) {
                                                // fOR Sole proprietor
                                                let fun = new NewCampaign();
                                                if (campData.provisionStatus == 6) {
                                                    fun.inCompleteRedundantCampaign(req, res, next);
                                                }
                                                else {
                                                    fun.inRedundantCampaign(req, res, next);
                                                }
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded " + campData.brandId, status: 502 });
                                                objv.execute();
                                            }
                                        })
                                    }
                                    else {
                                        // FOR any entity type
                                        let fun = new NewCampaign();
                                        if (campData.provisionStatus == 6) {
                                            fun.inCompleteRedundantCampaign(req, res, next);
                                        }
                                        else {
                                            fun.inRedundantCampaign(req, res, next);
                                        }
                                    }
                                }) */
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: err,
                                    status: resp.status,
                                    message: resp.message.replace(/::SN::/g, "Campaign Registration")
                                });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inRedundantCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                    campData.optinKeywords = typeof campData.optinKeywords === 'string' ? campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                    campData.optoutKeywords = typeof campData.optoutKeywords === 'string' ? campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                    campData.helpKeywords = typeof campData.helpKeywords === 'string' ? campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                let parent_sm_reference_no = req.body.parentSmCampKey;
                let files = req.files;
                let sm_reference_no = "";
                if (campData.smCampaignKey && campData.smCampaignKey != "") {
                    sm_reference_no = campData.smCampaignKey;
                }
                else {
                    // const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    // sm_reference_no = 'SM';
                    // const alphabetLength = 5;
                    // for (let i = 0; i < 5; i++) {
                    //     sm_reference_no += alphabet.charAt(Math.floor(Math.random() * alphabetLength));
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    const alphabetLength = alphabet.length;
                    const length = 5;
                    sm_reference_no = 'SM';
                    for (let i = 0; i < length; i++) {
                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                        const isDigit = randomIndex >= 52;
                        sm_reference_no += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                    }
                    // }
                }
                let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                obj00.qrysql = "SELECT UpstreamCnpId From `campaign` WHERE `sm_reference_no`='" + parent_sm_reference_no + "' AND `idaccount` = '" + sessdata.idaccount + "'";
                obj00.prepare();
                obj00.execute((errors, Upstream) => {
                    if (errors == 1) {
                        // if(Upstream[0].UpstreamCnpId!==null && Upstream[0].UpstreamCnpId!=='') {
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                        obj0.prepare();
                        obj0.execute((campError, camp) => {
                            if (campError == 1 && camp.length > 0) {
                                //-- Get SMS Provider 
                                let camp_rates = 0;
                                let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                Obj0.qrysql = "SELECT `idtariff` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "' AND `is_deleted` = '0'";
                                Obj0.prepare();
                                Obj0.execute(async (bErr, bRes) => {
                                    if (bErr == 1 && bRes.length > 0) {
                                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                                        obj.qrysql = "SELECT `rate`,`mrc` FROM `campaign_rates` WHERE `idtariff`='" + bRes[0].idtariff + "' AND `type`='campaign'  AND `category`='campaign_redundant' LIMIT 1";
                                        obj.prepare();
                                        obj.execute((err, rates) => {
                                            if (err == 1) {
                                                let rt = [];
                                                rt = rates.length > 0 ? rates : [Object.assign({ rate: 0 }, rates[0])];
                                                camp_rates = Array.isArray(rt) && rt.length > 0 ? rt[0].rate : 0;
                                                let RCRate = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0;
                                                let CRate = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0;
                                                let _rate = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0;
                                                let __nrc_rates = typeof camp[0].nrc_rates != 'undefined' && camp[0].nrc_rates > 0 ? camp[0].nrc_rates : 0;
                                                let camp_mrc = Array.isArray(rates) && rates.length > 0 ? rates[0].mrc : 0;
                                                let total_rate = camp_rates + CRate + camp_mrc;
                                                // return
                                                if (CRate > 0) {
                                                    // let Obj = new ModelRawQuery(req, res);
                                                    // Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + total_rate + "'";
                                                    // Obj.prepare();
                                                    // Obj.execute((bErr: any, bRes) => {
                                                    //     if (bErr == 1) {
                                                    rate.checkBalance(req, res, sessdata.idaccount, total_rate, (bErr, bRes) => {
                                                        if (bErr == 1) {
                                                            // if (bRes.length > 0) {
                                                            //if (bRes.length > 0) {
                                                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj2.qrysql = "SELECT `campaign_name`,`sm_reference_no` FROM `campaign` WHERE `idaccount` = '" + sessdata.idaccount + "' AND `sm_reference_no` = '" + sm_reference_no + "'";
                                                            obj2.prepare();
                                                            obj2.execute((err, result) => {
                                                                if (err == 1 && result.length > 0) {
                                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj3.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='" + campData.provisionStatus + "' , `campaign_name`='" + campData.campaignName + "', `noEmbeddedLink`='" + setDefaultFalse(campData.embeddedLink) + "', `noEmbeddedPhone`='" + setDefaultFalse(campData.embeddedPhone) + "', `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "', `messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "', `optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "', `optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "', `optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "', `optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', `helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "', `helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "', `vertical`='" + campData.vertical + "', `sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "', `sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "', `sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "', `sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "', `sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`usecase`='" + campData.usecase + "',`subUsecases`='" + campData.subUsecases + "',`autoRenewal`='" + campData.autoRenewal + "',`termsAndConditions`='" + setDefaultFalse(campData.termsAndConditions) + "',`numberPool`='" + setDefaultFalse(campData.numberPool) + "' ,`ageGated`='" + setDefaultFalse(campData.ageGated) + "',`directLending`='" + setDefaultFalse(campData.directLending) + "',`did_limit`='" + (0, markError_1.setToZero)(camp[0].service_limit) + "',`subscriberOptin`='" + setDefaultFalse(campData.subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(campData.subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(campData.subscriberHelp) + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW() WHERE `sm_reference_no`='" + campData.smCampaignKey + "'";
                                                                    obj3.prepare();
                                                                    obj3.execute((__error, resp) => {
                                                                        if (__error == 1) {
                                                                            let mnoCampaign = new NewCampaign();
                                                                            mnoCampaign.wallletDeduct(req, res, sessdata, total_rate, next);
                                                                            mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'inRedundantCampaign', (errorr, resp) => {
                                                                                if (resp.data) {
                                                                                    let tmp = [];
                                                                                    Object.entries(resp.data).forEach((ele) => {
                                                                                        let t = ele[1];
                                                                                        t["class"] = ele[0];
                                                                                        tmp.push(t);
                                                                                    });
                                                                                    let campaignData2 = tmp;
                                                                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                                                    obj.qrysql = "SELECT `iduser`,`idaccount`,`campMnoId` FROM campaign_mno WHERE sm_reference_no ='" + campData.smCampaignKey + "'";
                                                                                    obj.prepare();
                                                                                    obj.execute((error, result) => {
                                                                                        if (error == 1 && result.length > 0) {
                                                                                            let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj11.nonqrysql = "DELETE FROM `campaign_mno` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                                                            obj11.prepare();
                                                                                            obj11.execute((__error, lastid) => {
                                                                                                let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                                                for (let key of campData.mnoIds) {
                                                                                                    campaignData2.forEach((mnoData) => {
                                                                                                        if (key == mnoData.class) {
                                                                                                            campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.campaign_class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                obj1.nonqrysql = campMno.slice(0, -1);
                                                                                                obj1.prepare();
                                                                                                obj1.execute((_error, data) => {
                                                                                                    if (_error == 1) {
                                                                                                        console.log("mno update successfully!");
                                                                                                    }
                                                                                                });
                                                                                            });
                                                                                        }
                                                                                        else {
                                                                                            let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                                            for (let key of campData.mnoIds) {
                                                                                                campaignData2.forEach((mnoData) => {
                                                                                                    if (key == mnoData.class) {
                                                                                                        campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.campaign_class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                                                    }
                                                                                                });
                                                                                            }
                                                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj1.nonqrysql = campMno.slice(0, -1);
                                                                                            obj1.prepare();
                                                                                            obj1.execute((_error, data) => {
                                                                                                if (_error == 1) {
                                                                                                    console.log("mno insert successfully!");
                                                                                                }
                                                                                            });
                                                                                        }
                                                                                        // let obj4 = new ModelRawNonQuery(req, res);
                                                                                        // obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `request_type`,`sm_reference_no``event_type`,`description`,`webhook_description_detail`,`webhook_event_type`,`redundant_charge`,`cost`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",2,'" + campData.smCampaignKey + "',1,'Campaign Request Submitted for Approval','CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','Campaign Request Submitted for Approval'," + setToZero(RCRate) + "," + setToZero(total_rate) + ")";
                                                                                        // obj4.prepare();
                                                                                        // obj4.execute((campErr, __resp) => {
                                                                                        //     if (campErr == 1) {
                                                                                        //         console.log("Campaign Log Updated Successfully.");
                                                                                        //     }
                                                                                        //     else {
                                                                                        //         console.log("Campaign Log Not Updated!");
                                                                                        //     }
                                                                                        // });
                                                                                    });
                                                                                }
                                                                            });
                                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `request_type`,`sm_reference_no``event_type`,`description`,`webhook_description_detail`,`webhook_event_type`,`redundant_charge`,`cost`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",2,'" + campData.smCampaignKey + "',1,'Campaign Request Submitted for Approval','CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','Campaign Request Submitted for Approval'," + (0, markError_1.setToZero)(RCRate) + "," + (0, markError_1.setToZero)(total_rate) + ",'" + JSON.stringify(datasess) + "')";
                                                                            obj4.prepare();
                                                                            obj4.execute((campErr, __resp) => {
                                                                                if (campErr == 1) {
                                                                                    console.log("Campaign Log Updated Successfully.");
                                                                                }
                                                                                else {
                                                                                    console.log("Campaign Log Not Updated!");
                                                                                }
                                                                            });
                                                                            if (files && files.length > 0) {
                                                                                let copycampfile = new NewCampaign();
                                                                                copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                                                                    console.log("copycampfile", resp.status);
                                                                                });
                                                                            }
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Campaign Request Submitted for Approval", status: 201 });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Campaign Not Registered!", status: 504 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objb = new RawQuery_1.ModelRawQuery(req, res);
                                                                    objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                                                    objb.prepare();
                                                                    objb.execute((bError, bRes) => {
                                                                        if (bError == 1 && bRes.length > 0) {
                                                                            let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                                            objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0 AND `provisioning_status` != 6";
                                                                            objc.prepare();
                                                                            objc.execute((cError, cRes) => {
                                                                                if (cError == 1 && cRes.length < 1) {
                                                                                    console.log("Register Redundant Campaign IF::");
                                                                                    let fun = new NewCampaign();
                                                                                    fun.registerRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, _rate, total_rate, RCRate, next);
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded for " + campData.brandId, status: 502 });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            console.log("Register Redundant Campaign Else::");
                                                                            let fun = new NewCampaign();
                                                                            fun.registerRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, _rate, total_rate, RCRate, next);
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ error: bErr, message: "Please add funds to your account or contact support.", status: 503 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    rate.walletRechargeLog(req, res, {
                                                        idaccount: sessdata.idaccount,
                                                        amount: "+" + CRate,
                                                        purpose: 'Billing prorate should be greater then 0 to register a campaign'
                                                    }, 2, '-', (err, data) => {
                                                        console.log("inRegisterCampaign => walletRechargeLog Wallet recharge log response:", err, data);
                                                    });
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 502,
                                                        message: "Billing prorate should be greater then 0 to register a campaign!",
                                                        error: ""
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Please Select Correct Usecase!",
                                    error: camp,
                                    campaignId: null
                                });
                                objv.execute();
                            }
                        });
                        // }
                        // else{
                        //     let objv = new RawView(res);
                        //     objv.prepare({ status: 502, message: "DCA Not Submitted To SM Campaign Key!" +parent_sm_reference_no});
                        //     objv.execute();   
                        // }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "DCA Not Found!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    wallletDeduct(req, res, sessdata, amount, next) {
        let payload = {
            idaccount: sessdata.idaccount,
            amount: amount,
            purpose: 'redundant/copy campaign registration',
            type: '-'
        };
        rate.walletDeduction(req, res, payload, (errorD, dataD) => {
            console.log("wallletDeduct => walletDeduction Wallet deduction response:", errorD, dataD);
        });
    }
    registerRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, _rate, total_rate, RCRate, next) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let datasess = {
            iduser: sessdata.iduser,
            idaccount: sessdata.idaccount,
            ipAddress: sysInfo.ipAddress[0],
        };
        let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`sm_reference_no`,`provisioning_status`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`cost`,`status`,`parent_campaign_id`,`parent_sm_reference_no`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`, `updated_at`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + campData.brandId + "', '" + sm_reference_no + "', '" + campData.provisionStatus + "','" + campData.campaignName + "', '" + setDefaultFalse(campData.embeddedLink) + "', '" + setDefaultFalse(campData.embeddedPhone) + "','" + (0, markError_1.parseBody)(campData.description) + "', '" + (0, markError_1.parseBody)(campData.messageFlow) + "', '" + (0, markError_1.parseBody)(campData.optinMessage) + "', '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', '" + (0, markError_1.parseBody)(campData.helpMessage) + "', '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', '" + campData.vertical + "', '" + (0, markError_1.parseBody)(campData.sample1) + "', '" + (0, markError_1.parseBody)(campData.sample2) + "', '" + (0, markError_1.parseBody)(campData.sample3) + "', '" + (0, markError_1.parseBody)(campData.sample4) + "', '" + (0, markError_1.parseBody)(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + setDefaultFalse(campData.termsAndConditions) + "', '" + setDefaultFalse(campData.numberPool) + "', '" + setDefaultFalse(campData.ageGated) + "', '" + setDefaultFalse(campData.directLending) + "', '" + (0, markError_1.setToZero)(camp[0].service_limit) + "','" + setDefaultFalse(campData.subscriberOptin) + "','" + setDefaultFalse(campData.subscriberOptout) + "','" + setDefaultFalse(campData.subscriberHelp) + "', '" + (0, markError_1.setToZero)(_rate) + "','2','" + campData.campaignKey + "','" + parent_sm_reference_no + "','" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "','" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "','" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "',NOW())";
        obj00.prepare();
        obj00.execute((_errorr, data) => {
            if (_errorr == 1) {
                let fun = new NewCampaign();
                fun.wallletDeduct(req, res, sessdata, total_rate, next);
                let mnoCampaign = new NewCampaign();
                mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'registerRedundantCampaign', (errorr, resp) => {
                    if (resp.data) {
                        let tmp = [];
                        Object.entries(resp.data).forEach((ele) => {
                            let t = ele[1];
                            t["class"] = ele[0];
                            tmp.push(t);
                        });
                        let campaignData1 = tmp;
                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                        campaignData1.forEach((mnoData) => {
                            campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                        });
                        let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj01.nonqrysql = campMno.slice(0, -1);
                        obj01.prepare();
                        obj01.execute((_errorr, campMnoData) => {
                        });
                    }
                });
                if (files && files.length > 0) {
                    let copycampfile = new NewCampaign();
                    copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                    });
                }
                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `request_type`,`sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`redundant_charge`,`cost`,`webhook_full_log`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",2,'" + sm_reference_no + "',1,'Campaign Request Submitted for Approval','CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','Campaign Request Submitted for Approval'," + (0, markError_1.setToZero)(RCRate) + "," + (0, markError_1.setToZero)(total_rate) + ",'" + JSON.stringify(datasess) + "')";
                obj4.prepare();
                obj4.execute((campErr, __resp) => {
                    if (campErr == 1) {
                        console.log("Campaign Log Updated Successfully.");
                    }
                    else {
                        console.log("Campaign Log Not Updated!");
                    }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 201, message: "Redundant Campaign Created Successfully!" });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Redundant Campaign Not Registered!", status: 504 });
                objv.execute();
            }
        });
    }
    inCompleteRedundantCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                    campData.optinKeywords = typeof campData.optinKeywords === 'string' ? campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                    campData.optoutKeywords = typeof campData.optoutKeywords === 'string' ? campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                    campData.helpKeywords = typeof campData.helpKeywords === 'string' ? campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                let files = req.files;
                let parent_sm_reference_no = req.body.parentSmCampKey;
                let sm_reference_no = "";
                if (campData.smCampaignKey && campData.smCampaignKey != "") {
                    sm_reference_no = campData.smCampaignKey;
                }
                else {
                    // const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    // sm_reference_no = 'SM';
                    // const alphabetLength = 5;
                    // for (let i = 0; i < 5; i++) {
                    //     sm_reference_no += alphabet.charAt(Math.floor(Math.random() * alphabetLength));
                    // }
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    const alphabetLength = alphabet.length;
                    const length = 5;
                    sm_reference_no = 'SM';
                    for (let i = 0; i < length; i++) {
                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                        const isDigit = randomIndex >= 52;
                        sm_reference_no += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                    }
                }
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                obj0.prepare();
                obj0.execute((campError, camp) => {
                    if (campError == 1 && camp.length > 0) {
                        //-- Get SMS Provider 
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `campaign_name`,`sm_reference_no` FROM `campaign` WHERE `idaccount` = '" + sessdata.idaccount + "' AND `sm_reference_no` = '" + sm_reference_no + "'";
                        obj2.prepare();
                        obj2.execute((err, result) => {
                            if (err == 1 && result.length > 0) {
                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='" + campData.provisionStatus + "' , `campaign_name`='" + campData.campaignName + "', `noEmbeddedLink`='" + setDefaultFalse(campData.embeddedLink) + "', `noEmbeddedPhone`='" + setDefaultFalse(campData.embeddedPhone) + "', `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "', `messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "', `optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "', `optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "', `optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "', `optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', `helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "', `helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "', `vertical`='" + campData.vertical + "', `sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "', `sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "', `sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "', `sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "', `sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`usecase`='" + campData.usecase + "',`subUsecases`='" + campData.subUsecases + "',`autoRenewal`='" + campData.autoRenewal + "',`termsAndConditions`='" + setDefaultFalse(campData.termsAndConditions) + "',`numberPool`='" + setDefaultFalse(campData.numberPool) + "' ,`ageGated`='" + setDefaultFalse(campData.ageGated) + "',`directLending`='" + setDefaultFalse(campData.directLending) + "',`did_limit`='" + (0, markError_1.setToZero)(camp[0].service_limit) + "',`subscriberOptin`='" + setDefaultFalse(campData.subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(campData.subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(campData.subscriberHelp) + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW() WHERE `sm_reference_no`='" + campData.smCampaignKey + "'";
                                obj3.prepare();
                                obj3.execute((__error, resp) => {
                                    let mnoCampaign = new NewCampaign();
                                    mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'inCompleteRedundantCampaign', (errorr, resp) => {
                                        if (resp.data) {
                                            let tmp = [];
                                            Object.entries(resp.data).forEach((ele) => {
                                                let t = ele[1];
                                                t["class"] = ele[0];
                                                tmp.push(t);
                                            });
                                            let campaignData2 = tmp;
                                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                                            obj.qrysql = "SELECT `iduser`,`idaccount`,`campMnoId` FROM campaign_mno WHERE sm_reference_no ='" + campData.smCampaignKey + "'";
                                            obj.prepare();
                                            obj.execute((error, result) => {
                                                if (error == 1 && result.length > 0) {
                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "DELETE FROM `campaign_mno` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                    obj11.prepare();
                                                    obj11.execute((__error, lastid) => {
                                                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                        for (let key of campData.mnoIds) {
                                                            campaignData2.forEach((mnoData) => {
                                                                if (key == mnoData.class) {
                                                                    campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.campaign_class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                }
                                                            });
                                                        }
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = campMno.slice(0, -1);
                                                        obj1.prepare();
                                                        obj1.execute((_error, data) => {
                                                            if (_error == 1) {
                                                                console.log("mno update successfully!");
                                                            }
                                                        });
                                                    });
                                                }
                                                else {
                                                    let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                    for (let key of campData.mnoIds) {
                                                        campaignData2.forEach((mnoData) => {
                                                            if (key == mnoData.class) {
                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.campaign_class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                            }
                                                        });
                                                    }
                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = campMno.slice(0, -1);
                                                    obj1.prepare();
                                                    obj1.execute((_error, data) => {
                                                        if (_error == 1) {
                                                            console.log("mno insert successfully!");
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                        // console.log("mnoIds",campData.mnoIds);
                                    });
                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + campData.smCampaignKey + "','28','Campaign Details Updated','CAMPAIGN_DETAILS_UPDATED','Campaign Details Updated','" + JSON.stringify(datasess) + "')";
                                    obj4.prepare();
                                    obj4.execute((campErr, __resp) => {
                                        if (campErr == 1) {
                                            console.log("Campaign Log Updated Successfully.");
                                        }
                                        else {
                                            console.log("Campaign Log Not Updated!");
                                        }
                                    });
                                    if (files && files.length > 0) {
                                        let copycampfile = new NewCampaign();
                                        copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                            console.log("copycampfile", resp.status);
                                        });
                                    }
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, message: "Redundant Campaign Created Successfully!" });
                                    objv.execute();
                                });
                            }
                            else {
                                let fun = new NewCampaign();
                                fun.insertSaveRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, next);
                                /* let campData: any = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                                let objb = new ModelRawQuery(req, res);
                                objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                objb.prepare();
                                objb.execute((bError, bRes) => {
                                    if (bError == 1 && bRes.length > 0) {
                                        let objc = new ModelRawQuery(req, res);
                                        objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0 AND `provisioning_status` !=6";
                                        objc.prepare();
                                        objc.execute((cError, cRes) => {
                                            if (cError == 1 && cRes.length < 1) {
                                                console.log("Insert Save Redundant Campaign IF::");
                                                let fun = new NewCampaign();
                                                fun.insertSaveRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, next);
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded for " + campData.brandId, status: 502 });
                                                objv.execute();
                                            }
                                        })
                                    }
                                    else {
                                        console.log("Insert Save Redundant Campaign Else::");
                                        let fun = new NewCampaign();
                                        fun.insertSaveRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, next);
                                    }
                                }) */
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + sm_reference_no + "','39','Campaign Details Saved','CAMPAIGN_DETAILS_SAVED','Campaign Details Saved','" + JSON.stringify(datasess) + "')";
                                obj4.prepare();
                                obj4.execute((campErr, __resp) => {
                                    if (campErr == 1) {
                                        console.log("Campaign Log Updated Successfully.");
                                    }
                                    else {
                                        console.log("Campaign Log Not Updated!");
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Please Select Correct Usecase!",
                            error: camp,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    insertSaveRedundantCampaign(req, res, sessdata, campData, sm_reference_no, parent_sm_reference_no, files, camp, next) {
        let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`sm_reference_no`,`provisioning_status`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`status`,`parent_campaign_id`,`parent_sm_reference_no`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`, `updated_at`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + campData.brandId + "', '" + sm_reference_no + "', '" + campData.provisionStatus + "','" + campData.campaignName + "', '" + setDefaultFalse(campData.embeddedLink) + "', '" + setDefaultFalse(campData.embeddedPhone) + "','" + (0, markError_1.parseBody)(campData.description) + "', '" + (0, markError_1.parseBody)(campData.messageFlow) + "', '" + (0, markError_1.parseBody)(campData.optinMessage) + "', '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', '" + (0, markError_1.parseBody)(campData.helpMessage) + "', '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', '" + campData.vertical + "', '" + (0, markError_1.parseBody)(campData.sample1) + "', '" + (0, markError_1.parseBody)(campData.sample2) + "', '" + (0, markError_1.parseBody)(campData.sample3) + "', '" + (0, markError_1.parseBody)(campData.sample4) + "', '" + (0, markError_1.parseBody)(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + setDefaultFalse(campData.termsAndConditions) + "', '" + setDefaultFalse(campData.numberPool) + "', '" + setDefaultFalse(campData.ageGated) + "', '" + setDefaultFalse(campData.directLending) + "', '" + (0, markError_1.setToZero)(camp[0].service_limit) + "','" + setDefaultFalse(campData.subscriberOptin) + "','" + setDefaultFalse(campData.subscriberOptout) + "','" + setDefaultFalse(campData.subscriberHelp) + "','2','" + campData.campaignKey + "','" + parent_sm_reference_no + "','" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "','" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "','" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', NOW())";
        obj00.prepare();
        obj00.execute((_errorr, data) => {
            if (_errorr == 1) {
                let mnoCampaign = new NewCampaign();
                mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'insertSaveRedundantCampaign', (errorr, resp) => {
                    if (resp.data) {
                        let tmp = [];
                        Object.entries(resp.data).forEach((ele) => {
                            let t = ele[1];
                            t["class"] = ele[0];
                            tmp.push(t);
                        });
                        let campaignData2 = tmp;
                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                        for (let key of campData.mnoIds) {
                            campaignData2.forEach((mnoData) => {
                                if (key == mnoData.class) {
                                    campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + mnoData.campaign_class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                }
                            });
                        }
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = campMno.slice(0, -1);
                        obj1.prepare();
                        obj1.execute((_error, data) => {
                            if (_error == 1) {
                                console.log("mno insert successfully!");
                            }
                        });
                    }
                });
                if (files && files.length > 0) {
                    let copycampfile = new NewCampaign();
                    copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                    });
                }
            }
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 201, message: "Redundant Campaign Created Successfully!" });
            objv.execute();
        });
    }
    /********************************
    * Campaign Sumbimt to DCA Start
    */
    dcaSubmit(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let campId = req.body.data !== undefined ? JSON.parse(req.body.data).campId : req.query.campaignId;
                let iduser = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let idaccount = req.body.data !== undefined ? JSON.parse(req.body.data).idaccount : sessdata.idaccount;
                let serviceData = req.body.data !== undefined ? JSON.parse(req.body.data).service : '';
                // let serviceName: any = serviceData.sms_provider ? serviceData.sms_provider.toUpperCase() : '';             
                let serviceName = serviceData.sms_provider ? (serviceData.sms_provider.toUpperCase() === "SYNIVERSE" ? "SYNIV" : serviceData.sms_provider.toUpperCase()) : '';
                let Obj00 = new RawQuery_1.ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted`,`upstreamCnpId`, `status` FROM `campaign` WHERE `idaccount`='" + idaccount + "' AND `campaign_key`='" + campId + "' AND `deleted` = '0'";
                Obj00.prepare();
                Obj00.execute((_Err, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT `idtariff` FROM `user` WHERE `idaccount`='" + idaccount + "' AND `is_deleted` = '0'";
                        Obj0.prepare();
                        Obj0.execute((bErr, bRes) => {
                            if (bErr == 1 && bRes.length > 0) {
                                let rate = new APIBase_1.APIBase;
                                rate.getCampaignRate(req, res, bRes[0].idtariff, "campaign", "campaign_review", (err, rates) => {
                                    // let camp_rates: any = campRes[0].upstreamCnpId && campRes[0].upstreamCnpId.startsWith("S") ? 0 : Array.isArray(rates) && rates.length > 0 ? rates[0].rate : 0 ;
                                    let camp_rates = Array.isArray(rates) && rates.length > 0 ? rates[0].rate : 0;
                                    let camp_mrc = Array.isArray(rates) && rates.length > 0 ? rates[0].mrc : 0;
                                    let finalrate = (camp_rates + camp_mrc);
                                    // let Obj = new ModelRawQuery(req, res);
                                    // Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + idaccount + "' AND `balance` + `credit_limit` >= '" + camp_rates + "'";
                                    // Obj.prepare();
                                    // Obj.execute((bErr: any, bRes) => {
                                    //     if (bErr == 1 && bRes.length > 0) {
                                    /* rate.checkBalance(req, res, idaccount, camp_rates, (bErr, bRes) => {
                                        if (bErr == 1) { */
                                    if (serviceName || serviceName !== '' || serviceName !== undefined) {
                                        if (campRes[0].status == '3') {
                                            let payload = {
                                                campId: campId,
                                                iduser: iduser,
                                                idaccount: idaccount,
                                                serviceData: serviceData,
                                                serviceName: serviceName,
                                                datasess: datasess,
                                                camp_rates: camp_rates,
                                                camp_mrc: camp_mrc,
                                                finalrate: finalrate
                                            };
                                            let camp = new NewCampaign();
                                            camp.PFTdcaSubmit(req, res, payload, next);
                                        }
                                        else {
                                            let options = {
                                                'method': 'PUT',
                                                'url': apiUrl + 'partnerCampaign/' + campId + '/sharing/' + serviceName,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            (0, axios_1.request)(options, (error, response, body) => {
                                                if (!error) {
                                                    try {
                                                        let partnerCampaign = JSON.parse(response.body);
                                                        if (partnerCampaign.upstreamCnpId) {
                                                            let payload = {
                                                                idaccount: idaccount,
                                                                amount: finalrate,
                                                                purpose: 'campaign DCA Submit',
                                                                type: '-'
                                                            };
                                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                console.log("dcaSubmit => walletDeduction Wallet deduction response:", errorD, dataD);
                                                            });
                                                            // To Campaign Log Insert
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES (" + idaccount + ", " + iduser + ",'" + campId + "', '" + (0, markError_1.setToZero)(finalrate) + "','0','27','Campaign DCA Submit','CAMPAIGN_DCA_SUBMITTED','Campaign DCA Submitted','2','" + JSON.stringify(datasess) + "')";
                                                            obj4.prepare();
                                                            obj4.execute((campErr, __resp) => {
                                                                if (campErr == 1) {
                                                                    console.log("Campaign Log Updated Successfully.");
                                                                }
                                                                else {
                                                                    console.log("Campaign Log Not Updated!");
                                                                }
                                                            });
                                                            // To Campaign Update
                                                            let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj01.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='1', `downstreamCnpId`='" + partnerCampaign.downstreamCnpId + "', `upstreamCnpId`='" + serviceName + "', `sharingStatus`='" + partnerCampaign.sharingStatus + "', `sharedDate`='" + partnerCampaign.sharedDate + "',`statusDate`='" + partnerCampaign.statusDate + "', `updated_at`=NOW() WHERE `campaign_key`='" + campId + "' AND `idaccount`='" + idaccount + "' AND `deleted`=0";
                                                            obj01.prepare();
                                                            obj01.execute((____error, resp) => {
                                                                if (____error == 1) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 200, message: "DCA submitted successfully!" });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 501, message: "Something Went Wrong!" });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: partnerCampaign[0].description, status: partnerCampaign[0].code });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 503, message: "Something Went Wrong!" });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something Went Wrong With Service Profile!" });
                                        objv.execute();
                                    }
                                    /* }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Insufficient fund!", status: 502 });
                                        objv.execute();
                                    }
                                })*/
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went wrong with tariff!", status: 504 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    PFTdcaSubmit(req, res, pftcampdata, next) {
        let payload = {
            idaccount: pftcampdata.idaccount,
            amount: pftcampdata.finalrate,
            purpose: 'campaign DCA Submit',
            type: '-'
        };
        rate.walletDeduction(req, res, payload, (errorD, dataD) => {
            console.log("PFTdcaSubmit => walletDeduction Wallet deduction response:", errorD, dataD);
        });
        // To Campaign Log Insert
        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES (" + pftcampdata.idaccount + ", " + pftcampdata.iduser + ",'" + pftcampdata.campId + "', '" + (0, markError_1.setToZero)(pftcampdata.finalrate) + "','0','27','Campaign DCA Submit','CAMPAIGN_DCA_SUBMITTED','Campaign DCA Submitted','2','" + JSON.stringify(pftcampdata.datasess) + "')";
        obj4.prepare();
        obj4.execute((campErr, __resp) => {
            if (campErr == 1) {
                console.log("Campaign Log Updated Successfully.");
            }
            else {
                console.log("Campaign Log Not Updated!");
            }
        });
        // To Campaign Update
        let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj01.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='3', `downstreamCnpId`='SH9UWCQ', `upstreamCnpId`='" + pftcampdata.serviceName + "', `sharingStatus`='PENDING', `sharedDate`=NOW(),`statusDate`=NOW(), `updated_at`=NOW() WHERE `campaign_key`='" + pftcampdata.campId + "' AND `idaccount`='" + pftcampdata.idaccount + "' AND `deleted`=0";
        obj01.prepare();
        obj01.execute((error2, resp) => {
            if (error2 == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 200, message: "DCA submitted successfully!" });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 501, message: "Something Went Wrong!" });
                objv.execute();
            }
        });
    }
    updateinRegisterCampaign(req, campaignId, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let campData = req.body;
                let options = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campaignId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                };
                (0, axios_1.request)(options, (errorr, response, body) => {
                    if (!errorr) {
                        try {
                            let getCamp = JSON.parse(response.body);
                            if (getCamp.campaignId && getCamp.campaignId !== undefined) {
                                let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `campaign` SET `campaign_status`='" + getCamp.status + "',`nextRenewalOrExpirationDate`='" + getCamp.nextRenewalOrExpirationDate + "',`billedDate`='" + getCamp.billedDate + "',`createDate`='" + getCamp.createDate + "', `updated_at`=NOW() WHERE `campaign_key`='" + getCamp.campaignId + "' AND `idaccount`=" + sessdata.idaccount + " AND `deleted`=0";
                                obj01.prepare();
                                obj01.execute((____error, resp) => {
                                    console.log("nextRenewalOrExpirationDate updated");
                                });
                            }
                            else {
                                console.log("nextRenewalOrExpirationDate not updated.");
                            }
                        }
                        catch (e) {
                            console.log("Error :: updateinRegisterCampaign ::", e);
                            console.log("nextRenewalOrExpirationDate not updated!");
                        }
                    }
                    else {
                        console.log("nextRenewalOrExpirationDate not updated!!");
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    CampaignRegister(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let campData = req.body;
                let CRate = typeof campData.rate != 'undefined' && campData.rate > 0 ? campData.rate : 0;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                //-- Get SMS Provider 
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                // obj1.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                obj1.qrysql = "SELECT p.`priority`, UPPER(s.`provider`)`provider` FROM preference p LEFT JOIN `service_provider` s ON p.idsupplier=s.idsupplier WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                obj1.prepare();
                obj1.execute((proerr, provider) => {
                    if (proerr == 1 && provider.length > 0) {
                        if (CRate > 0) {
                            let objv = new RawView_1.RawView(res);
                            if (campData.brandId) {
                                var key;
                                let options = {
                                    'method': 'POST',
                                    'url': apiUrl + 'campaignBuilder',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': 'Basic ' + authKey
                                    },
                                    body: JSON.stringify(campData)
                                };
                                (0, axios_1.request)(options, (error, response, body) => {
                                    let body2 = {};
                                    try {
                                        body2 = JSON.parse(body);
                                    }
                                    catch {
                                        body2 = body;
                                    }
                                    let campaignId = typeof body2.campaignId != 'undefined' ? body2.campaignId : "";
                                    if (!error) {
                                        let resData = JSON.parse(response.body);
                                        if (resData.campaignId) {
                                            let tmp = [];
                                            let options = {
                                                'method': 'PUT',
                                                'url': apiUrl + 'partnerCampaign/' + resData.campaignId + '/sharing/' + provider[0].provider,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            (0, axios_1.request)(options, (error, response, body) => {
                                                if (!error) {
                                                    try {
                                                        let partnerCampaign = JSON.parse(response.body);
                                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                        if (response.body) {
                                                            Object.entries(resData.mnoMetadata).forEach((ele) => {
                                                                let t = ele[1];
                                                                t["class"] = ele[0];
                                                                tmp.push(t);
                                                            });
                                                            let campaignData1 = tmp;
                                                            let tmpqurty = "INSERT INTO `campaign` (`iduser`,`idbrand`,`campaign_key`, `campaign_class`, `campaign_name`, `minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`, `surcharge`, `tpn`, `brandTier`, `campaign_description`, `downstreamCnpId`, `upstreamCnpId`, `sharingStatus`, `sharedDate`, `statusDate`,`cost`, `updated_at`) VALUES ";
                                                            campaignData1.forEach((campaignData) => {
                                                                tmpqurty += "('" + sessdata.iduser + "','" + campData.brandId + "', '" + resData.campaignId + "', '" + campaignData.class + "', '" + campData.campaignName + "', '" + (0, markError_1.setToZero)(campaignData.minMsgSamples) + "', '" + campaignData.mno + "', '" + setDefaultFalse(campaignData.mnoReview) + "', '" + setDefaultFalse(campaignData.mnoSupport) + "', '" + campaignData.msgClass + "', '" + setDefaultFalse(campaignData.noEmbeddedLink) + "', '" + setDefaultFalse(campaignData.noEmbeddedPhone) + "', '" + setDefaultFalse(campaignData.qualify) + "', '" + setDefaultFalse(campaignData.reqSubscriberHelp) + "', '" + setDefaultFalse(campaignData.reqSubscriberOptin) + "', '" + setDefaultFalse(campaignData.reqSubscriberOptin) + "', '" + (0, markError_1.setToZero)(campaignData.surcharge) + "', '" + (0, markError_1.setToZero)(campaignData.tpn) + "', '" + campaignData.brandTier + "', '" + campData.description + "', '" + partnerCampaign.downstreamCnpId + "', '" + partnerCampaign.upstreamCnpId + "', '" + partnerCampaign.sharingStatus + "', '" + partnerCampaign.sharedDate + "', '" + partnerCampaign.statusDate + "', '" + (0, markError_1.setToZero)(CRate) + "',NOW()),";
                                                            });
                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = tmpqurty.slice(0, -1);
                                                            obj.prepare();
                                                            obj.execute((_error, data) => {
                                                                if (_error == 1) {
                                                                    if (campData.rate) {
                                                                        let payload = {
                                                                            idaccount: sessdata.idaccount,
                                                                            amount: CRate,
                                                                            purpose: 'campaign registration',
                                                                            type: '-'
                                                                        };
                                                                        rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                            console.log("CampaignRegister => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                        });
                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `campaign_key`,`cost`, `date`, `description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + resData.campaignId + "', " + (0, markError_1.setToZero)(campData.rate) + ", '" + Date.now() + "', 'Campaign_Rate','" + combinedLog + "')";
                                                                        obj3.prepare();
                                                                        obj3.execute((___error, resp) => {
                                                                            if (___error == 1) {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 201, message: "Campaign Register Successfully!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                                        obj2.qrysql = "SELECT * From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                                                                        obj2.prepare();
                                                                        obj2.execute((campError, camp) => {
                                                                            if (campError == 1) {
                                                                                let CRate = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0;
                                                                                let payload = {
                                                                                    idaccount: sessdata.idaccount,
                                                                                    amount: CRate,
                                                                                    purpose: 'campaign registration',
                                                                                    type: '-'
                                                                                };
                                                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                    console.log("CampaignRegister => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                                });
                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`campaign_key`,`cost`, `date`, `description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', " + (0, markError_1.setToZero)(camp[0].rate) + ", '" + Date.now() + "', 'Campaign_Rate','" + combinedLog + "')";
                                                                                obj3.prepare();
                                                                                obj3.execute((___error, resp) => {
                                                                                    if (___error == 1) {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ status: 201, message: "Campaign Register Successfully!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                                else {
                                                                    objv.prepare({
                                                                        message: "Something Went Wrong With Conection!",
                                                                        error: error,
                                                                        status: 502
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            objv.prepare({
                                                                message: "Something Went Wrong With Connection!",
                                                                error: error,
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: CampaignRegister ::", e);
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            objv.prepare({
                                                message: resData[0].field + " " + resData[0].description,
                                                error: "Campaign did not registered!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        objv.prepare({
                                            message: "Something Went Wrong With Connection!",
                                            error: error,
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                objv.prepare({
                                    err: 401,
                                    message: "brandId is mendatory field!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        }
                        else {
                            rate.walletRechargeLog(req, res, {
                                idaccount: sessdata.idaccount,
                                amount: "+" + CRate,
                                purpose: 'Billing prorate should be greater then 0 to register a campaign'
                            }, 2, '-', (err, data) => {
                                console.log("inRegisterCampaign => walletRechargeLog Wallet recharge log response:", err, data);
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Billing prorate should be greater then 0 to register a campaign!",
                                error: ""
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Service Profile not found!",
                            error: proerr,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************
    * Campaign MNO Detail
    */
    mnoIddetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let options = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/mno',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "MNO Details Fetched!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With MNO Details Fetched!", error: error, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: mnoIdDetails ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************************************
    * get campaign details based on campaign id  *
    *********************************************/
    getCampDetailById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = req.query.type ? JSON.parse(data.type) : data;
                let idaccount = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name,c.iduser,c.idaccount,c.reqSubscriberOptin,c.reqSubscriberOptout,c.reqSubscriberHelp,c.campaign_key,c.usecase,c.start_date,c.sharedDate,c.statusDate,c.subUsecases,c.campaign_description,c.sample1,c.sample2,c.sample3,c.sample4,c.sample5,c.messageFlow,c.helpMessage,c.optinMessage,c.optoutMessage,c.optinKeywords,c.optoutKeywords,c.helpKeywords,c.autoRenewal,c.noEmbeddedLink,c.noEmbeddedPhone,c.affiliateMarketing,c.termsAndConditions,c.numberPool,c.ageGated,c.directLending,c.subscriberOptin,c.subscriberOptout,c.subscriberHelp,c.nextRenewalOrExpirationDate FROM `campaign`c INNER JOIN `brand`b ON b.brandId = c.idbrand WHERE `campaign_key`='" + sdata.campId + "' AND c.`iduser` = '" + sdata.iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.qrysql = "SELECT b.brandId,b.brand_name,b.deleted `brand_deleted`,b.identityStatus,c.iduser,c.idaccount,c.reqSubscriberOptin,c.reqSubscriberOptout,c.reqSubscriberHelp,c.campaign_key,c.usecase,c.start_date,c.sharedDate,c.statusDate,c.subUsecases,c.campaign_description,c.sample1,c.sample2,c.sample3,c.sample4,c.sample5,c.messageFlow,c.helpMessage,c.optinMessage,c.optoutMessage,c.optinKeywords,c.optoutKeywords,c.helpKeywords,c.autoRenewal,c.noEmbeddedLink,c.noEmbeddedPhone,c.affiliateMarketing,c.termsAndConditions,c.numberPool,c.ageGated,c.directLending,c.subscriberOptin,c.subscriberOptout,c.subscriberHelp,c.nextRenewalOrExpirationDate,c.deleted,c.provisioning_status,c.sm_reference_no ,c.privacyPolicyLink,c.termsAndConditionsLink,c.embeddedLinkSample,c.requestextension_status,c.extended_date FROM `campaign`c INNER JOIN `brand`b ON b.brandId = c.idbrand WHERE `sm_reference_no`='" + sdata.campId + "' AND c.`idaccount` = " + idaccount + " GROUP BY campaign_key";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `iduser`,`idaccount`,`pft_id`,`campaign_id`,`did` FROM `did_pft` WHERE `sm_reference_no` ='" + sdata.campId + "'";
                        obj0.execute((__error, campRes) => {
                            let didList = [];
                            if (campRes && campRes.length > 0) {
                                didList = campRes.map((row) => row.did);
                            }
                            if (result && result.length > 0) {
                                result[0].number = didList.join(",");
                            }
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Campaign Detail Fetched Successfully!", status: 200 });
                            objv.execute();
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************************************
    * get campaign Mno details based on campaign id  *
    *********************************************/
    getMnoMetaDataDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = req.query.type ? JSON.parse(data.type) : data;
                // let iddacc : any = sdata.idaccount ?? sdata.iduser
                let iddacc = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,usecase,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE brandDailyCap END )`brandDailyCap` FROM `campaign` WHERE `campaign_key`='" + sdata.campId + "' AND `idaccount`=" + iddacc + " ";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Mno Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Mno Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCampMnoMetaDataDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = req.query.type ? JSON.parse(data.type) : data;
                let iddacc = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE CASE WHEN brandDailyCap ='null' THEN 'No' ELSE brandDailyCap END END )`brandDailyCap`,`mno_status`,`dca_elect` FROM `campaign_mno` WHERE `sm_reference_no`='" + sdata.campId + "' AND `idaccount`=" + iddacc + " ";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Mno Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Mno Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getMnoMetaDataForRegister(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1|| sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.query;
                        let brandId = data.type !== undefined ? JSON.parse(data.type).brandId : data.brandId;
                        let usecase = data.type !== undefined ? JSON.parse(data.type).usecase : data.usecase;
                        let message = '';
                        /* switch (true) {
                            case (!brandId && !usecase):
                                message = "BrandId and Usecase is required";
                                break;
                            case (!brandId || brandId.trim() == '' || brandId == 'null' || brandId == 'undefined' || !/^B[A-Z0-9]{6}$/.test(brandId)):
                                message = "BrandId Must be upper-case alphanumeric characters with prefix letter 'B'";
                                break;
                            case (!usecase || usecase.trim() == '' || usecase == 'null' || usecase == 'undefined' || /^\s/.test(usecase) || !/^[A-Z0-9_]+$/.test(usecase)):
                                message = "Unrecognized Usecase";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        } else { */ let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT identityStatus,entityType FROM `brand` WHERE `brandId`='" + brandId + "' AND `deleted`=0";
                        Obj0.prepare();
                        Obj0.execute((err, resStatus) => {
                            if (err == 1 && resStatus.length > 0) {
                                if (resStatus[0].entityType == 'PFT_BRAND' && usecase == 'TRIAL') {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Mno Meta Details Records Fetched!", data: mnoTrial.data });
                                    objv.execute();
                                }
                                else {
                                    //  }
                                    let options = {
                                        'method': 'GET',
                                        'url': apiUrl + 'campaignBuilder/brand/' + brandId + '/usecase/' + usecase,
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + authKey
                                        }
                                    };
                                    console.log("getMnoMetaDataForRegister options :: ", options);
                                    (0, axios_1.request)(options, (error, response, body) => {
                                        if (!error) {
                                            try {
                                                let data = (response.body && response.body.trim().startsWith('<html>')) ? '' : JSON.parse(response.body);
                                                console.log("getMnoMetaDataForRegister data :: ", data);
                                                if (data.mnoMetadata && data.mnoMetadata != undefined) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 200, message: "Mno Meta Details Records Fetched!", data: data.mnoMetadata });
                                                    objv.execute();
                                                }
                                                else {
                                                    let desc = data[0].description && data[0].description != undefined ? data[0].description : 'MNO Data not found!';
                                                    let code = data[0].code && data[0].code != undefined ? data[0].code : 501;
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: desc, status: code });
                                                    objv.execute();
                                                }
                                            }
                                            catch (e) {
                                                console.log("Error :: getMnoDataForRegister ::", e);
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With API!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Brand not found", data: data.mnoMetadata });
                                objv.execute();
                            }
                        });
                        /* } */
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    brandQualifyAllUseCases(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let brandId = data.type !== undefined ? JSON.parse(data.type).brandId : data.brandId;
                let options = {
                    'method': 'GET',
                    'url': apiUrl + 'campaignBuilder/brand/' + brandId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            if (data && data != undefined) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Use Case Records Fetched!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: data[0].field + " " + data[0].description, status: data[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: BrandQualifyAllUseCases ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Use Case!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /********************************************************************
    * Check NON Profit Brand and CV vetting appllied on NON Profit Brand*
    * CV = Campaign Verify Token of Vetting Partner
    ********************************************************************/
    checkNonProfitBrand(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT b.`entityType`, b.`einIssuingCountry`, bv.`evpId` FROM `brand` b  INNER JOIN `brand_vetting` bv ON b.`brandId` = bv.`brandId` WHERE b.`brandId` = '" + data.type + "' AND b.`entityType` = 'NON_PROFIT' AND bv.`evpId` = 'CV' AND b.`idaccount` = " + sessdata.idaccount + "";
                obj.prepare();
                obj.execute((errBrand, resultBrand) => {
                    if (errBrand == 1 && resultBrand.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: errBrand, data: resultBrand, message: "Non Profit Brand Vetting Verified CV Imported Vetting Data Found!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: errBrand, message: "Brand CV Vetting Does Not Exist!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    checkPublicVettStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.query;
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `iduser`, `idaccount`, `identityStatus`, `brandId`, `entityType`, `website`, `business_contact_email` FROM `brand` WHERE `idaccount` = " + sessdata.idaccount + " AND `brandId` = '" + data.type + "'";
                        obj1.prepare();
                        obj1.execute((errBrand, resultBrand) => {
                            if (errBrand == 1) {
                                if (resultBrand.length > 0) {
                                    let brand = resultBrand[0];
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT bv.`evpId`, bv.`vettingStatus`, bv.`vettingClass`,b.`entityType` FROM `brand_vetting` bv LEFT JOIN `brand` b ON b.`brandId` = bv.`brandId` WHERE bv.`brandId` = '" + data.type + "' AND bv.`idaccount` = " + sessdata.idaccount + " AND bv.`vettingClass` = 'AUTHPLUS' AND b.`entityType` = 'PUBLIC_PROFIT'";
                                    obj.prepare();
                                    obj.execute((errBrand1, resultBrand1) => {
                                        if (errBrand1 == 1) {
                                            if (brand.entityType == 'PUBLIC_PROFIT') {
                                                if ((0, markError_1.isMissing)(brand.website) || (0, markError_1.isMissing)(brand.business_contact_email)) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Website or business contact email required for PUBLIC PROFIT brand entity type!", status: 502 });
                                                    objv.execute();
                                                    return;
                                                }
                                                if (resultBrand1.length > 0) {
                                                    const anyActive = resultBrand1.some((r) => r.vettingStatus &&
                                                        r.vettingStatus.toString().trim().toUpperCase() == 'ACTIVE');
                                                    if (anyActive) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ data: resultBrand1, message: "Brand active for vetting authplus!", status: 200 });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ data: resultBrand1, message: "Vetting of Authplus are expired for this PUBLIC PROFIT brand entitytype!", status: 502 });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Brand does not qualify for submitted campaign use case. Please apply authplus vetting.", status: 502 });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Brand vetting not exist!", status: 200 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something went wrong with getting brand vetting!", status: 501 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Brand not found!", status: 502 });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went wrong with check Public Vett Status", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getConnPartnersDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let options = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/cnp',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Connectivity Partners Fetched!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getConnParnterDetails ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getResellerDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let options = {
                    'method': 'Get',
                    'url': apiUrl + 'reseller/RAP07Z4',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Reseller Records Fetched!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Reseller Records Not Fetched!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getResellerDetails ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getMNOList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let options = {
                            'method': 'Get',
                            'url': apiUrl + 'enum/mno',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        (0, axios_1.request)(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let data = JSON.parse(response.body);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "MNO ID's Fetched Successfully!", data: data, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Fetched MNO ID's!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: getMNOList ::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Fetched MNO ID's!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    mnoMetaData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let campId = req.query;
                        let message = '';
                        switch (true) {
                            case (!campId):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!campId.campaignId || campId.campaignId == '' || campId.campaignId == 'null' || campId.campaignId == 'undefined'):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!/^C[A-Z0-9]{6}$/.test(campId.campaignId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C'!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        }
                        else {
                            let options = {
                                'method': 'GET',
                                'url': apiUrl + 'campaign/' + campId.campaignId + '/mnoMetadata',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                }
                            };
                            (0, axios_1.request)(options, (error, response, body) => {
                                if (!error) {
                                    try {
                                        if (response.body) {
                                            let data = JSON.parse(response.body);
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "MNO MetaData Fetched successfully!", data: data, status: 200 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "MNO MetaData Not Fetched!", error: error, status: 502 });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: mnoMetaData ::", e);
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "MNO MetaData Not Fetched!", error: error, status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCampDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let campId = req.query;
                        let message = '';
                        switch (true) {
                            case (!campId):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!campId.campaignId || campId.campaignId == '' || campId.campaignId == 'null' || campId.campaignId == 'undefined'):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(campId.campaignId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        }
                        else {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `campaign_key`,`sm_reference_no`,`usecase` FROM `campaign` WHERE (`campaign_key`='" + campId.campaignId + "' OR `sm_reference_no`='" + campId.campaignId + "') AND `idaccount` = '" + sessdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((__error, campRes) => {
                                if (__error == 1 && campRes.length > 0) {
                                    if (campRes[0].usecase == 'TRIAL') {
                                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT `campaign_key`,`sm_reference_no`,`autoRenewal`,`billedDate`,`idbrand`,`vertical`,`usecase`,`subUsecases`,`campaign_description`,`noEmbeddedLink`,`noEmbeddedPhone`,`termsAndConditions`,`numberPool`,`ageGated`,`directLending`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`sample1`,`sample2`,`sample3`,`sample4`,`sample5`,`messageFlow`,`helpMessage`,`referenceId`,`nextRenewalOrExpirationDate`,`optinKeywords`,`optoutKeywords`,`helpKeywords`,`optinMessage`,`optoutMessage`,`cost`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`,`requestextension_status`,`extended_date` FROM `campaign` WHERE (`sm_reference_no`='" + campId.campaignId + "' OR `campaign_key`='" + campId.campaignId + "') AND `idaccount` = '" + sessdata.idaccount + "'";
                                        obj1.prepare();
                                        obj1.execute((__err, campDetails) => {
                                            if (__err == 1 && campDetails.length > 0) {
                                                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj0.qrysql = "SELECT `iduser`,`idaccount`,`pft_id`,`campaign_id`,`did` FROM `did_pft` WHERE `sm_reference_no`='" + campDetails[0].sm_reference_no + "' OR `campaign_id`='" + campId.campaignId + "'";
                                                obj0.execute((__error, campRes) => {
                                                    let didList = [];
                                                    if (campRes && campRes.length > 0) {
                                                        didList = campRes.map((row) => row.did);
                                                    }
                                                    campDetails[0].number = didList.join(",");
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Campaign Details Fetched successfully!", data: campDetails, status: 200 });
                                                    objv.execute();
                                                });
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ message: "Campaign Record Not Found!", status: 502 });
                                                obj.execute();
                                            }
                                        });
                                    }
                                    else {
                                        if (campRes[0].campaign_key == null) {
                                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT `campaign_key`,`sm_reference_no`,`autoRenewal`,`billedDate`,`idbrand`,`vertical`,`usecase`,`subUsecases`,`campaign_description`,`noEmbeddedLink`,`noEmbeddedPhone`,`termsAndConditions`,`numberPool`,`ageGated`,`directLending`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`sample1`,`sample2`,`sample3`,`sample4`,`sample5`,`messageFlow`,`helpMessage`,`referenceId`,`nextRenewalOrExpirationDate`,`optinKeywords`,`optoutKeywords`,`helpKeywords`,`optinMessage`,`optoutMessage`,`cost`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`,`requestextension_status`,`extended_date` FROM `campaign` WHERE `sm_reference_no`='" + campId.campaignId + "' AND `idaccount` = '" + sessdata.idaccount + "'";
                                            obj1.prepare();
                                            obj1.execute((__err, campDetails) => {
                                                if (__err == 1 && campDetails.length > 0) {
                                                    // let obj0 = new ModelRawQuery(req, res);
                                                    // obj0.qrysql = "SELECT `iduser`,`idaccount`,`pft_id`,`campaign_id`,`did` FROM `did_pft` WHERE campaign_id ='" + campId.campaignId + "'";
                                                    // obj0.execute((__error: any, campRes: any) => {
                                                    //     // campRes se DID collect karna
                                                    //     let didList: string[] = [];
                                                    //     if (campRes && campRes.length > 0) {
                                                    //         didList = campRes.map((row: any) => row.did);
                                                    //     }
                                                    //     // direct campDetails me number create karein
                                                    //     campDetails.number = didList.join(",");
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Campaign Details Fetched successfully!", data: campDetails, status: 200 });
                                                    objv.execute();
                                                    // })
                                                }
                                                else {
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ message: "Campaign Record Not Found!", status: 502 });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let options = {
                                                'method': 'GET',
                                                'url': apiUrl + 'campaign/' + campRes[0].campaign_key,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            (0, axios_1.request)(options, (error, response, body) => {
                                                if (!error) {
                                                    try {
                                                        let data = JSON.parse(response.body);
                                                        delete data.cspId;
                                                        delete data.mock;
                                                        delete data.resellerId;
                                                        if (data.campaignId && data.campaignId !== undefined) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Campaign Details Fetched successfully!", data: data, status: 200 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: data[0].field + " " + data[0].description, error: data, status: data[0].code });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Campaign Detail!", error: error, status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Campaign Detail Not Found!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /****************
    * 's AutoRenual *
    ****************/
    updateCamapign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let reqData = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
                        let swagger = req.body.data !== undefined ? "false" : "true";
                        // console.log(JSON.parse(req.body.data).mainData,"JSON.parse(req.body.data).mainData")
                        let smkey = req.body.data !== undefined ? JSON.parse(req.body.data).campId : req.query.campaignId;
                        // let campId: any = req.body.data !== undefined ? JSON.parse(req.body.data).campID : req.query.campaignId;
                        let iduser = req.body.data !== undefined ? JSON.parse(req.body.data).idaccount : sessdata.idaccount;
                        var resultAllCampaign = [];
                        for (var i in reqData) {
                            // reqData[i] !== '' &&
                            if (reqData[i] !== 'undefined') {
                                resultAllCampaign.push([i, reqData[i]]);
                            }
                        }
                        let campData = Object.fromEntries(resultAllCampaign);
                        /*let message: any = '';
                         const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
                        switch (true) {
                            case (!smkey || smkey == '' || smkey == 'null' || smkey == 'undefined'):
                                message = "Campaign Key/SM Reference No is required!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(smkey)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            case (Object.keys(campData).some(key => typeof campData[key] == 'string' && campData[key].trim() != '' && !prgmch.test(campData[key]))):
                                {
                                    for (const key in campData) {
                                        if (typeof campData[key] == 'string' && campData[key].trim() != '' && !prgmch.test(campData[key])) {
                                            message = `Invalid value for "${key}".`;
                                            break;
                                        }
                                    }
                                }
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        } else { */
                        if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                            campData.optinKeywords = campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                        }
                        if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                            campData.optoutKeywords = campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                        }
                        if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                            campData.helpKeywords = campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                        }
                        // let result = campId.substring(0, 2);
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `campaign_key`,`sm_reference_no`,`provisioning_status`, `subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`noEmbeddedLink`,`noEmbeddedPhone`,`numberPool`,`ageGated`,`directLending`, `camp_reseller_unique_id`,`status` FROM `campaign` WHERE (`campaign_key`='" + smkey + "' OR `sm_reference_no`='" + smkey + "') AND `idaccount`=" + iduser + "";
                        obj0.prepare();
                        obj0.execute((errr, result) => {
                            if (result.length > 0) {
                                let subscriberOptin = (campData.subscriberOptin !== undefined && campData.subscriberOptin !== '') ? campData.subscriberOptin : result[0].subscriberOptin;
                                let subscriberOptout = (campData.subscriberOptout !== undefined && campData.subscriberOptout !== '') ? campData.subscriberOptout : result[0].subscriberOptout;
                                let subscriberHelp = (campData.subscriberHelp !== undefined && campData.subscriberHelp !== '') ? campData.subscriberHelp : result[0].subscriberHelp;
                                let numberPool = (campData.numberPool !== undefined && campData.numberPool !== '') ? campData.numberPool : result[0].numberPool;
                                let ageGated = (campData.ageGated !== undefined && campData.ageGated !== '') ? campData.ageGated : result[0].ageGated;
                                let directLending = (campData.directLending !== undefined && campData.directLending !== '') ? campData.directLending : result[0].directLending;
                                let noEmbeddedLink = (campData.embeddedLink !== undefined && campData.embeddedLink !== '') ? campData.embeddedLink : result[0].noEmbeddedLink;
                                let noEmbeddedPhone = (campData.embeddedPhone !== undefined && campData.embeddedPhone !== '') ? campData.embeddedPhone : result[0].noEmbeddedPhone;
                                let resselerid = (result[0].camp_reseller_unique_id !== undefined && result[0].camp_reseller_unique_id !== '') ? result[0].camp_reseller_unique_id : '';
                                campData.resellerId = resselerid;
                                if (result.length > 0) {
                                    if (result[0].campaign_key && result[0].campaign_key != 'null' && result[0].campaign_key != 'undefined' && result[0].provisioning_status !== 5) {
                                        if (result[0].provisioning_status !== 7) {
                                            // Campaign Update to Third Party
                                            if (result[0].status == 3) {
                                                let fun = new NewCampaign();
                                                fun.campaignUpdatePFT(req, res, sessdata, result, null, campData, smkey, iduser, next);
                                            }
                                            else {
                                                let fun = new NewCampaign();
                                                fun.campaignUpdateTCR(req, res, sessdata, result, null, campData, smkey, iduser, next);
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 501, message: "You can't update campaign please contact to Adminstration" });
                                            objv.execute();
                                        }
                                    }
                                    else if (result[0].provisioning_status == 5) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `campaign` SET `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "',`sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "',`sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "',`sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "',`sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "',`sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "',`helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "',`optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "',`optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "',`helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "',`optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "',`optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "',`autoRenewal`='" + campData.autoRenewal + "',`subscriberOptin`='" + setDefaultFalse(subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(subscriberHelp) + "',`noEmbeddedLink`='" + setDefaultFalse(noEmbeddedLink) + "',`noEmbeddedPhone`='" + setDefaultFalse(noEmbeddedPhone) + "',`numberPool`='" + setDefaultFalse(numberPool) + "',`ageGated`='" + setDefaultFalse(ageGated) + "',`directLending`='" + setDefaultFalse(directLending) + "',`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "',`camp_reseller_unique_id`='" + campData.resselerid + "', `updated_at`=NOW() WHERE `sm_reference_no`='" + smkey + "' AND `idaccount`='" + iduser + "' AND `deleted`=0";
                                        obj.prepare();
                                        obj.execute((___error, resp) => {
                                            if (___error == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 200, message: "Campaign details Updated Successfully!" });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Campaign details Not updated!", status: 501 });
                                                objv.execute();
                                            }
                                        });
                                        // To update did pft
                                        if (campData.pftnumber.length > 0) {
                                            let objp = new RawQuery_1.ModelRawQuery(req, res);
                                            objp.qrysql = "SELECT `iduser`,`idaccount`,`pft_id` FROM `did_pft` WHERE `sm_reference_no` ='" + smkey + "'";
                                            objp.prepare();
                                            objp.execute((error, result) => {
                                                if (error == 1 && result.length > 0) {
                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "DELETE FROM `did_pft` WHERE `sm_reference_no` ='" + smkey + "'";
                                                    obj11.prepare();
                                                    obj11.execute((__error, lastid) => {
                                                        let did = campData.pftnumber.length;
                                                        let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                        for (let i = 0; i < did; i++) {
                                                            let entry1 = campData.pftnumber[i];
                                                            numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + smkey + "','" + entry1 + "'),";
                                                        }
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = numberqry.slice(0, -1);
                                                        obj1.prepare();
                                                        obj1.execute((_error, data) => {
                                                            if (_error == 1) {
                                                                console.log("Number update successfully!");
                                                            }
                                                        });
                                                    });
                                                }
                                                else {
                                                    let did = campData.pftnumber.length;
                                                    let numberqry = "INSERT INTO `did_pft` (`iduser`,`idaccount`,`sm_reference_no`, `did`) VALUES";
                                                    for (let i = 0; i < did; i++) {
                                                        let entry1 = campData.pftnumber[i];
                                                        numberqry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + smkey + "','" + entry1 + "'),";
                                                    }
                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = numberqry.slice(0, -1);
                                                    obj1.prepare();
                                                    obj1.execute((_error, data) => {
                                                        if (_error == 1) {
                                                            console.log("number insert successfully!");
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                        // To Campaign Log Update
                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + smkey + "','3','Campaign Updated','CAMPAIGN_UPDATED','Campaign Updated',2,'" + JSON.stringify(datasess) + "')";
                                        obj4.prepare();
                                        obj4.execute((campErr, __resp) => {
                                            if (campErr == 1) {
                                                console.log("Campaign Log Updated Successfully.");
                                            }
                                            else {
                                                console.log("Campaign Log Not Updated!");
                                            }
                                        });
                                    }
                                    else if ((result[0].provisioning_status == 0 || result[0].provisioning_status == 1 || result[0].provisioning_status == 2 || result[0].provisioning_status == 3 || result[0].provisioning_status == 4 || result[0].provisioning_status == 5 || result[0].provisioning_status == 7) && swagger == "false") {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `campaign` SET `autoRenewal`='" + campData.autoRenewal + "', `updated_at`=NOW()";
                                        obj.prepare();
                                        obj.execute((errr, resp) => {
                                            if (errr == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 200, message: "Campaign details Updated Successfully!" });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Campaign details Not updated!", status: 501 });
                                                objv.execute();
                                            }
                                        });
                                        // To Campaign Log Update
                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `sm_reference_no`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + smkey + "','3','Campaign Updated','CAMPAIGN_UPDATED','Campaign Updated',2,'" + JSON.stringify(datasess) + "')";
                                        obj4.prepare();
                                        obj4.execute((campErr, resp) => {
                                            if (campErr == 1) {
                                                console.log("Campaign Log Updated Successfully.");
                                            }
                                            else {
                                                console.log("Campaign Log Not Updated!");
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 501, message: "You can't update campaign please contact to Adminstration" });
                                        objv.execute();
                                    }
                                }
                            }
                        });
                        /* } */
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    campaignUpdateTCR(req, res, sessdata, result, provisioning_status, campData, smkey, iduser, next) {
        let con = provisioning_status !== null ? '`provisioning_status` = 0,' : '';
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let datasess = {
            iduser: sessdata.iduser,
            idaccount: sessdata.idaccount,
            ipAddress: sysInfo.ipAddress[0],
        };
        let options = {
            'method': 'PUT',
            'url': apiUrl + 'campaign/' + result[0].campaign_key,
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + authKey
            },
            body: JSON.stringify(campData)
        };
        (0, axios_1.request)(options, (error, response, body) => {
            if (!error) {
                try {
                    let resData = JSON.parse(response.body);
                    let escapedLog = JSON.stringify([response.body, datasess]);
                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                    resData.sm_reference_no = result[0].sm_reference_no;
                    if (resData.campaignId && resData.campaignId !== undefined) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `campaign` SET " + con + " `campaign_description`='" + (0, markError_1.parseBody)(resData.description) + "',`sample1`='" + (0, markError_1.parseBody)(resData.sample1) + "',`sample2`='" + (0, markError_1.parseBody)(resData.sample2) + "',`sample3`='" + (0, markError_1.parseBody)(resData.sample3) + "',`sample4`='" + (0, markError_1.parseBody)(resData.sample4) + "',`sample5`='" + (0, markError_1.parseBody)(resData.sample5) + "',`messageFlow`='" + (0, markError_1.parseBody)(resData.messageFlow) + "',`helpMessage`='" + (0, markError_1.parseBody)(resData.helpMessage) + "',`optinKeywords`='" + (0, markError_1.parseBody)(resData.optinKeywords) + "',`optoutKeywords`='" + (0, markError_1.parseBody)(resData.optoutKeywords) + "',`helpKeywords`='" + (0, markError_1.parseBody)(resData.helpKeywords) + "',`optinMessage`='" + (0, markError_1.parseBody)(resData.optinMessage) + "',`optoutMessage`='" + (0, markError_1.parseBody)(resData.optoutMessage) + "',`autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "',`subscriberOptin`='" + setDefaultFalse(resData.subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(resData.subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(resData.subscriberHelp) + "',`noEmbeddedLink`='" + setDefaultFalse(resData.embeddedLink) + "',`noEmbeddedPhone`='" + setDefaultFalse(resData.embeddedPhone) + "',`termsAndConditions`='" + setDefaultFalse(resData.termsAndConditions) + "',`numberPool`='" + setDefaultFalse(resData.numberPool) + "',`ageGated`='" + setDefaultFalse(resData.ageGated) + "',`directLending`='" + setDefaultFalse(resData.directLending) + "',`nextRenewalOrExpirationDate`='" + resData.nextRenewalOrExpirationDate + "',`billedDate`='" + resData.billedDate + "',`createDate`='" + resData.createDate + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "',`camp_reseller_unique_id`='" + campData.resellerId + "', `updated_at`=NOW() WHERE `campaign_key`='" + result[0].campaign_key + "' AND `idaccount`='" + iduser + "'";
                        obj.prepare();
                        obj.execute((___error, resp) => {
                            if (!error) {
                                delete resData.cspId;
                                delete resData.mock;
                                delete resData.resellerId;
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: resData });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Campaign details Not updated!", data: resData, status: 501 });
                                objv.execute();
                            }
                        });
                        // To Campaign Log Update
                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`, `sm_reference_no`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + result[0].campaign_key + "','" + result[0].sm_reference_no + "', '3','Campaign Updated','CAMPAIGN_UPDATED','Campaign Updated',2,'" + combinedLog + "')";
                        obj4.prepare();
                        obj4.execute((campErr, __resp) => {
                            if (campErr == 1) {
                                console.log("Campaign Log Updated Successfully.");
                            }
                            else {
                                console.log("Campaign Log Not Updated!");
                            }
                        });
                    }
                    else {
                        // To Campaign Log Update
                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`sm_reference_no`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + result[0].campaign_key + "','" + result[0].sm_reference_no + "','4','Campaign Update Failed','CAMPAIGN_UPDATE_FAILED','Campaign Update Failed',2,'" + combinedLog + "')";
                        obj4.prepare();
                        obj4.execute((campErr, __resp) => {
                            if (campErr == 1) {
                                console.log("Campaign Log Updated Successfully.");
                            }
                            else {
                                console.log("Campaign Log Not Updated!");
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                        objv.execute();
                    }
                }
                catch (e) {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                objv.execute();
            }
        });
    }
    campaignUpdatePFT(req, res, sessdata, result, provisioning_status, campData, smkey, iduser, next) {
        let con = provisioning_status !== null ? '`provisioning_status` = 0,' : '';
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let datasess = {
            iduser: sessdata.iduser,
            idaccount: sessdata.idaccount,
            ipAddress: sysInfo.ipAddress[0],
        };
        let escapedLog = JSON.stringify([req.body, datasess]);
        let combinedLog = escapedLog.replace(/'/g, "\\'");
        campData.sm_reference_no = result[0].sm_reference_no;
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "UPDATE `campaign` SET " + con + " `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "',`sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "',`sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "',`sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "',`sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "',`sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "',`helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "',`optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "',`optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "',`helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "',`optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "',`optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "',`autoRenewal`='" + campData.autoRenewal + "',`subscriberOptin`='" + setDefaultFalse(result[0].subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(result[0].subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(result[0].subscriberHelp) + "',`noEmbeddedLink`='" + setDefaultFalse(result[0].embeddedLink) + "',`noEmbeddedPhone`='" + setDefaultFalse(result[0].embeddedPhone) + "',`termsAndConditions`='" + setDefaultFalse(result[0].termsAndConditions) + "',`numberPool`='" + setDefaultFalse(result[0].numberPool) + "',`ageGated`='" + setDefaultFalse(result[0].ageGated) + "',`directLending`='" + setDefaultFalse(result[0].directLending) + "',`billedDate`=NOW(),`createDate`=NOW() ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "',`camp_reseller_unique_id`='" + campData.resellerId + "', `updated_at`=NOW() WHERE `campaign_key`='" + result[0].campaign_key + "' AND `idaccount`='" + iduser + "'";
        obj.prepare();
        obj.execute((error, resp) => {
            if (error == 1) {
                delete campData.resellerId;
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: campData });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Campaign details Not updated!", data: campData, status: 501 });
                objv.execute();
            }
        });
        // To Campaign Log Update
        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`, `sm_reference_no`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + result[0].campaign_key + "','" + result[0].sm_reference_no + "', '3','Campaign Updated','CAMPAIGN_UPDATED','Campaign Updated',2,'" + combinedLog + "')";
        obj4.prepare();
        obj4.execute((campErr, __resp) => {
            if (campErr == 1) {
                console.log("Campaign Log Updated Successfully.");
            }
            else {
                console.log("Campaign Log Not Updated!");
            }
        });
    }
    campaResellerMap(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if(sessdata.type == 1){
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let resellerid = Array.isArray(sdata.selectedResellers) && sdata.selectedResellers.length > 0 ? sdata.selectedResellers[0].camp_reseller_unique_id : '';
                        if (sdata.campId && sdata.campId.startsWith("C")) {
                            let campData = {
                                resellerId: resellerid,
                                campaign_key: sdata.campId
                            };
                            let options = {
                                'method': 'PUT',
                                'url': apiUrl + 'campaign/' + sdata.campId,
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                },
                                body: JSON.stringify(campData)
                            };
                            (0, axios_1.request)(options, (error, response, body) => {
                                if (!error) {
                                    try {
                                        let resData = JSON.parse(response.body);
                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                        if (resData.campaignId && resData.campaignId !== undefined) {
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `campaign` SET `camp_reseller_unique_id`='" + resData.resellerId + "', `updated_at`=NOW() WHERE `campaign_key`='" + resData.campaignId + "' AND `idaccount`='" + sdata.idaccount + "'";
                                            obj.prepare();
                                            obj.execute((___error, resp) => {
                                                if (!error) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 200, message: "Campaign Reseller Mapped Successfully!", data: resData });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Campaign Reseller Not Mapped!", data: resData, status: 501 });
                                                    objv.execute();
                                                }
                                            });
                                            // To Campaign Log Update
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`, `sm_reference_no`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaign_key + "','" + sdata.smId + "', '47','Campaign Updated','CAMPAIGN_RESELLER_MAPPED','Campaign Reseller Mapped',2,'" + combinedLog + "')";
                                            obj4.prepare();
                                            obj4.execute((campErr, __resp) => {
                                                if (campErr == 1) {
                                                    console.log("Campaign Log Updated Successfully.");
                                                }
                                                else {
                                                    console.log("Campaign Log Not Updated!");
                                                }
                                            });
                                        }
                                        else {
                                            const fields = `${resData.flatMap((item) => item.fields).join(', ')}`;
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: fields + ' ' + resData[0].description, status: resData[0].code });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error campaResellerMap :: ", e);
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new _406_1.Res406(res);
                            objv.prepare({ status: 404, message: "This campaign is not registered!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*******************************
    *  Update Campaign's AutoRenual*
    *******************************/
    updateAutoRenualCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let reqData = req.body;
                        console.log(reqData);
                        let campId = req.query.campaignId;
                        let iduser = sessdata.idaccount;
                        var reqCampaign = [];
                        let message = '';
                        switch (true) {
                            case (![true, false, 'true', 'false'].includes(reqData.autoRenewal)):
                                message = "autoRenewal must be true/false!";
                                break;
                            case (!campId || campId == '' || campId == 'null' || campId == 'undefined'):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!/^C[A-Z0-9]{6}$/.test(campId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C'!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        }
                        else {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `campaign_key`,`status` FROM `campaign` WHERE `campaign_key`='" + campId + "'";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    if (result[0].status == '3') {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `campaign` SET `autoRenewal`='" + reqData.autoRenewal + "', `updated_at`=NOW() WHERE `campaign_key`='" + campId + "' AND `idaccount`=" + iduser + " AND `deleted`=0";
                                        obj.prepare();
                                        obj.execute((error1, resp) => {
                                            if (error1 == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 200, message: "Auto Renewal Updated Successfully!", });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Auto Renewal Not updated", data: resp, status: 501 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        for (var i in reqData) {
                                            if (reqData[i] !== '' && reqData[i] !== 'undefined') {
                                                reqCampaign.push([i, reqData[i]]);
                                            }
                                        }
                                        let campData = Object.fromEntries(reqCampaign);
                                        let options = {
                                            'method': 'PUT',
                                            'url': apiUrl + 'campaign/' + campId,
                                            'headers': {
                                                'Content-Type': 'application/json',
                                                'Authorization': 'Basic ' + authKey
                                            },
                                            body: JSON.stringify(campData)
                                        };
                                        (0, axios_1.request)(options, (error, response, body) => {
                                            if (!error) {
                                                try {
                                                    let resData = JSON.parse(response.body);
                                                    if (resData.campaignId && resData.campaignId !== undefined) {
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `campaign` SET `autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "', `updated_at`=NOW() WHERE `campaign_key`='" + campId + "' AND `idaccount`=" + iduser + " AND `deleted`=0";
                                                        obj.prepare();
                                                        obj.execute((___error, resp) => {
                                                            if (!error) {
                                                                delete resData.cspId;
                                                                delete resData.mock;
                                                                delete resData.resellerId;
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 200, message: "Auto Renewal Updated Successfully!", data: resData });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Auto Renewal Not updated", data: resData, status: 501 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                                                        objv.execute();
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error :: updateAutoRenualCampaign ::", e);
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong with campaign", status: 501 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let fun = new NewCampaign();
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let smCampID = req.query && req.query.data && req.query.data !== undefined ? req.query.data : req.query.campaignId;
                        let message = '';
                        switch (true) {
                            case (!smCampID || smCampID == '' || smCampID == 'null' || smCampID == 'undefined'):
                                message = "Campaign Key/SM Reference No is required!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(smCampID)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 400, message: message });
                            objv.execute();
                        }
                        else {
                            // if (!smCampID) {
                            //     let objv = new RawView(res);
                            //     objv.prepare({ status: 400, message: "Campaign Key/SM Reference No is required" });
                            //     objv.execute();
                            //     return;
                            // }
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `iduser`,`idaccount`, `campaign_key`,`sm_reference_no`,`provisioning_status`,`usecase` FROM `campaign` WHERE (`campaign_key`='" + smCampID + "' OR `sm_reference_no`='" + smCampID + "')";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1 && result.length > 0) {
                                    let otherPayLoad = {
                                        sm_reference_no: result[0].sm_reference_no,
                                        campaign_key: result[0].campaign_key,
                                        provisioning_status: result[0].provisioning_status,
                                        usecase: result[0].usecase,
                                    };
                                    if (sessdata.type == 1) {
                                        let userPayLoad1 = {
                                            iduser: result[0].iduser,
                                            idaccount: result[0].idaccount
                                        };
                                        let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                                        fun.deleteCampaignIn(req, res, userPayLoad, otherPayLoad, next);
                                    }
                                    else {
                                        let userPayLoad = {
                                            iduser: sessdata.iduser,
                                            idaccount: sessdata.idaccount
                                        };
                                        fun.deleteCampaignIn(req, res, userPayLoad, otherPayLoad, next);
                                    }
                                }
                                else {
                                    let objvs = new RawView_1.RawView(res);
                                    objvs.prepare({ status: 504, message: "Something went wrong with get campaign detail!" });
                                    objvs.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteCampaignIn(req, res, userPayLoad, otherPayLoad, next) {
        let condition = '';
        if (otherPayLoad.campaign_key && otherPayLoad.campaign_key !== null && otherPayLoad.sm_reference_no) {
            if (otherPayLoad.usecase == 'TRIAL') {
                condition += "`campaign_key`='" + otherPayLoad.campaign_key + "'";
                let fun = new NewCampaign();
                fun.callforDeleteCamp(req, res, otherPayLoad.campaign_key, condition, 'campaign_key', userPayLoad, next);
            }
            else {
                let options = {
                    'method': 'DELETE',
                    'url': apiUrl + 'campaign/' + otherPayLoad.campaign_key,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                (0, axios_1.request)(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if ((response.statusCode == 204 && response.statusCode !== undefined) || (JSON.parse(body)[0].code == 502 && JSON.parse(body)[0].code !== undefined)) {
                                condition += "`campaign_key`='" + otherPayLoad.campaign_key + "'";
                                let fun = new NewCampaign();
                                fun.callforDeleteCamp(req, res, otherPayLoad.campaign_key, condition, 'campaign_key', userPayLoad, next);
                            }
                            else {
                                let data = JSON.parse(body);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: data[0].field + ' ' + data[0].description,
                                    status: data[0].code
                                });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Campaign Not Deleted!", status: 502 });
                        objv.execute();
                    }
                });
            }
        }
        else {
            condition += "`sm_reference_no`='" + otherPayLoad.sm_reference_no + "'";
            let fun = new NewCampaign();
            fun.callforDeleteCamp(req, res, otherPayLoad.sm_reference_no, condition, 'sm_reference_no', userPayLoad, next);
        }
    }
    callforDeleteCamp(req, res, smCampID, condition, types, userPayLoad, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `campaign` SET `deleted`=1, `delete_date`=NOW(), `updated_at`=NOW() WHERE " + condition + "";
                obj.prepare();
                obj.execute((__error, camp) => {
                    if (__error == 1) {
                        obj.nonqrysql = "DELETE FROM `brand_log` WHERE " + condition + " ";
                        obj.prepare();
                        obj.execute((__error, lastid) => {
                            if (__error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Campaign Deactivated Successfully!", campaignId: smCampID, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                        // To Campaign Log Update
                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `" + types + "`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + userPayLoad.idaccount + "', '" + userPayLoad.iduser + "','" + smCampID + "','7','Camapaign Removed','CAMPAIGN_REMOVED','Camapaign Removed','" + JSON.stringify(datasess) + "')";
                        obj4.prepare();
                        obj4.execute((campErr, __resp) => {
                            if (campErr == 1) {
                                console.log("Campaign Log Updated Successfully.");
                            }
                            else {
                                console.log("Campaign Log Not Updated!");
                            }
                        });
                    }
                    else {
                        // To Campaign Log Update
                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `" + types + "`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + userPayLoad.idaccount + "', '" + userPayLoad.iduser + "','" + smCampID + "','8','Camapaign Remove Failed','CAMPAIGN_REMOVED_FAILED','Campaign Removed Failed','" + JSON.stringify(datasess) + "')";
                        obj4.prepare();
                        obj4.execute((campErr, __resp) => {
                            if (campErr == 1) {
                                console.log("Campaign Log Updated Successfully.");
                            }
                            else {
                                console.log("Campaign Log Not Updated!");
                            }
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Campaign Not Deleted!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************************************
       *Start Resubmit Campaign  *
       *********************************************/
    resubmitCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = JSON.parse(req.body.data);
                let campID = sdata.campId;
                // let mnoDetail:any =[];
                let mnoDetail = sdata.mnodetail;
                //  let resultAllBrand:any = [];
                // mnoDetail.forEach((campaignmnoData: any) => {
                //     resultAllBrand.push(campaignmnoData.campaign_class); 
                // })
                // let mnoData = resultAllBrand;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let idaccount = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                let iduser = sessdata.type == 1 ? sdata.iduser : sessdata.iduser;
                if (sdata.mnoMetadata) {
                    let fun = new NewCampaign();
                    fun.resubmitPFTCampaign(req, res, sdata, datasess, idaccount, iduser, next);
                }
                else {
                    let options = {
                        'method': 'PUT',
                        'url': apiUrl + 'campaign/' + campID + '/resubmit',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify({ 'mnoIds': mnoDetail })
                    };
                    (0, axios_1.request)(options, (err, response, body) => {
                        if (!err) {
                            try {
                                let resData = JSON.parse(response.body);
                                let escapedLog = JSON.stringify([response.body, datasess]);
                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                if (resData.campaignId) {
                                    let tmp = [];
                                    Object.entries(resData.mnoMetadata).forEach((ele) => {
                                        let t = ele[1];
                                        t["class"] = ele[0];
                                        tmp.push(t);
                                    });
                                    let campaignMNOData1 = tmp;
                                    campaignMNOData1.forEach((mnoData) => {
                                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj0.qrysql = "SELECT `campaign_class` FROM `campaign_mno` WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `idaccount`=" + idaccount + " ";
                                        obj0.prepare();
                                        obj0.execute((error, result) => {
                                            if (error == 1) {
                                                if (result.length > 0) {
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    // obj.nonqrysql = "UPDATE `campaign` SET `tpmScope`='" + mnoData.tpmScope + "', `minMsgSamples`='" + mnoData.minMsgSamples + "',`msgClass`='" + mnoData.msgClass + "',`reqSubscriberOptout`='" + mnoData.reqSubscriberOptout + "',`mnoReview`='" + mnoData.mnoReview + "',`mmsTpm`='" + mnoData.mmsTpm + "',`noEmbeddedPhoneForMNO`='" + mnoData.noEmbeddedPhone + "',`mno`='" + mnoData.mno + "',`tpm`='" + mnoData.tpm + "',`reqSubscriberHelp`='" + mnoData.reqSubscriberHelp + "',`reqSubscriberOptin`='" + mnoData.reqSubscriberOptin + "',`mnoSupport`='" + mnoData.mnoSupport + "',`noEmbeddedLinkForMNO`='" + mnoData.noEmbeddedLink + "',`qualify`='" + mnoData.qualify + "',`campaign_class`='" + mnoData.class + "',`brandDailyCap`='" + mnoData.brandDailyCap + "',`brandTier`='" + mnoData.brandTier + "' WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `iduser`='" + sessdata.iduser + "'";
                                                    obj.nonqrysql = "UPDATE `campaign_mno` SET `campaign_class`='" + mnoData.class + "',`minMsgSamples`='" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "',`mno`='" + mnoData.mno + "',`mnoReview`='" + setDefaultFalse(mnoData.mnoReview) + "',`mnoSupport`='" + setDefaultFalse(mnoData.mnoSupport) + "',`msgClass`='" + mnoData.msgClass + "',`noEmbeddedLink`='" + setDefaultFalse(mnoData.noEmbeddedLink) + "',`noEmbeddedPhone`='" + setDefaultFalse(mnoData.noEmbeddedPhone) + "',`qualify`='" + setDefaultFalse(mnoData.qualify) + "',`reqSubscriberHelp`='" + setDefaultFalse(mnoData.reqSubscriberHelp) + "',reqSubscriberOptin='" + setDefaultFalse(mnoData.reqSubscriberOptin) + "',reqSubscriberOptout='" + setDefaultFalse(mnoData.reqSubscriberOptout) + "',`brandTier`='" + mnoData.brandTier + "',`tpm`='" + (0, markError_1.setToZero)(mnoData.tpm) + "',`mmsTpm`='" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "',`tpmScope`='" + mnoData.tpmScope + "',`brandDailyCap`='" + mnoData.brandDailyCap + "'  WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `idaccount`=" + idaccount + " ";
                                                    // obj.nonqrysql = obj.slice(0, -1);
                                                    obj.prepare();
                                                    obj.execute((errorr, data) => {
                                                        if (errorr == 1) {
                                                            console.log("Mno Update Successfully");
                                                        }
                                                        else {
                                                            console.log("Mno Not Updated");
                                                        }
                                                    });
                                                }
                                                else {
                                                    let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj01.nonqrysql = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`campaign_key`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES(" + iduser + "," + idaccount + ", '" + campID + "', '" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData?.mno + "', '" + setDefaultFalse(mnoData?.mnoReview) + "', '" + setDefaultFalse(mnoData?.mnoSupport) + "', '" + mnoData?.msgClass + "','" + setDefaultFalse(mnoData?.noEmbeddedLink) + "','" + setDefaultFalse(mnoData?.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData?.qualify) + "', '" + setDefaultFalse(mnoData?.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData?.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData?.reqSubscriberOptout) + "','" + mnoData?.brandTier + "','" + (0, markError_1.setToZero)(mnoData?.tpm) + "','" + (0, markError_1.setToZero)(mnoData?.mmsTpm) + "','" + mnoData?.tpmScope + "','" + mnoData?.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData?.surcharge) + "','" + (0, markError_1.setToZero)(mnoData?.tpn) + "','REGISTERED',0)";
                                                    obj01.prepare();
                                                    obj01.execute((errorr, campMnoData) => {
                                                    });
                                                }
                                            }
                                            else {
                                                console.log({ message: "Something Went Wrong with finding MNOs!", status: 504 });
                                            }
                                        });
                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES (" + idaccount + ", " + iduser + ",'" + campID + "',5,'Campaign Re-Submitted','CAMPAIGN_RESUBMITTED','Campaign Re-Submitted','" + combinedLog + "')";
                                        obj4.prepare();
                                        obj4.execute((campErr, resp) => {
                                            if (campErr == 1) {
                                                console.log("Campaign Log Updated Successfully.");
                                            }
                                            else {
                                                console.log("Campaign Log Not Updated!");
                                            }
                                        });
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Campaign Resubmit Successfully!", campaignId: campID, status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES (" + idaccount + ", " + iduser + ",'" + campID + "',6,'Campaign Re-Submit Failed','CAMPAIGN_RESUBMITTED_FAILED','Campaign Re-Submit Failed','" + combinedLog + "')";
                                    obj4.prepare();
                                    obj4.execute((campErr, resp) => {
                                        if (campErr == 1) {
                                            console.log("Campaign Log Updated Successfully.");
                                        }
                                        else {
                                            console.log("Campaign Log Not Updated!");
                                        }
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: resData[0].description, status: 502 });
                                    objv.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: resubmitCampaign ::", e);
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    resubmitPFTCampaign(req, res, sdata, datasess, idaccount, iduser, next) {
        // let sdata: any = JSON.parse(req.body.data);
        // let campID = sdata.campId;
        // let mnoDetail = sdata.mnodetail;
        // let sysInfo = ipAddressAndBrowser(req);
        // let datasess: any = {
        //     iduser: sessdata.iduser,
        //     idaccount: sessdata.idaccount,
        //     ipAddress: sysInfo.ipAddress[0],
        // }
        let escapedLog = JSON.stringify([req.body, datasess]);
        let combinedLog = escapedLog.replace(/'/g, "\\'");
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `campaign_key`,`sm_reference_no` FROM `campaign` WHERE (`sm_reference_no`='" + sdata.campId + "' OR `campaign_key`='" + sdata.campId + "') AND `deleted`='0'";
        obj0.prepare();
        obj0.execute((error, result) => {
            if (error == 1 && result.length > 0) {
                if (result[0].campaign_key) {
                    let tmp = [];
                    Object.entries(mnoTrial.data).forEach((ele) => {
                        let t = ele[1];
                        t["class"] = ele[0];
                        tmp.push(t);
                    });
                    let campaignMNOData1 = tmp;
                    campaignMNOData1.forEach((mnoData) => {
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `campaign_class` FROM `campaign_mno` WHERE `campaign_key`='" + sdata.campId + "' AND `campaign_class`='" + mnoData.class + "' AND `idaccount`=" + idaccount + " ";
                        obj0.prepare();
                        obj0.execute((error, result) => {
                            if (error == 1) {
                                if (result.length > 0) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `campaign_mno` SET `campaign_class`='" + mnoData.class + "',`minMsgSamples`='" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "',`mno`='" + mnoData.mno + "',`mnoReview`='" + setDefaultFalse(mnoData.mnoReview) + "',`mnoSupport`='" + setDefaultFalse(mnoData.mnoSupport) + "',`msgClass`='" + mnoData.msgClass + "',`noEmbeddedLink`='" + setDefaultFalse(mnoData.noEmbeddedLink) + "',`noEmbeddedPhone`='" + setDefaultFalse(mnoData.noEmbeddedPhone) + "',`qualify`='" + setDefaultFalse(mnoData.qualify) + "',`reqSubscriberHelp`='" + setDefaultFalse(mnoData.reqSubscriberHelp) + "',reqSubscriberOptin='" + setDefaultFalse(mnoData.reqSubscriberOptin) + "',reqSubscriberOptout='" + setDefaultFalse(mnoData.reqSubscriberOptout) + "',`brandTier`='" + mnoData.brandTier + "',`tpm`='" + (0, markError_1.setToZero)(mnoData.tpm) + "',`mmsTpm`='" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "',`tpmScope`='" + mnoData.tpmScope + "',`brandDailyCap`='" + mnoData.brandDailyCap + "'  WHERE `campaign_key`='" + sdata.campId + "' AND `campaign_class`='" + mnoData.class + "' AND `idaccount`=" + idaccount + " ";
                                    obj.prepare();
                                    obj.execute((errorr, data) => {
                                        if (errorr == 1) {
                                            console.log("Mno Update Successfully");
                                        }
                                        else {
                                            console.log("Mno Not Updated");
                                        }
                                    });
                                }
                                else {
                                    let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj01.nonqrysql = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`campaign_key`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES(" + iduser + "," + idaccount + ", '" + sdata.campId + "', '" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData?.mno + "', '" + setDefaultFalse(mnoData?.mnoReview) + "', '" + setDefaultFalse(mnoData?.mnoSupport) + "', '" + mnoData?.msgClass + "','" + setDefaultFalse(mnoData?.noEmbeddedLink) + "','" + setDefaultFalse(mnoData?.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData?.qualify) + "', '" + setDefaultFalse(mnoData?.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData?.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData?.reqSubscriberOptout) + "','" + mnoData?.brandTier + "','" + (0, markError_1.setToZero)(mnoData?.tpm) + "','" + (0, markError_1.setToZero)(mnoData?.mmsTpm) + "','" + mnoData?.tpmScope + "','" + mnoData?.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData?.surcharge) + "','" + (0, markError_1.setToZero)(mnoData?.tpn) + "','REGISTERED',0)";
                                    obj01.prepare();
                                    obj01.execute((errorr, campMnoData) => {
                                    });
                                }
                            }
                            else {
                                console.log({ message: "Something Went Wrong with finding MNOs!", status: 504 });
                            }
                        });
                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES (" + idaccount + ", " + iduser + ",'" + sdata.campId + "',5,'Campaign Re-Submitted','CAMPAIGN_RESUBMITTED','Campaign Re-Submitted','" + combinedLog + "')";
                        obj4.prepare();
                        obj4.execute((campErr, resp) => {
                            if (campErr == 1) {
                                console.log("Campaign Log Updated Successfully.");
                            }
                            else {
                                console.log("Campaign Log Not Updated!");
                            }
                        });
                    });
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Campaign Resubmit Successfully!", campaignId: sdata.campId, status: 201 });
                    objv.execute();
                }
                else {
                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES (" + idaccount + ", " + iduser + ",'" + sdata.campId + "',6,'Campaign Re-Submit Failed','CAMPAIGN_RESUBMITTED_FAILED','Campaign Re-Submit Failed','" + combinedLog + "')";
                    obj4.prepare();
                    obj4.execute((campErr, resp) => {
                        if (campErr == 1) {
                            console.log("Campaign Log Updated Successfully.");
                        }
                        else {
                            console.log("Campaign Log Not Updated!");
                        }
                    });
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Resubmit is not possible because campaign key not found", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 501, message: "Campaign not found or deleted" });
                objv.execute();
            }
        });
    }
    /*************************************************************************
    *******************************Campaign Event Log*************************
    **************************************************************************/
    getCampaignEvents(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query.type;
                let sdata = JSON.parse(data);
                let condition;
                let ext_field;
                if (sessdata.type == 1) {
                    ext_field = "idaccount, iduser,";
                }
                if (sdata.campaignIds && sdata.campaignkey) {
                    condition = "(sm_reference_no = '" + sdata.campaignIds + "' OR campaign_key = '" + sdata.campaignkey + "')";
                }
                else if (sdata.campaignIds || !sdata.campaignkey) {
                    condition = "sm_reference_no = '" + sdata.campaignIds + "'";
                }
                else if (sdata.campaignkey || !sdata.campaignIds) {
                    condition = "campaign_key = '" + sdata.campaignkey + "'";
                }
                else {
                    condition = "1=1";
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "SELECT " + ext_field + " campaign_key, date, event_type, webhook_event_type, (CASE WHEN webhook_description_detail IS NOT NULL THEN webhook_description_detail ELSE description END) AS webhook_description_detail, description FROM `campaign_log` WHERE `request_type` !=0 AND " + condition + " ORDER BY `idcampaign_log` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Events Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "No Event Fetched!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*************************************************************************
    * End Campaign Functionality *********************************************
    **************************************************************************/
    /*********************************************
    *Start get Tariff details based on TariffId  *
    *********************************************/
    getSubscriptionPlan(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = JSON.parse(data.type);
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT u.idtariff,t.name FROM `user`u INNER JOIN `tariff`t ON u.idtariff = t.idtariff WHERE u.`iduser`=" + sdata.iduser + " AND u.`idaccount` = " + sdata.idaccount + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Tariff Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched Tariff Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************************************
    *End get Tariff details based on TariffId    *
    *********************************************/
    // Start Create Campaign File Sample
    createCampaignFile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let campFileData = req.body.data;
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `campaign_file` (`mimeType`,`fileName`) VALUES ('" + campFileData.mimeType + "', '" + campFileData.fileName + "')";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT fileName FROM `campaign_file` WHERE `camp_file_id`=" + result.insertId + " ";
                        obj1.prepare();
                        obj1.execute((__error, CamFileRes) => {
                            if (__error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: CamFileRes,
                                    message: "Image Insert Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Record not found!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Insert Campaign File Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    appealRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errsess, sessdata) => {
            if (errsess == 1) {
                let appeal_rate = 11;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let sdata = JSON.parse(req.body.payload);
                let files = req.files.length;
                // let Obj = new ModelRawQuery(req, res);
                // Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 10";
                // Obj.prepare();
                // Obj.execute((walletError: any, wallet: any) => {
                //     if (walletError == 1 && wallet.length > 0) {
                rate.checkBalance(req, res, sessdata.idaccount, appeal_rate, (walletError, wallet) => {
                    if (walletError == 1) {
                        if (files > 0) {
                            let Obj_ap = new RawQuery_1.ModelRawQuery(req, res);
                            Obj_ap.qrysql = "SELECT `iduser`,`idaccount`,`identityStatus`, `brandId` FROM `brand` WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`= '" + sdata.brandId + "'";
                            Obj_ap.prepare();
                            Obj_ap.execute((result_appeal, result_ap) => {
                                if (result_appeal == 1 && result_ap.length > 0) {
                                    if (result_ap[0].identityStatus !== "VETTED_VERIFIED") {
                                        let evidence = new NewCampaign();
                                        evidence.evidenceRequest(req, res, sessdata, 'BrandAppeal', (errorr, resp) => {
                                            if (resp.status == 200) {
                                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj1.qrysql = "SELECT uuid from `evidence_files` WHERE `iduser`=" + sessdata.iduser + " AND `key`='" + resp.key + "' AND `brandId`='" + sdata.brandId + "'";
                                                obj1.prepare();
                                                obj1.execute((uuid_error, uuid_success) => {
                                                    let Resuuids = [];
                                                    Resuuids = JSON.parse(JSON.stringify(uuid_success));
                                                    const uuids = Resuuids.map((item) => item.uuid);
                                                    if (uuid_error == 1) {
                                                        var options = {
                                                            'method': 'POST',
                                                            'url': apiUrl + 'brand/' + sdata.brandId + '/appeal',
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'Authorization': 'Basic ' + authKey
                                                            },
                                                            body: JSON.stringify({
                                                                "appealCategories": sdata.category,
                                                                "attachmentUuids": uuids,
                                                                "explanation": sdata.explanation
                                                            })
                                                        };
                                                        (0, axios_1.request)(options, function (error, response) {
                                                            if (!error) {
                                                                try {
                                                                    let escapedLog = JSON.stringify([response.body, datasess]);
                                                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                                    // let appealRequest = JSON.parse(response.body);
                                                                    let appealRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                                    //if (error == null) {
                                                                    if (appealRequest == null || appealRequest == '') {
                                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','Pending',1,'Brand Appeal Requested Successfully','" + combinedLog + "')";
                                                                        obj4.prepare();
                                                                        obj4.execute((_err, result) => {
                                                                            console.log("Brand Appeal Log Updated");
                                                                        });
                                                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj2.nonqrysql = "INSERT INTO `brand_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`attachmentUuids`,`explanation`,`vetting_status`,`key`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','" + sdata.category + "','" + uuids + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending','" + resp.key + "')";
                                                                        obj2.prepare();
                                                                        obj2.execute((_err, result) => {
                                                                            if (_err == 1) {
                                                                                let payload = {
                                                                                    idaccount: sessdata.idaccount,
                                                                                    amount: appeal_rate,
                                                                                    purpose: 'brand appeal',
                                                                                    type: '-'
                                                                                };
                                                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                    console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                                });
                                                                                console.log("Brand Appeal Requested Successfully!");
                                                                                let objh = new RawView_1.RawView(res);
                                                                                objh.prepare({ status: 200, message: "Brand Appeal Requested Successfully!" });
                                                                                objh.execute();
                                                                            }
                                                                            else {
                                                                                console.log("Appeal Request Not Saved Successfully!!!");
                                                                                let objh = new RawView_1.RawView(res);
                                                                                objh.prepare({ status: 200, message: "Brand Appeal Request Raised But Not Saved!" });
                                                                                objh.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Appeal Request Failed','" + combinedLog + "')";
                                                                        obj.prepare();
                                                                        obj.execute((_err, result) => {
                                                                            console.log("Brand Log Updated");
                                                                        });
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 502, message: appealRequest[0].description });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: appealRequest ::", e);
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            }
                                                            else {
                                                                let obj = new RawView_1.RawView(res);
                                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                obj.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objk = new RawView_1.RawView(res);
                                                        objk.prepare({ status: 404, message: "UUID not found!" });
                                                        objk.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: resp.status, message: resp.message });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objk = new RawView_1.RawView(res);
                                        objk.prepare({ status: 405, message: "Appeals are limited to the entities with UNVERIFIED identity status" });
                                        objk.execute();
                                    }
                                }
                                else {
                                    let objk = new RawView_1.RawView(res);
                                    objk.prepare({ status: 406, message: "Brand Id Not Found!" });
                                    objk.execute();
                                }
                            });
                        }
                        else {
                            const options = {
                                'method': 'POST',
                                'url': apiUrl + 'brand/' + sdata.brandId + '/appeal',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                },
                                body: JSON.stringify({
                                    "appealCategories": sdata.category,
                                    "explanation": sdata.explanation
                                })
                            };
                            (0, axios_1.request)(options, function (error, response) {
                                if (!error) {
                                    try {
                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                        //let payloadResp = JSON.parse(response.body);
                                        let payloadResp = response.body == '' ? response.body : JSON.parse(response.body);
                                        //if (error == null) {
                                        if (payloadResp == null || payloadResp == '') {
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','Pending',1,'Brand Appeal Requested Successfully','" + combinedLog + "')";
                                            obj4.prepare();
                                            obj4.execute((_err, result) => {
                                                console.log("Brand Appeal Log Updated");
                                            });
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `brand_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`explanation`,`vetting_status`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','" + sdata.category + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending')";
                                            obj.prepare();
                                            obj.execute((_err, result) => {
                                                if (_err == 1) {
                                                    let payload = {
                                                        idaccount: sessdata.idaccount,
                                                        amount: appeal_rate,
                                                        purpose: 'brand appeal',
                                                        type: '-'
                                                    };
                                                    rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                        console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                    });
                                                    console.log("Brand Appeal Requested Successfully!");
                                                    let objh = new RawView_1.RawView(res);
                                                    objh.prepare({ status: 200, message: "Brand Appeal Requested Successfully!" });
                                                    objh.execute();
                                                }
                                                else {
                                                    console.log("Brand Appeal Request Not Saved Successfully!!!");
                                                    let objh = new RawView_1.RawView(res);
                                                    objh.prepare({ status: 200, message: "Brand Appeal Request Raised But Not Saved. We will Fix it Soon!" });
                                                    objh.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Pending',4,'Brand Appeal Request Failed','" + combinedLog + "')";
                                            obj4.prepare();
                                            obj4.execute((_err, result) => {
                                                console.log("Brand Appeal Log Updated");
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: payloadResp[0].description });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: appealRequest ::", e);
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: walletError, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    appealVettingRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errsess, sessdata) => {
            if (errsess == 1) {
                let appealV_rate = 11;
                let sdata = JSON.parse(req.body.payload);
                let files = req.files.length;
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                // let obj1 = new ModelRawQuery(req, res);
                // obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 10"
                // obj1.prepare();
                // obj1.execute((walletError: any, wallet: any) => {
                //     if (walletError == 1 && wallet.length > 0) {
                rate.checkBalance(req, res, sessdata.idaccount, appealV_rate, (walletError, wallet) => {
                    if (walletError == 1) {
                        if (files > 0) {
                            let evidence = new NewCampaign();
                            evidence.evidenceRequest(req, res, sessdata, 'BrandVettingAppeal', (errorr, resp) => {
                                if (resp.status == 200) {
                                    let objv = new RawQuery_1.ModelRawQuery(req, res);
                                    objv.qrysql = "SELECT uuid from `evidence_files` WHERE `idaccount`=" + sessdata.idaccount + " AND `key`='" + resp.key + "' AND `brandId`='" + sdata.brandId + "'";
                                    objv.prepare();
                                    objv.execute((uuid_error, uuid_success) => {
                                        let Resuuids = [];
                                        Resuuids = JSON.parse(JSON.stringify(uuid_success));
                                        const uuids = Resuuids.map((item) => item.uuid);
                                        if (uuid_error == 1) {
                                            var options = {
                                                'method': 'POST',
                                                'url': apiUrl + 'brand/' + sdata.brandId + '/externalVetting/appeal',
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                },
                                                body: JSON.stringify({
                                                    "evpId": sdata.evpId,
                                                    "vettingId": sdata.vettingId,
                                                    "appealCategories": sdata.category,
                                                    "attachmentUuids": uuids,
                                                    "explanation": sdata.explanation,
                                                })
                                            };
                                            (0, axios_1.request)(options, function (error, response) {
                                                let escapedLog = JSON.stringify([response.body, datasess]);
                                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                if (!error) {
                                                    try {
                                                        let appealVettingRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                        if (appealVettingRequest == null || appealVettingRequest == '') {
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`vettingId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + sdata.vettingId + "','" + appealV_rate + "','Pending',1,'Brand Vetting Appeal Requested Successfully','" + combinedLog + "')";
                                                            obj4.prepare();
                                                            obj4.execute((_err, result) => {
                                                                console.log("Brand Vetting Appeal Log Updated");
                                                            });
                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "INSERT INTO `brand_vetting_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`attachmentUuids`,`explanation`,`vetting_status`,`key`,`evpId`,`vettingId`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appealV_rate + "','" + sdata.category + "','" + uuids + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending','" + resp.key + "','" + sdata.evpId + "','" + sdata.vettingId + "')";
                                                            obj.prepare();
                                                            obj.execute((_err, result) => {
                                                                if (_err == 1) {
                                                                    let payload = {
                                                                        idaccount: sessdata.idaccount,
                                                                        amount: appealV_rate,
                                                                        purpose: 'brand appeal',
                                                                        type: '-'
                                                                    };
                                                                    rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                        console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                    });
                                                                    console.log("Brand Vetting Appeal Request sent Successfully!");
                                                                    let objh = new RawView_1.RawView(res);
                                                                    objh.prepare({ status: 200, message: "Appeal Request sent Successfully!" });
                                                                    objh.execute();
                                                                }
                                                                else {
                                                                    console.log("Brand Vetting Appeal Request Not Saved Successfully!");
                                                                    let objh = new RawView_1.RawView(res);
                                                                    objh.prepare({ status: 200, message: "New Appeal Request Raised But Not Saved. We Will Fix it Soon!" });
                                                                    objh.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Vetting Appeal Requested Failed','" + combinedLog + "')";
                                                            obj4.prepare();
                                                            obj4.execute((_err, result) => {
                                                                console.log("Brand Vetting Appeal Log Updated");
                                                            });
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 502, message: appealVettingRequest[0].description });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: appealVettingRequest ::", e);
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objk = new RawView_1.RawView(res);
                                            objk.prepare({ status: 404, message: "UUID not found!" });
                                            objk.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: resp.status, message: resp.message });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            var options = {
                                'method': 'POST',
                                'url': apiUrl + 'brand/' + sdata.brandId + '/externalVetting/appeal',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                },
                                body: JSON.stringify({
                                    "evpId": sdata.evpId,
                                    "vettingId": sdata.vettingId,
                                    "appealCategories": sdata.category,
                                    "explanation": sdata.explanation,
                                })
                            };
                            (0, axios_1.request)(options, function (error, response) {
                                let escapedLog = JSON.stringify([response.body, datasess]);
                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                if (!error) {
                                    try {
                                        let appealVettingRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                        if (appealVettingRequest == null || appealVettingRequest == '') {
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`vettingId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + sdata.vettingId + "','" + appealV_rate + "','Pending',1,'Brand Vetting Appeal Requested Successfully','" + combinedLog + "')";
                                            obj4.prepare();
                                            obj4.execute((_err, result) => {
                                                console.log("Brand Log Updated");
                                            });
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `brand_vetting_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`explanation`,`vetting_status`,`evpId`,`vettingId`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appealV_rate + "','" + sdata.category + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending','" + sdata.evpId + "','" + sdata.vettingId + "')";
                                            obj.prepare();
                                            obj.execute((_err, result) => {
                                                if (_err == 1) {
                                                    let payload = {
                                                        idaccount: sessdata.idaccount,
                                                        amount: appealV_rate,
                                                        purpose: 'Brand Vetting Appeal Request',
                                                        type: '-'
                                                    };
                                                    rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                        console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                    });
                                                    console.log("Appeal Request sent Successfully!");
                                                    let objh = new RawView_1.RawView(res);
                                                    objh.prepare({ status: 200, message: "Appeal Request sent Successfully!" });
                                                    objh.execute();
                                                }
                                                else {
                                                    console.log("Brand Vetting Appeal Request Not Saved Successfully!!");
                                                    let objh = new RawView_1.RawView(res);
                                                    objh.prepare({ status: 200, message: "New Appeal Request Raised But Not Saved!" });
                                                    objh.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Vetting Appeal Requested Failed','" + combinedLog + "')";
                                            obj4.prepare();
                                            obj4.execute((_err, result) => {
                                                console.log("Brand Vetting Appeal Log Updated");
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: appealVettingRequest[0].description });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: AppealVettingRequest ::", e);
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error_code: 0, error: walletError, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 503 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    evidenceRequest(req, res, sessdata, type, callback) {
        let sdata = JSON.parse(req.body.payload);
        let files = [];
        files = req.files;
        let fileSizes = [];
        let key = Math.random().toString(36).slice(2);
        files.forEach((element, index) => {
            fileSizes.push(element.size);
        });
        const maxTotalFileSizeBytes = 30 * 1024 * 1024;
        const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
        const totalFiles = fileSizes.length;
        const totalFileSizeBytes = fileSizes.reduce((acc, fileSize) => acc + fileSize, 0);
        if (totalFiles <= 10 && totalFileSizeBytes <= maxTotalFileSizeBytes) {
            const individualFileLimitReached = fileSizes.every((fileSize) => fileSize <= maxIndividualFileSizeBytes);
            if (individualFileLimitReached) {
                var fs = require('fs');
                files.forEach((element, index) => {
                    let options = {
                        'method': 'POST',
                        'url': apiUrl + 'brand/' + sdata.brandId + '/appeal/evidence',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        formData: {
                            'file': {
                                'value': fs.createReadStream((element.path || '').replace(/^(\.\.[/\\])+/, '').split(/[\\/]/).pop()), 'options': {
                                    'filename': element.filename,
                                    'contentType': null
                                }
                            }
                        }
                    };
                    (0, axios_1.request)(options, function (error, response) {
                        console.log("evidenceRequest => error:", error);
                        console.log("evidenceRequest => response:", error, response.body);
                        if (!error) {
                            try {
                                let resp = JSON.parse(response.body);
                                let value = appealEvidence.fileEvidence + resp.fileName;
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `evidence_files` (`iduser`,`idaccount`,`brandId`,`uuid`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + resp.uuid + "','" + key + "','" + resp.mimeType + "','" + resp.fileName + "' ,'" + value + "', '" + type + "')";
                                obj.prepare();
                                obj.execute((_err, result) => {
                                    if (files.length - 1 == index) {
                                        if (_err == 1) {
                                            console.log("Data inserted Successfully");
                                            callback(1, { data: resp, status: 200, key: key });
                                        }
                                        else {
                                            console.log("Something Went wrong data not inserted");
                                            callback(0, { message: "Something Went wrong data not inserted", status: 502 });
                                        }
                                    }
                                });
                            }
                            catch (e) {
                                console.log("Error :: evidenceRequest ::", e);
                                console.log("Something Went wrong data not inserted");
                                callback(0, { status: 503, message: "Something went wrong!" });
                            }
                        }
                        else {
                            console.log("response description");
                            callback(0, { message: response[0].description, status: response.code });
                        }
                    });
                });
            }
            else {
                console.log("Individual file size limit exceeded.");
                callback(0, { message: "Individual file size limit exceeded.", status: 504 });
            }
        }
        else {
            console.log("Total file count or total file size limit exceeded.");
            callback(0, { message: "Total file count or total file size limit exceeded.", status: 505 });
        }
    }
    getBranAppeal(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let ext_field;
                if (sessData.type == 1) {
                    ext_field = "iduser,idaccount,";
                }
                let sdata = req.query;
                let data = JSON.parse(sdata.type);
                let brandId = data.brandId;
                let iduser = sessData.type == 1 ? data.idaccount : sessData.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser,idaccount,brandID,appealCategories,attachmentUuids,explanation,vetting_status,`key`,`created_at`,`vetting_status_updated_at` FROM `brand_appeal` WHERE brandId='" + brandId + "' AND iduser='" + data.iduser + "'";
                obj.qrysql = "SELECT " + ext_field + " brandID,appealCategories,attachmentUuids,explanation,vetting_status,`key`,vetting_status_update_at,created_at FROM `brand_appeal` WHERE brandId='" + brandId + "' AND idaccount=" + iduser + " ";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Brand Appeal Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getBranAppealFiles(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let data = JSON.parse(sdata.type);
                let iduser = sessData.type == 1 ? data.idaccount : sessData.idaccount;
                let brandId = data.brandId;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT uuid, fileName, `key`, `path`, `mimeType`,`evidence_type` FROM `evidence_files` WHERE `idaccount`=" + iduser + " AND `brandId`='" + brandId + "' AND `key`='" + data.key + "'";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Brand Appeal Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "NO appeal available in this Appeal Request!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getVettingAppealDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                rate.checksessionvalid1_2_22_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let data;
                        try {
                            data = JSON.parse(sdata.type);
                        }
                        catch {
                            data = (sdata.type);
                        }
                        let message = "";
                        switch (true) {
                            case (!data):
                                message = "Missing Parameter brandId";
                                break;
                            case (data?.brandId == '' || data?.brandId == "null" || data?.brandId == "undefined"):
                                message = "BrandId is required";
                                break;
                            case (!/^B[A-Z0-9]{6}$/.test(data?.brandId)):
                                message = "BrandId is invalid";
                                break;
                            case (sessData.type == 1 && (!data?.idaccount || data.idaccount == "" || data.idaccount == "null" || data.idaccount == "undefined")):
                                message = "Idaccount is required for admin";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        let brandId = data.brandId;
                        let iduser = sessData.type == 1 ? data.idaccount : sessData.idaccount;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT ba.brandId, ba.appealCategories, ba.explanation, ba.vetting_status,ba.vetting_status_update_at,ba.created_at,ef.uuid, ef.fileName, ef.key, ef.path,ef.mimeType FROM `brand_vetting_appeal`ba LEFT JOIN `evidence_files` ef ON ef.key=ba.key WHERE ba.`idaccount`=" + iduser + " AND ba.`brandId`='" + brandId + "' ORDER BY `created_at` DESC";
                        obj.prepare();
                        obj.execute((err, result) => {
                            if (err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: 'Brand Vetting Appeal Fatched Successfully!', data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Vetting Appeal Detail!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /********************************
  * Upload Campaign File Panel + Swagger
  */
    campaignFileUploader(req, res, sessdata, smCampKey, callback) {
        let files = [];
        files = req.files;
        let fileSizes = [];
        let key = Math.random().toString(36).slice(2);
        files.forEach((element, index) => {
            fileSizes.push(element.size);
        });
        const maxTotalFileSizeBytes = 30 * 1024 * 1024;
        const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
        const totalFiles = fileSizes.length;
        const totalFileSizeBytes = fileSizes.reduce((acc, fileSize) => acc + fileSize, 0);
        if (totalFiles <= 10 && totalFileSizeBytes <= maxTotalFileSizeBytes) {
            const individualFileLimitReached = fileSizes.every((fileSize) => fileSize <= maxIndividualFileSizeBytes);
            if (individualFileLimitReached) {
                var fs = require('fs');
                if (smCampKey) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `campaign_key`,`sm_reference_no`,`provisioning_status`,`status` FROM `campaign` WHERE (`campaign_key`='" + smCampKey + "' OR `sm_reference_no`='" + smCampKey + "') AND `idaccount`=" + sessdata.idaccount + "";
                    obj.prepare();
                    obj.execute((err, results) => {
                        if (err == 1) {
                            // let campaignId = results[0].campaign_key;
                            if (results.length > 0) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT `campaignId`,`sm_reference_no` FROM `campaign_sample_file` WHERE (`campaignId`='" + smCampKey + "' OR `sm_reference_no`='" + smCampKey + "') AND `idaccount`=" + sessdata.idaccount + "";
                                obj1.prepare();
                                obj1.execute((errs, resCSF) => {
                                    if (errs == 1) {
                                        if (resCSF.length < 5) {
                                            if (results[0].campaign_key && results[0].status != 3) {
                                                files.forEach((element, index) => {
                                                    const isValid = MIME_TYPE_MAP[element.mimetype];
                                                    if (!isValid) {
                                                        console.log("File type " + element.filename.split('.').pop() + " not accepted");
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "File type " + element.filename.split('.').pop() + " not accepted", status: 402 });
                                                        objv.execute();
                                                        return;
                                                    }
                                                    let options = {
                                                        'method': 'POST',
                                                        'url': apiUrl + 'campaign/' + results[0].campaign_key + '/mms',
                                                        'headers': {
                                                            'Content-Type': 'application/json',
                                                            'Authorization': 'Basic ' + authKey
                                                        },
                                                        formData: {
                                                            'file': {
                                                                'value': fs.createReadStream((element.path || '').replace(/^(\.\.[/\\])+/, '').split(/[\\/]/).pop()),
                                                                'options': {
                                                                    'filename': element.filename,
                                                                    'contentType': null
                                                                }
                                                            }
                                                        }
                                                    };
                                                    (0, axios_1.request)(options, function (error, response) {
                                                        if (!error) {
                                                            try {
                                                                let resp = JSON.parse(response.body);
                                                                let value = appealEvidence.campaignFile + resp.fileName;
                                                                if (resp.uuid) {
                                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`sm_reference_no`,`campaignId`,`uuid`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + results[0].sm_reference_no + "', '" + results[0].campaign_key + "','" + resp.uuid + "','" + key + "','" + resp.mimeType + "','" + resp.fileName + "' ,'" + value + "','CampaignMMSSampleFile')";
                                                                    obj.prepare();
                                                                    obj.execute((_err, result) => {
                                                                        if (files.length - 1 == index) {
                                                                            if (_err == 1) {
                                                                                let newDataRegister = Object.assign(resp, { "attachmentKey": key });
                                                                                callback(1, { message: 'Campaign File Upload Successfully', data: resp, status: 200 });
                                                                            }
                                                                            else {
                                                                                callback(0, { message: "Something went wrong!", status: 505 });
                                                                            }
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    callback(0, { message: resp[0].description, status: resp[0].code });
                                                                }
                                                            }
                                                            catch (e) {
                                                                callback(0, { error_code: 0, status: 502, message: "Something went wrong!" });
                                                            }
                                                        }
                                                        else {
                                                            // console.log(response[0].description, response[0].code);
                                                            callback(0, { message: response[0].description, status: response[0].code });
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                // if (results.length > 0) {
                                                // if (results[0].provisioning_status == '5' || results[0].provisioning_status == '7') {
                                                files.forEach((element, index) => {
                                                    let value = appealEvidence.campaignFile + element.filename;
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`sm_reference_no`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + smCampKey + "','" + key + "','" + element.mimetype + "','" + element.filename + "' ,'" + value + "','CampaignMMSSampleFile')";
                                                    obj.prepare();
                                                    obj.execute((_err, result) => {
                                                        if (files.length - 1 == index) {
                                                            if (_err == 1) {
                                                                callback(1, { message: 'Campaign File Upload Successfully', status: 200 });
                                                            }
                                                            else {
                                                                callback(0, { status: 505, message: "Something went wrong!" });
                                                            }
                                                        }
                                                    });
                                                });
                                            }
                                            // else {
                                            //     callback(0, { error_code: 0, status: 501, message: "Your campaign is approved. You are not allow make changes!" });
                                            // }
                                            // }
                                            // else {
                                            //     callback(0, { error_code: 0, status: 503, message: "Please Enter Signalmash ID!" });
                                            // }
                                        }
                                        else {
                                            callback(0, { status: 504, message: "Campaign File Limit Exceed!" });
                                        }
                                    }
                                    else {
                                        console.log("something went wrong");
                                        callback(0, { status: 505, message: "Something went wrong!" });
                                    }
                                });
                            }
                            else {
                                callback(0, { status: 505, message: "NO Record Found!" });
                            }
                            // }
                        }
                        else {
                            callback(0, { error_code: 0, status: 502, message: "Something went wrong with campaign!" });
                        }
                    });
                }
                else {
                    console.log("SM Reference No. not Found");
                    callback(0, { message: 'SM Reference No. not found', status: 200 });
                }
            }
            else {
                console.log("Individual file size limit exceeded.");
                callback(0, { message: 'Individual file size limit exceeded.', status: 200 });
            }
        }
        else {
            console.log("Total file count or total file size limit exceeded.");
            callback(0, { message: 'Total file count or total file size limit exceeded', status: 200 });
        }
    }
    addCampaignFile(req, res, sessdata, payLoad, callback) {
        if (payLoad.campaignId) {
            let campaignId = "";
            let ucKey;
            ucKey = payLoad.key;
            campaignId = payLoad.campaignId;
            var fs = require('fs');
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT `id`, `fileName`, `key`, `path`,`mimeType` FROM `campaign_sample_file` WHERE `key`='" + ucKey + "'";
            obj.prepare();
            obj.execute((err, results) => {
                results.forEach((element, index) => {
                    let filePath = appealDir.CAMPAIGNUPLOAD + '/' + element.fileName;
                    let options = {
                        'method': 'POST',
                        'url': apiUrl + 'campaign/' + campaignId + '/mms',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        formData: {
                            'file': {
                                'value': fs.createReadStream(filePath),
                                'options': {
                                    'filename': element.fileName,
                                    'contentType': null
                                }
                            }
                        }
                    };
                    (0, axios_1.request)(options, function (error, response) {
                        if (!error) {
                            try {
                                let resp = JSON.parse(response.body);
                                let value = appealEvidence.campaignFile + resp.fileName;
                                if (resp.uuid) {
                                    let sampleId = [];
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `campaign_sample_file` SET `campaignId` = '" + campaignId + "' ,`uuid`= '" + resp.uuid + "',`mimeType`='" + resp.mimeType + "',`fileName`='" + resp.fileName + "', `path`='" + value + "'  WHERE `idaccount` = " + sessdata.idaccount + " AND `id` = '" + element.id + "'";
                                    obj.prepare();
                                    obj.execute((_err, result) => {
                                        if (results.length - 1 == index) {
                                            if (_err == 1) {
                                                callback(1, { message: 'Campaign File Upload Successfully', data: resp, status: 200 });
                                            }
                                            else {
                                                callback(0, { message: "Something went wrong!", status: 505 });
                                            }
                                        }
                                    });
                                }
                                else {
                                    callback(0, { message: resp[0].description, status: resp[0].code });
                                }
                            }
                            catch (e) {
                                console.log("Error :: addCampaignFile ::", e);
                                callback(0, { error_code: 0, status: 502, message: "Something went wrong!" });
                            }
                        }
                        else {
                            callback(0, { message: response[0].description, status: response[0].code });
                        }
                    });
                });
            });
        }
        else {
            console.log("Total file count or total file size limit exceeded.");
            callback(0, { message: 'Total file count or total file size limit exceeded', status: 200 });
        }
    }
    campaignPanelFileUploader(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let files;
                files = req.files;
                let key = "";
                let uckey = Math.random().toString(36).slice(2);
                let oldSmkey = req.body.smCampaignKey ? req.body.smCampaignKey : '';
                if (oldSmkey) {
                    key = oldSmkey;
                }
                else {
                    // const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    // key = "SM";
                    // const alphabetLength = 5;
                    // for (let i = 0; i < 5; i++) {
                    //     key += alphabet.charAt(Math.floor(Math.random() * alphabetLength));
                    // }
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    const alphabetLength = alphabet.length;
                    const length = 5;
                    key = 'SM';
                    for (let i = 0; i < length; i++) {
                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                        const isDigit = randomIndex >= 52;
                        key += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                    }
                }
                let fileSize;
                fileSize = files[0].size;
                const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
                if (fileSize <= maxIndividualFileSizeBytes) {
                    const isValid = MIME_TYPE_MAP[files[0].mimetype];
                    if (!isValid) {
                        console.log("File type " + files[0].filename.split('.').pop() + " not accepted");
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "File type " + files[0].filename.split('.').pop() + " not accepted", status: 402 });
                        objv.execute();
                        return;
                    }
                    let value = appealEvidence.campaignFile + files[0].filename;
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`sm_reference_no`,`mimeType`,`fileName`,`path`,`evidence_type`, `key`) VALUES ('" + sessData.iduser + "', '" + sessData.idaccount + "','" + key + "','" + files[0].mimetype + "','" + files[0].filename + "' ,'" + value + "','CampaignMMSSampleFile' , '" + uckey + "')";
                    obj.prepare();
                    obj.execute((_err, result) => {
                        if (_err == 1) {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `id`,`fileName` AS name, `key`, `path`,`mimeType`,`sm_reference_no` FROM `campaign_sample_file` WHERE `sm_reference_no`='" + key + "' AND `id`='" + result.insertId + "'";
                            obj.prepare();
                            obj.execute((err, results) => {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: 'Campaign File Upload Successfully', data: results, lastId: result.insertId, status: 200 });
                                objv.execute();
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 505 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: 'Total file count or total file size limit exceeded', status: 200 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteSampleFile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let mediaId = data.id;
                if (mediaId) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `key`='" + mediaId + "' AND `idaccount`='" + sessdata.idaccount + "'";
                    obj.prepare();
                    obj.execute((__err, delRes) => {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                        obj.execute();
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Key Not Found!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    campaignMultimediaFileUpload(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        let campId = sdata.campaignId ? sdata.campaignId : sdata.smCampKey;
                        let message = '';
                        switch (true) {
                            case (!sdata):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!campId || campId == '' || campId == 'null' || campId == 'undefined'):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(campId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 504, message: message });
                            objv.execute();
                        }
                        else {
                            if (req.files) {
                                let camp = new NewCampaign();
                                camp.campaignFileUploader(req, res, sessdata, campId, (errorr, resp) => {
                                    if (errorr == 1) {
                                        console.log(resp.message);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: resp.message, data: resp.data, status: resp.status });
                                        objv.execute();
                                    }
                                    else {
                                        console.log(resp.message);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: resp.message, status: resp.status });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 402, message: "File not available!" });
                                objv.execute();
                            }
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getNewCampaignsFileById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = req.query.type ? JSON.parse(data.type) : data;
                let smCampKey = sdata.smCampKey;
                let iduser = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT uuid, fileName, `key`, `path`, `mimeType`,`evidence_type` FROM `campaign_sample_file` WHERE `sm_reference_no`='" + smCampKey + "' AND `idaccount` = '" + iduser + "'";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        try {
                            if (result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: 'Campaign File Fatched Successfully!', data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "NO Campaign File available!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went Wrong!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "NO Campaign File available!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************************************
         * get campaign File details based on campaign id  *
         *********************************************/
    getCampaignsFileById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = req.query.type ? JSON.parse(data.type) : data;
                let iduser = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                console.log("getCampaignsFileById", sdata, iduser);
                let smCampaignKey = sdata.smCampKey;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT uuid, fileName, `key`, `path`, `mimeType`,`evidence_type` FROM `campaign_sample_file` WHERE `sm_reference_no`='" + smCampaignKey + "' AND `idaccount` = " + iduser + " ";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        try {
                            if (result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: 'Campaign File Fatched Successfully!', data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "NO Campaign File available!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getCampaignFilesById ::", e);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went Wrong!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "NO Campaign File available!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteAddCampFile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `id`=" + data.id + " AND `idaccount`=" + sessdata.idaccount + " ";
                obj.prepare();
                obj.execute((__err, delRes) => {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                    obj.execute();
                });
            }
            else {
                let obj = new RawView_1.RawView(res);
                obj.prepare({ status: 401, message: "Unauthorized User" });
                obj.execute();
            }
        });
    }
    /* Delete campaign file Panel + Swagger*
    ****************/
    deleteCampFile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let data = req.query;
                        let attachmentId = data.attachmentId !== undefined ? data.attachmentId : data.id;
                        let message = '';
                        switch (true) {
                            case (!data):
                                message = "uuid/key is required";
                                break;
                            case (!attachmentId || String(attachmentId).trim() == '' || attachmentId == 'null' || attachmentId == 'undefined'):
                                message = "uuid/key is required";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 501, message: message });
                            objv.execute();
                        }
                        else {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `sm_reference_no`, `uuid` FROM `campaign_sample_file` WHERE (`uuid`='" + attachmentId + "' OR `key`='" + attachmentId + "') AND `idaccount`= " + sessdata.idaccount + "";
                            obj.prepare();
                            obj.execute((err, resCamFile) => {
                                if (err == 1) {
                                    if (resCamFile.length > 0) {
                                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                                        obj.qrysql = "SELECT `campaign_key`,`status` FROM `campaign` WHERE `sm_reference_no`='" + resCamFile[0].sm_reference_no + "'";
                                        obj.prepare();
                                        obj.execute((error, result) => {
                                            if (error == 1) {
                                                if (result[0].status == '3') {
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `key`='" + attachmentId + "' AND `idaccount`= " + sessdata.idaccount + " AND `sm_reference_no` ='" + resCamFile[0].sm_reference_no + "' ";
                                                    obj.prepare();
                                                    obj.execute((__err, delRes) => {
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                                                        obj.execute();
                                                    });
                                                }
                                                else {
                                                    if (resCamFile[0].uuid !== null && resCamFile[0].uuid !== '' && resCamFile[0].uuid !== undefined) {
                                                        let uuid = resCamFile[0].uuid.replace('/', '%2F').replace('/', '%2F');
                                                        let options = {
                                                            'method': 'DELETE',
                                                            'url': apiUrl + 'attachment/' + uuid,
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'Authorization': 'Basic ' + authKey
                                                            }
                                                        };
                                                        (0, axios_1.request)(options, (errr, response, body) => {
                                                            if (!errr) {
                                                                try {
                                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `uuid`='" + attachmentId + "' AND `idaccount`= " + sessdata.idaccount + " AND `sm_reference_no` ='" + resCamFile[0].sm_reference_no + "' ";
                                                                    obj.prepare();
                                                                    obj.execute((errrs, delRes) => {
                                                                        let obj = new RawView_1.RawView(res);
                                                                        obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                                                                        obj.execute();
                                                                    });
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: deleteCampFile ::", e);
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    message: "Something went wrong!",
                                                                    status: 502
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `key`='" + attachmentId + "' AND `idaccount`= " + sessdata.idaccount + " AND `sm_reference_no` ='" + resCamFile[0].sm_reference_no + "' ";
                                                        obj.prepare();
                                                        obj.execute((__err, delRes) => {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                                                            obj.execute();
                                                        });
                                                    }
                                                }
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ status: 501, message: "Something went wrong with campaign" });
                                                obj.execute();
                                            }
                                        });
                                        // if (resCamFile[0].uuid !== null && resCamFile[0].uuid !== '' && resCamFile[0].uuid !== undefined) {
                                        //     let uuid: any = resCamFile[0].uuid.replace('/', '%2F').replace('/', '%2F');
                                        //     let options: any = {
                                        //         'method': 'DELETE',
                                        //         'url': apiUrl + 'attachment/' + uuid,
                                        //         'headers': {
                                        //             'Content-Type': 'application/json',
                                        //             'Authorization': 'Basic ' + authKey
                                        //         }
                                        //     };
                                        //     request(options, (errr: any, response: any, body: any) => {
                                        //         if (!errr) {
                                        //             try {
                                        //                 let obj = new ModelRawNonQuery(req, res);
                                        //                 obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `uuid`='" + attachmentId + "' AND `idaccount`= " + sessdata.idaccount + " AND `sm_reference_no` ='" + resCamFile[0].sm_reference_no + "' ";
                                        //                 obj.prepare();
                                        //                 obj.execute((errrs: any, delRes: any) => {
                                        //                     let obj = new RawView(res);
                                        //                     obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                                        //                     obj.execute();
                                        //                 })
                                        //             }
                                        //             catch (e) {
                                        //                 console.log("Error :: deleteCampFile ::", e);
                                        //                 let obj = new RawView(res);
                                        //                 obj.prepare({ status: 502, message: "Something went wrong!" });
                                        //                 obj.execute();
                                        //             }
                                        //         }
                                        //         else {
                                        //             let objv = new RawView(res);
                                        //             objv.prepare({
                                        //                 message: "Something went wrong!",
                                        //                 status: 502
                                        //             });
                                        //             objv.execute();
                                        //         }
                                        //     });
                                        // }
                                        // else {
                                        //     let obj = new ModelRawNonQuery(req, res);
                                        //     obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `key`='" + attachmentId + "' AND `idaccount`= " + sessdata.idaccount + " AND `sm_reference_no` ='" + resCamFile[0].sm_reference_no + "' ";
                                        //     obj.prepare();
                                        //     obj.execute((__err: any, delRes: any) => {
                                        //         let obj = new RawView(res);
                                        //         obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                                        //         obj.execute();
                                        //     })
                                        // }
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 501, message: "No record found at this attachmentId!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 502, message: "Something went wrong with getting data!" });
                                    obj.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /* Get campaign files from Swagger*/
    getCampFile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                rate.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (req.query.campaignId) {
                        let condition = '';
                        let message = '';
                        let data = req.query;
                        switch (true) {
                            case (!data):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!data.campaignId || data.campaignId == '' || data.campaignId == 'null' || data.campaignId == 'undefined'):
                                message = "Please enter a valid Campaign ID!";
                                break;
                            case (!/^(C[A-Z0-9]{6}|SM[A-Z0-9]{5})$/.test(data.campaignId)):
                                message = "CampaignId must be exactly 7 characters long and start with 'C' or 'SM'!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 504, message: message });
                            objv.execute();
                        }
                        else {
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT `campaign_key`,`sm_reference_no` FROM `campaign` WHERE (`campaign_key`='" + req.query.campaignId + "' OR `sm_reference_no`='" + req.query.campaignId + "') AND `idaccount` = '" + sessdata.idaccount + "'";
                            obj0.prepare();
                            obj0.execute((__error, campRes) => {
                                if (__error == 1 && campRes.length > 0) {
                                    condition += "`sm_reference_no`='" + campRes[0].sm_reference_no + "'";
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `uuid`, `key` AS `attachmentKey`, `fileName`, `mimeType` FROM `campaign_sample_file` WHERE " + condition + " AND idaccount='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((err, result) => {
                                        if (err == 1) {
                                            if (result.length > 0) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: 'Campaign Multimedia files fetched successfully.', data: result, status: 200 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "NO Campaign Multimedia file in this Campaign!", status: 404 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something went wrong with get campaign multimedia files!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Campaign Detail Not Found!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        // }
                        // else {
                        //     let objv = new RawView(res);
                        //     objv.prepare({ message: "Please enter a valid Campaign ID!", status: 504 });
                        //     objv.execute();
                        // }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /*********************************************
   *get Campaign approve by Admin  *
   *********************************************/
    campApproveByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        let message = "";
                        switch (true) {
                            case (!sdata):
                                message = "Missing request body";
                                break;
                            case (!sdata?.campId || ["", "null", "undefined"].includes(sdata.campId)):
                                message = "campId is required";
                                break;
                            case (!sdata?.iduser || ["", "null", "undefined"].includes(sdata.iduser) || !/^[1-9]\d*$/.test(sdata.iduser)):
                                message = "Iduser is required";
                                break;
                            case (!sdata?.idaccount || ["", "null", "undefined"].includes(sdata.idaccount) || !/^[1-9]\d*$/.test(sdata.idaccount)):
                                message = "Idaccount is required";
                                break;
                            case (!/^SM[A-Z0-9]{5}$/.test(sdata.campId)):
                                message = "campId must be exactly 7 characters long and start with 'SM'!";
                                break;
                            case (!Array.isArray(sdata.selectedResellers) && !sdata.selectedResellers):
                                message = "selectedResellers is required";
                                break;
                            case (Array.isArray(sdata.selectedResellers) && sdata.selectedResellers.length == 0 && !('camp_reseller_unique_id' in sdata.selectedResellers)):
                                message = "camp reseller unique id is required";
                                break;
                            case (sdata.selectedResellers[0].camp_reseller_unique_id == ''):
                                message = "camp reseller unique id is required";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                        }
                        else {
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessdata.iduser,
                                idaccount: sessdata.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            checkuser.checkKycStatus(req, res, sdata.idaccount, (err, dt) => {
                                if (err == 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: dt.status, message: dt.message });
                                    objv.execute();
                                    return;
                                }
                                else {
                                    let resellerid = Array.isArray(sdata.selectedResellers) && sdata.selectedResellers.length > 0 ? sdata.selectedResellers[0].camp_reseller_unique_id : '';
                                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj0.qrysql = "SELECT b.`brandId`, b.`identityStatus`,c.sm_reference_no,c.noEmbeddedLink,c.noEmbeddedPhone, c.`campaign_key`, c.campaign_key,`campaign_description` as description,c.messageFlow,c.optinMessage, c.optoutMessage, c.helpMessage, c.sample1, c.sample2, c.sample3, c.sample4, c.sample5, c.autoRenewal, c.subscriberOptin, c.subscriberOptout, c.subscriberHelp, c.numberPool, c.optinKeywords, c.optoutKeywords, c.helpKeywords, c.directLending, c.ageGated ,c.privacyPolicyLink,c.termsAndConditionsLink,c.embeddedLinkSample FROM brand b LEFT JOIN campaign c ON b.brandId = c.idbrand WHERE c.`sm_reference_no` ='" + sdata.campId + "' AND c.`iduser` ='" + sdata.iduser + "'";
                                    obj0.prepare();
                                    obj0.execute((err, brandata) => {
                                        if (err == 1 && brandata.length > 0) {
                                            if (brandata[0].campaign_key && brandata[0].campaign_key.startsWith("C")) {
                                                let result = [{
                                                        campaign_key: brandata[0].campaign_key,
                                                        sm_reference_no: brandata[0].sm_reference_no
                                                    }];
                                                let subscriberOptin = (brandata[0].subscriberOptin !== undefined && brandata[0].subscriberOptin !== '') ? brandata[0].subscriberOptin : brandata[0].subscriberOptin;
                                                let subscriberOptout = (brandata[0].subscriberOptout !== undefined && brandata[0].subscriberOptout !== '') ? brandata[0].subscriberOptout : brandata[0].subscriberOptout;
                                                let subscriberHelp = (brandata[0].subscriberHelp !== undefined && brandata[0].subscriberHelp !== '') ? brandata[0].subscriberHelp : brandata[0].subscriberHelp;
                                                let numberPool = (brandata[0].numberPool !== undefined && brandata[0].numberPool !== '') ? brandata[0].numberPool : brandata[0].numberPool;
                                                let ageGated = (brandata[0].ageGated !== undefined && brandata[0].ageGated !== '') ? brandata[0].ageGated : brandata[0].ageGated;
                                                let directLending = (brandata[0].directLending !== undefined && brandata[0].directLending !== '') ? brandata[0].directLending : brandata[0].directLending;
                                                let noEmbeddedLink = (brandata[0].embeddedLink !== undefined && brandata[0].embeddedLink !== '') ? brandata[0].embeddedLink : brandata[0].noEmbeddedLink;
                                                let noEmbeddedPhone = (brandata[0].embeddedPhone !== undefined && brandata[0].embeddedPhone !== '') ? brandata[0].embeddedPhone : brandata[0].noEmbeddedPhone;
                                                let campData = {
                                                    resellerId: resellerid,
                                                    campaign_key: brandata[0].campaign_key,
                                                    description: brandata[0].description,
                                                    messageFlow: brandata[0].messageFlow,
                                                    optinMessage: brandata[0].optinMessage,
                                                    optoutMessage: brandata[0].optoutMessage,
                                                    helpMessage: brandata[0].helpMessage,
                                                    sample1: brandata[0].sample1,
                                                    sample2: brandata[0].sample2,
                                                    sample3: brandata[0].sample3,
                                                    sample4: brandata[0].sample4,
                                                    sample5: brandata[0].sample5,
                                                    autoRenewal: brandata[0].autoRenewal,
                                                    subscriberOptin: subscriberOptin,
                                                    subscriberOptout: subscriberOptout,
                                                    subscriberHelp: subscriberHelp,
                                                    numberPool: numberPool,
                                                    optinKeywords: brandata[0].optinKeywords,
                                                    optoutKeywords: brandata[0].optoutKeywords,
                                                    helpKeywords: brandata[0].helpKeywords,
                                                    directLending: directLending,
                                                    embeddedLink: noEmbeddedLink,
                                                    embeddedPhone: noEmbeddedPhone,
                                                    ageGated: ageGated,
                                                    privacyPolicyLink: brandata[0].privacyPolicyLink,
                                                    termsAndConditionsLink: brandata[0].termsAndConditionsLink,
                                                    embeddedLinkSample: brandata[0].embeddedLinkSample
                                                };
                                                console.log("campData ::", campData);
                                                let fun = new NewCampaign();
                                                fun.campaignUpdateTCR(req, res, sessdata, result, 0, campData, sdata.campId, sdata.idaccount, next);
                                            }
                                            else {
                                                if (brandata[0].identityStatus == 'VETTED_VERIFIED' || brandata[0].identityStatus == 'VERIFIED') {
                                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj.qrysql = "SELECT `idbrand` AS brandId , `usecase` ,`status`, `subUsecases` , `noEmbeddedLink` , `noEmbeddedPhone` , `affiliateMarketing` , `termsAndConditions` , `numberPool` , `ageGated` , `directLending` , `subscriberOptin` , `subscriberOptout` , `subscriberHelp` , `sample1` , `sample2` , `sample3` , `sample4` , `sample5` , `messageFlow` , `campaign_description` as description , `helpMessage` , `autoRenewal` , `optinKeywords` , `optoutKeywords` , `helpKeywords` , `optinMessage` , `optoutMessage` ,`cost`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample` FROM `campaign` WHERE `sm_reference_no` = '" + sdata.campId + "' AND `iduser` = '" + sdata.iduser + "'";
                                                    obj.prepare();
                                                    obj.execute((campError, camp) => {
                                                        if (campError == 1) {
                                                            camp[0].resellerId = resellerid;
                                                            let campData = camp[0];
                                                            // let campstatus = campData.status;
                                                            let options = {
                                                                'method': 'POST',
                                                                'url': apiUrl + 'campaignBuilder',
                                                                'headers': {
                                                                    'Content-Type': 'application/json',
                                                                    'Authorization': 'Basic ' + authKey
                                                                },
                                                                body: JSON.stringify(campData)
                                                            };
                                                            (0, axios_1.request)(options, async (error, response, body) => {
                                                                if (!error) {
                                                                    try {
                                                                        let resData = JSON.parse(response.body);
                                                                        let escapedLog = JSON.stringify([response.body, datasess]);
                                                                        let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                                        if (resData.campaignId) {
                                                                            let tmp = [];
                                                                            Object.entries(resData.mnoMetadata).forEach((ele) => {
                                                                                let t = ele[1];
                                                                                t["class"] = ele[0];
                                                                                tmp.push(t);
                                                                            });
                                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj3.nonqrysql = "UPDATE campaign SET `campaign_key` = '" + resData.campaignId + "',`camp_reseller_unique_id` = '" + resellerid + "',`provisioning_status` = 0 , `nextRenewalOrExpirationDate` = CURDATE() + INTERVAL 3 MONTH , `billedDate` = DATE_FORMAT(CONCAT(UTC_DATE(), ' 00:00:00'), '%Y-%m-%dT%H:%i:%s.000Z'), `createDate` = DATE_FORMAT(UTC_TIMESTAMP(), '%Y-%m-%dT%H:%i:%s.000Z'), `updated_at`=NOW() WHERE sm_reference_no = '" + sdata.campId + "'";
                                                                            obj3.prepare();
                                                                            obj3.execute((campErr, resp) => {
                                                                                console.log("Campaign ID Updated Successfully.");
                                                                            });
                                                                            /* if (campstatus == 2) {
                                                                                let obj3 = new ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "UPDATE campaign SET `campaign_key` = '" + resData.campaignId + "',`provisioning_status` = 0 , `nextRenewalOrExpirationDate` = CURDATE() + INTERVAL 3 MONTH , `billedDate` = DATE_FORMAT(CONCAT(UTC_DATE(), ' 00:00:00'), '%Y-%m-%dT%H:%i:%s.000Z'), `createDate` = DATE_FORMAT(UTC_TIMESTAMP(), '%Y-%m-%dT%H:%i:%s.000Z') WHERE sm_reference_no = '" + sdata.campId + "'";
                                                                                obj3.prepare();
                                                                                obj3.execute((campErr, resp) => {
                                                                                    console.log("Campaign ID Updated Successfully.");
                                                                                });
                                                                            }
                                                                            else {
                                                                                let obj3 = new ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "UPDATE campaign SET `campaign_key` = '" + resData.campaignId + "',`provisioning_status` = 0 , `nextRenewalOrExpirationDate` = CURDATE() + INTERVAL 3 MONTH , `billedDate` = DATE_FORMAT(CONCAT(UTC_DATE(), ' 00:00:00'), '%Y-%m-%dT%H:%i:%s.000Z'), `createDate` = DATE_FORMAT(UTC_TIMESTAMP(), '%Y-%m-%dT%H:%i:%s.000Z') WHERE sm_reference_no = '" + sdata.campId + "';";
                                                                                obj3.prepare();
                                                                                obj3.execute((campErr, resp) => {
                                                                                    console.log("Campaign ID Updated Successfully.");
                                                                                });
                                                                            } */
                                                                            let obj04 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj04.nonqrysql = "UPDATE `campaign_sample_file` SET `campaignId` = '" + resData.campaignId + "' WHERE sm_reference_no = '" + sdata.campId + "';";
                                                                            obj04.prepare();
                                                                            obj04.execute((campErr, resCSF) => {
                                                                                console.log("update SM Campaign Key for campaign_sample_file ");
                                                                            });
                                                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj5.nonqrysql = "UPDATE brand_log SET `campaign_key` = '" + resData.campaignId + "' WHERE sm_reference_no = '" + sdata.campId + "';";
                                                                            obj5.prepare();
                                                                            obj5.execute((campErr, respBl) => {
                                                                                console.log("Campaign ID Updated Successfully in Brand Log!");
                                                                            });
                                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj6.nonqrysql = "UPDATE campaign_log SET `campaign_key` = '" + resData.campaignId + "' WHERE sm_reference_no = '" + sdata.campId + "';";
                                                                            obj6.prepare();
                                                                            obj6.execute((campErr, respBl) => {
                                                                                console.log("Campaign ID Updated Successfully in campaign Log!");
                                                                            });
                                                                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj7.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sdata.idaccount + "', '" + sdata.iduser + "','2','" + sdata.campId + "','40','Campaign Approved By Admin','CAMPAIGN_APPROVED_BY_ADMIN','Campaign Approved By Admin','" + combinedLog + "')";
                                                                            obj7.prepare();
                                                                            obj7.execute((campErr, respBl) => {
                                                                                console.log("Campaign Log Inserted Successfully!");
                                                                            });
                                                                            let payLoad = {
                                                                                campaignId: resData.campaignId,
                                                                                sm_reference_no: sdata.campId,
                                                                                idaccount: sdata.idaccount
                                                                            };
                                                                            let camp = new NewCampaign();
                                                                            camp.sendCampaignFileApp(req, res, sessdata, payLoad, (errorr, resp) => { });
                                                                            let objW = new RawView_1.RawView(res);
                                                                            objW.prepare({ message: "Campaign Approved Successfully!", status: 200 });
                                                                            objW.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: resData[0].fields + " " + resData[0].description, status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    }
                                                                    catch (e) {
                                                                        let obj = new RawView_1.RawView(res);
                                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                        obj.execute();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ error_code: 0, status: 505, message: "Something went wrong to retrieving campaign details!" });
                                                            obj.execute();
                                                        }
                                                    });
                                                    return;
                                                }
                                                else {
                                                    let objW = new RawView_1.RawView(res);
                                                    objW.prepare({ message: "Brand Still not Verified!", status: 500 });
                                                    objW.execute();
                                                }
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something went wrong with checking campaign!", status: 504 });
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    pftcampApproveByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        let message = "";
                        switch (true) {
                            case (!sdata):
                                message = "Missing request body";
                                break;
                            case (!sdata?.campId || ["", "null", "undefined"].includes(sdata.campId)):
                                message = "campId is required";
                                break;
                            case (!sdata?.iduser || ["", "null", "undefined"].includes(sdata.iduser) || !/^[1-9]\d*$/.test(sdata.iduser)):
                                message = "Iduser is required";
                                break;
                            case (!sdata?.idaccount || ["", "null", "undefined"].includes(sdata.idaccount) || !/^[1-9]\d*$/.test(sdata.idaccount)):
                                message = "Idaccount is required";
                                break;
                            case (!/^SM[A-Z0-9]{5}$/.test(sdata.campId)):
                                message = "campId must be exactly 7 characters long and start with 'SM'!";
                                break;
                            case (!Array.isArray(sdata.selectedResellers) && !sdata.selectedResellers):
                                message = "selectedResellers is required";
                                break;
                            case (Array.isArray(sdata.selectedResellers) && sdata.selectedResellers.length == 0 && !('camp_reseller_unique_id' in sdata.selectedResellers)):
                                message = "camp reseller unique id is required";
                                break;
                            case (sdata.selectedResellers[0].camp_reseller_unique_id == ''):
                                message = "camp reseller unique id is required";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                        }
                        else {
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessdata.iduser,
                                idaccount: sessdata.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            checkuser.checkKycStatus(req, res, sdata.idaccount, (err, dt) => {
                                if (err == 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: dt.status, message: dt.message });
                                    objv.execute();
                                    return;
                                }
                                else {
                                    let resellerid = Array.isArray(sdata.selectedResellers) && sdata.selectedResellers.length > 0 ? sdata.selectedResellers[0].camp_reseller_unique_id : '';
                                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj0.qrysql = "SELECT b.`brandId`, b.`identityStatus`,c.sm_reference_no, c.`campaign_key`, c.campaign_key FROM brand b LEFT JOIN campaign c ON b.brandId = c.idbrand WHERE c.`sm_reference_no` ='" + sdata.campId + "' AND c.`iduser` ='" + sdata.iduser + "'";
                                    obj0.prepare();
                                    obj0.execute((err, brandata) => {
                                        if (err == 1 && brandata.length > 0) {
                                            if (brandata[0].campaign_key && brandata[0].campaign_key.startsWith("C")) {
                                                let escapedLog = JSON.stringify([req.body, datasess]);
                                                let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='0',`camp_reseller_unique_id`='" + resellerid + "', `updated_at`=NOW() WHERE `campaign_key`='" + brandata[0].campaign_key + "' AND `idaccount`='" + sdata.idaccount + "'";
                                                obj.prepare();
                                                obj.execute((errorr, resp) => {
                                                    if (errorr == 1) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 200, message: "Campaign details Updated Successfully!" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Campaign details Not updated!", status: 501 });
                                                        objv.execute();
                                                    }
                                                });
                                                // To Campaign Log Update
                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`, `sm_reference_no`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`,`webhook_full_log`) VALUES ('" + sdata.idaccount + "', '" + sdata.iduser + "','" + brandata[0].campaign_key + "','" + brandata[0].sm_reference_no + "', '3','Campaign Updated','CAMPAIGN_UPDATED','Campaign Updated',2,'" + combinedLog + "')";
                                                obj4.prepare();
                                                obj4.execute((campErr, __resp) => {
                                                    if (campErr == 1) {
                                                        console.log("Campaign Log Updated Successfully.");
                                                    }
                                                    else {
                                                        console.log("Campaign Log Not Updated!");
                                                    }
                                                });
                                            }
                                            else {
                                                if (brandata[0].identityStatus == 'VETTED_VERIFIED' || brandata[0].identityStatus == 'VERIFIED') {
                                                    let camp_key;
                                                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                                                    const alphabetLength = alphabet.length;
                                                    const length = 6;
                                                    camp_key = 'C';
                                                    for (let i = 0; i < length; i++) {
                                                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                                                        const isDigit = randomIndex >= 52;
                                                        camp_key += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                                                    }
                                                    let escapedLog = JSON.stringify([req.body, datasess]);
                                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "UPDATE campaign SET `campaign_key` = '" + camp_key + "',`camp_reseller_unique_id` = '" + resellerid + "',`provisioning_status` = 0 , `nextRenewalOrExpirationDate` = CURDATE() + INTERVAL 3 MONTH , `billedDate` = DATE_FORMAT(CONCAT(UTC_DATE(), ' 00:00:00'), '%Y-%m-%dT%H:%i:%s.000Z'), `createDate` = DATE_FORMAT(UTC_TIMESTAMP(), '%Y-%m-%dT%H:%i:%s.000Z'), `updated_at`=NOW() WHERE sm_reference_no = '" + sdata.campId + "'";
                                                    obj3.prepare();
                                                    obj3.execute((campErr, resp) => {
                                                        console.log("Campaign ID Updated Successfully.");
                                                    });
                                                    let obj04 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj04.nonqrysql = "UPDATE `campaign_sample_file` SET `campaignId` = '" + camp_key + "' WHERE sm_reference_no = '" + sdata.campId + "'";
                                                    obj04.prepare();
                                                    obj04.execute((campErr, resCSF) => {
                                                        console.log("update SM Campaign Key for campaign_sample_file ");
                                                    });
                                                    let obj05 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj04.nonqrysql = "UPDATE `did_pft` SET `campaign_id` = '" + camp_key + "' WHERE `sm_reference_no` = '" + sdata.campId + "'";
                                                    obj04.prepare();
                                                    obj04.execute((campErr, resCSF) => {
                                                        console.log("Update SM Campaign Key for did_pft ");
                                                    });
                                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj5.nonqrysql = "UPDATE brand_log SET `campaign_key` = '" + camp_key + "' WHERE sm_reference_no = '" + sdata.campId + "'";
                                                    obj5.prepare();
                                                    obj5.execute((campErr, respBl) => {
                                                        console.log("Campaign ID Updated Successfully in Brand Log!");
                                                    });
                                                    let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj6.nonqrysql = "UPDATE campaign_log SET `campaign_key` = '" + camp_key + "' WHERE sm_reference_no = '" + sdata.campId + "'";
                                                    obj6.prepare();
                                                    obj6.execute((campErr, respBl) => {
                                                        console.log("Campaign ID Updated Successfully in campaign Log!");
                                                    });
                                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj7.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sdata.idaccount + "', '" + sdata.iduser + "','2','" + sdata.campId + "','40','Campaign Approved By Admin','CAMPAIGN_APPROVED_BY_ADMIN','Campaign Approved By Admin','" + combinedLog + "')";
                                                    obj7.prepare();
                                                    obj7.execute((campErr, respBl) => {
                                                        console.log("Campaign Log Inserted Successfully!");
                                                    });
                                                    let objW = new RawView_1.RawView(res);
                                                    objW.prepare({ message: "Campaign Approved Successfully!", status: 200 });
                                                    objW.execute();
                                                }
                                                else {
                                                    let objW = new RawView_1.RawView(res);
                                                    objW.prepare({ message: "Brand Still not Verified!", status: 500 });
                                                    objW.execute();
                                                }
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something went wrong with checking campaign!", status: 504 });
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    sendCampaignFileApp(req, res, sessdata, payLoad, callback) {
        if (payLoad.campaignId) {
            let campaignId = payLoad.campaignId;
            let sm_reference_no = payLoad.sm_reference_no;
            let idaccount = payLoad.idaccount;
            var fs = require('fs');
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT `fileName` , `path` , `key` FROM `campaign_sample_file` WHERE sm_reference_no = '" + sm_reference_no + "'";
            obj.prepare();
            obj.execute((err, results) => {
                if (err == 1 && results.length > 0) {
                    results.forEach((element, index) => {
                        let filePath = appealDir.CAMPAIGNUPLOAD + '/' + element.fileName;
                        let options = {
                            'method': 'POST',
                            'url': apiUrl + 'campaign/' + campaignId + '/mms',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            formData: {
                                'file': {
                                    'value': fs.createReadStream(filePath),
                                    'options': {
                                        'filename': element.fileName,
                                        'contentType': null
                                    }
                                }
                            }
                        };
                        (0, axios_1.request)(options, function (error, response) {
                            if (!error) {
                                try {
                                    let resp = JSON.parse(response.body);
                                    let value = appealEvidence.campaignFile + resp.fileName;
                                    // if (resp.uuid) {
                                    let sampleId = [];
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `campaign_sample_file` SET `campaignId` = '" + campaignId + "' ,`uuid`= '" + resp.uuid + "',`mimeType`='" + resp.mimeType + "',`fileName`='" + resp.fileName + "', `path`='" + value + "'  WHERE `idaccount`='" + idaccount + "' AND `key` = '" + element.key + "'";
                                    obj.prepare();
                                    obj.execute((_err, result) => {
                                        if (results.length - 1 == index) {
                                            if (_err == 1) {
                                                console.log({ message: 'Campaign File Upload Successfully', data: resp, status: 200 });
                                                // callback(1, { message: 'Campaign File Upload Successfully', data: resp, status: 200 })
                                            }
                                            else {
                                                console.log({ message: "Something went wrong!", status: 505 });
                                                // callback(0, { message: "Something went wrong!", status: 505 })
                                            }
                                        }
                                    });
                                    // }
                                    // else {
                                    //     callback(0, { message: resp[0].description, status: resp[0].code })
                                    // }
                                }
                                catch (e) {
                                    console.log({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    // callback(0, { error_code: 0, status: 502, message: "Something went wrong!" })
                                }
                            }
                            else {
                                console.log({ error_code: 0, status: 503, message: "Something went wrong with file upload!" });
                                // callback(0, { message: response[0].description !== undefined ? response[0].description : "", status: response[0].code })
                            }
                        });
                    });
                }
                else {
                    console.log("No file available.");
                }
            });
        }
        else {
            console.log("Total file count or total file size limit exceeded.");
            // callback(0, { message: 'Total file count or total file size limit exceeded', status: 200 })
        }
    }
    copyCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                checkuser.checkKycStatus(req, res, sessdata.idaccount, (err, dt) => {
                    if (err == 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: dt.status, message: dt.message });
                        objv.execute();
                        return;
                    }
                    else {
                        let checkService = new APIBase_1.APIBase();
                        checkService.serviceActivation(req, res, sessdata, "7", (err, resp) => {
                            if (resp.status == 200) {
                                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                                let fun = new NewCampaign();
                                if (campData.usecase == 'TRIAL') {
                                    fun.registerpftcamp(req, res, sessdata, next);
                                }
                                else {
                                    if (campData.provisionStatus == 6) {
                                        fun.inCompleteCampaign(req, res, next);
                                    }
                                    else {
                                        // fun.inCopyCampaign(req, res, next);
                                        // fOR Sole proprietor
                                        let objb = new RawQuery_1.ModelRawQuery(req, res);
                                        objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                        objb.prepare();
                                        objb.execute((bError, bRes) => {
                                            if (bError == 1 && bRes.length > 0) {
                                                let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0 AND `provisioning_status` != 6";
                                                objc.prepare();
                                                objc.execute((cError, cRes) => {
                                                    if (cError == 1 && cRes.length < 1) {
                                                        fun.inCopyCampaign(req, res, next);
                                                    }
                                                    else {
                                                        console.log("In Copy Campaign ::");
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded for " + campData.brandId, status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                // FOR any entity type 
                                                let fun = new NewCampaign();
                                                fun.inCopyCampaign(req, res, next);
                                                // if (campData.provisionStatus == 6) {
                                                //     fun.inCompleteCampaign(req, res, next);
                                                // }
                                                // else {
                                                //     fun.inCopyCampaign(req, res, next);
                                                // }
                                            }
                                        });
                                    }
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: err,
                                    status: resp.status,
                                    message: resp.message.replace(/::SN::/g, "Campaign Registration")
                                });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    inCompleteCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                    campData.optinKeywords = typeof campData.optinKeywords === 'string' ? campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                    campData.optoutKeywords = typeof campData.optoutKeywords === 'string' ? campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                    campData.helpKeywords = typeof campData.helpKeywords === 'string' ? campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                let files = req.files;
                let sm_reference_no = "";
                if (campData.smCampaignKey) {
                    sm_reference_no = campData.smCampaignKey;
                }
                else {
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    const alphabetLength = alphabet.length;
                    const length = 5;
                    sm_reference_no = 'SM';
                    for (let i = 0; i < length; i++) {
                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                        const isDigit = randomIndex >= 52;
                        sm_reference_no += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                    }
                }
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                obj0.prepare();
                obj0.execute((campError, camp) => {
                    if (campError == 1 && camp.length > 0) {
                        //-- Get SMS Provider 
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `campaign_name`,`sm_reference_no` FROM `campaign` WHERE `idaccount` = '" + sessdata.idaccount + "' AND `sm_reference_no` = '" + sm_reference_no + "'";
                        obj2.prepare();
                        obj2.execute((err, result) => {
                            if (err == 1 && result.length > 0) {
                                let conn = {
                                    "noEmbeddedPhone": campData.embeddedPhone,
                                    "noEmbeddedLink": campData.embeddedLink, "termsAndConditions": campData.termsAndConditions,
                                    "numberPool": campData.numberPool, "ageGated": campData.ageGated, "directLending": campData.directLending, "subscriberOptin": campData.subscriberOptin, "subscriberOptout": campData.subscriberOptout, "subscriberHelp": campData.subscriberHelp, "affiliateMarketing": campData.affiliateMarketing
                                };
                                Object.keys(conn).forEach((key) => {
                                    if (conn[key] === '' || conn[key] === null || conn[key] === undefined) {
                                        delete conn[key];
                                    }
                                });
                                let setQuery = Object.keys(conn).map(key => `${key} = '${conn[key]}'`).join(", ");
                                if (setQuery) {
                                    setQuery += ", ";
                                }
                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='" + campData.provisionStatus + "' , " + setQuery + " `campaign_name`='" + campData.campaignName + "',  `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "', `messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "', `optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "', `optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "', `optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "', `optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', `helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "', `helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "', `vertical`='" + campData.vertical + "', `sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "', `sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "', `sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "', `sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "', `sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`usecase`='" + campData.usecase + "',`subUsecases`='" + campData.subUsecases + "',`autoRenewal`='" + campData.autoRenewal + "',`did_limit`='" + (0, markError_1.setToZero)(camp[0].service_limit) + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW() WHERE `sm_reference_no`='" + campData.smCampaignKey + "'";
                                obj3.prepare();
                                obj3.execute((__error, resp) => {
                                    let mnoCampaign = new NewCampaign();
                                    mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'inCompleteCampaign', (errorr, resp) => {
                                        if (resp.data) {
                                            let tmp = [];
                                            if (resp.data) {
                                                Object.entries(resp.data).forEach((ele) => {
                                                    let t = ele[1];
                                                    t["class"] = ele[0];
                                                    tmp.push(t);
                                                });
                                            }
                                            let campaignData2 = tmp;
                                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                                            obj.qrysql = "SELECT `iduser`,`idaccount`,`campMnoId` FROM campaign_mno WHERE sm_reference_no ='" + campData.smCampaignKey + "'";
                                            obj.prepare();
                                            obj.execute((error, result) => {
                                                if (error == 1 && result.length > 0) {
                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "DELETE FROM `campaign_mno` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                    obj11.prepare();
                                                    obj11.execute((__error, lastid) => {
                                                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                        for (let key of campData.mnoIds) {
                                                            campaignData2.forEach((mnoData) => {
                                                                if (key == mnoData.class) {
                                                                    campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                }
                                                            });
                                                        }
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = campMno.slice(0, -1);
                                                        obj1.prepare();
                                                        obj1.execute((_error, data) => {
                                                            if (_error == 1) {
                                                                console.log("mno update successfully!");
                                                            }
                                                        });
                                                    });
                                                }
                                                else {
                                                    let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                    for (let key of campData.mnoIds) {
                                                        campaignData2.forEach((mnoData) => {
                                                            if (key == mnoData.class) {
                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                            }
                                                        });
                                                    }
                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = campMno.slice(0, -1);
                                                    obj1.prepare();
                                                    obj1.execute((_error, data) => {
                                                        if (_error == 1) {
                                                            console.log("mno insert successfully!");
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    });
                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + campData.smCampaignKey + "','28','Campaign Details Updated','CAMPAIGN_DETAILS_UPDATED','Campaign Details Updated','" + JSON.stringify(datasess) + "')";
                                    obj4.prepare();
                                    obj4.execute((campErr, __resp) => {
                                        if (campErr == 1) {
                                            console.log("Campaign Log Updated Successfully.");
                                        }
                                        else {
                                            console.log("Campaign Log Not Updated!");
                                        }
                                    });
                                    if (files && files.length > 0) {
                                        let copycampfile = new NewCampaign();
                                        copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                            console.log("copycampfile", resp.status);
                                        });
                                    }
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, message: "Campaign Saved Successfully!" });
                                    objv.execute();
                                });
                            }
                            else {
                                let fun = new NewCampaign();
                                fun.insertSaveCampaign(req, res, sessdata, campData, camp, sm_reference_no, files, next);
                                /* let objb = new ModelRawQuery(req, res);
                                objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                objb.prepare();
                                objb.execute((bError, bRes) => {
                                    if (bError == 1 && bRes.length > 0) {
                                        let objc = new ModelRawQuery(req, res);
                                        objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + campData.brandId + "' AND `deleted`=0";
                                        objc.prepare();
                                        objc.execute((cError, cRes) => {
                                            if (cError == 1 && cRes.length < 1) {
                                                let fun = new NewCampaign();
                                                fun.insertSaveCampaign(req, res, sessdata, campData, camp, sm_reference_no, files, next);
                                            }
                                            else {

                                                let objv = new RawView(res);
                                                objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded 4 " + campData.brandId, status: 502 });
                                                objv.execute();
                                            }
                                        })
                                    }
                                    else {
                                        let fun = new NewCampaign();
                                        fun.insertSaveCampaign(req, res, sessdata, campData, camp, sm_reference_no, files, next);
                                    }
                                }) */
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Please Select Correct Usecase!",
                            error: camp,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    insertSaveCampaign(req, res, sessdata, campData, camp, sm_reference_no, files, next) {
        let conn = {
            "noEmbeddedPhone": campData.embeddedPhone,
            "noEmbeddedLink": campData.embeddedLink, "termsAndConditions": campData.termsAndConditions,
            "numberPool": campData.numberPool, "ageGated": campData.ageGated, "directLending": campData.directLending,
            "subscriberOptin": campData.subscriberOptin, "subscriberOptout": campData.subscriberOptout,
            "subscriberHelp": campData.subscriberHelp, "affiliateMarketing": campData.affiliateMarketing,
        };
        Object.keys(conn).forEach((key) => {
            if (conn[key] === '' || conn[key] === null || conn[key] === undefined) {
                delete conn[key];
            }
        });
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let datasess = {
            iduser: sessdata.iduser,
            idaccount: sessdata.idaccount,
            ipAddress: sysInfo.ipAddress[0],
        };
        let setQuery = Object.keys(conn).map(key => `${key} = '${conn[key]}'`).join(", ");
        if (setQuery) {
            setQuery += ", ";
        }
        let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj01.nonqrysql = "INSERT INTO `campaign` SET " + setQuery + " iduser = '" + sessdata.iduser + "', idaccount = '" + sessdata.idaccount + "', idbrand = '" + campData.brandId + "', sm_reference_no = '" + sm_reference_no + "', provisioning_status = '" + campData.provisionStatus + "', campaign_name = '" + campData.campaignName + "', campaign_description = '" + (0, markError_1.parseBody)(campData.description) + "', messageFlow = '" + (0, markError_1.parseBody)(campData.messageFlow) + "', optinMessage = '" + (0, markError_1.parseBody)(campData.optinMessage) + "', optinKeywords = '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', optoutMessage = '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', optoutKeywords = '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', helpMessage = '" + (0, markError_1.parseBody)(campData.helpMessage) + "', helpKeywords = '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', vertical = '" + campData.vertical + "', sample1 = '" + (0, markError_1.parseBody)(campData.sample1) + "', sample2 = '" + (0, markError_1.parseBody)(campData.sample2) + "', sample3 = '" + (0, markError_1.parseBody)(campData.sample3) + "', sample4 = '" + (0, markError_1.parseBody)(campData.sample4) + "', sample5 = '" + (0, markError_1.parseBody)(campData.sample5) + "', usecase = '" + campData.usecase + "', subUsecases = '" + campData.subUsecases + "', autoRenewal = '" + campData.autoRenewal + "', did_limit = '" + (0, markError_1.setToZero)(camp[0].service_limit) + "' ,`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW()";
        obj01.prepare();
        obj01.execute((_errorr, data) => {
            if (_errorr == 1) {
                let mnoCampaign = new NewCampaign();
                mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'insertSaveCampaign', (errorr, resp) => {
                    if (resp.data) {
                        let tmp = [];
                        Object.entries(resp.data).forEach((ele) => {
                            let t = ele[1];
                            t["class"] = ele[0];
                            tmp.push(t);
                        });
                        let campaignData2 = tmp;
                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                        for (let key of campData.mnoIds) {
                            campaignData2.forEach((mnoData) => {
                                if (key == mnoData.class) {
                                    campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                }
                            });
                        }
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = campMno.slice(0, -1);
                        obj1.prepare();
                        obj1.execute((_error, data) => {
                            if (_error == 1) {
                                console.log("mno insert successfully!");
                            }
                        });
                    }
                });
                if (files && files.length > 0) {
                    let copycampfile = new NewCampaign();
                    copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                    });
                }
            }
        });
        //Update Campaign
        // let fun = new NewCampaign();
        // fun.updateinRegisterCampaign(req, resData.campaignId, res, next);
        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + sm_reference_no + "','39','Campaign Details Saved','CAMPAIGN_DETAILS_SAVED','Campaign Details Saved','" + JSON.stringify(datasess) + "')";
        obj4.prepare();
        obj4.execute((campErr, __resp) => {
            if (campErr == 1) {
                console.log("Campaign Log Updated Successfully.");
            }
            else {
                console.log("Campaign Log Not Updated!");
            }
        });
        let objv = new RawView_1.RawView(res);
        objv.prepare({ status: 201, message: "Campaign Saved Successfully!" });
        objv.execute();
    }
    inCopyCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let datasess = {
                    iduser: sessdata.iduser,
                    idaccount: sessdata.idaccount,
                    ipAddress: sysInfo.ipAddress[0],
                };
                let campData = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;
                if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                    campData.optinKeywords = typeof campData.optinKeywords === 'string' ? campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                    campData.optoutKeywords = typeof campData.optoutKeywords === 'string' ? campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                    campData.helpKeywords = typeof campData.helpKeywords === 'string' ? campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '') : '';
                }
                let files = req.files;
                let sm_reference_no = "";
                if (campData.smCampaignKey && campData.smCampaignKey != "") {
                    sm_reference_no = campData.smCampaignKey;
                }
                else {
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    const alphabetLength = alphabet.length;
                    const length = 5;
                    sm_reference_no = 'SM';
                    for (let i = 0; i < length; i++) {
                        const randomIndex = Math.floor(Math.random() * alphabetLength);
                        const isDigit = randomIndex >= 52;
                        sm_reference_no += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                    }
                }
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                obj0.prepare();
                obj0.execute((campError, camp) => {
                    if (campError == 1 && camp.length > 0) {
                        //-- Get SMS Provider 
                        let CRate = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0;
                        let __rate = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0;
                        let __nrc_rates = typeof camp[0].nrc_rates != 'undefined' && camp[0].nrc_rates > 0 ? camp[0].nrc_rates : 0;
                        if (CRate > 0) {
                            rate.checkBalance(req, res, sessdata.idaccount, CRate, (bErr, bRes) => {
                                if (bErr == 1) {
                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj2.qrysql = "SELECT `campaign_name`,`sm_reference_no` FROM `campaign` WHERE `idaccount` = '" + sessdata.idaccount + "' AND `sm_reference_no` = '" + sm_reference_no + "'";
                                    obj2.prepare();
                                    obj2.execute((err, result) => {
                                        if (err == 1 && result.length > 0) {
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='" + campData.provisionStatus + "' , `campaign_name`='" + campData.campaignName + "', `noEmbeddedLink`='" + setDefaultFalse(campData.embeddedLink) + "', `noEmbeddedPhone`='" + setDefaultFalse(campData.embeddedPhone) + "', `campaign_description`='" + (0, markError_1.parseBody)(campData.description) + "', `messageFlow`='" + (0, markError_1.parseBody)(campData.messageFlow) + "', `optinMessage`='" + (0, markError_1.parseBody)(campData.optinMessage) + "', `optinKeywords`='" + (0, markError_1.parseBody)(campData.optinKeywords) + "', `optoutMessage`='" + (0, markError_1.parseBody)(campData.optoutMessage) + "', `optoutKeywords`='" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', `helpMessage`='" + (0, markError_1.parseBody)(campData.helpMessage) + "', `helpKeywords`='" + (0, markError_1.parseBody)(campData.helpKeywords) + "', `vertical`='" + campData.vertical + "', `sample1`='" + (0, markError_1.parseBody)(campData.sample1) + "', `sample2`='" + (0, markError_1.parseBody)(campData.sample2) + "', `sample3`='" + (0, markError_1.parseBody)(campData.sample3) + "', `sample4`='" + (0, markError_1.parseBody)(campData.sample4) + "', `sample5`='" + (0, markError_1.parseBody)(campData.sample5) + "',`usecase`='" + campData.usecase + "',`subUsecases`='" + campData.subUsecases + "',`autoRenewal`='" + campData.autoRenewal + "',`termsAndConditions`='" + setDefaultFalse(campData.termsAndConditions) + "',`numberPool`='" + setDefaultFalse(campData.numberPool) + "' ,`ageGated`='" + setDefaultFalse(campData.ageGated) + "',`directLending`='" + setDefaultFalse(campData.directLending) + "',`did_limit`='" + (0, markError_1.setToZero)(camp[0].service_limit) + "',`subscriberOptin`='" + setDefaultFalse(campData.subscriberOptin) + "',`subscriberOptout`='" + setDefaultFalse(campData.subscriberOptout) + "',`subscriberHelp`='" + setDefaultFalse(campData.subscriberHelp) + "',`privacyPolicyLink`='" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "',`termsAndConditionsLink`='" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "',`embeddedLinkSample`='" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "', `updated_at`=NOW() WHERE `sm_reference_no`='" + campData.smCampaignKey + "'";
                                            obj3.prepare();
                                            obj3.execute((__error, resp) => {
                                                if (__error == 1) {
                                                    // To brand Log Update
                                                    let fun = new NewCampaign();
                                                    fun.wallletDeduct(req, res, sessdata, CRate, next);
                                                    fun.getMnoMetaDataForInRegister(req, res, sessdata, 'inCopyCampaign', (errorr, resp) => {
                                                        if (resp.data) {
                                                            let tmp = [];
                                                            Object.entries(resp.data).forEach((ele) => {
                                                                let t = ele[1];
                                                                t["class"] = ele[0];
                                                                tmp.push(t);
                                                            });
                                                            let campaignData2 = tmp;
                                                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj.qrysql = "SELECT `iduser`,`idaccount`,`campMnoId` FROM campaign_mno WHERE sm_reference_no ='" + campData.smCampaignKey + "'";
                                                            obj.prepare();
                                                            obj.execute((error, result) => {
                                                                if (error == 1 && result.length > 0) {
                                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj11.nonqrysql = "DELETE FROM `campaign_mno` WHERE `sm_reference_no` ='" + campData.smCampaignKey + "'";
                                                                    obj11.prepare();
                                                                    obj11.execute((__error, lastid) => {
                                                                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                        for (let key of campData.mnoIds) {
                                                                            campaignData2.forEach((mnoData) => {
                                                                                if (key == mnoData.class) {
                                                                                    campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                                }
                                                                            });
                                                                        }
                                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = campMno.slice(0, -1);
                                                                        obj1.prepare();
                                                                        obj1.execute((_error, data) => {
                                                                            if (_error == 1) {
                                                                                console.log("mno update successfully!");
                                                                            }
                                                                        });
                                                                    });
                                                                }
                                                                else {
                                                                    let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                    for (let key of campData.mnoIds) {
                                                                        campaignData2.forEach((mnoData) => {
                                                                            if (key == mnoData.class) {
                                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + campData.smCampaignKey + "','" + mnoData.class + "','" + (0, markError_1.setToZero)(mnoData.minMsgSamples) + "', '" + mnoData.mno + "', '" + setDefaultFalse(mnoData.mnoReview) + "', '" + setDefaultFalse(mnoData.mnoSupport) + "', '" + mnoData.msgClass + "','" + setDefaultFalse(mnoData.noEmbeddedLink) + "','" + setDefaultFalse(mnoData.noEmbeddedPhone) + "','" + setDefaultFalse(mnoData.qualify) + "', '" + setDefaultFalse(mnoData.reqSubscriberHelp) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptin) + "', '" + setDefaultFalse(mnoData.reqSubscriberOptout) + "','" + mnoData.brandTier + "','" + (0, markError_1.setToZero)(mnoData.tpm) + "','" + (0, markError_1.setToZero)(mnoData.mmsTpm) + "','" + mnoData.tpmScope + "','" + mnoData.brandDailyCap + "','" + (0, markError_1.setToZero)(mnoData.surcharge) + "','" + (0, markError_1.setToZero)(mnoData.tpn) + "','REGISTERED','0'),";
                                                                            }
                                                                        });
                                                                    }
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = campMno.slice(0, -1);
                                                                    obj1.prepare();
                                                                    obj1.execute((_error, data) => {
                                                                        if (_error == 1) {
                                                                            console.log("mno insert successfully!");
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        }
                                                    });
                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`event_type`,`description`,`webhook_description_detail`,`webhook_event_type`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + campData.smCampaignKey + "','1','Campaign Request Submitted for Approval','Campaign " + sm_reference_no + " for brand " + campData.brandId + " is submitted for approval.', 'CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','" + JSON.stringify(datasess) + "')";
                                                    obj4.prepare();
                                                    obj4.execute((campErr, __resp) => {
                                                        if (campErr == 1) {
                                                            console.log("Campaign Log Updated Successfully.");
                                                        }
                                                        else {
                                                            console.log("Campaign Log Not Updated!");
                                                        }
                                                    });
                                                    if (files && files.length > 0) {
                                                        let copycampfile = new NewCampaign();
                                                        copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                                                            console.log("copycampfile", resp.status);
                                                        });
                                                    }
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 201, message: "Campaign Registered Successfully!" });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Campaign Not Registered!", status: 504 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objb = new RawQuery_1.ModelRawQuery(req, res);
                                            objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                                            objb.prepare();
                                            objb.execute((bError, bRes) => {
                                                if (bError == 1 && bRes.length > 0) {
                                                    let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                    objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0 AND `provisioning_status` != 6";
                                                    objc.prepare();
                                                    objc.execute((cError, cRes) => {
                                                        if (cError == 1 && cRes.length < 1) {
                                                            let fun = new NewCampaign();
                                                            fun.insertCopyCampaign(req, res, sessdata, campData, sm_reference_no, files, camp, __rate, CRate, next);
                                                        }
                                                        else {
                                                            console.log("In Copy Campaign ::");
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded for " + campData.brandId, status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let fun = new NewCampaign();
                                                    fun.insertCopyCampaign(req, res, sessdata, campData, sm_reference_no, files, camp, __rate, CRate, next);
                                                }
                                            });
                                        }
                                    });
                                    // }
                                    // else {
                                    //     let objv = new RawView(res);
                                    //     objv.prepare({ error: bErr, message: "Please add funds to your account or contact support.", status: 503 });
                                    //     objv.execute();
                                    // }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: bErr, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            rate.walletRechargeLog(req, res, {
                                idaccount: sessdata.idaccount,
                                amount: "+" + CRate,
                                purpose: 'Billing prorate should be greater then 0 to register a campaign'
                            }, 2, '-', (err, data) => {
                                console.log("inRegisterCampaign => walletRechargeLog Wallet recharge log response:", err, data);
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Billing prorate should be greater then 0 to register a campaign!",
                                error: ""
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Please Select Correct Usecase!",
                            error: camp,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    insertCopyCampaign(req, res, sessdata, campData, sm_reference_no, files, camp, __rate, CRate, next) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let datasess = {
            iduser: sessdata.iduser,
            idaccount: sessdata.idaccount,
            ipAddress: sysInfo.ipAddress[0],
        };
        let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`sm_reference_no`,`provisioning_status`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`cost`,`privacyPolicyLink`,`termsAndConditionsLink`,`embeddedLinkSample`, `updated_at`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + campData.brandId + "', '" + sm_reference_no + "', '" + campData.provisionStatus + "','" + campData.campaignName + "', '" + setDefaultFalse(campData.embeddedLink) + "', '" + setDefaultFalse(campData.embeddedPhone) + "','" + (0, markError_1.parseBody)(campData.description) + "', '" + (0, markError_1.parseBody)(campData.messageFlow) + "', '" + (0, markError_1.parseBody)(campData.optinMessage) + "', '" + (0, markError_1.parseBody)(campData.optinKeywords) + "', '" + (0, markError_1.parseBody)(campData.optoutMessage) + "', '" + (0, markError_1.parseBody)(campData.optoutKeywords) + "', '" + (0, markError_1.parseBody)(campData.helpMessage) + "', '" + (0, markError_1.parseBody)(campData.helpKeywords) + "', '" + campData.vertical + "', '" + (0, markError_1.parseBody)(campData.sample1) + "', '" + (0, markError_1.parseBody)(campData.sample2) + "', '" + (0, markError_1.parseBody)(campData.sample3) + "', '" + (0, markError_1.parseBody)(campData.sample4) + "', '" + (0, markError_1.parseBody)(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + setDefaultFalse(campData.termsAndConditions) + "', '" + setDefaultFalse(campData.numberPool) + "', '" + setDefaultFalse(campData.ageGated) + "', '" + setDefaultFalse(campData.directLending) + "', '" + (0, markError_1.setToZero)(camp[0].service_limit) + "','" + setDefaultFalse(campData.subscriberOptin) + "','" + setDefaultFalse(campData.subscriberOptout) + "','" + setDefaultFalse(campData.subscriberHelp) + "', '" + (0, markError_1.setToZero)(__rate) + "','" + (0, markError_1.parseBody)(campData.privacyPolicyLink) + "','" + (0, markError_1.parseBody)(campData.termsAndConditionsLink) + "','" + (0, markError_1.parseBody)(campData.embeddedLinkSample) + "',NOW())";
        obj00.prepare();
        obj00.execute((_errorr, data) => {
            if (_errorr == 1) {
                // To brand Log Update
                let fun = new NewCampaign();
                fun.wallletDeduct(req, res, sessdata, CRate, next);
                let mnoCampaign = new NewCampaign();
                mnoCampaign.getMnoMetaDataForInRegister(req, res, sessdata, 'insertCopyCampaign', (errorr, resp) => {
                    if (resp.data) {
                        let tmp = [];
                        Object.entries(resp.data).forEach((ele) => {
                            let t = ele[1];
                            t["class"] = ele[0];
                            tmp.push(t);
                        });
                        let campaignData1 = tmp;
                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`sm_reference_no`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                        Array.isArray(campData.mnoIds) && campData.mnoIds.forEach((mnoId) => {
                            let campaignData = campaignData1.find((data) => data.class === mnoId);
                            if (campaignData)
                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + sm_reference_no + "', '" + campaignData.class + "','" + (0, markError_1.setToZero)(campaignData.minMsgSamples) + "', '" + campaignData.mno + "', '" + setDefaultFalse(campaignData.mnoReview) + "', '" + setDefaultFalse(campaignData.mnoSupport) + "', '" + campaignData.msgClass + "','" + setDefaultFalse(campaignData.noEmbeddedLink) + "','" + setDefaultFalse(campaignData.noEmbeddedPhone) + "','" + setDefaultFalse(campaignData.qualify) + "', '" + setDefaultFalse(campaignData.reqSubscriberHelp) + "', '" + setDefaultFalse(campaignData.reqSubscriberOptin) + "', '" + setDefaultFalse(campaignData.reqSubscriberOptout) + "','" + campaignData.brandTier + "','" + (0, markError_1.setToZero)(campaignData.tpm) + "','" + (0, markError_1.setToZero)(campaignData.mmsTpm) + "','" + campaignData.tpmScope + "','" + campaignData.brandDailyCap + "','" + (0, markError_1.setToZero)(campaignData.surcharge) + "','" + (0, markError_1.setToZero)(campaignData.tpn) + "','REGISTERED','0'),";
                        });
                        let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj01.nonqrysql = campMno.slice(0, -1);
                        obj01.prepare();
                        obj01.execute((_errorr, campMnoData) => {
                        });
                    }
                });
                if (files && files.length > 0) {
                    let copycampfile = new NewCampaign();
                    copycampfile.CopyCampaignFile(req, res, sessdata, sm_reference_no, (errorr, resp) => {
                        console.log("copycampfile", resp.status);
                    });
                }
                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`,`request_type`, `sm_reference_no`,`cost`, `event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','2','" + sm_reference_no + "', '" + (0, markError_1.setToZero)(__rate) + "','1','Campaign Request Submitted for Approval' , 'CAMPAIGN_REQUEST_SUBMITTED_FOR_APPROVAL','Campaign " + sm_reference_no + " for brand " + campData.brandId + " is submitted for approval.','" + JSON.stringify(datasess) + "')";
                obj4.prepare();
                obj4.execute((campErr, __resp) => {
                    if (campErr == 1) {
                        console.log("Campaign Log Updated Successfully.");
                    }
                    else {
                        console.log("Campaign Log Not Updated!");
                    }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 201, message: "Campaign Registered Successfully!" });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Campaign Not Registered!", status: 504 });
                objv.execute();
            }
        });
    }
    getMnoMetaDataForInRegister(req, res, sessdata, callingFunctionName, callback) {
        let campData = req.body.campaignData ? JSON.parse(req.body.campaignData) : req.body;
        let brandId = (req.body.oldbrandId) ? req.body.oldbrandId : campData.brandId;
        let usecase = campData.usecase;
        console.log("No MNO Found for ::: ", '/' + callingFunctionName + ' brandId :: ' + brandId + ' Usecase :: ', usecase);
        let options = {
            'method': 'GET',
            'url': apiUrl + 'campaignBuilder/brand/' + brandId + '/usecase/' + usecase,
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + authKey
            }
        };
        (0, axios_1.request)(options, (error, response, body) => {
            if (!error) {
                try {
                    let mnodata = JSON.parse(response.body);
                    if (mnodata.mnoMetadata && mnodata.mnoMetadata != undefined) {
                        console.log({ data: mnodata.mnoMetadata, message: "Mno Meta Details Records Fetched!", status: 200 });
                        callback(1, { data: mnodata.mnoMetadata, message: "Mno Meta Details Records Fetched!", status: 200 });
                    }
                    else {
                        console.log({ data: mnodata.mnoMetadata, message: mnodata[0].field + " " + mnodata[0].description, status: mnodata[0].code });
                        callback(0, { data: mnodata.mnoMetadata, message: mnodata[0].field + " " + mnodata[0].description, status: mnodata[0].code });
                    }
                }
                catch (e) {
                    console.log({ error_code: 0, status: 502, message: "Something went wrong with getting MNOs!", data: [] });
                    callback(0, { error_code: 0, status: 502, message: "Something went wrong!", data: [] });
                }
            }
            else {
                console.log({ status: 502, message: "Something Went Wrong With API!", data: [] });
                callback(0, { status: 502, message: "Something Went Wrong With API!", data: [] });
            }
        });
    }
    CopyCampaignFile(req, res, sessdata, smCampKey, callback) {
        let sdata = JSON.parse(req.body.campaignData);
        let files = [];
        files = req.files;
        let fileSizes = [];
        let sm_reference_no = "";
        sm_reference_no = smCampKey;
        files.forEach((element, index) => {
            fileSizes.push(element.size);
        });
        const maxTotalFileSizeBytes = 30 * 1024 * 1024;
        const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
        const totalFiles = fileSizes.length;
        const totalFileSizeBytes = fileSizes.reduce((acc, fileSize) => acc + fileSize, 0);
        if (totalFiles <= 10 && totalFileSizeBytes <= maxTotalFileSizeBytes) {
            const individualFileLimitReached = fileSizes.every((fileSize) => fileSize <= maxIndividualFileSizeBytes);
            if (individualFileLimitReached) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `sm_reference_no` FROM campaign_sample_file WHERE sm_reference_no = '" + sm_reference_no + "'";
                obj1.prepare();
                obj1.execute((error, rsult) => {
                    if (error == 1 && rsult.length > 0) {
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE sm_reference_no = '" + sm_reference_no + "' AND `idaccount`='" + sessdata.idaccount + "'";
                        obj0.prepare();
                        obj0.execute((__err, delRes) => {
                            files.forEach((element, index) => {
                                let uckey = Math.random().toString(36).slice(2);
                                let value = appealEvidence.campaignFile + element.filename;
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`sm_reference_no`,`mimeType`,`fileName`,`path`,`evidence_type` , `key`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sm_reference_no + "','" + element.mimetype + "','" + element.filename + "' ,'" + value + "', 'CampaignMMSSampleFile' , '" + uckey + "')";
                                obj.prepare();
                                obj.execute((_err, result) => {
                                    if (files.length - 1 == index) {
                                        if (_err == 1) {
                                            console.log("Data inserted Successfully");
                                            callback(1, { message: 'Data inserted Successfully', status: 200 });
                                        }
                                        else {
                                            console.log("Something Went wrong data not inserted");
                                            callback(0, { message: "Something Went wrong , data not inserted", status: 502 });
                                        }
                                    }
                                });
                            });
                        });
                    }
                    else {
                        files.forEach((element, index) => {
                            let uckey = Math.random().toString(36).slice(2);
                            let value = appealEvidence.campaignFile + element.filename;
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`sm_reference_no`,`mimeType`,`fileName`,`path`,`evidence_type` , `key`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sm_reference_no + "','" + element.mimetype + "','" + element.filename + "' ,'" + value + "', 'CampaignMMSSampleFile' , '" + uckey + "')";
                            obj.prepare();
                            obj.execute((_err, result) => {
                                if (files.length - 1 == index) {
                                    if (_err == 1) {
                                        console.log("Data inserted Successfully");
                                        callback(1, { message: 'Data inserted Successfully', status: 200 });
                                    }
                                    else {
                                        console.log("Something Went wrong data not inserted");
                                        callback(0, { message: "Something Went wrong , Data not inserted", status: 502 });
                                    }
                                }
                            });
                        });
                    }
                });
            }
            else {
                console.log("Individual file size limit exceeded.");
                callback(0, { message: "Individual file size limit exceeded.", status: 504 });
            }
        }
        else {
            console.log("Total file count or total file size limit exceeded.");
            callback(0, { message: "Total file count or total file size limit exceeded.", status: 505 });
        }
    }
    redundantBrandRegister(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let data = req.body.data;
                let RateS = 4.50;
                let message = '';
                const isEmpty = (value) => value === undefined || value === null || value === '' || value === 'undefined' || value === 'null';
                switch (true) {
                    case (!data || isEmpty(data)):
                        message = "Missing request body!";
                        break;
                    case (isEmpty(data.smcKey)):
                        message = "smcKey is required!";
                        break;
                    case (!/^(\SM[A-Z0-9]{5})$/.test(data.smcKey)):
                        message = "smcKey must be exactly 7 characters long and start with 'SM'!";
                        break;
                    case (!data.c_key || isEmpty(data.c_key)):
                        message = "Campaign key is required!";
                        break;
                    case (!/^(\C[A-Z0-9]{6})$/.test(data.c_key)):
                        message = "Campaign key must be exactly 7 characters long and start with 'C'!";
                        break;
                    case (!data.brandName || isEmpty(data.brandName)):
                        message = "Brand Name is required!";
                        break;
                    case (!data.oldbrandId || isEmpty(data.oldbrandId)):
                        message = "old brandId is required!";
                        break;
                    case (!/^B[A-Z0-9]{6}$/.test(data.oldbrandId)):
                        message = "old brandId must be upper-case alphanumeric characters with prefix letter 'B'!";
                        break;
                    case (!data.brandtype || isEmpty(data.brandtype)):
                        message = "brand type is required!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else {
                    const brandId = data.oldbrandId;
                    const campkey = data.c_key;
                    checkuser.checkKycStatus(req, res, sessdata.idaccount, (err, dt) => {
                        if (err == 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: dt.status, message: dt.message });
                            objv.execute();
                            return;
                        }
                        else {
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessdata.iduser,
                                idaccount: sessdata.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            let checkService = new APIBase_1.APIBase();
                            checkService.serviceActivation(req, res, sessdata, "6", (err, resp) => {
                                if (resp.status == 200) {
                                    if (brandId) {
                                        let ObjA = new RawQuery_1.ModelRawQuery(req, res);
                                        ObjA.qrysql = "SELECT `company_name`, `mobilePhone`, `referenceId`, `brand_name`,`entityType`, `ein`, `einIssuingCountry`,`altBusinessIdType`, `altBusinessId`, `address`, `city`, `state`, `postal_code`,`country`, `website`,`stockSymbol` ,`stockExchange`, `vertical_type`,`firstName`, `lastName` ,  `brand_relation`,`email`,`phone`,`business_contact_email` FROM `brand` WHERE `idaccount`='" + sessdata.idaccount + "' AND `brandId`='" + brandId + "' AND `deleted`=0";
                                        ObjA.prepare();
                                        ObjA.execute((adErr2, Res2) => {
                                            if (adErr2 == 1 && Res2.length > 0) {
                                                let brandData = Res2[0];
                                                const formattedData = {
                                                    companyName: brandData.company_name,
                                                    displayName: brandData.brand_name ? brandData.brand_name : "",
                                                    entityType: brandData.entityType,
                                                    ein: brandData.ein,
                                                    einIssuingCountry: brandData.einIssuingCountry,
                                                    altBusinessIdType: brandData.altBusinessIdType ? brandData.altBusinessIdType : 'NONE',
                                                    altBusinessId: brandData.altBusinessId,
                                                    street: brandData.address,
                                                    city: brandData.city,
                                                    state: brandData.state,
                                                    postalCode: brandData.postal_code,
                                                    country: brandData.country,
                                                    website: brandData.website,
                                                    stockSymbol: brandData.stockSymbol,
                                                    stockExchange: brandData.stockExchange ? brandData.stockExchange : 'NONE',
                                                    vertical: brandData.vertical_type,
                                                    firstName: brandData.firstName,
                                                    lastName: brandData.lastName,
                                                    brandRelationship: brandData.brand_relation,
                                                    email: brandData.email,
                                                    phone: brandData.phone,
                                                    businessContactEmail: brandData.business_contact_email
                                                };
                                                // let Obj = new ModelRawQuery(req, res);
                                                // Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 4";
                                                // Obj.prepare();
                                                // Obj.execute((crErr: any, crRes) => {
                                                //     if (crErr == 1 && crRes.length > 0) {
                                                let ObjC = new RawQuery_1.ModelRawQuery(req, res);
                                                ObjC.qrysql = "SELECT `usecase` FROM `campaign` WHERE `idaccount`='" + sessdata.idaccount + "' AND `campaign_key`='" + campkey + "' AND `deleted`=0";
                                                ObjC.prepare();
                                                ObjC.execute((adErr1, Res1) => {
                                                    if (adErr1 == 1 && Res1.length > 0) {
                                                        let campData = Res1[0];
                                                        let ObjU = new RawQuery_1.ModelRawQuery(req, res);
                                                        ObjU.qrysql = "SELECT `rate`,`nrc_rates` FROM `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                                                        ObjU.prepare();
                                                        ObjU.execute((adErr, Res3) => {
                                                            if (adErr == 1) {
                                                                let rt = [];
                                                                rt = Res3.length > 0 ? Res3 : [Object.assign({ rate: 0, nrc_rates: 0 }, Res3[0])];
                                                                let campaign_rate = rt[0].rate + rt[0].nrc_rates;
                                                                let camp_rates = 0;
                                                                let Obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                                Obj0.qrysql = "SELECT `idtariff` FROM `user` WHERE `iduser`='" + sessdata.iduser + "' AND `is_deleted` = '0'";
                                                                Obj0.prepare();
                                                                Obj0.execute((bErr, bRes) => {
                                                                    if (bErr == 1 && bRes.length > 0) {
                                                                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                                        obj.qrysql = "SELECT `rate` FROM `campaign_rates` WHERE `idtariff`='" + bRes[0].idtariff + "' AND `type`='campaign'  AND `category`='campaign_redundant' LIMIT 1";
                                                                        obj.prepare();
                                                                        obj.execute((err, rates) => {
                                                                            if (err == 1) {
                                                                                let rt = [];
                                                                                rt = rates.length > 0 ? rates : [Object.assign({ rate: 0 }, rates[0])];
                                                                                camp_rates = Array.isArray(rt) && rt.length > 0 ? rt[0].rate : 0;
                                                                                let total_rates = RateS + camp_rates + campaign_rate;
                                                                                console.log("total rates", total_rates);
                                                                                rate.checkBalance(req, res, sessdata.idaccount, total_rates, (crErr, crRes) => {
                                                                                    if (crErr == 1) {
                                                                                        let options = {
                                                                                            'method': 'POST',
                                                                                            'url': apiUrl + 'brand/nonBlocking',
                                                                                            'headers': {
                                                                                                'Content-Type': 'application/json',
                                                                                                'Authorization': 'Basic ' + authKey
                                                                                            },
                                                                                            body: JSON.stringify(formattedData)
                                                                                        };
                                                                                        (0, axios_1.request)(options, (error, response, body) => {
                                                                                            if (!error) {
                                                                                                try {
                                                                                                    let resultData = JSON.parse(response.body);
                                                                                                    let escapedLog = JSON.stringify([response.body, datasess]);
                                                                                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                                                                    if (resultData.brandId && resultData.brandId !== undefined) {
                                                                                                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                                                                        obj3.qrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `mobilePhone`, `brandId`,`cspId`, `altBusinessId`, `altBusinessIdType`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `stockSymbol`, `stockExchange`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`,`optionalAttributes`,`createDate`,`evpVettingScore`,`mobilePhoneVerifiedDate`, `brandType`,`cost`,`parent_brand_id`,`business_contact_email`) VALUES('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + (0, markError_1.parseBody)(resultData.companyName) + "', '" + (0, markError_1.parseBody)(resultData.displayName) + "', '" + resultData.entityType + "', '" + resultData.ein + "', '" + resultData.brandRelationship + "', '" + (0, markError_1.parseBody)(resultData.street) + "', '" + (0, markError_1.parseBody)(resultData.city) + "', '" + resultData.state + "', '" + (0, markError_1.parseBody)(resultData.postalCode) + "', '" + (0, markError_1.parseBody)(resultData.website) + "', '" + resultData.vertical + "', '" + resultData.country + "', '" + resultData.email + "', '" + brandData.phone + "','" + brandData.mobilePhone + "', '" + resultData.brandId + "', '" + resultData.cspId + "', '" + brandData.altBusinessId + "', '" + brandData.altBusinessIdType + "', '" + (0, markError_1.setToZero)(resultData.registrationScore) + "', '" + resultData.universalEin + "',  '" + resultData.referenceId + "', '" + resultData.entityType + "', '" + resultData.identityStatus + "', '" + resultData.stockSymbol + "', '" + resultData.stockExchange + "', '" + resultData.einIssuingCountry + "', '" + resultData.mock + "', '" + (0, markError_1.parseBody)(brandData.firstName) + "', '" + (0, markError_1.parseBody)(resultData.lastName) + "', '" + resultData.ipAddress + "', '" + JSON.stringify(resultData.optionalAttributes) + "', '" + resultData.createDate + "', '" + (0, markError_1.setToZero)(resultData.evpVettingScore) + "', '" + resultData.mobilePhoneVerifiedDate + "', 'register','" + RateS + "','" + brandId + "','" + resultData.businessContactEmail + "')";
                                                                                                        obj3.execute((__error, result) => {
                                                                                                            if (__error == 1) {
                                                                                                                let swaggerResChn = resultData;
                                                                                                                delete swaggerResChn.cspId;
                                                                                                                delete swaggerResChn.mock;
                                                                                                                let swaggerResponse = swaggerResChn;
                                                                                                                if (resultData.entityType == "SOLE_PROPRIETOR") {
                                                                                                                    let otp = new BrandManager();
                                                                                                                    otp.smsOTPBrand(req, res, resultData.brandId, (smsErr, smsOtp) => {
                                                                                                                        if (smsErr == 1) {
                                                                                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                            obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `idaccount`='" + sessdata.idaccount + "' AND `brandId`='" + resultData.brandId + "' AND `deleted`=0";
                                                                                                                            obj.prepare();
                                                                                                                            obj.execute((___error, resp) => { });
                                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                                            objv.prepare({
                                                                                                                                status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "New Brand Created Successfully And " +
                                                                                                                                    smsOtp.message
                                                                                                                            });
                                                                                                                            objv.execute();
                                                                                                                        }
                                                                                                                        else {
                                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                                            objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                                                                                            objv.execute();
                                                                                                                        }
                                                                                                                    });
                                                                                                                }
                                                                                                                else {
                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                    objv.prepare({ status: 201, brandId: resultData.brandId, data: swaggerResponse, message: "New Brand Created Successfully." });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                                let payload = {
                                                                                                                    idaccount: sessdata.idaccount,
                                                                                                                    amount: RateS,
                                                                                                                    purpose: 'Redundant Brand Registration',
                                                                                                                    type: '-'
                                                                                                                };
                                                                                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                                                    console.log("redundantBrandRegister => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                                                                });
                                                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resultData.brandId + "', '" + RateS + "', '" + Date.now() + "','31', 'Brand Registered','" + combinedLog + "')";
                                                                                                                obj3.prepare();
                                                                                                                obj3.execute((log_error, _resp) => {
                                                                                                                    if (log_error == 1) {
                                                                                                                        console.log("Brand Log Updated.");
                                                                                                                    }
                                                                                                                    else {
                                                                                                                        console.log("Brand Log Not Updated.");
                                                                                                                    }
                                                                                                                });
                                                                                                            }
                                                                                                            else {
                                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                                objv.prepare({ status: 504, brandId: resultData.brandId, message: "Result Not Saved Successfully!" });
                                                                                                                objv.execute();
                                                                                                            }
                                                                                                        });
                                                                                                    }
                                                                                                    else {
                                                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`,`webhook_full_log`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resultData.brandId + "', '" + RateS + "', '" + Date.now() + "','2', 'Brand Register Failed','" + combinedLog + "')";
                                                                                                        obj3.prepare();
                                                                                                        obj3.execute((log_error, _resp) => {
                                                                                                            if (log_error == 1) {
                                                                                                                console.log("Brand Log Updated.");
                                                                                                            }
                                                                                                            else {
                                                                                                                console.log("Brand Log Not Updated.");
                                                                                                            }
                                                                                                        });
                                                                                                        const fields = `${resultData.flatMap((item) => item.fields).join(', ')}`;
                                                                                                        let objv = new RawView_1.RawView(res);
                                                                                                        objv.prepare({ message: fields + ' ' + resultData[0].description, status: resultData[0].code });
                                                                                                        objv.execute();
                                                                                                    }
                                                                                                }
                                                                                                catch (e) {
                                                                                                    console.log("Error::->redundantBrandRegister", e);
                                                                                                    let obj = new RawView_1.RawView(res);
                                                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                                                    obj.execute();
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                objv.prepare({ status: 505, message: "Something Went Wrong. Brand Not Created Successfully!" });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ error: crErr, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                        });
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ error: adErr1, message: "Use-case not found", status: 503 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ error: adErr2, message: "brand data not exists", status: 504 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "brand ID not exists", status: 502 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: err,
                                        status: resp.status,
                                        message: resp.message.replace(/::SN::/g, "Brand Registration")
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getRedundantCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query;
                let sdata = req.query.type ? JSON.parse(data.type) : data;
                let smKey = (sdata.smKey == null) ? " " : sdata.smKey;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sm_reference_no, campaign_key, idbrand, usecase, provisioning_status FROM `campaign` WHERE `status` = '2' AND  `parent_sm_reference_no`='" + smKey + "' ORDER BY `id_campaign` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Redundant Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: [],
                            message: "No Campaigns Found!",
                            status: 200
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    RedCampaignFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = "";
                let ext_field;
                if (sessdata.type == 1) {
                    ext_field = "c.iduser, c.idaccount,";
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== '' && data.idaccount !== null ? "c.`idaccount`='" + data.idaccount + "' AND" : '';
                }
                if (data.brandId)
                    condition += '`brandId` LIKE "%' + (0, markError_1.parseBody)(data.brandId) + '%" AND ';
                if (data.brand_name)
                    condition += '`brand_name` LIKE "%' + (0, markError_1.parseBody)(data.brand_name) + '%" AND ';
                if (data.campaign_key)
                    condition += '`campaign_key` LIKE "%' + (0, markError_1.parseBody)(data.campaign_key) + '%" AND ';
                if (data.sm_reference_no)
                    condition += '`sm_reference_no` LIKE "%' + (0, markError_1.parseBody)(data.sm_reference_no) + '%" AND ';
                if (data.parent_campaign_id)
                    condition += '`parent_campai