"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationAPI = exports.URL = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const markError_1 = require("./markError");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _405_1 = require("../lib/view/405");
const md5_1 = __importDefault(require("md5"));
exports.URL = require("url").URL;
class ApplicationAPI {
    authenticate(req, res, next) {
        console.log("Body::\n", req.body);
        console.log("Query::\n", req.query);
        console.log("Host::\n", req.get("host"));
        console.log("Origin::\n", req.get("origin"));
        let responses = {
            error: 1,
            message: "",
            data: {}
        }, results = {};
        try {
            let sdata = req.body.data, //JSON.parse(req.body.data),
            username = typeof sdata.username != 'undefined' && sdata.username ? sdata.username : "", password = typeof sdata.password != 'undefined' && sdata.password ? sdata.password : "";
            if (username && password) {
                let ePass = (0, md5_1.default)(password);
                let iQry = "SELECT us.`iduser`, us.`username`, us.`password`,  us.`type` FROM `user` us\n";
                // iQry += "LEFT JOIN `roles` ur ON ur.iduser = us.type\n"
                iQry += "WHERE us.`username`='" + (0, markError_1.parseBody)(username) + "'";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = iQry;
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        if (result.length > 0) {
                            if (ePass == (0, md5_1.default)(result[0].password)) {
                                let session = new Session_1.SessionManagment(req, res, next);
                                session.SetSession(result[0], (error, sessdata) => {
                                    let obji = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obji.nonqrysql = "INSERT INTO `user_activity`(`iduser`,`type``) VALUES(" + result[0].id + "," + (0, markError_1.setToZero)(result[0].type) + ",'login')";
                                    obji.prepare();
                                    obji.execute((error, activity) => {
                                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj2.qrysql = "SELECT `id`, `name` FROM `campaign` WHERE `id` IN (" + result[0].campaign + ")";
                                        obj2.prepare();
                                        obj2.execute((error, allcamp) => {
                                            responses.error = 0;
                                            responses.message = "Successfully logged In.";
                                            responses.data = {
                                                login: result[0],
                                                allcamp: allcamp
                                            };
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare(responses);
                                            objv.execute();
                                        });
                                    });
                                });
                            }
                            else {
                                responses.message = "Invalid credential!";
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(responses);
                                objv.execute();
                            }
                        }
                        else {
                            responses.message = "User did not found!";
                            let objv = new RawView_1.RawView(res);
                            objv.prepare(responses);
                            objv.execute();
                        }
                    }
                    else {
                        responses.message = "Something went, try again!";
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(responses);
                        objv.execute();
                    }
                });
            }
            else {
                responses.message = "Invalid credential!";
                let objv = new RawView_1.RawView(res);
                objv.prepare(responses);
                objv.execute();
            }
        }
        catch (e) {
            console.log("Error :: authenticate::", e);
            //responses.message = e.message
            let objv = new RawView_1.RawView(res);
            objv.prepare(responses);
            objv.execute();
        }
    }
    SessionLogin(req, res, next) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT us.`iduser`, us.`username`, us.`password`,  us.`type` FROM `session` WHERE `authkey`='" + req.query.type + "'";
        console.log("this is rishabh", req.query.type);
        if (obj.prepare()) {
            obj.execute((_error, result) => {
                console.log(result);
                if (result.length > 0) {
                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                    obj2.filter = null;
                    obj2.qrysql = "SELECT `id`, `name` FROM `campaign` WHERE `id` IN (" + result[0].campaign + ")";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ login: result, allcamp: allcamp });
                        objv.execute();
                    });
                }
            });
        }
        else {
            let objv = new _405_1.Res405(res);
            objv.prepare({ error: "Few parameter are missing in request" });
            objv.execute();
        }
    }
}
exports.ApplicationAPI = ApplicationAPI;
