"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentClass = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const _406_1 = require("../lib/view/406");
const _403_1 = require("../lib/view/403");
const module_config_1 = require("../config/module.config");
const ModelLogin_1 = require("../lib/model/ModelLogin");
const RawQuery_1 = require("../lib/model/RawQuery");
const markError_1 = require("./markError");
const Str = require('@supercharge/strings');
class AgentClass {
    constructor() { }
    addAgent(req, res, next) {
        var sdata = req.body;
        const name = Math.floor(1000000 + Math.random() * 9000000);
        const contact = 'user/' + name;
        const agent_key = Str.random(12);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `username` FROM agents where `username` = '" + (0, markError_1.parseBody)(sdata.UserName) + "'";
                    obj1.prepare();
                    obj1.execute((__error, agents) => {
                        if (__error == 1) {
                            if (agents.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Username Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `agents` (`iduser`, `name`, `username`, `password`, `full_name`, `contact`, `system`, `callerid`, `agent_key`, `group`, `vm_pin`) VALUES(" + sessdata.iduser + ",'" + name + "', '" + (0, markError_1.parseBody)(sdata.UserName) + "', '" + (0, markError_1.parseBody)(sdata.Password) + "', '" + (0, markError_1.parseBody)(sdata.FullName).trim() + "', '" + contact + "', 'single_box', '" + sdata.CallerId + "', '" + agent_key + "', '" + sdata.Group + "', " + (0, markError_1.setToZero)(sdata.VmPin) + ")";
                                obj.prepare();
                                obj.execute((_error, result) => {
                                    if (_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 201, message: "Agent Added Successfully!" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: agents });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateAgent(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let str = '';
                    if (sdata.FullName) {
                        str += '`full_name`="' + (0, markError_1.parseBody)(sdata.FullName).trim() + '", ';
                    }
                    if (sdata.UserName) {
                        str += '`username`="' + (0, markError_1.parseBody)(sdata.UserName) + '", ';
                    }
                    if (sdata.Password) {
                        str += '`password`="' + (0, markError_1.parseBody)(sdata.Password) + '", ';
                    }
                    if (sdata.CallerId) {
                        str += '`callerid`="' + sdata.CallerId + '", ';
                    }
                    if (sdata.VmPin) {
                        str += '`vm_pin`="' + (0, markError_1.setToZero)(sdata.VmPin) + '"';
                    }
                    str = str.trim().replace(/,\s*$/, "");
                    obj.nonqrysql = "UPDATE `agents` SET " + str + " WHERE idagent = " + sdata.IdAgent + "";
                    // obj.nonqrysql = "UPDATE `agents` SET `full_name` = '" + sdata.FullName + "', `username` = '" + sdata.UserName + "', `password` = '" + sdata.Password + "' where idaccount = '" + sessdata.idaccount + "' AND idagent = '" + sdata.IdAgent + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Agent Updated Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateAgentStatus(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `agents` SET `status` = '" + sdata.status + "' AND idagent = " + sdata.idagent + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Status Updated Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAgents(req, res, next) {
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let con;
                    if (sdata.groupKey && sdata.groupKey !== undefined && sdata.groupKey !== 'undefined' && sdata.groupKey !== null && sdata.groupKey !== 'null') {
                        con = "AND `group`='" + sdata.groupKey + "'";
                    }
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `agent_key`, `idagent`, `name`, `full_name`, `username`, `password`, `vm_pin` from `agents` WHERE `iduser` = " + sessdata.iduser + " " + con + " ";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSingleAgent(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idagent`,`iduser`,`name`,`full_name`,`username`,`password`,`group`,`vm_pin`,`callerid` from `agents` where `iduser` = " + sessdata.iduser + " AND `idagent`=" + req.query.type + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAllAgent(req, res, next) {
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `agent` FROM `tiers` WHERE `iduser`=" + sessdata.iduser + " AND `queue`='" + sdata.GroupName + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Agent List Get Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAgent(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idagent`,`full_name`,`contact`,`status`,`state`,`max_no_answer`,`wrap_up_time`,`reject_delay_time`,`busy_delay_time`,`no_answer_delay_time`,`last_bridge_start`,`last_bridge_end`,`last_offered_call`,`last_status_change`,`no_answer_count`,`calls_answered`,`talk_time`,`ready_time`,`extension`,`group` from `agents` where `iduser` = " + sessdata.iduser + " AND `username`='" + req.query.username + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteAgent(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE from `agents` where `idagent`=" + req.query.id + "";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Agent Deleted Successfully!", data: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    addGroup(req, res, next) {
        var sdata = req.body;
        console.log(sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT * FROM `group` where `group_name` = '" + (0, markError_1.parseBody)(sdata.GroupName) + "' AND `iduser`=" + sessdata.iduser + "";
                    obj1.prepare();
                    obj1.execute((_error, group) => {
                        if (_error == 1) {
                            if (group.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Group Name Already Exists In Your Group List!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                const group_key = Str.random(10);
                                let tierrules = sdata.TierRulesApply ? sdata.TierRulesApply : 'false';
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `group` (`iduser`, `group_name`, `strategy`, `tier_rules_apply`, `description`, `group_key`) VALUES (" + sessdata.iduser + ",'" + (0, markError_1.parseBody)(sdata.GroupName) + "', '" + sdata.Strategy + "', '" + tierrules + "', '" + (0, markError_1.parseBody)(sdata.Description) + "', '" + group_key + "')";
                                obj.prepare();
                                obj.execute((__error, result) => {
                                    if (__error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Group Added Successfully!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: group });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT id_group,iduser,group_name,strategy,tier_rules_apply,description,group_key FROM `group` where `id_group` = '" + sdata.idgroup + "' AND `iduser`=" + sessdata.iduser + "";
                    obj1.prepare();
                    obj1.execute((_error, group_res) => {
                        if (group_res.length > 0) {
                            // let objv = new RawView(res);
                            // objv.prepare({ message: "Group Name Already Exists In Your Group List!!", status: 502 });
                            // objv.execute();
                            // }
                            // else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            let str = '';
                            let tierrules = sdata.TierRulesApply ? sdata.TierRulesApply : 'false';
                            if (sdata.GroupName) {
                                str += '`group_name`="' + (0, markError_1.parseBody)(sdata.GroupName) + '", ';
                            }
                            if (sdata.Strategy) {
                                str += '`strategy`="' + sdata.Strategy + '", ';
                            }
                            if (tierrules) {
                                str += '`tier_rules_apply`="' + tierrules + '", ';
                            }
                            if (sdata.Description) {
                                str += '`description`="' + (0, markError_1.parseBody)(sdata.Description) + '", ';
                            }
                            str = str.trim().replace(/,\s*$/, "");
                            obj.nonqrysql = "UPDATE `group` SET " + str + "  WHERE `id_group` = " + sdata.idgroup + "";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Group Updated Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT g.group_name, g.group_key, g.id_group, GROUP_CONCAT(a.full_name) `agents` FROM `group` g LEFT JOIN tiers t ON g.group_key=t.queue LEFT JOIN agents a ON a.name=t.agent WHERE g.iduser= '" + sessdata.iduser + "' GROUP BY g.id_group ";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Group Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSingleGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id_group` , `iduser` , `group_name`, `strategy` , `tier_rules_apply` , `description`, `group_key` from `group` where `iduser` = " + sessdata.iduser + " AND `id_group`=" + req.query.type + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE from `group` where `id_group`=" + req.query.id + "";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Group Deleted Successfully!", data: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getGroups(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 1 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `group_name`, `group_key` FROM `group` WHERE  iduser = " + sessdata.iduser + "";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Group Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    agentLogin(req, res, next) {
        req.body = { username: req.body.Username, password: req.body.Password };
        let obj = new ModelLogin_1.ModelLogin(req, res);
        let swlogin = new module_config_1.modAgent();
        if (obj.prepare(swlogin)) {
            obj.execute((error, result) => {
                if (error == 2) {
                    let session = new Session_1.SessionManagment(req, res, next);
                    session.SetSession(result, (error, sessdata) => {
                        if (result.authkey !== undefined) {
                            if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                                let authkey = result.authkey;
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `agents` SET `status`='Logged In' WHERE `idagent` = " + result.idagent + "";
                                obj1.prepare();
                                obj1.execute((err, resp) => {
                                    if (err == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ "sessionkey": authkey });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Invalid Authkey!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Service Unavailable!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare("Invalid Session");
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _403_1.Res403(res);
                    objv.prepare({ error: "Invalid Username and password to set proper session" });
                    objv.execute();
                }
            });
        }
    }
    agentLogout(req, res, next) {
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idagent` from `session` where `authkey`='" + sdata.Session + "'";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (result.length > 0) {
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `agents` SET `status`='Logged Out' WHERE `idagent` = " + result[0].idagent + "";
                            obj1.prepare();
                            obj1.execute((err, rep) => {
                                if (err == 1) {
                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "DELETE FROM `session` WHERE `idagent` = " + result[0].idagent + "";
                                    obj2.prepare();
                                    obj2.execute((err1, resp) => {
                                        if (err1 == 1) {
                                            let obj3 = new RawView_1.RawView(res);
                                            obj3.prepare({ Result: "Agent Logout Successfully", status: 201 });
                                            obj3.execute();
                                        }
                                        else {
                                            let obj3 = new RawView_1.RawView(res);
                                            obj3.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                            obj3.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj2 = new RawView_1.RawView(res);
                                    obj2.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                    obj2.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Data Found!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    changeStatus(req, res, next) {
        let sdata = req.body;
        let status = req.body.AgentStatus === "Ready" ? "Available" : "On Break";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idagent` from `session` where `authkey`='" + sdata.Session + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            if (result.length > 0) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `agents` SET `status`='" + status + "' WHERE `idagent` = '" + result[0].idagent + "'";
                                obj1.prepare();
                                obj1.execute((err, rep) => {
                                    if (err == 1) {
                                        let obj2 = new RawView_1.RawView(res);
                                        obj2.prepare({ message: "Update Agent Status Successfully", status: 201 });
                                        obj2.execute();
                                    }
                                    else {
                                        let obj2 = new RawView_1.RawView(res);
                                        obj2.prepare({ message: "Something Went Wrong With Connection", error: result, status: 502 });
                                        obj2.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "No Data Found!", status: 502, error: result });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", error: result, status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // To Send Channel Request
    saveChannelRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = req.body.data;
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "INSERT INTO channel_request (`iduser`,`idaccount`,`current_in_channel_limit`, `current_out_channel_limit`, `request_in_channel_limit`,`request_out_channel_limit`) VALUES(" + sessdata.iduser + "," + sessdata.idaccount + ",'" + (0, markError_1.setToZero)(rdata.current_in_channel_limit) + "', '" + (0, markError_1.setToZero)(rdata.current_out_channel_limit) + "', '" + (0, markError_1.setToZero)(rdata.request_in_channel_limit) + "', '" + (0, markError_1.setToZero)(rdata.request_out_channel_limit) + "')";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, message: "Channel Request Send Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 501, message: "Channel Request Not Sent!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    channelRequestList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var sdata = req.query;
                let condition;
                if (sessdata.type == 1)
                    condition = sdata.type !== null && sdata.type !== undefined && sdata.type ? "WHERE `idaccount`= '" + sdata.type + "'" : '';
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition = "WHERE `idaccount`= " + sessdata.idaccount + "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `channel_id`, `iduser`,`idaccount`,`current_in_channel_limit`,`current_out_channel_limit`,`request_in_channel_limit`,`request_out_channel_limit`,`created_at`,`updated_at`,`status` FROM `channel_request` " + condition + " ORDER BY  `channel_id` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Channel Requests Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Channel Requests Available!", data: result, status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "List Not Fetched Successfully!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    changeChanelStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let msgSuc;
                let msgErr;
                if (data.status == '1') {
                    msgSuc = "Channel Limit Approved Successfully!";
                    msgErr = "Channel Limit Not Approved!";
                }
                if (data.status == '2') {
                    msgSuc = "Channel Limit Rejected Successfully!";
                    msgErr = "Channel Limit Not Rejected!";
                }
                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj1.nonqrysql = "UPDATE `channel_request` SET `status`='" + data.status + "',`updated_at`=NOW() WHERE `channel_id`=" + data.channel_id + "";
                obj1.prepare();
                obj1.execute((error, result) => {
                    if (error == 1) {
                        if (data.status == '1') {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "UPDATE `account` SET `ib_channel`='" + (0, markError_1.setToZero)(data.request_in_channel_limit) + "',`ob_channel`='" + (0, markError_1.setToZero)(data.request_out_channel_limit) + "' WHERE `idaccount`='" + data.idaccount + "'";
                            obj0.prepare();
                            obj0.execute((error, result) => { });
                        }
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: msgSuc });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: msgErr });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
}
exports.AgentClass = AgentClass;
