"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Users = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
// import { AppRoute } from "../lib/AppRoute";
const markError_1 = require("./markError");
class Users {
    constructor() {
        // super();
    }
    AddCustomer(req, res, next) {
        console.log(req.body.data);
        let sdata;
        try {
            sdata = JSON.parse(req.body.data);
        }
        catch (e) {
            console.log("Error :: AddCustomer::", e);
            sdata = req.body.data;
        }
        let session = new Session_1.SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (sdata.iduser == -1) {
                    obj.nonqrysql = "CALL AddCustomer(-1, " + sessdata.id + ", 1, '" + (0, markError_1.parseBody)(sdata.username) + "','" + sdata.password + "','" + sdata.email + "','','" + sdata.contact + "','" + sdata.fullname + "','','','Male',0,0,0,0,'')";
                    msg = "Customer Account is added successfully";
                }
                else {
                    obj.nonqrysql = "CALL AddCustomer('" + sdata.iduser + "', " + sessdata.id + ", 1, '','','" + sdata.email + "','" + (0, markError_1.parseBody)(sdata.company) + "','" + sdata.contact + "','" + (0, markError_1.parseBody)(sdata.fullname) + "','" + (0, markError_1.parseBody)(sdata.address) + "','" + (0, markError_1.parseBody)(sdata.city) + "','" + sdata.gender + "','" + sdata.billingrate + "','" + sdata.maxprice + "','" + sdata.maxagent + "','" + (0, markError_1.setToZero)(sdata.creditlimit) + "', '" + sdata.servers + "')";
                    msg = "Customer Account is updated successfully";
                }
                obj.prepare();
                obj.execute((error, result) => {
                    //console.log(result);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result[0], message: msg });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    AddSupplier(req, res, next) {
        console.log(req.body.data);
        let sdata;
        try {
            sdata = JSON.parse(req.body.data);
        }
        catch (e) {
            console.log("Error :: AddSupplier::", e);
            sdata = req.body.data;
        }
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (sdata.id == -1)
                    obj.nonqrysql = "CALL AddSupplier('-1', '" + sdata.name + "','" + sdata.ipaddress + "','" + sdata.prefix + "','" + sdata.rates + "', '')";
                else
                    obj.nonqrysql = "CALL  UpdateProviders('" + sdata.id + "', '" + sdata.name + "','" + sdata.ip + "','" + sdata.prefix + "','" + sdata.rate + "', '" + sdata.servers + "')";
                obj.prepare();
                obj.execute((error, result) => {
                    //console.log(result);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: "Supplier is added successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getServer(req, res, next) {
        let sdata = req.query.filter;
        let session = new Session_1.SessionManagment(req, res, next);
        try {
            sdata = JSON.parse(sdata);
        }
        catch (err) {
            console.log("Error :: getServer::", err);
        }
        console.log(sdata);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL getUserServer('" + sdata.id + "')";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result[0], message: "Get server details successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DeleteSupplier(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(req.query);
                var sdata = req.query;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteSupplier(" + sdata.id + ")";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: "Delete data successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DeleteCustomer(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(req.query);
                var sdata = req.query;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteUser(" + sessdata.id + ", " + sdata.id + ")";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: "Delete data successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    Recharge(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(req.body.data);
                let sdata;
                try {
                    sdata = JSON.parse(req.body.data);
                }
                catch (e) {
                    console.log("Error :: Recharge::", e);
                    sdata = req.body.data;
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL AddBalance(" + sessdata.id + ", " + sdata.userid + ", '" + sdata.amount + "','" + sdata.description + "')";
                obj.prepare();
                obj.execute((error, result) => {
                    console.log(result);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result[0], message: "Account is recharged successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    ManageServer(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(req.body.data);
                let sdata;
                try {
                    sdata = JSON.parse(req.body.data);
                }
                catch (e) {
                    console.log("Error :: ManageServer::", e);
                    sdata = req.body.data;
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL ManageServer(" + sdata.id + ", '" + sdata.detail + "')";
                obj.prepare();
                obj.execute((error, result) => {
                    console.log(result);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare(res);
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Users = Users;
