"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelPdfUpload = void 0;
const ModelObject_1 = require("./ModelObject");
const _405_1 = require("../view/405");
const server_1 = require("../../server");
var fs = require('fs');
class ModelPdfUpload extends ModelObject_1.ModelObject {
    constructor(req, res) {
        super(req, res);
        this.type = "INSERT";
    }
    fileUpload() {
        console.log(this.req.file);
        var target_path = process.cwd() + "/uploads/" + this.req.file.originalname;
        var tmp_path = this.req.file.path;
        var src = fs.createReadStream(tmp_path);
        var dest = fs.createWriteStream(target_path);
        src.pipe(dest);
        var data = [this.req.file.originalname, this.req.file.path];
        return data;
    }
    prepare() {
        var ret = true;
        console.log("Current into prepare function of uploadfile=============");
        console.log(this.req.body.data);
        if (this.req.file.mimetype != "application/pdf") {
            console.log("Invalid File type");
            let objv = new _405_1.Res405(this.res);
            objv.prepare({ error: "No file Uploaded or Invalid file format" });
            objv.execute();
            ret = false;
        }
        if (this.table.length < 1 || this.table == null) {
            console.log("Table is not defined properly.");
            ret = false;
        }
        if (this.req.body.data != "") {
            //this.nonquery.data=this.req.body.data;
            let time = Date.now();
            let tiffile = 'file' + time;
            this.nonquery.data = {
                filename: this.req.file.originalname,
                filepath: this.req.file.path,
                tiffile: tiffile,
                iduser: server_1.cursess.session.id
            };
            console.log(this.nonquery.data);
        }
        else {
            let objv = new _405_1.Res405(this.res);
            objv.prepare({ error: "Invalid request type" });
            objv.execute();
            console.log("Data is not found into the request");
            ret = false;
        }
        console.log("End of prepare function of uploadfile=============with return " + ret);
        return ret;
    }
    execute(callback) {
        this.log.Debug("Calling Pdf Upload function in ModelObject.");
        this.nonquery.prepare();
        this.nonquery.Execute((err, data) => {
            data = Object.assign(this.nonquery.data, data);
            console.log(data);
            this.respond(err, data, callback);
        });
    }
}
exports.ModelPdfUpload = ModelPdfUpload;
