"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelProcedure = void 0;
const ModelObject_1 = require("./ModelObject");
class ModelProcedure extends ModelObject_1.ModelObject {
    constructor(req, res) {
        super(req, res);
        this.type = "PROCEDURE";
    }
    prepare(fields) {
        var ret = true;
        console.log(this.req.query);
        console.log(this.req.body);
        if (this.name.length < 1 || this.name == null) {
            console.log("Procedure is not defined properly.");
            return false;
        }
        let tmpdata = {}, tmp = {};
        if (this.req.body.hasOwnProperty('data')) {
            try {
                tmpdata = JSON.parse(this.req.body.data);
            }
            catch (e) {
                tmpdata = this.req.body.data;
            }
        }
        else {
            console.log("Data is not found into the request");
            return false;
        }
        fields.forEach((element) => {
            if (tmpdata.hasOwnProperty(element)) {
                tmp[element] = tmpdata[element];
            }
        });
        this.nonquery.data = tmp;
        return ret;
    }
    execute(callback) {
        this.log.Debug("Calling uPDATE function in ModelObject.");
        this.nonquery.prepare();
        this.nonquery.Execute((err, data) => {
            this.respond(err, data, callback);
        });
    }
}
exports.ModelProcedure = ModelProcedure;
