"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Commission = void 0;
const AppRoute_1 = require("../lib/AppRoute");
const RawView_1 = require("../lib/view/RawView");
const RawQuery_1 = require("../lib/model/RawQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
class Commission extends AppRoute_1.AppRoute {
    constructor() {
        super();
    }
    /*commission details filter*/
    commissionFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let data = req.query.type;
                let sdata = JSON.parse(data);
                let condition = '';
                if (sessdata.type == 4) {
                    condition += ' AND `reseller_iduser`="' + sessdata.iduser + '" ';
                }
                if (sdata.selectedUser) {
                    condition += ' AND `reseller_iduser`="' + sdata.selectedUser + '" ';
                }
                if (sdata.fromDate) {
                    condition += " AND DATE_FORMAT(`created_at`,'%Y-%m-%d')>='" + sdata.fromDate + "'";
                }
                if (sdata.toDate) {
                    condition += " AND DATE_FORMAT(`created_at`,'%Y-%m-%d')<='" + sdata.toDate + "'";
                }
                if (sdata.san)
                    condition += ' AND `cust_idaccount` LIKE "%' + Math.floor(sdata.san - 100000000) + '%" ';
                if (sdata.commission_amount)
                    condition += 'AND `commission_amount`  LIKE "%' + sdata.commission_amount + '%" ';
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT (100000000 + `cust_idaccount`) `san`, `invoice_number`,`customer_name`,`commission_amount`,`total_amount`,COALESCE(DATE_FORMAT(`created_at`, '%Y-%m-%d %H:%i:%s'),'N/A') `created_at` FROM `commission_detail` WHERE `cd_id` !='' " + condition + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Fetched Data Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Record Found!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong Find Records!", status: 502 });
                        objv.execute();
                    }
                });
            }
        });
    }
    /**GET query for Commission Plan */
    getCommissionPlan(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id_plan`,`plan_name`,`description`,`created_at`,`updated_at`,`assigned_id` FROM `commission_plan`WHERE `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Commission Plan Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Commission Plan List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /*GET query for Commission Tier */
    getCommissionTier(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT cp.plan_name,ct.tier,ct.from_amount,ct.to_amount,ct.commission FROM `commission_plan` cp LEFT JOIN `commission_tier` ct ON cp.assigned_id=ct.id_plan WHERE cp.iduser='" + sessdata.iduser + "' ORDER BY tier";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Commission Tier Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Commission Tier List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    commSummaryFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.query.type;
                let sdata = JSON.parse(data);
                let condition = "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                if (sdata.fromDate && sdata.toDate) {
                    condition += '`date` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                }
                if (sessdata.iduser) {
                    condition += '`iduser`="' + sessdata.iduser + '" AND ';
                }
                if (sdata.transaction_id)
                    condition += '`transaction_id` LIKE "%' + sdata.transaction_id + '%" AND ';
                if (sdata.status) {
                    condition += ' `status` = "' + sdata.status + '" AND ';
                }
                obj.qrysql = "SELECT `username`, `reseller_name`, iduser, date, DATE_FORMAT(`date`, '%Y-%m-%d %H:%i:%s')`date`, COALESCE(reseller_name,'N/A') reseller_name,COALESCE(total_invoice_amount,'N/A') total_invoice_amount,COALESCE(commissinable_revenue,'N/A')commissinable_revenue, COALESCE(non_commissinable_revenue,'N/A') non_commissinable_revenue,COALESCE(commission_amount,'N/A')commission_amount, COALESCE(transaction_id,'N/A')transaction_id,COALESCE(status,'N/A')`status` FROM `commission_summary` WHERE " + condition + " `type`='4' ORDER BY `date` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Commission Details Fetched Successfully!",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "No Record Found!",
                                status: 401,
                                error: result
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched Commission Details!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Commission = Commission;
