"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InteliquentAPI = void 0;
const APIBase_1 = require("./APIBase");
const numberApi_1 = require("./numberApi");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const Osr_1 = require("./Osr");
const SinchSubmitNumber_1 = require("./SinchSubmitNumber");
var request = require('request');
class InteliquentAPI extends APIBase_1.APIBase {
    key;
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        this.key = "eFluR1hOVERZZGY3dHc5Tno4dzFaemhtbFpnQzpEendnQjZCMVVKc2JwaUZxRXBieW9MODY0dFR3";
        this.timekey = timekey,
            this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }
    rpad(name, size) {
        let ret = name;
        for (let i = name.length; i < size; i++)
            ret += "x";
        return ret;
    }
    getNpaNxx(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    let tnMask;
                    if (sdata.NXX == "null" || sdata.NXX == undefined) {
                        tnMask = this.rpad(sdata.NPA, 10);
                    }
                    if (sdata.NXX !== undefined && sdata.NXX !== 'null') {
                        tnMask = this.rpad(sdata.NPA + "" + sdata.NXX, 10);
                    }
                    var options = {
                        'method': 'POST',
                        'url': 'https://services.inteliquent.com/Services/2.0.0/tnInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': 'xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC',
                            "tnMask": tnMask,
                            "quantity": sdata.Qty
                        }),
                    };
                    request(options, (error, response) => {
                        console.log("Responce", response.body);
                        let ddata = JSON.parse(response.body);
                        if (!error) {
                            if (ddata.statusCode == 200) {
                                console.log("data", ddata);
                                if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                    let str = ddata.tnResult;
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele) => {
                                        qrystr += "('', '" + ele.telephoneNumber + "', '" + ele.lata + "', '', '" + ele.rateCenter + "', '" + ele.province + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + ele.city + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.rateCenterTier + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback('', ddata);
                                }
                            }
                            else {
                                callback('', ddata);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    callback(err, voice_rate);
                }
            });
        }
    }
    getByRate(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    var options = {
                        'method': 'POST',
                        'url': 'https://services.inteliquent.com/Services/1.0.0/tnInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': 'xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC',
                            "tnMask": "**********",
                            "tnWildcard": "***********",
                            "rateCenter": sdata.RateCenter,
                            "province": sdata.State,
                            "quantity": sdata.Qty
                        }),
                    };
                    request(options, (error, response) => {
                        let ddata = JSON.parse(response.body);
                        console.log("ddata", ddata);
                        if (!error) {
                            if (ddata.statusCode == 200) {
                                if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                    let str = ddata.tnResult;
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele) => {
                                        qrystr += "('', '" + ele.telephoneNumber + "', '" + ele.lata + "', '', '" + ele.rateCenter + "', '" + ele.province + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + ele.city + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.rateCenterTier + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback('', ddata);
                                }
                            }
                            else {
                                callback('', ddata);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    callback(err, voice_rate);
                }
            });
        }
    }
    getTollFree(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    let tnMask;
                    if (sdata.TF_PREFIX !== undefined) {
                        tnMask = this.rpad(sdata.TF_PREFIX, 10);
                    }
                    else {
                        tnMask = "**********";
                    }
                    var options = {
                        'method': 'POST',
                        'url': 'https://services.inteliquent.com/Services/1.0.0/tfInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': 'xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC',
                            "tnMask": tnMask,
                            "quantity": sdata.Qty,
                        }),
                    };
                    request(options, (error, response) => {
                        let ddata = JSON.parse(response.body);
                        console.log("ddata", JSON.stringify(ddata));
                        if (!error) {
                            if (ddata.statusCode == 200) {
                                if (ddata.tfList.tfItem != undefined && ddata.tfList.tfItem.length > 0) {
                                    let str = ddata.tfList.tfItem;
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele) => {
                                        qrystr += "('', '" + ele.tn + "', '', '', '', '', '', '', '', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','" + "TF" + "','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback('', ddata);
                                }
                            }
                            else {
                                callback('', ddata);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    callback(err, voice_rate);
                }
            });
        }
    }
    buyDID(req, res, did_details, other_data, callback) {
        const sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let id_grouporder = other_data.id_grouporder;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            // To get the proration status
            let objv0 = new RawQuery_1.ModelRawQuery(req, res);
            objv0.qrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let proration_status = proration_success[0].proration;
                    // To purchase the toll free number
                    if (did_details[0].type == "TF") {
                        var options = {
                            'method': 'POST',
                            'url': 'https://services.inteliquent.com/Services/1.0.0/tfOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "privateKey": "xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC",
                                "productAbbr": "8XXAVAIL",
                                "tfOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "resporgId": "LQX01",
                                                "routingLabel": "NTDAL-4927-8XX-950",
                                                "trunkGroup": "CHCGIL24IPL_4649"
                                            }
                                        ]
                                    }
                                }
                            })
                        };
                        request(options, (error, response) => {
                            let sdata1 = JSON.parse(response.body);
                            console.log("Inteliq::", sdata1);
                            if (!error) {
                                // If order success
                                if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate = new Date();
                                            let lDate = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate();
                                            let totalDays = (lDate - day) + 1;
                                            let prorate;
                                            if (proration_status == "true") {
                                                prorate = (totalDays * did_details[0].rates) / 30;
                                            }
                                            else {
                                                prorate = did_details[0].rates;
                                            }
                                            console.log(prorate);
                                            prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0;
                                            // To update the wallet amount
                                            let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                                // To update the wallet transaction log
                                                let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", ";
                                                iQry += "`amount`='-" + prorate + "', ";
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', ";
                                                iQry += "`status`=1;";
                                                let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry;
                                                objWL.prepare();
                                                objWL.execute((error, result) => {
                                                    console.log("Transaction response::", result);
                                                });
                                                // To create the DID log
                                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });
                                                // To delete the DID from cart
                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                obj5.prepare();
                                                obj5.execute((walletError, wallet) => { });
                                                // To create the did_order
                                                let providerOrderId = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : '';
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order = did_data.insertId;
                                                        let orderID = "SORD" + id_order.toString();
                                                        let log_error = "";
                                                        let log_message = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        let log_result = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";";
                                                        obj.prepare();
                                                        obj.execute((error, result) => { });
                                                    }
                                                });
                                                // Leave the successfull output
                                                let objV = new RawView_1.RawView(res);
                                                objV.prepare({
                                                    error_code: 1,
                                                    status: 201,
                                                    message: "DID buy successfully.",
                                                    result: [
                                                        {
                                                            "did": sdata.DID.trim()
                                                        }
                                                    ]
                                                });
                                                objV.execute();
                                            });
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                }
                                // If order failed
                                else {
                                    // To delete the DID from cart
                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                    obj5.prepare();
                                    obj5.execute((walletError, wallet) => { });
                                    let I1 = sdata1.status.indexOf("Waiting on internal port");
                                    let I2 = sdata1.status.indexOf("TN is on a pending order");
                                    let providerOrderId = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : '';
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    // It will check, if order goes into pending
                                    if (I1 > -1 || I2 > -1) {
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`, `ordConf`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "', '0')";
                                    }
                                    else {
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                    }
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order = did_data.insertId;
                                            let orderID = "SORD" + id_order.toString();
                                            let log_error = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_message = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_result = "";
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";";
                                            obj.prepare();
                                            obj.execute((error, result) => { });
                                        }
                                    });
                                    let objV = new RawView_1.RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: sdata1.statusCode,
                                        message: sdata1.status
                                    });
                                    objV.execute();
                                }
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 400, error: error });
                                obj.execute();
                            }
                        });
                    }
                    // To purchase the local number
                    else {
                        var options = {
                            'method': 'POST',
                            'url': 'https://services.inteliquent.com/Services/1.0.0/tnOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "privateKey": "xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC",
                                "tnOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "trunkGroup": "CHCGIL24IPL_4648"
                                            }
                                        ]
                                    }
                                }
                            })
                        };
                        request(options, (error, response) => {
                            let sdata1 = JSON.parse(response.body);
                            console.log("Inteliq::", sdata1);
                            if (!error) {
                                // If order success
                                if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate = new Date();
                                            let lDate = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate();
                                            let totalDays = (lDate - day) + 1;
                                            let prorate;
                                            if (proration_status == "true") {
                                                prorate = (totalDays * did_details[0].rates) / 30;
                                            }
                                            else {
                                                prorate = did_details[0].rates;
                                            }
                                            console.log(prorate);
                                            prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0;
                                            // To update the wallet amount
                                            let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                                // To update the wallet transaction log
                                                let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", ";
                                                iQry += "`amount`='-" + prorate + "', ";
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', ";
                                                iQry += "`status`=1;";
                                                let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry;
                                                objWL.prepare();
                                                objWL.execute((error, result) => {
                                                    console.log("Transaction response::", result);
                                                });
                                                // To create the DID log
                                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });
                                                // To delete the DID from cart
                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                obj5.prepare();
                                                obj5.execute((walletError, wallet) => { });
                                                // To create the did_order
                                                let providerOrderId = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : '';
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order = did_data.insertId;
                                                        let orderID = "SORD" + id_order.toString();
                                                        let log_error = "";
                                                        let log_message = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        let log_result = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";";
                                                        obj.prepare();
                                                        obj.execute((error, result) => { });
                                                    }
                                                });
                                                // To submit the number on OSR
                                                if (sdata.CampaignId) {
                                                    let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                                    osr.updateNumber(req, res, data.insertId, (error, responce) => { });
                                                }
                                                else {
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({
                                                        error_code: 1,
                                                        status: 201,
                                                        message: "DID buy successfully.",
                                                        result: [
                                                            {
                                                                "did": sdata.DID.trim()
                                                            }
                                                        ]
                                                    });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                }
                                // If order failed
                                else {
                                    // To delete the DID from cart
                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                    obj5.prepare();
                                    obj5.execute((walletError, wallet) => { });
                                    let providerOrderId = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : '';
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order = did_data.insertId;
                                            let orderID = "SORD" + id_order.toString();
                                            let log_error = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_message = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_result = "";
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";";
                                            obj.prepare();
                                            obj.execute((error, result) => { });
                                        }
                                    });
                                    let objV = new RawView_1.RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: sdata1.statusCode,
                                        message: sdata1.status
                                    });
                                    objV.execute();
                                }
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 400,
                                    error: error
                                });
                                obj.execute();
                            }
                        });
                    }
                }
                else {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }
    disconnectDID(req, res, callback) {
        const sdata = req.body;
        let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `day_num` from `tariff` WHERE `idtariff`='" + this.sessdata.idtariff + "'";
        obj1.prepare();
        obj1.execute((errday, resday) => {
            if (errday == 1 && resday.length > 0) {
                let number = new numberApi_1.Number();
                number.countDays(req, res, sdata.DID.trim(), (err, countdays) => {
                    if (countdays && countdays > resday[0].day_num) {
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `type` from `did_buy` WHERE `iduser`='" + iduser + "' AND `did`='" + sdata.DID.trim() + "'";
                        obj2.prepare();
                        obj2.execute((err, resu) => {
                            if (resu.length > 0) {
                                // To release the toll-free number
                                if (resu[0].type == "TF") {
                                    var options = {
                                        'method': 'POST',
                                        'url': 'https://services.inteliquent.com/Services/1.0.0/tfDisconnect',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + this.key
                                        },
                                        body: JSON.stringify({
                                            "privateKey": "xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC",
                                            "tnList": {
                                                "tnItem": [
                                                    {
                                                        "tn": sdata.DID.trim()
                                                    }
                                                ]
                                            }
                                        })
                                    };
                                    request(options, (error, response) => {
                                        console.log("Inteliquent Err::", error);
                                        if (!error) {
                                            console.log("Inteliquent Res::", response.body);
                                            let data = JSON.parse(response.body);
                                            if (data.status == 'Success') {
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                                obj.prepare();
                                                obj.execute((error, resp) => {
                                                    if (error == 1) {
                                                        // To  update updated_at date in did log
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1";
                                                        obj.prepare();
                                                        obj.execute((errorDiDLg, resDiDLg) => { });
                                                        // To delete the number from OSR
                                                        let objv = new RawView_1.RawView(res);
                                                        let payLoad = {
                                                            DID: sdata.DID.trim()
                                                        };
                                                        let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                                        osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                            console.log("OSR Response::", response);
                                                            if (error == 1) {
                                                                // To delete the number from Sinch
                                                                let osr = new SinchSubmitNumber_1.SinchApi(this.priority, this.sessdata);
                                                                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                                    console.log("Sinch Response::", response);
                                                                });
                                                            }
                                                        });
                                                        // To release the final output
                                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: data.statusCode, message: data.status });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 400, error: error });
                                            objv.execute();
                                        }
                                    });
                                }
                                // To release the local number
                                else {
                                    var options = {
                                        'method': 'POST',
                                        'url': 'https://services.inteliquent.com/Services/1.0.0/tnDisconnect',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + this.key
                                        },
                                        body: JSON.stringify({
                                            "privateKey": "xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC",
                                            "tnList": {
                                                "tnItem": [
                                                    {
                                                        "tn": sdata.DID.trim()
                                                    }
                                                ]
                                            }
                                        })
                                    };
                                    request(options, (error, response) => {
                                        console.log("Inteliquent Err::", error);
                                        if (!error) {
                                            console.log("Inteliquent Res::", response.body);
                                            let data = JSON.parse(response.body);
                                            console.log("Data", data);
                                            if (data.status == 'Success') {
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                                obj.prepare();
                                                obj.execute((error, resp) => {
                                                    if (error == 1) {
                                                        // To  update updated_at date in did log
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1";
                                                        obj.prepare();
                                                        obj.execute((errorDiDLg, resDiDLg) => { });
                                                        // To delete the number from OSR
                                                        let objv = new RawView_1.RawView(res);
                                                        let payLoad = {
                                                            DID: sdata.DID.trim()
                                                        };
                                                        let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                                        osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                            console.log("OSR Response::", response);
                                                            if (error == 1) {
                                                                // To delete the number from Sinch
                                                                let osr = new SinchSubmitNumber_1.SinchApi(this.priority, this.sessdata);
                                                                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                                    console.log("Sinch Response::", response);
                                                                });
                                                            }
                                                        });
                                                        // To release the final output
                                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: "Something Went Wrong" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: data.statusCode, message: data.status });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 400, error: error });
                                            objv.execute();
                                        }
                                    });
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 417, message: "Days are Less then " + resday[0].day_num + " So you can not disconnect Did from this Account" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Days Not Found!" });
                objv.execute();
            }
        });
    }
}
exports.InteliquentAPI = InteliquentAPI;
