"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PeerlessAPI = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const Osr_1 = require("./Osr");
const SinchSubmitNumber_1 = require("./SinchSubmitNumber");
const numberApi_1 = require("./numberApi");
var request = require('request');
var convert = require('xml-js');
class PeerlessAPI extends APIBase_1.APIBase {
    url;
    customer;
    passCode;
    userId;
    soapenv;
    pub;
    key;
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        this.customer = "TRAYTECKdba";
        this.passCode = "F6EBSVEJ";
        this.userId = "jeremy.kelley_stg@iplinktelecom.com";
        this.soapenv = "http://schemas.xmlsoap.org/soap/envelope/";
        this.pub = "http://publicapi.api.s2.peerless.com/";
        // for staging server
        this.url = "https://aniweb02.peerlessnetwork.com:8181/public/APIService?wsdl";
        // for production server
        // this.url = "https://animate.peerlessnetwork.com:8181/public/APIService?wsdl"
        this.priority = proirity;
        this.key = "";
        this.secret = "";
        this.timekey = timekey,
            this.sessdata = sessdata;
    }
    getNpaNxx(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                let condition = "";
                let stateRateCenter = "";
                if (req.query.NPA && (req.query.NXX == '' || req.query.NXX == 'null')) {
                    condition = '<npas><npa>' + req.query.NPA + '</npa></npas>';
                    stateRateCenter = "SELECT `state`, `region` FROM `lerg_info` WHERE npa = '" + req.query.NPA + "'";
                }
                else if (req.query.NPA && req.query.NXX) {
                    condition = '<npas><npa>' + req.query.NPA + '</npa></npas><nxxs><nxx>' + req.query.NXX + '</nxx></nxxs>';
                    stateRateCenter = "SELECT `state`, `region` FROM `lerg_info` WHERE npa = '" + req.query.NPA + "' AND nxx = '" + req.query.NXX + "'";
                }
                let objv0 = new RawQuery_1.ModelRawQuery(req, res);
                objv0.qrysql = stateRateCenter;
                objv0.prepare();
                objv0.execute((state_error, state_success) => {
                    if (state_error == 1) {
                        const qty = req.query.Qty;
                        let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><filters>' + condition + '<quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
                        let options = {
                            'method': 'POST',
                            'url': this.url,
                            'body': data,
                            'headers': {
                                'Content-Type': 'text/xml',
                                'SOAPAction': 'searchNumbers'
                            },
                        };
                        console.log("Peerless Http::", options);
                        request(options, (error, response, body) => {
                            console.log("Peerless::\n", body);
                            if (body) {
                                let tmp = body;
                                var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                                var res1 = JSON.parse(result1);
                                let check = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["tnCount"];
                                if (check._text > '0') {
                                    let ddata = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["result"]["tn"];
                                    if (!ddata.length) {
                                        ddata = [ddata];
                                    }
                                    if (ddata !== undefined && ddata.length > 0) {
                                        let str = ddata;
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`,`iduser`,`idaccount`, `priorty`,`key`,`type`,`rates`) VALUE ";
                                        str.forEach((ele) => {
                                            qrystr += "('','" + ele.number._text + "','', '', '', '', '', '', '' ,'" + "Peerless" + "','" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '" + this.priority + "','" + this.timekey + "','NN','" + voice_rate[0].rate + "'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback('', ddata);
                                    }
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 502, message: "No DID Found!" });
                                    obj.execute();
                                }
                            }
                            else {
                                callback('', error);
                            }
                        });
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with get State and Rate Center!" });
                        obj.execute();
                    }
                });
            });
        }
    }
    getByRate(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const state = req.query.State;
                    const rate_center = req.query.RateCenter;
                    const qty = req.query.Qty;
                    let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><filters><states><state>' + state + '</state></states><rateCenters><rateCenter>' + rate_center + '</rateCenter></rateCenters><quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
                    let options = {
                        'method': 'POST',
                        'url': this.url,
                        'body': data,
                        'headers': {
                            'Content-Type': 'text/xml',
                            'SOAPAction': 'searchNumbers'
                        },
                    };
                    console.log("Peerless Http::", options);
                    request(options, (error, response, body) => {
                        console.log("Peerless::\n", body);
                        if (!error) {
                            let tmp = body;
                            var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                            var res1 = JSON.parse(result1);
                            var check = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["tnCount"];
                            if (check._text > '0') {
                                var ddata = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["result"]["tn"];
                                if (!ddata.length) {
                                    ddata = [ddata];
                                }
                                let rateCenter = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["rateCenters"]["rateCenter"]["_text"];
                                let state = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["states"]["state"]["_text"];
                                if (ddata !== undefined && ddata.length > 0) {
                                    let str = ddata;
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`iduser`,`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`,`key`,`type`,`rates`) VALUE ";
                                    str.forEach((ele) => {
                                        qrystr += "('" + this.sessdata.iduser + "', '','" + ele.number._text + "', '', '', '" + rateCenter + "','" + state + "', '', '', '','" + "Peerless" + "', '" + this.sessdata.idaccount + "', '" + this.priority + "','" + this.timekey + "','NN','" + voice_rate[0].rate + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback('', ddata);
                                }
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "No DID Found!" });
                                obj.execute();
                            }
                        }
                        else {
                            callback('', error);
                        }
                    });
                }
                else {
                    callback(err, voice_rate);
                }
            });
        }
    }
    getTollFree(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            const tollfree = req.query.TF_PREFIX;
            const qty = req.query.Qty;
            /** For testing purpose */
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                let condition = "";
                condition = '<npas><npa>' + tollfree + '</npa></npas>';
                const qty = req.query.Qty;
                let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><filters>' + condition + '<quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
                let options = {
                    'method': 'POST',
                    'url': this.url,
                    'body': data,
                    'headers': {
                        'Content-Type': 'text/xml',
                        'SOAPAction': 'searchNumbers'
                    },
                };
                console.log("Peerless TF Options::", options);
                request(options, (error, response, body) => {
                    console.log("Peerless TF Search::\n", body);
                    if (body) {
                        let tmp = body;
                        var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                        var res1 = JSON.parse(result1);
                        let check = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["tnCount"];
                        if (check._text > '0') {
                            let ddata = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["result"]["tn"];
                            if (!ddata.length) {
                                ddata = [ddata];
                            }
                            if (ddata !== undefined && ddata.length > 0) {
                                let str = ddata;
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`,`iduser`,`idaccount`, `priorty`,`key`,`type`,`rates`) VALUE ";
                                str.forEach((ele) => {
                                    qrystr += "('','" + ele.number._text + "','', '', '', '', '', '', '' ,'" + "Peerless" + "','" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '" + this.priority + "','" + this.timekey + "','TF','" + voice_rate[0].rate + "'),";
                                });
                                obj1.nonqrysql = qrystr.slice(0, -1);
                                obj1.prepare();
                                obj1.execute((err, data) => {
                                    callback(err, data);
                                });
                            }
                            else {
                                callback('', ddata);
                            }
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 502, message: "No DID Found!" });
                            obj.execute();
                        }
                    }
                    else {
                        callback('', error);
                    }
                });
            });
            // let options: any = {
            //     'method': 'POST',
            //     'url': 'https://devapi.coretel.net/cgi-bin/xmlnumberdb.pl',
            //     'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>VanitySearch</RequestType><Purpose>SIP</Purpose><Quantity>" + qty + "</Quantity><Tollfree>" + tollfree + "</Tollfree><BillingAccount>" + this.key + "</BillingAccount><Password>" + this.secret + "</Password></xml>",
            //     rejectUnauthorized: false,
            //     requestCert: true,
            //     agent: false
            // };
            // console.log("Peerless Http::", options)
            // request(options, (error: any, response: any, body: any) => {
            //     console.log("Peerless::\n", body)
            //     if (!error) {
            //         let tmp: string = body;
            //         let valid_xml = tmp.slice(0, -6)
            //         console.log(valid_xml);
            //         var result1 = convert.xml2json(valid_xml, { compact: true, spaces: 4 });
            //         var res1 = JSON.parse(result1);
            //         let ddata = res1.xml.SearchResult;
            //         console.log("Data==>", ddata);
            //         if (ddata !== undefined && ddata.length > 0) {
            //             let str: any = ddata;
            //             let obj1 = new ModelRawNonQuery(req, res);
            //             let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`, `type`) VALUE ";
            //             str.forEach((ele: any) => {
            //                 console.log(ele.Number._text);
            //                 qrystr += "('','" + ele.Number._text + "', '', '', '" + ele.RateCenter._text + "', '', '', '', '' ,'" + "coreTel" + "', '" + this.sessdata.idaccount + "', '" + this.priority + "', 'TF'),";
            //             });
            //             obj1.nonqrysql = qrystr.slice(0, -1);
            //             obj1.prepare();
            //             obj1.execute((err, data) => {
            //                 callback(err, data);
            //             });
            //         } else {
            //             callback('', ddata);
            //         }
            //     } else {
            //         callback('', error);
            //     }
            // });
        }
    }
    buyDID(req, res, did_details, other_data, callback) {
        const sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let id_grouporder = other_data.id_grouporder;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            // To get the proration status
            let objv0 = new RawQuery_1.ModelRawQuery(req, res);
            objv0.qrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let proration_status = proration_success[0].proration;
                    // To purchase the toll-free number
                    if (did_details[0].type == "TF") {
                        let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:placeTFOrder><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><TFNOrder><orderType>TF</orderType><respOrgId>PNN01</respOrgId><defaultAos>US</defaultAos><defaultDestination>TF_TTTF_02</defaultDestination><defaultPayPhoneBlocking>1</defaultPayPhoneBlocking><tollFreeOrderNumbers><tollFreeOrderNumbers><tn>' + sdata.DID.trim() + '</tn><aos>US</aos><destination>TF_TTTF_02</destination><cnamDelivery>true</cnamDelivery><payPhoneBlocking>true</payPhoneBlocking></tollFreeOrderNumbers></tollFreeOrderNumbers></TFNOrder></pub:placeTFOrder></soapenv:Body></soapenv:Envelope>';
                        let options = {
                            'method': 'POST',
                            'url': this.url,
                            'headers': {
                                'Content-Type': 'text/xml',
                                'SOAPAction': 'placeTFOrder'
                            },
                            body: data,
                        };
                        console.log("Peerless place order options::", options);
                        request(options, (error, response, body) => {
                            console.log("Peerless place order response::\n", body);
                            let tmp = body;
                            var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                            let res1 = JSON.parse(result1);
                            if (!error) {
                                // If order placed successfully
                                if (typeof res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"] != 'undefined') {
                                    let providerOrderId = typeof res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"]["return"] != 'undefined' && res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"]["return"]["_text"] ? res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"]["return"]["_text"] : '';
                                    let order = providerOrderId;
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','Peerless','" + order + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate = new Date();
                                            let lDate = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate();
                                            let totalDays = (lDate - day) + 1;
                                            let prorate;
                                            if (proration_status == "true") {
                                                prorate = (totalDays * did_details[0].rates) / 30;
                                            }
                                            else {
                                                prorate = did_details[0].rates;
                                            }
                                            prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0;
                                            let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                                // To update the wallet transaction log
                                                let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", ";
                                                iQry += "`amount`='-" + prorate + "', ";
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', ";
                                                iQry += "`status`=1;";
                                                let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry;
                                                objWL.prepare();
                                                objWL.execute((error, result) => {
                                                });
                                                // To create the DID log
                                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','Peerless','" + order + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });
                                                // To delete the DID from cart
                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                obj5.prepare();
                                                obj5.execute((walletError, wallet) => { });
                                                // To create the did_order
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`,`error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order = did_data.insertId;
                                                        let orderID = "SORD" + id_order.toString();
                                                        let log_error = "";
                                                        let log_message = "Order successfully created.";
                                                        let log_result = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                        obj.prepare();
                                                        obj.execute((error, result) => { });
                                                    }
                                                    let objV = new RawView_1.RawView(res);
                                                    objV.prepare({
                                                        error_code: 1,
                                                        status: 201,
                                                        message: "DID buy successfully.",
                                                        result: [
                                                            {
                                                                "did": did
                                                            }
                                                        ]
                                                    });
                                                    objV.execute();
                                                });
                                            });
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                }
                                // If order failed
                                else if (typeof res1["S:Envelope"]["S:Body"]["S:Fault"] != 'undefined') {
                                    let Fault = res1["S:Envelope"]["S:Body"]["S:Fault"];
                                    let providerOrderId = '';
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + did + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order = did_data.insertId;
                                            let orderID = "SORD" + id_order.toString();
                                            let log_error = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_message = (Fault['faultcode'] + ' - ' + Fault['faultstring']).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_result = "";
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='501', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                            obj.prepare();
                                            obj.execute((error, result) => { });
                                        }
                                    });
                                    let objV = new RawView_1.RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: Fault['faultstring'],
                                        error: Fault['faultcode'] + ' - ' + Fault['faultstring']
                                    });
                                    objV.execute();
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    obj.execute();
                                }
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 404,
                                    message: "DID not Available!"
                                });
                                obj.execute();
                            }
                        });
                    }
                    // To purchase the local number
                    else {
                        let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:placeOrder><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><order><orderType>NN</orderType><orderNumbers><number><tn>' + sdata.DID.trim() + '</tn><mou>1000</mou><routeLabel>TRAYTECH_03</routeLabel><peerlessMsgProvisioning>?</peerlessMsgProvisioning></number></orderNumbers></order></pub:placeOrder></soapenv:Body></soapenv:Envelope>';
                        let options = {
                            'method': 'POST',
                            'url': this.url,
                            'headers': {
                                'Content-Type': 'text/xml',
                                'SOAPAction': 'placeOrder'
                            },
                            body: data,
                        };
                        request(options, (error, response, body) => {
                            console.log("Peerless::\n", body);
                            let tmp = body;
                            var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                            let res1 = JSON.parse(result1);
                            if (!error) {
                                // If order placed successfully
                                if (typeof res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"] != 'undefined') {
                                    let providerOrderId = typeof res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"]["return"] != 'undefined' && res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"]["return"]["_text"] ? res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"]["return"]["_text"] : '';
                                    let order = providerOrderId;
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','Peerless','" + order + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate = new Date();
                                            let lDate = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate();
                                            let totalDays = (lDate - day) + 1;
                                            let prorate;
                                            if (proration_status == "true") {
                                                prorate = (totalDays * did_details[0].rates) / 30;
                                            }
                                            else {
                                                prorate = did_details[0].rates;
                                            }
                                            prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0;
                                            let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                                // To update the wallet transaction log
                                                let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", ";
                                                iQry += "`amount`='-" + prorate + "', ";
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', ";
                                                iQry += "`status`=1;";
                                                let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry;
                                                objWL.prepare();
                                                objWL.execute((error, result) => {
                                                });
                                                // To create the DID log
                                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','Peerless','" + order + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });
                                                // To delete the DID from cart
                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                obj5.prepare();
                                                obj5.execute((walletError, wallet) => { });
                                                // To create the did_order
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`,`error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201','" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order = did_data.insertId;
                                                        let orderID = "SORD" + id_order.toString();
                                                        let log_error = "";
                                                        let log_message = "Order successfully created.";
                                                        let log_result = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                        obj.prepare();
                                                        obj.execute((error, result) => { });
                                                    }
                                                    if (sdata.CampaignId) {
                                                        let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                                        osr.updateNumber(req, res, data.insertId, (error, responce) => {
                                                            if (responce) {
                                                                return callback('', responce);
                                                            }
                                                            else {
                                                                callback(error, '');
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({
                                                            error_code: 1,
                                                            status: 201,
                                                            message: "DID buy successfully.",
                                                            result: [
                                                                {
                                                                    "did": did
                                                                }
                                                            ]
                                                        });
                                                        obj.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                }
                                // If order failed
                                else if (typeof res1["S:Envelope"]["S:Body"]["S:Fault"] != 'undefined') {
                                    let Fault = res1["S:Envelope"]["S:Body"]["S:Fault"];
                                    let providerOrderId = '';
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + did + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order = did_data.insertId;
                                            let orderID = "SORD" + id_order.toString();
                                            let log_error = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_message = (Fault['faultcode'] + ' - ' + Fault['faultstring']).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_result = "";
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='501', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                            obj.prepare();
                                            obj.execute((error, result) => { });
                                        }
                                    });
                                    let objV = new RawView_1.RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: Fault['faultstring'],
                                        error: Fault['faultcode'] + ' - ' + Fault['faultstring']
                                    });
                                    objV.execute();
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    obj.execute();
                                }
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 404,
                                    message: "DID not Available!"
                                });
                                obj.execute();
                            }
                        });
                    }
                }
                else {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }
    disconnectDID(req, res, callback) {
        const sdata = req.body;
        let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `day_num` from `tariff` WHERE `idtariff`='" + this.sessdata.idtariff + "'";
        obj1.prepare();
        obj1.execute((errday, resday) => {
            if (errday == 1 && resday.length > 0) {
                let number = new numberApi_1.Number();
                number.countDays(req, res, sdata.DID.trim(), (err, countdays) => {
                    if (countdays && countdays > resday[0].day_num) {
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `type` from `did_buy` WHERE `iduser`='" + iduser + "' AND `did`='" + sdata.DID.trim() + "'";
                        obj2.prepare();
                        obj2.execute((err, resu) => {
                            if (resu.length > 0) {
                                let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:disconnectOrder><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><disconnectOrderRequest><pon>?</pon><tns><tn>' + sdata.DID.trim() + '</tn><discoType>1</discoType></tns></disconnectOrderRequest></pub:disconnectOrder></soapenv:Body></soapenv:Envelope>';
                                var options = {
                                    'method': 'POST',
                                    'url': this.url,
                                    'headers': {
                                        'Content-Type': 'text/xml',
                                        'SOAPAction': 'disconnectOrder'
                                    },
                                    'body': data,
                                };
                                request(options, (error, response, body) => {
                                    console.log("Thinq Err::", error);
                                    if (!error) {
                                        console.log("Thinq Res::", body);
                                        let tmp = body;
                                        var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                                        let res1 = JSON.parse(result1);
                                        let data = res1["S:Envelope"]["S:Body"]["ns2:disconnectOrderResponse"]["return"]["_text"];
                                        if (data) {
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                            obj.prepare();
                                            obj.execute((error, resp) => {
                                                if (error == 1) {
                                                    // To  update updated_at date in did log
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1";
                                                    obj.prepare();
                                                    obj.execute((errorDiDLg, resDiDLg) => { });
                                                    // To delete the number from OSR
                                                    let objv = new RawView_1.RawView(res);
                                                    let payLoad = {
                                                        DID: sdata.DID.trim()
                                                    };
                                                    let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                                    osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                        console.log("OSR Response::", response);
                                                        if (error == 1) {
                                                            // To delete the number from Sinch
                                                            let osr = new SinchSubmitNumber_1.SinchApi(this.priority, this.sessdata);
                                                            osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                                console.log("Sinch Response::", response);
                                                            });
                                                        }
                                                    });
                                                    // To release the final output
                                                    objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 502, message: "Something Went Wrong" });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: data.statusCode, message: data.status });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 400, error: error });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 417, message: "Days are Less then " + resday[0].day_num + " So you can not disconnect Did from this Account" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Days Not Found!" });
                objv.execute();
            }
        });
    }
}
exports.PeerlessAPI = PeerlessAPI;
