"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SinchSMS = void 0;
const APISMSBase_1 = require("./APISMSBase");
const RawView_1 = require("../lib/view/RawView");
const numberApi_1 = require("./numberApi");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const lrnApi_1 = require("./lrnApi");
class SinchSMS extends APISMSBase_1.SMS {
    constructor() {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
    }
    SendSms(req, res, next, Data, sms_provider, callback) {
        let sessdata = Data.sessdata;
        let lergData = Data.lergData;
        // To set the data for final SMS
        this.saveSMS(req, res, next, sessdata, lergData, sms_provider, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    SendMms(req, res, next, Data, sms_provider, callback) {
        let sessdata = Data.sessdata;
        let lergData = Data.lergData;
        let didData = Data.DIDdata;
        let fType = Data.fileType;
        // To set the data for final SMS
        this.saveMMS(req, res, next, sessdata, lergData, sms_provider, didData, fType, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        });
    }
    /* public SendMms(req: Request, res: Response, next: NextFunction,token: string,sms_provider: string, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let number = new Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ "message": "Invalid DID" });
                        obj.execute();
                    } else {
                        let PayLoad: any = {
                            TO: TO
                        }
                        let lerg = new LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {

                                if (lerg_info.length > 0) {
                                    this.saveMMS(req, res, next, sessdata, lerg_info,sms_provider, (sms_err, sms_result) => {
                                        if (sms_result != undefined) {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_result);
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_err);
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({message:"Lerg Info Not Found"});
                                    objv.execute();
                                }
                            })
                        })
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    } */
    SendSms_Old(req, res, next, token, sms_provider, callback) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let number = new numberApi_1.Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    }
                    else {
                        let lerg = new lrnApi_1.LergApi("", "");
                        lerg.lrnDetails(req, res, token, (lrn_err, lrn_detail) => {
                            console.log(lrn_err, lrn_detail);
                            if (lrn_detail.hasOwnProperty('errors')) {
                                if (lrn_detail.errors[0] == "LRN Not Found.")
                                    this.getLrnDetails(req, res, TO, (lerg_err, lerg_info) => {
                                        if (lerg_info.data.length > 0) {
                                            this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider, (sms_err, sms_result) => {
                                                if (sms_result != undefined) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare(sms_result);
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare(sms_err);
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Lerg Info Not Found" });
                                            objv.execute();
                                        }
                                    });
                            }
                            else {
                                this.getLrnDetails(req, res, lrn_detail.lnp, (lerg_err, lerg_info) => {
                                    console.log(lerg_err, lerg_info);
                                    if (lerg_info.data.length > 0) {
                                        this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider, (sms_err, sms_result) => {
                                            if (sms_result != undefined) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(sms_result);
                                                objv.execute();
                                            }
                                            else {
                                                console.log("lerg not found");
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(sms_err);
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        console.log("lerg not found");
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Lerg Info Not Found" });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                });
            }
            else {
                console.log("sesserror");
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}
exports.SinchSMS = SinchSMS;
