"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeleSMS = void 0;
const APISMSBase_1 = require("./APISMSBase");
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const numberApi_1 = require("./numberApi");
const _406_1 = require("../lib/view/406");
const lrnApi_1 = require("./lrnApi");
const APIBase_1 = require("./APIBase");
class TeleSMS extends APISMSBase_1.SMS {
    constructor() {
        super();
        this.key = "48de6c84-7726-4879-bc08-f7a5dcf63f1c";
        this.account = "";
    }
    SendSms(req, res, next, Data, sms_provider, callback) {
        let sessdata = Data.sessdata;
        let lergData = Data.lergData;
        // To set the data for final SMS
        this.saveSMS(req, res, next, sessdata, lergData, sms_provider, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    SendMms(req, res, next, token, sms_provider, callback) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let number = new numberApi_1.Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    }
                    else {
                        let PayLoad = {
                            TO: TO
                        };
                        let lerg = new lrnApi_1.LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase_1.APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                if (lerg_info.length > 0) {
                                    this.saveSMS(req, res, next, sessdata, lerg_info, sms_provider, (sms_err, sms_result) => {
                                        if (sms_result != undefined) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare(sms_result);
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare(sms_err);
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Lerg Info Not Found" });
                                    objv.execute();
                                }
                            });
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    SendSms_Old(req, res, next, token, sms_provider, callback) {
        let sdata = req.body;
        var TO = "" + sdata.TO + "";
        console.log("To", TO);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let number = new numberApi_1.Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    }
                    else {
                        let lerg = new lrnApi_1.LergApi("", "");
                        lerg.lrnDetails(req, res, token, (lrn_err, lrn_detail) => {
                            console.log("lrn_detail", lrn_detail);
                            if (lrn_detail.hasOwnProperty('errors')) {
                                if (lrn_detail.errors[0] == "LRN Not Found.")
                                    console.log("To===>", TO);
                                this.getLrnDetails(req, res, TO, (lerg_err, lerg_info) => {
                                    console.log("lerg_info", lerg_info);
                                    if (lerg_info.data.length > 0) {
                                        this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider, (sms_err, sms_result) => {
                                            if (sms_result != undefined) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(sms_result);
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(sms_err);
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Lerg Info Not Found" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                this.getLrnDetails(req, res, lrn_detail.lnp, (lerg_err, lerg_info) => {
                                    if (lerg_info.data.length > 0) {
                                        this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider, (sms_err, sms_result) => {
                                            if (sms_result != undefined) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(sms_result);
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(sms_err);
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Lerg Info Not Found" });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}
exports.TeleSMS = TeleSMS;
