"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThinQAPI = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const Osr_1 = require("./Osr");
const SinchSubmitNumber_1 = require("./SinchSubmitNumber");
const numberApi_1 = require("./numberApi");
const RawView_1 = require("../lib/view/RawView");
var request = require('request');
class ThinQAPI extends APIBase_1.APIBase {
    key;
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
        this.timekey = timekey;
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }
    getNpaNxx(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err = 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    console.log("sdata", sdata);
                    var url;
                    if (sdata.NPA != undefined && sdata.NPA != 'null') {
                        url = "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=npa&quantity=" + sdata.Qty + "&contiguous=false&npa=" + sdata.NPA + "";
                    }
                    if ((sdata.NPA != undefined && sdata.NPA != 'null') && (sdata.NXX != undefined && sdata.NXX != 'null')) {
                        url = "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=npanxx&quantity=" + sdata.Qty + "&contiguous=false&npa=" + sdata.NPA + "&nxx=" + sdata.NXX + "";
                    }
                    let options = {
                        'method': 'GET',
                        'url': url,
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    request(options, (error, response) => {
                        if (!error) {
                            let data = JSON.parse(response.body);
                            console.log("Reponcnce==>", data);
                            if (data.dids != undefined && data.dids.length > 0) {
                                let str = data.dids;
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let found = false;
                                let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                str.forEach((ele) => {
                                    if (ele.thinqTier == 0) {
                                        let did = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                        found = true;
                                    }
                                });
                                if (found)
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                else
                                    obj1.nonqrysql = "";
                                obj1.prepare();
                                obj1.execute((err, data) => {
                                    callback(err, data);
                                });
                            }
                            else {
                                callback('', data);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }
    getByRate(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    let options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=ratecenter&quantity=" + sdata.Qty + "&contiguous=false&state=" + sdata.State + "&rateCenter=" + sdata.RateCenter + "",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    console.log("Options", options);
                    request(options, (error, response) => {
                        if (!error) {
                            let data = JSON.parse(response.body);
                            console.log("data==>", data);
                            if (data.dids != undefined && data.dids.length > 0) {
                                let str = data.dids;
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let found = false;
                                let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                str.forEach((ele) => {
                                    if (ele.thinqTier == 0) {
                                        let did = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                        found = true;
                                    }
                                });
                                if (found)
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                else
                                    obj1.nonqrysql = "";
                                obj1.prepare();
                                obj1.execute((err, data) => {
                                    callback(err, data);
                                });
                            }
                            else {
                                callback('', data);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }
    getTollFree(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=tollfree&searchBy=&quantity=" + sdata.Qty + "&contiguous=false",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    request(options, (error, response) => {
                        if (!error) {
                            let data = JSON.parse(response.body);
                            console.log("data", data);
                            if (data.dids != undefined && data.dids.length > 0) {
                                let str = data.dids;
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                str.forEach((ele) => {
                                    let did = "" + ele.id + "";
                                    let number = did.substring(1, 11);
                                    qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','TF','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                });
                                obj1.nonqrysql = qrystr.slice(0, -1);
                                obj1.prepare();
                                obj1.execute((err, data) => {
                                    callback(err, data);
                                });
                            }
                            else {
                                callback('', data);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }
    buyDID(req, res, did_details, other_data, callback) {
        const sdata = req.body;
        let types;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let Did = did.slice(len, len + 10);
        let id_grouporder = other_data.id_grouporder;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            // To get the proration status
            let objv0 = new RawQuery_1.ModelRawQuery(req, res);
            objv0.qrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let proration_status = proration_success[0].proration;
                    types = did_details[0].type == 'TF' ? 'TF' : 'NN';
                    var options = {
                        'method': 'POST',
                        'url': 'https://api.thinq.com/account/15080/origination/order/create',
                        'headers': {
                            'Authorization': 'Basic ' + this.key,
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            "order": {
                                "tns": [
                                    {
                                        "route_id": 7818,
                                        "did": sdata.DID.trim()
                                    }
                                ],
                                "blocks": []
                            }
                        })
                    };
                    request(options, (error, response) => {
                        console.log("Thinq1::", response.body);
                        if (!error) {
                            let data = JSON.parse(response.body);
                            // If order created on provider side
                            if (typeof data.id != 'undefined' && data.id) {
                                console.log(data.id);
                                var options = {
                                    'method': 'POST',
                                    'url': 'https://api.thinq.com/account/15080/origination/order/complete/' + `${data.id}`,
                                    'headers': {
                                        'Authorization': 'Basic ' + this.key,
                                        'Content-Type': 'application/json'
                                    }
                                };
                                request(options, (error, response) => {
                                    console.log("Thinq2::", response.body);
                                    let ddata = JSON.parse(response.body);
                                    // If order completed on provider side
                                    if (typeof ddata.id != 'undefined' && ddata.id) {
                                        let providerOrderId = typeof data.id != 'undefined' && data.id ? data.id : '';
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`) VALUE('" + this.sessdata.idaccount + "','','completed','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "')";
                                        obj.prepare();
                                        obj.execute((did_err, did_data) => {
                                            if (did_err == 1) {
                                                let dateObj = new Date();
                                                let day = dateObj.getUTCDate();
                                                let nDate = new Date();
                                                let lDate = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate();
                                                let totalDays = (lDate - day) + 1;
                                                let prorate = 0;
                                                if (proration_status == "true") {
                                                    prorate = (totalDays * did_details[0].rates) / 30;
                                                }
                                                else {
                                                    prorate = did_details[0].rates;
                                                }
                                                console.log(prorate);
                                                // To update the wallet amount
                                                let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                                objv.prepare();
                                                objv.execute((wallet_error, wallet_success) => {
                                                    // To update the wallet transaction log
                                                    let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                    iQry += "`idaccount`=" + this.sessdata.idaccount + ", ";
                                                    iQry += "`amount`='-" + prorate + "', ";
                                                    iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', ";
                                                    iQry += "`status`=1;";
                                                    let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry;
                                                    objWL.prepare();
                                                    objWL.execute((error, result) => {
                                                        console.log("Transaction response::", result);
                                                    });
                                                    // To create the DID log
                                                    let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                                    objv1.prepare();
                                                    objv1.execute((log_error, did_log) => { });
                                                    // To delete the DID from cart
                                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                    obj5.prepare();
                                                    obj5.execute((walletError1, wallet1) => { });
                                                    // To create the did_order
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + Did + "', '2', '" + types + "', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        // To update the other data on current order
                                                        if (did_err == 1) {
                                                            let id_order = did_data.insertId;
                                                            let orderID = "SORD" + id_order.toString();
                                                            let log_error = "";
                                                            let log_message = ddata.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                            let log_result = JSON.stringify(ddata).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                            obj.prepare();
                                                            obj.execute((error, result) => { });
                                                        }
                                                    });
                                                    // To submit the number on OSR
                                                    if (sdata.CampaignId && types == "NN") {
                                                        let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                                        osr.updateNumber(req, res, did_data.insertId, (error, responce) => { });
                                                    }
                                                    else {
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({
                                                            error_code: 1,
                                                            status: 201,
                                                            message: "DID buy successfully.",
                                                            result: [
                                                                {
                                                                    "did": Did
                                                                }
                                                            ]
                                                        });
                                                        obj.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({
                                                    error_code: 0,
                                                    status: 502,
                                                    message: "Something went wrong with connection!"
                                                });
                                                obj.execute();
                                            }
                                        });
                                    }
                                    // If order failed
                                    else {
                                        let providerOrderId = typeof data.id != 'undefined' && data.id ? data.id : '';
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + Did + "', '4', '" + types + "', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                        obj.prepare();
                                        obj.execute((did_err, did_data) => {
                                            // To update the other data on current order
                                            if (did_err == 1) {
                                                let id_order = did_data.insertId;
                                                let orderID = "SORD" + id_order.toString();
                                                let log_error = JSON.stringify(ddata).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                let log_message = ddata.message.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                let log_result = "";
                                                obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + ddata.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                obj.prepare();
                                                obj.execute((error, result) => { });
                                            }
                                        });
                                        let objV = new RawView_1.RawView(res);
                                        objV.prepare({
                                            error_code: 0,
                                            status: ddata.code,
                                            message: ddata.message,
                                            error: ddata
                                        });
                                        objV.execute();
                                    }
                                });
                            }
                            // If order failed
                            else {
                                let providerOrderId = typeof data.id != 'undefined' && data.id ? data.id : '';
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + Did + "', '4', '" + types + "', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                obj.prepare();
                                obj.execute((did_err, did_data) => {
                                    // To update the other data on current order
                                    if (did_err == 1) {
                                        let id_order = did_data.insertId;
                                        let orderID = "SORD" + id_order.toString();
                                        let log_error = JSON.stringify(data).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                        let log_message = data.message.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                        let log_result = "";
                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + data.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                        obj.prepare();
                                        obj.execute((error, result) => { });
                                    }
                                });
                                let objV = new RawView_1.RawView(res);
                                objV.prepare({
                                    error_code: 0,
                                    status: data.code,
                                    message: data.message,
                                    error: data
                                });
                                objV.execute();
                            }
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({
                                error_code: 0,
                                status: 400,
                                error: error
                            });
                            obj.execute();
                        }
                    });
                }
                else {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }
    disconnectDID(req, res, callback) {
        let sdata = req.body;
        let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `day_num` from `tariff` WHERE `idtariff`='" + this.sessdata.idtariff + "'";
        obj1.prepare();
        obj1.execute((errday, resday) => {
            if (errday == 1 && resday.length > 0) {
                let number = new numberApi_1.Number();
                number.countDays(req, res, sdata.DID.trim(), (err, countdays) => {
                    if (countdays && countdays > resday[0].day_num) {
                        var options = {
                            'method': 'POST',
                            'url': 'https://api.thinq.com/account/15080/origination/disconnect',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "dids": [sdata.DID.trim()]
                            })
                        };
                        request(options, (error, response) => {
                            console.log("Thinq Err::", error);
                            if (!error) {
                                console.log("Thinq Res::", response.body);
                                let data = JSON.parse(response.body);
                                if (data.status == "completed") {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                    obj.prepare();
                                    obj.execute((error, resp) => {
                                        if (error == 1) {
                                            // To  update updated_at date in did log
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1";
                                            obj.prepare();
                                            obj.execute((errorDiDLg, resDiDLg) => { });
                                            // To delete the number from OSR
                                            let objv = new RawView_1.RawView(res);
                                            let payLoad = {
                                                DID: sdata.DID.trim()
                                            };
                                            let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                                            osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                console.log("OSR Response::", response);
                                                if (error == 1) {
                                                    // To delete the number from Sinch
                                                    let osr = new SinchSubmitNumber_1.SinchApi(this.priority, this.sessdata);
                                                    osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                        console.log("Sinch Response::", response);
                                                    });
                                                }
                                            });
                                            // To release the final output
                                            objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something went wrong with connection" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: data.code, message: data.message });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 400, error: error });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 417, message: "Days are Less then " + resday[0].day_num + " So you can not disconnect Did from this Account" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Days Not Found!" });
                objv.execute();
            }
        });
    }
}
exports.ThinQAPI = ThinQAPI;
