"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentClass = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const AppRoute_1 = require("../lib/AppRoute");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const _406_1 = require("../lib/view/406");
const _403_1 = require("../lib/view/403");
const module_config_1 = require("../config/module.config");
const ModelLogin_1 = require("../lib/model/ModelLogin");
const RawQuery_1 = require("../lib/model/RawQuery");
const Str = require('@supercharge/strings');
class AgentClass extends AppRoute_1.AppRoute {
    constructor() {
        super();
    }
    addAgent(req, res, next) {
        var sdata = req.body;
        const name = Math.floor(1000000 + Math.random() * 9000000);
        const contact = 'user/' + name;
        const agent_key = Str.random(12);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT * FROM agents where `username` = '" + sdata.UserName + "'";
                obj1.prepare();
                obj1.execute((__error, agents) => {
                    if (__error == 1) {
                        if (agents.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Username Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "INSERT INTO `agents` (`iduser`, `name`, `username`, `password`, `full_name`, `contact`, `system`, `callerid`, `agent_key`, `group`, `vm_pin`) VALUES('" + sessdata.iduser + "','" + name + "', '" + sdata.UserName + "', '" + sdata.Password + "', '" + sdata.FullName + "', '" + contact + "', 'single_box', '" + sdata.CallerId + "', '" + agent_key + "', '" + sdata.Group + "', '" + sdata.VmPin + "')";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, message: "Agent Added Successfully!" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: agents });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateAgent(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let str = '';
                if (sdata.FullName) {
                    str += '`full_name`="' + sdata.FullName + '", ';
                }
                if (sdata.UserName) {
                    str += '`username`="' + sdata.UserName + '", ';
                }
                if (sdata.Password) {
                    str += '`password`="' + sdata.Password + '", ';
                }
                if (sdata.CallerId) {
                    str += '`callerid`="' + sdata.CallerId + '", ';
                }
                if (sdata.VmPin) {
                    str += '`vm_pin`="' + sdata.VmPin + '"';
                }
                str = str.trim().replace(/,\s*$/, "");
                obj.nonqrysql = "UPDATE `agents` SET " + str + " WHERE idagent = '" + sdata.IdAgent + "'";
                // obj.nonqrysql = "UPDATE `agents` SET `full_name` = '" + sdata.FullName + "', `username` = '" + sdata.UserName + "', `password` = '" + sdata.Password + "' where idaccount = '" + sessdata.idaccount + "' AND idagent = '" + sdata.IdAgent + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateAgentStatus(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `agents` SET `status` = '" + sdata.status + "' AND idagent = '" + sdata.idagent + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Status Updated Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAgents(req, res, next) {
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `agent_key`, `idagent`, `name`, `full_name`, `username`, `password`, `vm_pin` from `agents` WHERE `iduser` = '" + sessdata.iduser + "' AND `group`='" + sdata.groupKey + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSingleAgent(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * from `agents` where `iduser` = '" + sessdata.iduser + "' AND `idagent`='" + req.query.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAllAgent(req, res, next) {
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `agent` FROM `tiers` WHERE `iduser`='" + sessdata.iduser + "' AND `queue`='" + sdata.GroupName + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent List Get Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAgent(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idagent`,`full_name`,`contact`,`status`,`state`,`max_no_answer`,`wrap_up_time`,`reject_delay_time`,`busy_delay_time`,`no_answer_delay_time`,`last_bridge_start`,`last_bridge_end`,`last_offered_call`,`last_status_change`,`no_answer_count`,`calls_answered`,`talk_time`,`ready_time`,`extension`,`group` from `agents` where `iduser` = '" + sessdata.iduser + "' AND `username`='" + req.query.username + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteAgent(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE from `agents` where `idagent`='" + req.query.id + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Deleted Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    addGroup(req, res, next) {
        var sdata = req.body;
        console.log(sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT * FROM `group` where `group_name` = '" + sdata.GroupName + "' AND `iduser`='" + sessdata.iduser + "'";
                obj1.prepare();
                obj1.execute((_error, group) => {
                    if (_error == 1) {
                        if (group.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Group Name Already Exists In Your Group List!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            const group_key = Str.random(10);
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "INSERT INTO `group` (`iduser`, `group_name`, `strategy`, `tier_rules_apply`, `description`, `group_key`) VALUES ('" + sessdata.iduser + "','" + sdata.GroupName + "', '" + sdata.Strategy + "', '" + sdata.TierRulesApply + "', '" + sdata.Description + "', '" + group_key + "')";
                            obj.prepare();
                            obj.execute((__error, result) => {
                                if (__error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Group Added Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: group });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // updateGroup(req: Request, res: Response, next: NextFunction) {
    // 	var sdata: any = req.body;
    // 	let session = new SessionManagment(req, res, next);
    // 	session.GetSession((error: any, sessdata: any) => {
    // 		if (error == 1) {
    // 			let obj = new ModelRawNonQuery(req, res);
    // 			let str = '';
    // 			if (sdata.GroupName) {
    // 				str += '`group_name`="' + sdata.GroupName + '", '
    // 			}
    // 			if (sdata.Strategy) {
    // 				str += '`strategy`="' + sdata.Strategy + '", '
    // 			}
    // 			if (sdata.TierRulesApply == true || sdata.TierRulesApply == false) {
    // 				str += '`tier_rules_apply`="' + sdata.TierRulesApply + '", '
    // 			}
    // 			if (sdata.Description) {
    // 				str += '`description`="' + sdata.Description + '", '
    // 			}
    // 			str = str.trim().replace(/,\s*$/, "");
    // 			obj.nonqrysql = "UPDATE `group` SET " + str + "  WHERE `id_group` = '" + sdata.idgroup + "'";
    // 			obj.prepare();
    // 			obj.execute((_error: any, result: any) => {
    // 				if (_error == 1) {
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Group Updated Successfully!", status: 201 });
    // 					objv.execute();
    // 				}
    // 				else {
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
    // 					objv.execute();
    // 				}
    // 			});
    // 		}
    // 		else {
    // 			let objv = new Res406(res);
    // 			objv.prepare(session);
    // 			objv.execute();
    // 		}
    // 	});
    // }
    updateGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT * FROM `group` where `group_name` = '" + sdata.GroupName + "' AND `iduser`='" + sessdata.iduser + "'";
                obj1.prepare();
                obj1.execute((_error, group_res) => {
                    if (group_res.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Group Name Already Exists In Your Group List!!", status: 502 });
                        objv.execute();
                    }
                    else {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        let str = '';
                        if (sdata.GroupName) {
                            str += '`group_name`="' + sdata.GroupName + '", ';
                        }
                        if (sdata.Strategy) {
                            str += '`strategy`="' + sdata.Strategy + '", ';
                        }
                        if (sdata.TierRulesApply == true || sdata.TierRulesApply == false) {
                            str += '`tier_rules_apply`="' + sdata.TierRulesApply + '", ';
                        }
                        if (sdata.Description) {
                            str += '`description`="' + sdata.Description + '", ';
                        }
                        str = str.trim().replace(/,\s*$/, "");
                        obj.nonqrysql = "UPDATE `group` SET " + str + "  WHERE `id_group` = '" + sdata.idgroup + "'";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Group Updated Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT *, GROUP_CONCAT(a.full_name) `agents` FROM `group` g LEFT JOIN tiers t ON g.group_key=t.queue LEFT JOIN agents a ON a.name=t.agent WHERE g.iduser= '" + sessdata.iduser + "' GROUP BY g.id_group ";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Group Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSingleGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * from `group` where `iduser` = '" + sessdata.iduser + "' AND `id_group`='" + req.query.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteGroup(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE from `group` where `id_group`='" + req.query.id + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Group Deleted Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // addMapping(req: Request, res: Response, next: NextFunction) {
    // 	const data = req.body.agents;
    // 	const group = req.body.group;
    // 	console.log(req.body, "req.body");
    // 	const session = new SessionManagment(req, res, next);
    // 	session.GetSession((error: any, sessdata: any) => {
    // 		if (error == 1) {
    // 			// let obj = new ModelRawNonQuery(req, res);
    // 			let tmpquery1 = '';
    // 			data.forEach((element: any) => {
    // 				tmpquery1 += "'"+element.name+"' ,";
    // 			});
    // 			let tempquery = tmpquery1.slice(0, -1);
    // 			let tmpquery = "DELETE from `tiers` where `queue` = '"+group.group_key+"' AND `agent` IN("+tempquery+")";
    // 			let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql = tmpquery;
    // 			obj.prepare();
    // 			obj.execute((_error: any, result: any) => {
    // 				if (_error == 1) {
    // 					let tmpqurty="INSERT INTO `tiers` (`iduser`, `queue`, `agent`) VALUES ";
    // 					data.forEach((element: any) => {
    // 						tmpqurty += "('" + sessdata.iduser + "','" + group.group_key + "', '" + element.name + "' ),";
    // 					});
    // 					// data.forEach((element: any) => {
    // 					// 	let obj = new ModelRawNonQuery(req, res);
    // 					// 	obj.nonqrysql = "INSERT INTO `tiers` (`idaccount`, `queue`, `agent`, `name`, `group_key`) VALUES ('" + sessdata.idaccount + "', '" + group.group_name + "', '" + element.full_name + "','" + element.name + "', '" + group.group_key + "' )";
    // 					// 	obj.prepare();
    // 					// 	obj.execute((error: any, result: any) => {
    // 					// 	});
    // 					// });
    // 					// let objv = new RawView(res);
    // 					// objv.prepare({ message: "Group Mapping Updated Successfully!" });
    // 					// objv.execute();
    // 					let obj1 = new ModelRawNonQuery(req, res);
    // 					obj1.nonqrysql =tmpqurty.slice(0, -1);
    // 					obj1.prepare();
    // 					obj1.execute((error: any, result: any) => {
    // 						if(result){
    // 							let objv = new RawView(res);
    // 							objv.prepare({ message: "Group Mapping Added Successfully!", data: result, status: 201 });
    // 							objv.execute();
    // 						}
    // 						else{
    // 							let objv = new RawView(res);
    // 							objv.prepare({ message: "Somthing Went Wrong With Connection!", status: 502, error: result });
    // 							objv.execute();	
    // 						}
    // 					});
    // 				}
    // 				else {
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
    // 					objv.execute();
    // 				}
    // 			});
    // 		}
    // 		else {
    // 			let objv = new Res406(res);
    // 			objv.prepare(session);
    // 			objv.execute();
    // 		}
    // 	});
    // }
    // getMapping(req: Request, res: Response, next: NextFunction) {
    // 	var sdata = req.body;
    // 	let session = new SessionManagment(req, res, next);
    // 	session.GetSession((error: any, sessdata: any) => {
    // 		if (error == 1) {
    // 			let obj = new ModelRawQuery(req, res);
    // 			obj.qrysql = "SELECT `idtier` `key`, `agent`, `queue` from `tiers` where `iduser` = '" + sessdata.iduser + "' AND `queue`='" + req.query.type + "'";
    // 			obj.prepare();
    // 			obj.execute((_error: any, result: any) => {
    // 				if (_error == 1) {
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
    // 					objv.execute();
    // 				}
    // 				else {
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
    // 					objv.execute();
    // 				}
    // 			});
    // 		}
    // 		else {
    // 			let objv = new Res406(res);
    // 			objv.prepare(session);
    // 			objv.execute();
    // 		}
    // 	});
    // }
    // updateMapping(req: Request, res: Response, next: NextFunction) {
    // 	const data = req.body.agents;
    // 	const group = req.body.group;
    // 	console.log(req.body, "req.body");
    // 	const session = new SessionManagment(req, res, next);
    // 	session.GetSession((error: any, sessdata: any) => {
    // 		if (error == 1) {
    // 			let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql = "DELETE from `tiers` where `queue`='" + group.group_key + "'";
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if (result) {
    // 					let tmpqurty="INSERT INTO `tiers` (`idaccount`, `queue`, `agent`) VALUES ";
    // 					data.forEach((element: any) => {
    // 						tmpqurty += "('" + sessdata.idaccount + "','" + group.group_key + "', '" + element.name + "' ),";
    // 					});
    // data.forEach((element: any) => {
    // 	let obj = new ModelRawNonQuery(req, res);
    // 	obj.nonqrysql = "INSERT INTO `tiers` (`idaccount`, `queue`, `agent`, `name`, `group_key`) VALUES ('" + sessdata.idaccount + "', '" + group.group_name + "', '" + element.full_name + "','" + element.name + "', '" + group.group_key + "' )";
    // 	obj.prepare();
    // 	obj.execute((error: any, result: any) => {
    // 	});
    // });
    // let objv = new RawView(res);
    // objv.prepare({ message: "Group Mapping Updated Successfully!" });
    // objv.execute();
    // 					let obj = new ModelRawNonQuery(req, res);
    // 					obj.nonqrysql =tmpqurty.slice(0, -1);
    // 					obj.prepare();
    // 					obj.execute((error: any, result: any) => {
    // 						if(result){
    // 						let objv = new RawView(res);
    // 						objv.prepare({ message: "Group Mapping Added Successfully!" });
    // 						objv.execute();
    // 						}
    // 						else{
    // 							let objv = new RawView(res);
    // 							objv.prepare({ message: "Somthing Went Wrong!" });
    // 							objv.execute();	
    // 						}
    // 					});
    // 				}
    // 				else {
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Something Went Wrong!" });
    // 					objv.execute();
    // 				}
    // 			});
    // 		}
    // 		else {
    // 			let objv = new Res406(res);
    // 			objv.prepare(session);
    // 			objv.execute();
    // 		}
    // 	});
    // }
    getGroups(req, res, next) {
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `group_name`, `group_key` FROM `group` WHERE  iduser = '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Group Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // addAgentMapping(req: Request, res: Response, next: NextFunction) {
    // 	console.log(req.body.agents, "req.body");
    // 	const data = req.body.name.split(',');
    // 	const groupKey = req.body.group_key;
    // 	const session = new SessionManagment(req, res, next);
    // 	session.GetSession((error: any, sessdata: any) => {
    // 		if (error == 1) {
    // 			let tmpquery1 = '';
    // 			data.forEach((element: any) => {
    // 				tmpquery1 += "'"+element+"' ,";
    // 			});
    // 			let tempquery = tmpquery1.slice(0, -1);
    // 			let tmpquery = "DELETE from `tiers` where `queue` = '"+groupKey+"' AND `agent` IN("+tempquery+")";
    // 			let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql = tmpquery;
    // 			obj.prepare();
    // 			obj.execute((_error: any, result: any) => {
    // 				let tmpqurty: any;
    // 				if(_error == 1){
    // 					tmpqurty="INSERT INTO `tiers` (`iduser`, `agent`, `queue`) VALUES ";
    // 					data.forEach((element: any) => {
    // 						tmpqurty += "('" + sessdata.iduser + "', '"+element+"' , '"+groupKey+"'),";
    // 					});
    // 				}
    // 				else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong With Connection!", status: 502, error: result });
    // 					objv.execute();	
    // 				}
    // 			let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((__error: any, _result: any) => {
    // 				if(__error == 1){
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Group Mapping Added Successfully!", status: 201, data: _result });
    // 					objv.execute();
    // 				}
    // 				else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong With Connection!", status: 502, error: _result });
    // 					objv.execute();	
    // 				}
    // 			});	
    // 			});
    // 		}
    // 		else {
    // 			let objv = new Res406(res);
    // 			objv.prepare(session);
    // 			objv.execute();
    // 		}
    // 	});
    // }
    agentLogin(req, res, next) {
        req.body = { username: req.body.Username, password: req.body.Password };
        let obj = new ModelLogin_1.ModelLogin(req, res);
        let swlogin = new module_config_1.modAgent();
        if (obj.prepare(swlogin)) {
            obj.execute((error, result) => {
                if (error == 2) {
                    let session = new Session_1.SessionManagment(req, res, next);
                    session.SetSession(result, (error, sessdata) => {
                        if (result.authkey !== undefined) {
                            let authkey = result.authkey;
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `agents` SET `status`='Logged In' WHERE `idagent` = '" + result.idagent + "'";
                            obj1.prepare();
                            obj1.execute((err, resp) => {
                                if (err == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ "sessionkey": authkey });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Invalid Authkey!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare("Invalid Session");
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _403_1.Res403(res);
                    objv.prepare({ error: "Invalid Username and password to set proper session" });
                    objv.execute();
                }
            });
        }
    }
    agentLogout(req, res, next) {
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idagent` from `session` where `authkey`='" + sdata.Session + "'";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result.length > 0) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `agents` SET `status`='Logged Out' WHERE `idagent` = '" + result[0].idagent + "'";
                        obj1.prepare();
                        obj1.execute((err, rep) => {
                            if (err == 1) {
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "DELETE FROM `session` WHERE `idagent` = '" + result[0].idagent + "'";
                                obj2.prepare();
                                obj2.execute((err1, resp) => {
                                    if (err1 == 1) {
                                        let obj3 = new RawView_1.RawView(res);
                                        obj3.prepare({ Result: "Agent Logout Successfully", status: 201 });
                                        obj3.execute();
                                    }
                                    else {
                                        let obj3 = new RawView_1.RawView(res);
                                        obj3.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                        obj3.execute();
                                    }
                                });
                            }
                            else {
                                let obj2 = new RawView_1.RawView(res);
                                obj2.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                obj2.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "No Data Found!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    changeStatus(req, res, next) {
        let sdata = req.body;
        let status = req.body.AgentStatus === "Ready" ? "Available" : "On Break";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idagent` from `session` where `authkey`='" + sdata.Session + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `agents` SET `status`='" + status + "' WHERE `idagent` = '" + result[0].idagent + "'";
                            obj1.prepare();
                            obj1.execute((err, rep) => {
                                if (err == 1) {
                                    let obj2 = new RawView_1.RawView(res);
                                    obj2.prepare({ message: "Update Agent Status Successfully", status: 201 });
                                    obj2.execute();
                                }
                                else {
                                    let obj2 = new RawView_1.RawView(res);
                                    obj2.prepare({ message: "Something Went Wrong With Connection", error: result, status: 502 });
                                    obj2.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Data Found!", status: 502, error: result });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: result, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.AgentClass = AgentClass;
