"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const AppRoute_1 = require("../lib/AppRoute");
const RawQuery_1 = require("../lib/model/RawQuery");
const Str = require('@supercharge/strings');
const makeNumber = (length) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeChar = (length) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeRanChar = (length) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const generatePassword = () => {
    let result = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
};
class Connection extends AppRoute_1.AppRoute {
    constructor() {
        super();
    }
    getConnections(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                if (sessdata.type == 22) {
                    obj.qrysql = "SELECT * FROM `endpoint` WHERE `iduser`= '" + sessdata.iduser + "'";
                }
                else {
                    obj.qrysql = "SELECT e.*, CONCAT(us.firstname,' ',us.lastname) AS fullname FROM `endpoint`e JOIN `user_profile`us ON us.iduser = e.iduser WHERE e.`idaccount`= '" + sessdata.idaccount + "'";
                }
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // getDid
    getDid(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM did_buy";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Did Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // get did history
    getDidHistory(req, res, next) {
        let sdata = req.query;
        console.log("sdtaaa", sdata);
        let condition = "";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                if (sdata.fromDate || sdata.toDate || sdata.didnumber || sdata.didnpa) {
                    if (sdata.didnumber && sdata.didnpa && sdata.fromDate && sdata.toDate) {
                        condition += 'created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%" AND `npa`="' + sdata.didnpa + '"';
                    }
                    else if (sdata.didnpa && sdata.fromDate && sdata.toDate) {
                        condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `npa`="' + sdata.didnpa + '"';
                    }
                    else if (sdata.didnumber && sdata.fromDate && sdata.toDate) {
                        condition += 'created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%"';
                    }
                    else {
                        condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                    }
                    obj.qrysql = "SELECT DISTINCT `did`,`provider`,`account_id`,`iduser` FROM `did_log` WHERE " + condition + " LIMIT 1000";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Did Log Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "No data Found!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // get did history Details
    /*getDidHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let splitdata = sdata.type.split('_');
        let iduser = splitdata[0];
        let did = splitdata[1];

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT dl.iduser,dl.did,ch.iduser,dl.status,dl.provider,ch.`campaign_name`,ch.`campaign_key`, CONCAT(up.firstname,' ',up.lastname)`customer_name`, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=0  LIMIT 1) sdate, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=1 ORDER BY id DESC LIMIT 1) edate FROM `did_log` dl INNER JOIN `campaign_history` ch ON dl.`iddidlog`=ch.`iddidlog` INNER JOIN `user_profile` up ON up.iduser=dl.iduser WHERE dl.iduser='" + iduser + "' AND dl.did='" + did + "' GROUP BY ch.iddidlog ORDER BY ch.in_use ASC;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Did Log Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }*/
    getDidHistoryDetails(req, res, next) {
        let sdata = req.query;
        let did = sdata.type;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT DISTINCT dl.iddidlog, dl.iduser, CONCAT(up.firstname,' ',up.lastname)`customer`, dl.created_at `sdate`, dl.updated_at `edate`, IF(dl.created_at IS NOT NULL AND dl.updated_at IS NOT NULL, DATEDIFF(dl.updated_at, dl.created_at), 'N/A') duration FROM `did_log` dl INNER JOIN `user_profile` up ON up.iduser=dl.iduser WHERE dl.did='" + did + "' ORDER BY dl.iddidlog DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Customer History Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getCampaignHistoryDetails(req, res, next) {
        let sdata = req.query;
        let did = sdata.type;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT dl.iduser,dl.did,ch.`campaign_name`,ch.`campaign_key`, GROUP_CONCAT(in_use)`in_use`,(SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=0  LIMIT 1) sdate, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=1 ORDER BY id DESC LIMIT 1) edate FROM `did_log` dl INNER JOIN `campaign_history` ch ON dl.`iddidlog`=ch.`iddidlog` WHERE dl.did='" + did + "' GROUP BY ch.campaign_key ORDER BY ch.id ASC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Campaign History Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    AddCredential(req, res, next) {
        var rdata = [];
        rdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `username`='" + rdata.Username + "', `password`='" + rdata.Password + "' WHERE `connection_key`='" + rdata.ConnectionKey + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Connection Add Successfully",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    AddIP(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata = [];
                            let da = req.body.IP.split(',');
                            da.forEach((element) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element });
                            });
                            rdata.forEach((element) => {
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES('" + element.idendpoint + "', '" + element.ip + "')";
                                obj2.prepare();
                                obj2.execute((_error, allcamp) => {
                                });
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 201, message: "IP Add Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Data not found", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    UpdateIP(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata = [];
                            let da = req.body.IP.split(',');
                            da.forEach((element) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element });
                            });
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
                            obj3.prepare();
                            obj3.execute((derror, allcamp) => {
                                if (derror == 1) {
                                    let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                    rdata.forEach((element) => {
                                        sql += "('" + element.idendpoint + "','" + element.ip + "'),";
                                    });
                                    sql = sql.substring(0, sql.length - 1);
                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj2.qrysql = sql;
                                    obj2.prepare();
                                    obj2.execute((_error, allcamp) => {
                                        if (_error == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "IP Updated Successfully!",
                                                status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                    rdata.forEach((element) => {
                                        sql += "('" + element.idendpoint + "','" + element.ip + "'),";
                                    });
                                    sql = sql.substring(0, sql.length - 1);
                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj2.qrysql = sql;
                                    obj2.prepare();
                                    obj2.execute((_error, allcamp) => {
                                        if (_error == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "IP Updated Successfully!",
                                                status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Data not found!",
                                status: 404
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    UpdataFqdn(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            let rdata;
                            rdata = req.body;
                            obj2.filter = null;
                            obj2.nonqrysql = "UPDATE routing_profile SET FQDN_type='" + rdata.type + "', FQDN_user='" + rdata.user + "' WHERE idendpoint='" + result[0].idendpoint + "'";
                            obj2.prepare();
                            obj2.execute((_error, allcamp) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    obj2.prepare();
                                    objv.prepare({
                                        status: 201,
                                        message: "Updated Successfully"
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    obj2.prepare();
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong With Connection!"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv2 = new RawView_1.RawView(res);
                            objv2.prepare({
                                status: 404,
                                message: "Data not found"
                            });
                            objv2.execute();
                        }
                    }
                    else {
                        let objv2 = new RawView_1.RawView(res);
                        objv2.prepare({
                            status: 502,
                            message: "Something went wrong with connection!"
                        });
                        objv2.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    AddForwardAll(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body;
                let number;
                switch (rdata.forward_type) {
                    case "Sip uri":
                        number = 1;
                        break;
                    case "Number":
                        number = 2;
                        break;
                    case "IP Address":
                        number = 3;
                        break;
                    case "Group":
                        number = 4;
                        break;
                    case "Extension":
                        number = 5;
                        break;
                }
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`='" + number + "',`forward`='" + rdata.forward + "' WHERE `connection_key`='" + rdata.ConnectionKey + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Connection Updated Successfully",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    AddHookUrl(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let type;
                let priority;
                switch (sdata.Type) {
                    case "CDR Url":
                        type = "cdr";
                        priority = '0';
                        break;
                    case "SMS Receive":
                        type = "sms-received";
                        priority = '1';
                        break;
                    case "SMS Status":
                        type = "sms-status";
                        priority = '2';
                        break;
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "' AND `iduser`= '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_errorChk, resLt) => {
                    if (_errorChk == 1 && resLt.length > 0) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT * FROM `hooksetting` WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND `type`= '" + type + "'";
                        obj1.prepare();
                        obj1.execute((_errorgt, result) => {
                            if (result == '') {
                                let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj11.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES ((SELECT idaccount FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "'), (SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') , '" + type + "' , '" + sdata.Urls + "', '" + priority + "' , '')";
                                obj11.prepare();
                                obj11.execute((_error, data) => {
                                    if (_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Webhook Url Inserted Successfully", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went wrong with Insert Urls!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE hooksetting SET url='" + sdata.Urls + "' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                                obj.prepare();
                                obj.execute((hook_error, hook_result) => {
                                    if (hook_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Webhook url updated successfully. Becouse this entry was already", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went wrong with update urls. Becouse this entry was already", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Connection key not found!", status: 404 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    UpdateHookUrl(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let type, priority;
                switch (sdata.Type) {
                    case "CDR Url":
                        type = "cdr";
                        break;
                    case "SMS Receive":
                        type = "sms-received";
                        break;
                    case "SMS Status":
                        type = "sms-status";
                        break;
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE hooksetting SET url='" + sdata.Urls + "' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                obj.prepare();
                obj.execute((hook_error, hook_result) => {
                    if (hook_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Webhook Urls Updated Successfully", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went wrong with connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    getInbound(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM inbound WHERE idendpoint='" + sdata.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Inbound Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getOutbound(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM outbound WHERE idendpoint='" + sdata.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Outbound Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getConnectionData(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM routing_profile";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Routing Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getUrlData(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='" + sdata.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Hooksetting Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getExpertSetting(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `routing_profile` WHERE `idendpoint`='" + sdata.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Routing Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    saveConnection(req, res, next) {
        const connection_key = Str.random(30);
        const randDigit = connection_key.slice(4, 12);
        var rdata = [];
        rdata = req.body.data != undefined ? req.body.data : req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT * FROM endpoint where name = '" + rdata.connectionName + "'";
                obj1.prepare();
                obj1.execute((_error, getConn) => {
                    if (_error == 1) {
                        if (getConn.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Connection Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let obj8 = new RawQuery_1.ModelRawQuery(req, res);
                            obj8.qrysql = "SELECT * FROM endpoint where isDefault = 'true'";
                            obj8.prepare();
                            obj8.execute((cerror, getConn1) => {
                                if (cerror == 1) {
                                    var isDefault;
                                    if (getConn1.length > 0) {
                                        isDefault = "false";
                                    }
                                    else {
                                        isDefault = "true";
                                    }
                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj2.filter = null;
                                    let username = Math.random().toString(36).substr(2, 11);
                                    //let username = sessdata.username + val;
                                    //let password = randDigit;
                                    let password = generatePassword();
                                    const inbound_key = Str.random(30);
                                    const outbound_key = Str.random(30);
                                    obj2.qrysql = "CALL addconnection('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + rdata.connectionName + "', '" + connection_key + "', '" + username + "', '" + password + "', '" + inbound_key + "', '" + outbound_key + "', '" + isDefault + "')";
                                    obj2.prepare();
                                    obj2.execute((__error, allcamp) => {
                                        if (__error == 1) {
                                            let newData = allcamp[0];
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                data: newData[0],
                                                message: "Connection Saved Successfully!",
                                                status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                data: allcamp[0],
                                                message: "Something Went Wrong With Connection",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With DB Connection!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With DB Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    getIP(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM ip_address WHERE idendpoint='" + sdata.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "IP Address Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteConnection(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM endpoint WHERE idendpoint = '" + req.query.id + "'";
                obj.prepare();
                obj.execute((_error, lastid) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Connection Deleted Successfully!", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", data: lastid[0], status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    saveIP(req, res, next) {
        var insertedData;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var rdata = [];
                rdata = req.body.data.IPArr;
                rdata.forEach((element) => {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO ip_address (`iduser`, `idaccount`, `idendpoint`, `ip`) VALUES('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + element.idendpoint + "', '" + element.ip + "')";
                    obj2.prepare();
                    obj2.execute((_error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "IP Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    save_smsOutbound(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type`='" + rdata.type + "'";
                obj2.prepare();
                obj2.execute((_error, response) => {
                    if (_error == 1) {
                        if (response != null && response != '') {
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE hooksetting SET `url`='" + rdata.delivery_url + "' WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type` = '" + rdata.type + "'";
                            obj3.execute((error, result) => {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Updated Successfully!", status: 201 });
                                objv.execute();
                            });
                        }
                        else {
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO hooksetting(`idaccount`, `idendpoint`, `type`, `url`) VALUES ('" + sessdata.idaccount + "', '" + rdata.idendpoint + "', '" + rdata.type + "', '" + rdata.delivery_url + "')";
                            obj3.execute((error, result) => {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Saved Successfully!", status: 201 });
                                objv.execute();
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: response, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    save_smsInbound(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type`='" + rdata.type + "'";
                obj2.prepare();
                obj2.execute((_error, response) => {
                    if (_error == 1) {
                        if (response != null && response != '') {
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE hooksetting SET `url`='" + rdata.url + "' WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type` = '" + rdata.type + "'";
                            obj3.execute((__error, result) => {
                                if (__error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Updated Successfully", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Updated Successfully", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO hooksetting(`idaccount`, `idendpoint`, `type`, `url`) VALUES ('" + sessdata.idaccount + "', '" + rdata.idendpoint + "', '" + rdata.type + "', '" + rdata.url + "')";
                            obj3.execute((__error, result) => {
                                if (__error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Saved Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    saveUrls(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                let result = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((ele) => {
                        result[ele.field] = ele.value;
                    });
                    let sms_key = Str.random(30);
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES('" + sessdata.idaccount + "', '" + result.idendpoint + "', '" + result.type + "', '" + result.url + "', '" + result.ID + "', '" + sms_key + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Updated Successfully", status: 201 });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    deleteIP(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM ip_address WHERE id_ipaddress = '" + req.query.id + "'";
                obj.prepare();
                obj.execute((_error, lastid) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "IP Deleted Successfully.", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateInbound(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE inbound SET dnis='" + rdata.dnis + "', ani='" + rdata.ani + "', ringback_timeout='" + rdata.ringback_timeout + "', answer_timeout='" + rdata.answer_timeout + "', channel_limit='" + rdata.channel_limit + "', sip_uri='" + rdata.sip_uri + "', media_type='" + rdata.media_type + "', enable_sip_compact='" + rdata.enable_sip_compact + "', enable_privacy_zone='" + rdata.enable_privacy_zone + "', enable_prack='" + rdata.enable_prack + "', recording='" + rdata.recording + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, data) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: data,
                            message: "Inbound Updated Successfully!",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: data,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateOutbound(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                let ntype = req.body.data.type;
                let uuid = '';
                if (rdata.uuid_detail && rdata.uuid_detail != 'null') {
                    uuid = rdata.uuid_detail;
                }
                else {
                    uuid = '';
                }
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE outbound SET caller_id='" + rdata.caller_id + "', type='" + ntype + "', country='" + rdata.country + "', channel_limit='" + rdata.channel_limit + "', initiated_by='" + rdata.initiated_by + "', voice_profile='" + rdata.voice_profile + "', media_type='" + rdata.media_type + "', enable_ringback='" + rdata.ringback + "', generate_ringback='" + rdata.tone + "', recording='" + rdata.recording + "', uuid_detail='" + uuid + "', amd='" + rdata.amd + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Outbound Updated Successfully",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateConnectionName(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT * FROM endpoint where name = '"+rdata.connectionName+"'";
                // obj.prepare();
                // obj.execute((error: any, result: any) => {
                //     if(result[0]){
                //         let objv = new RawView(res);
                //         objv.prepare({  
                //             message: "Connection Already Exists!" 
                //         });
                //         objv.execute();
                //     }
                //     else{
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + rdata.connectionName + "', `brandId`='" + rdata.brand + "', `campaignId`='" + rdata.campaign + "'  WHERE `idendpoint`='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Connection Name Updated Successfully",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection Name!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
                //     }
                // });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateConnTeckPre(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `tech_prefix`='" + rdata.tech_prefix + "' WHERE `idendpoint`='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, trechPre) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: 0, data: trechPre, message: "Tech Prefix Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0, data: trechPre, message: "Something Went Wrong With Tech Prefix!", status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateConnUserPass(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `username`='" + rdata.username + "', `password`='" + rdata.password + "' WHERE `idendpoint`='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, credentials) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: 0, data: credentials, message: "Credentials Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0, data: credentials, message: "Something Went Wrong With Credentials!", status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateConnInboundCall(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`='" + rdata.forward_type + "',`forward`='" + rdata.forward + "' WHERE `idendpoint`='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, credentials) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: 0, data: credentials, message: "Forwords Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0, data: credentials, message: "Something Went Wrong With Forwords!", status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE endpoint SET status='" + req.body.data + "' WHERE idendpoint='" + req.query.id + "'";
                obj.prepare();
                obj.execute((_error, lastid) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Status Update Successfully.", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Status Update Successfully.", data: lastid, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateConnection(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                let techPrefix;
                if (rdata.tech_prefix) {
                    techPrefix = rdata.tech_prefix;
                }
                else {
                    techPrefix = '';
                }
                obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + rdata.connectionName + "', `username`='" + rdata.username + "', `password`='" + rdata.password + "', `tech_prefix`='" + techPrefix + "',`forward_type`='" + rdata.forward_type + "',`forward`='" + rdata.forward + "', `brandId`='" + rdata.brand + "', `campaignId`='" + rdata.campaign + "' WHERE `idendpoint`='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Connection Updated Successfully",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateFQDN(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata;
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE routing_profile SET FQDN_type='" + rdata.type + "', FQDN_user='" + rdata.user + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            status: 201,
                            message: "Updated Successfully"
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong With Connection!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // updateIP(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let rdata: any = [];
    //             rdata = req.body.data.IPArr
    //             let obj3 = new ModelRawQuery(req, res);
    //             obj3.qrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
    //             obj3.prepare();
    //             obj3.execute((derror: any, allcamp: any) => {
    //                 if (derror == 1) {
    //                     let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
    //                     rdata.forEach((element: any) => {
    //                         sql += "('" + element.idendpoint + "','" + element.ip + "'),"
    //                     });
    //                     sql = sql.substring(0, sql.length - 1);
    //                     let obj2 = new ModelRawQuery(req, res);
    //                     obj2.qrysql = sql;
    //                     obj2.prepare();
    //                     obj2.execute((_error: any, allcamp: any) => {
    //                         if (_error == 1) {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "IP Updated Successfully!",
    //                                 status: 201
    //                             })
    //                             objv.execute();
    //                         }
    //                         else {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "Duplicate Entry Please Try Again!",
    //                                 status: 1062
    //                             })
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //                 else {
    //                     let sql = "INSERT INTO ip_address (`iduser`, `idaccount`,`idendpoint`, `ip`) VALUES ";
    //                     rdata.forEach((element: any) => {
    //                         sql += "('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + element.idendpoint + "','" + element.ip + "'),"
    //                     });
    //                     sql = sql.substring(0, sql.length - 1);
    //                     let obj2 = new ModelRawQuery(req, res);
    //                     obj2.qrysql = sql;
    //                     obj2.prepare();
    //                     obj2.execute((_error: any, allcamp: any) => {
    //                         if (_error == 1) {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "IP Updated Successfully!",
    //                                 data: allcamp,
    //                                 status: 201
    //                             })
    //                             objv.execute();
    //                         }
    //                         else {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "Something Went Wrong With Connection!",
    //                                 status: 502
    //                             })
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //             });
    //             // obj2.filter = null;
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }
    updateIP(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data.IPArr;
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
                obj3.prepare();
                obj3.execute((derror, allcamp) => {
                    if (derror == 1) {
                        let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                        rdata.forEach((element) => {
                            sql += "('" + element.idendpoint + "','" + element.ip + "'),";
                        });
                        sql = sql.substring(0, sql.length - 1);
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = sql;
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            if (_error == 1) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT * FROM `ip_address` WHERE `idendpoint`='" + rdata[0].idendpoint + "'";
                                obj1.prepare();
                                obj1.execute((_errorget, resultenp) => {
                                    if (_errorget == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "IP Inserted Successfully!",
                                            status: 201,
                                            dataip: resultenp
                                        });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "IP Not Inserted!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Duplicate Entry Please Try Again!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let sql = "INSERT INTO ip_address (`iduser`, `idaccount`,`idendpoint`, `ip`) VALUES ";
                        rdata.forEach((element) => {
                            sql += "('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + element.idendpoint + "','" + element.ip + "'),";
                        });
                        sql = sql.substring(0, sql.length - 1);
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = sql;
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            if (_error == 1) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT * FROM `ip_address` WHERE `idendpoint`='" + rdata[0].idendpoint + "'";
                                obj1.prepare();
                                obj1.execute((_errorget, resultenp) => {
                                    if (_errorget == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "IP Inserted Successfully!",
                                            status: 201,
                                            dataip: resultenp
                                        });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "IP Not Inserted!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Connection!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                });
                // obj2.filter = null;
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateUrls(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                let result = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((ele) => {
                        result[ele.field] = ele.value;
                    });
                    // if(result.idhooksetting){
                    if (result.url == null) {
                        result.url = '';
                    }
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE hooksetting SET url='" + result.url + "' WHERE idendpoint='" + result.idendpoint + "' AND type='" + result.type + "'";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                    // }
                    // else{
                    //     let sms_key = Str.random(30);
                    //     let obj = new ModelRawNonQuery(req, res);
                    //     obj.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES('" + sessdata.idaccount + "', '" +result.idendpoint + "', '" + result.type + "', '" + result.url + "', '" + result.ID + "', '"+sms_key+"')";
                    //     obj.prepare();
                    //     obj.execute((error: any, data: any) => {
                    //     });
                    // }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Updated Successfully", status: 201 });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    insertUrlsData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let idendpoint = req.body.data;
                // delete
                // let obj0 = new ModelRawQuery(req, res);
                // obj0.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='"+ idendpoint +"'";
                // obj0.prepare();
                // obj0.execute((_errorgt: any, resultchk: any) => {
                //     if(resultchk.length <= 2){
                //         let obj00 = new ModelRawQuery(req, res);
                //         obj00.qrysql = "delete from hooksetting where idendpoint = '" + idendpoint + "'";
                //         obj00.prepare();
                //         obj00.execute((derror: any, allcamp: any) => {
                // insert
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'cdr'";
                obj1.prepare();
                obj1.execute((_errorgt, resultcdr) => {
                    if (resultcdr == '') {
                        let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj11.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  ('" + sessdata.idaccount + "', '" + idendpoint + "' , 'cdr' , '', '0' , '')";
                        obj11.prepare();
                        obj11.execute((_error, data) => { });
                    }
                });
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'sms-status'";
                obj2.prepare();
                obj2.execute((_errorgt, resultstatus) => {
                    if (resultstatus == '') {
                        let obj22 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj22.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  ('" + sessdata.idaccount + "', '" + idendpoint + "' , 'sms-status' , '', '2' , '')";
                        obj22.prepare();
                        obj22.execute((_error, data) => { });
                    }
                });
                let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                obj3.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'sms-received'";
                obj3.prepare();
                obj3.execute((errorgtreceived, resultreceived) => {
                    if (resultreceived == '') {
                        let obj33 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj33.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  ('" + sessdata.idaccount + "', '" + idendpoint + "' , 'sms-received' , '', '1' , '')";
                        obj33.prepare();
                        obj33.execute((_error, data) => { });
                    }
                });
                //});
                let objv = new RawView_1.RawView(res);
                objv.prepare({ error: 0, message: "Updated Successfully", status: 201 });
                objv.execute();
                //     }
                // });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateExpertSetting(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE routing_profile SET encode_header='" + rdata.Encode + "', comfort_noise='" + rdata.enable_comfort + "', enable_on_net='" + rdata.enable_on_net + "', DTMF_type='" + rdata.DTMF_type + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Updated Successfully",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updatePassword(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = req.body.data;
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE endpoint SET username='" + rdata.password + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error, upPass) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: 1, data: upPass, message: "Updated Successfully", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: 0, message: "Something Went Wrong With update Password!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data available!");
                objv.execute();
            }
        });
    }
    listConnections(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL ListConnection('" + sessdata.idaccount + "')";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "List Connection Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UserDefaultConnection(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                if (sessdata.type == 22) {
                    obj.qrysql = "SELECT * FROM `endpoint` WHERE `isDefault`='true' AND `iduser`= '" + sessdata.iduser + "'";
                }
                else {
                    obj.qrysql = "SELECT e.*, CONCAT(us.firstname,' ',us.lastname) AS fullname FROM `endpoint`e JOIN `user_profile`us ON us.iduser = e.iduser WHERE `isDefault`='true' AND e.`idaccount`= '" + sessdata.idaccount + "'";
                }
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Single Connection Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    AllKeyByConnKey(req, res, next) {
        let key = req.query.type;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT endpoint.idendpoint,endpoint.connection_key, inbound.inbound_key, outbound.outbound_key FROM endpoint JOIN inbound ON endpoint.idendpoint = inbound.idendpoint JOIN outbound ON endpoint.idendpoint = outbound.idendpoint WHERE `connection_key`= '" + key + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Key Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Key!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    setDefaultConnection(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='false' WHERE `iduser`='" + sdata.data.split('-')[1] + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='true' WHERE `idendpoint`='" + sdata.data.split('-')[0] + "'";
                        obj.prepare();
                        obj.execute((__error, _result) => {
                            if (__error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Default Connection Changed Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Default Connection Not Changed DB Error!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Connection = Connection;
