"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setToZero = exports.parseBody = exports.ipAddressAndBrowser = void 0;
const Str = require('@supercharge/strings');
const jwt = require('jsonwebtoken');
const { networkInterfaces } = require('os');
const checkDesc = (desc) => {
    let result = '';
    if (desc) {
        result = desc.replace(/"/g, '\\"').replace(/'/g, "\\'");
        return result;
    }
    else {
        result = '';
        return result;
    }
};
const parseBody = (desc) => {
    let result = '';
    if (desc) {
        result = desc
            .replace(/\\/g, '\\\\')
            .replace(/"/g, '\\"')
            .replace(/'/g, "\\'");
    }
    return result;
};
exports.parseBody = parseBody;
const setToZero = (data) => {
    let description = data ?? '';
    let dest = Number(description);
    if (dest == '') {
        return 0;
    }
    else {
        return data;
    }
};
exports.setToZero = setToZero;
const ipAddressAndBrowser = (req) => {
    /* login history Create  Token */
    let secret = Str.random(15);
    let Token = jwt.sign({
        exp: Math.floor(Date.now() / 1000),
    }, secret);
    //To Get ipaddress
    const nets = networkInterfaces();
    const ipAddress = [];
    for (const name of Object.keys(nets)) {
        for (const net of nets[name]) {
            const familyV4Value = typeof net.family === 'string' ? 'IPv4' : 4;
            if (net.family === familyV4Value && !net.internal) {
                ipAddress.push(net.address);
            }
        }
    }
    /*To Get Browser Name */
    const userAgentString = req.headers['user-agent'];
    const userAgent = userAgentString;
    let browserName = 'unknown';
    if (userAgent?.includes('Safari')) {
        browserName = 'Safari';
    }
    if (userAgent?.includes('Chrome')) {
        browserName = 'Google Chrome';
    }
    if (userAgent?.includes('Edg')) {
        browserName = 'Microsoft Edge';
    }
    if (userAgent?.includes('OPR')) {
        browserName = 'Opera';
    }
    if (userAgent?.includes('msie')) {
        browserName = 'Internet Explorer';
    }
    if (userAgent?.includes('Firefox')) {
        browserName = 'Firefox';
    }
    let sysInfo = {
        ipAddress: [req.headers['x-forwarded-for'] || req.socket.remoteAddress],
        browserName: browserName, uniqueToken: Token
    };
    return sysInfo;
};
exports.ipAddressAndBrowser = ipAddressAndBrowser;
exports.default = checkDesc;
