"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DIDManager = exports.Number = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const AppRoute_1 = require("../lib/AppRoute");
const RawQuery_1 = require("../lib/model/RawQuery");
const ThinQ_1 = require("./ThinQ");
const Inteliquent_1 = require("./Inteliquent");
const CoreTel_1 = require("./CoreTel");
const Osr_1 = require("./Osr");
const TeleApi_1 = require("./TeleApi");
const _404_1 = require("../lib/view/404");
const md5_1 = __importDefault(require("md5"));
const Peerless_1 = require("./Peerless");
const SinchSubmitNumber_1 = require("./SinchSubmitNumber");
const lrnApi_1 = require("./lrnApi");
let request = require('request');
const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
const devurl = 'http://osrdev-e1.netnumber.net:84/osr/v2/entries/';
const myip = "iplink";
const nnid = "104141";
let email = "noc@nglcom.com";
let password = "xUxCyLwd";
class Number extends AppRoute_1.AppRoute {
    constructor() {
        super();
    }
    SearchByNpxNaa(req, res, next) {
        let sdata = req.query;
        if (sdata.NPA && sdata.Qty) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    if (error == 1) {
                        let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority`, u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            console.log("responce", responce);
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                    responce.forEach((ele) => {
                                        if (ele.username == "thinq")
                                            index_thinq = ele.priority;
                                        if (ele.username == "inteliquent")
                                            index_intel = ele.priority;
                                        if (ele.username == "teleapi")
                                            index_teleapi = ele.priority;
                                        if (ele.username == "Coretel")
                                            index_coretel = ele.priority;
                                        if (ele.username == "Peerless")
                                            index_peerless = ele.priority;
                                    });
                                    console.log({
                                        "index_thinq": index_thinq,
                                        "index_intel": index_intel,
                                        "index_teleapi": index_teleapi,
                                        "index_coretel": index_coretel,
                                        "index_peerless": index_peerless
                                    });
                                    let thinq = new ThinQ_1.ThinQAPI(index_thinq, sessdata, key);
                                    thinq.getNpaNxx(req, res, (err1, res1) => {
                                        let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                        intel.getNpaNxx(req, res, (err2, res2) => {
                                            let tele = new TeleApi_1.TeleAPI(index_teleapi, sessdata, key);
                                            tele.getNpaNxx(req, res, (err3, res3) => {
                                                let peer = new Peerless_1.PeerlessAPI(index_peerless, sessdata, key);
                                                peer.getNpaNxx(req, res, (err4, res4) => {
                                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT  `phone_number`, `provider`, `rate_center`, `state`,`supplier_tier` FROM `did_search` where `iduser`='" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                    obj2.prepare();
                                                    obj2.execute((err_result, res_result) => {
                                                        if (err_result == 1) {
                                                            if (res_result.length > 0) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 404, message: "No DID's found on [" + sdata.NPA + "]" });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new _404_1.Res404(res);
                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new _404_1.Res404(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare("No session data there");
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "All field are required,NPA,Qty" });
            objv.execute();
        }
    }
    SearchByRate(req, res, next) {
        let sdata = req.query;
        if (sdata.RateCenter && sdata.State && sdata.Qty) {
            const str1 = req.query.NPA;
            const str2 = req.query.NXX;
            var sdata1 = str1 + "" + str2;
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    if (error == 1) {
                        let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            console.log("responce", responce);
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                    responce.forEach((ele) => {
                                        console.log("ele", ele);
                                        if (ele.username == "thinq")
                                            index_thinq = ele.priority;
                                        if (ele.username == "inteliquent")
                                            index_intel = ele.priority;
                                        if (ele.username == "teleapi")
                                            index_teleapi = ele.priority;
                                        if (ele.username == "Coretel")
                                            index_coretel = ele.priority;
                                        if (ele.username == "Peerless")
                                            index_peerless = ele.priority;
                                    });
                                    console.log({
                                        "index_thinq": index_thinq,
                                        "index_intel": index_intel,
                                        "index_teleapi": index_teleapi,
                                        "index_coretel": index_coretel,
                                        "index_peerless": index_peerless
                                    });
                                    let thinq = new ThinQ_1.ThinQAPI(index_thinq, sessdata, key);
                                    thinq.getByRate(req, res, (err1, res1) => {
                                        let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                        intel.getByRate(req, res, (err2, res2) => {
                                            let tele = new TeleApi_1.TeleAPI(index_teleapi, sessdata, key);
                                            tele.getByRate(req, res, (err2, res2) => {
                                                let peer = new Peerless_1.PeerlessAPI(index_peerless, sessdata, key);
                                                peer.getByRate(req, res, (err4, res4) => {
                                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT  `phone_number`, `provider`, `rate_center`, `state`, `supplier_tier` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                    obj2.prepare();
                                                    obj2.execute((err_result, res_result) => {
                                                        if (err_result == 1) {
                                                            if (res_result.length > 0) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 404, message: "No DID's found on [" + sdata.RateCenter + "]" });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 502, message: " Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new _404_1.Res404(res);
                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: " Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare("No session data there");
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "All field are required,RateCenter,State,Qty" });
            objv.execute();
        }
    }
    SearchTolefree(req, res, next) {
        let sdata = req.query;
        if (sdata.TF_PREFIX && sdata.Qty) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    if (error == 1) {
                        let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            console.log(responce);
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                    responce.forEach((ele) => {
                                        if (ele.username == "thinq")
                                            index_thinq = ele.priority;
                                        if (ele.username == "inteliquent")
                                            index_intel = ele.priority;
                                        if (ele.username == "teleapi")
                                            index_teleapi = ele.priority;
                                        if (ele.username == "Coretel")
                                            index_coretel = ele.priority;
                                        if (ele.username == "Peerless")
                                            index_peerless = ele.priority;
                                    });
                                    console.log({
                                        "index_thinq": index_thinq,
                                        "index_intel": index_intel,
                                        "index_teleapi": index_teleapi,
                                        "index_coretel": index_coretel,
                                        "index_peerless": index_peerless
                                    });
                                    let thinq = new ThinQ_1.ThinQAPI(index_thinq, sessdata, key);
                                    thinq.getTollFree(req, res, (err1, res1) => {
                                        let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                        intel.getTollFree(req, res, (err2, res2) => {
                                            let tele = new TeleApi_1.TeleAPI(index_teleapi, sessdata, key);
                                            tele.getTollFree(req, res, (err2, res2) => {
                                                let peer = new Peerless_1.PeerlessAPI(index_peerless, sessdata, key);
                                                peer.getTollFree(req, res, (err3, res3) => {
                                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT  `phone_number`, `provider` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                    obj2.prepare();
                                                    obj2.execute((err_result, res_result) => {
                                                        if (err_result == 1) {
                                                            if (res_result.length > 0) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 404, message: "No DID's found on [" + sdata.TF_PREFIX + "]" });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new _404_1.Res404(res);
                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare("No Session data there");
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "All field are required, TF_PREFIX, Qty" });
            objv.execute();
        }
    }
    PurchaseDid(req, res, next) {
        const sdata = req.body;
        let via_panel = (typeof sdata.via_panel != 'undefined' && sdata.via_panel > 0) ? sdata.via_panel : 0;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (sessdata.type == 2 || sessdata.type == 22) {
                if (error == 1) {
                    if (sdata.DID) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `provider`, `rates`, `type` FROM `did_search` WHERE `iduser`='" + sessdata.iduser + "' AND `phone_number`='" + sdata.DID.trim() + "'";
                        obj.prepare();
                        obj.execute((error, responce) => {
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + responce[0].rates + "'";
                                    obj5.prepare();
                                    obj5.execute((walletError, wallet) => {
                                        if (walletError == 1) {
                                            if (wallet.length > 0) {
                                                // To create the group_order for external customers
                                                let DIDM = new DIDManager();
                                                // Payload of group order
                                                let payLoad = {
                                                    via_panel: via_panel,
                                                    numbers: sdata.DID.toString(),
                                                    routing: sdata.Connection,
                                                    in_routing: sdata.InboundVoice,
                                                    out_routing: sdata.OutboundVoice,
                                                    campaign: sdata.CampaignId
                                                };
                                                DIDM.CreateGroupOrder(req, res, sessdata, payLoad, (error, result) => {
                                                    if (error == 1) {
                                                        let id_grouporder = result.id_grouporder;
                                                        // To update the process count of group order
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `did_group_order` SET `is_process`=1 WHERE `id_grouporder`=" + id_grouporder + ";";
                                                        obj.prepare();
                                                        obj.execute((error, result) => {
                                                            console.log("GroupOrder process count::\n", result);
                                                        });
                                                        let other_data = {
                                                            id_grouporder: id_grouporder
                                                        };
                                                        // Thinq provider
                                                        if (responce[0].provider == "thinQ") {
                                                            let thinq = new ThinQ_1.ThinQAPI("", sessdata, '');
                                                            thinq.buyDID(req, res, responce, other_data, (err, resp) => { });
                                                        }
                                                        // Intelliquent provider
                                                        else if (responce[0].provider == "inteliQ") {
                                                            let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
                                                            intel.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                        }
                                                        // TeleAPI provider
                                                        else if (responce[0].provider == "teleapi") {
                                                            let tele = new TeleApi_1.TeleAPI("", sessdata, '');
                                                            tele.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                        }
                                                        // Peerless provider
                                                        else if (responce[0].provider == "Peerless") {
                                                            let peer = new Peerless_1.PeerlessAPI("", sessdata, '');
                                                            peer.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                        }
                                                        // CoreTelAPI provider
                                                        else {
                                                            let coretel = new CoreTel_1.CoreTelAPI("", sessdata);
                                                            coretel.buyDID(req, res, responce, other_data, (error, responce) => {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    error_code: 0,
                                                                    status: 404,
                                                                    message: "Invalid DID provider!"
                                                                });
                                                                objv.execute();
                                                            });
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            error_code: 0,
                                                            error: result,
                                                            message: "Something Went Wrong With Connection!",
                                                            status: 502
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    error_code: 0,
                                                    error: wallet,
                                                    message: "Please add funds to your account or contact support.",
                                                    status: 503
                                                });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                error_code: 0,
                                                error: wallet,
                                                message: "Something Went Wrong to Fetch Account Balance!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: 0,
                                        status: 404,
                                        message: "Did Not Available"
                                    });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: 0,
                                    status: 502,
                                    message: "Something went wrong with connection!"
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error_code: 0,
                            status: 500,
                            message: "DID are required!"
                        });
                        objv.execute();
                    }
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error_code: 0,
                    status: 404,
                    message: "Not Permitted"
                });
                objv.execute();
            }
        });
    }
    EnableSMS(req, res, next) {
        const sdata = req.body;
        if (sdata.DID && sdata.CampaignId) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let camp_key = sdata.CampaignId;
                    let iduser = '';
                    if (sdata.iduser) {
                        iduser = sdata.iduser;
                    }
                    else {
                        iduser = sessdata.iduser;
                    }
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`=(SELECT upstreamCnpId FROM `campaign` WHERE `campaign_key`='" + camp_key + "' AND `deleted`=0 LIMIT 1)";
                    obj0.prepare();
                    obj0.execute((camperr, campres) => {
                        if (camperr == 1 && campres.length > 0) {
                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                            // obj1.qrysql = "SELECT d.did,d.camp_registry,d.iduser,d.sms_provider,d.provider ,c.campaign_key, c.did_count,c.did_limit FROM did_buy d INNER JOIN campaign c ON d.camp_registry=c.campaign_key WHERE d.camp_registry = '" + camp_key + "' AND d.iduser = '" + iduser + "' AND d.did = '" + sdata.DID.trim() + "' GROUP BY d.did";
                            obj1.qrysql = "SELECT did,camp_registry,sms_provider,provider FROM did_buy WHERE iduser = '" + iduser + "' AND did = '" + sdata.DID.trim() + "' GROUP BY did";
                            obj1.prepare();
                            obj1.execute((error, responce) => {
                                if (error == 1 && responce.length > 0) {
                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name FROM campaign WHERE `campaign_key` = '" + camp_key + "' AND `iduser` = '" + iduser + "' GROUP BY campaign_key";
                                    obj1.prepare();
                                    obj1.execute((error, camp_res) => {
                                        if (error == 1 && camp_res.length > 0) {
                                            let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj00.qrysql = "SELECT `iddidlog` FROM did_log WHERE `did`= '" + sdata.DID.trim() + "' AND `iduser` = '" + iduser + "' ORDER BY `iddidlog` DESC";
                                            obj00.prepare();
                                            obj00.execute((log_error, log_res) => {
                                                if (log_error == 1 && log_res.length > 0) {
                                                    if (camp_res[0].did_limit > camp_res[0].did_count) {
                                                        if (responce[0].provider == "inteliQ" || responce[0].provider == "thinQ") {
                                                            let did = sdata.DID;
                                                            let len = did.length - 10;
                                                            let number = did.slice(len, did.length);
                                                            let number1 = "+1" + number;
                                                            let camp_name = camp_res[0].campaign_name;
                                                            let options = {
                                                                'method': 'PUT',
                                                                'url': produrl + "" + `${number1}`,
                                                                'headers': {
                                                                    'Content-Type': 'application/json'
                                                                },
                                                                body: '{ id: "' + campres[0].myip + '", nnid:"' + campres[0].nnid + '" , "context": "A2P", "campaign_id": "' + sdata.CampaignId + '" }'
                                                            };
                                                            request(options, (error, response) => {
                                                                if (!error) {
                                                                    let data = JSON.parse(response.body);
                                                                    let __tn = typeof data.tn != 'undefined' ? data.tn : '';
                                                                    let __message = typeof data.message != 'undefined' ? data.message : '';
                                                                    let __campaign_id = typeof data.campaign_id != 'undefined' ? data.campaign_id : '';
                                                                    let rDt = {
                                                                        tn: __tn,
                                                                        message: __message,
                                                                        campaign_id: __campaign_id
                                                                    };
                                                                    if (data.message == "Success") {
                                                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj2.nonqrysql = "UPDATE `campaign` SET did_count=(" + camp_res[0].did_count + "+1)  WHERE `iduser` = '" + iduser + "' AND `campaign_key` = '" + camp_key + "'";
                                                                        obj2.prepare();
                                                                        obj2.execute((osr_errrr, resppp) => {
                                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj3.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register', `camp_registry`='" + camp_key + "', `sms_provider`='" + campres[0].sms_provider + "' WHERE `iduser` = '" + iduser + "' AND `did`='" + number + "'";
                                                                            obj3.prepare();
                                                                            obj3.execute((osr_err, resp) => {
                                                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj4.nonqrysql = "INSERT INTO `campaign_history`(`iduser`,`idaccount`,`did`,`campaign_key`,`campaign_name`,`in_use`,`iddidlog`) VALUES ('" + iduser + "','" + sessdata.idaccount + "','" + number + "','" + camp_key + "','" + camp_name + "', '0','" + log_res[0].iddidlog + "')";
                                                                                obj4.prepare();
                                                                                obj4.execute((osr_err, resp) => {
                                                                                    if (osr_err == 1) {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ status: 200, message: "SMS enabled successfully" });
                                                                                        objv.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ status: 502, message: "SMS is not enabled!" });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            });
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: data.response_code, message: data.message, data: rDt });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 400, error: error });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 404, message: "Invalid Provider!" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 404, message: `You can not enable DID's in this Campaign!` });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 404, message: `ID DID not found on this DID!` });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 404, message: "CampaignId Not Found!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 404, message: "DID Not Found!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: "CampaignId does not match!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "All fields are required, DID, CampaignId" });
            objv.execute();
        }
    }
    DisconnectDid(req, res, next) {
        const sdata = req.body;
        if (sdata.DID) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22) {
                    let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : sessdata.iduser;
                    if (error == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT provider FROM `did_buy` WHERE `did`='" + sdata.DID + "' AND `iduser`='" + iduser + "'";
                        obj.prepare();
                        obj.execute((error, responce) => {
                            if (error == 1) {
                                if (responce.length > 0) {
                                    // Thinq provider
                                    if (responce[0].provider == "thinQ") {
                                        let thinq = new ThinQ_1.ThinQAPI("", sessdata, '');
                                        thinq.disconnectDID(req, res, (error, responce) => { });
                                    }
                                    // Intelliquent provider
                                    else if (responce[0].provider == "inteliQ") {
                                        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
                                        intel.disconnectDID(req, res, (error, responce) => { });
                                    }
                                    // TeleAPI provider
                                    else if (responce[0].provider == "teleapi") {
                                        let tele = new TeleApi_1.TeleAPI("", sessdata, '');
                                        tele.disconnectDID(req, res, (error, responce) => { });
                                    }
                                    // Peerless provider
                                    else if (responce[0].provider == "Peerless") {
                                        let peer = new Peerless_1.PeerlessAPI("", sessdata, '');
                                        peer.disconnectDID(req, res, (error, responce) => { });
                                    }
                                    // CoreTelAPI provider
                                    else {
                                        let coretel = new CoreTel_1.CoreTelAPI("", sessdata);
                                        coretel.disconnectDID(req, res, (error, responce) => { });
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 404, message: "DID Not Available" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare("No session data there");
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted " });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    disconnectSelectedDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            var disDID = [];
            disDID.length = 0;
            disDID.splice(0, disDID.length);
            var disDIDid = [];
            disDIDid.length = 0;
            disDIDid.splice(0, disDIDid.length);
            var notdisDID = [];
            notdisDID.length = 0;
            notdisDID.splice(0, notdisDID.length);
            var notdisDIDid = [];
            notdisDIDid.length = 0;
            notdisDIDid.splice(0, notdisDIDid.length);
            let arrStr = '';
            let TotalDays;
            if (err == 1) {
                let sdata = req.body.data;
                let inc = 0;
                let DIDIds = [];
                for (let x of sdata) {
                    DIDIds.push(x.iddid);
                }
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT t.day_num,d.iddid,d.created_at,d.did FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid IN(" + DIDIds + ")";
                obj1.prepare();
                obj1.execute((errday, resday) => {
                    if (errday == 1 && resday.length > 0) {
                        for (let y of resday) {
                            let did_buy_date = y.created_at;
                            let today_date = new Date();
                            const oneDay = 1000 * 60 * 60 * 24;
                            const diffInTime = today_date.getTime() - did_buy_date.getTime();
                            TotalDays = Math.round(diffInTime / oneDay);
                            if (TotalDays) {
                                if (TotalDays > y.day_num) {
                                    disDID.push(y.did);
                                    arrStr = disDIDid.push(y.iddid);
                                }
                                else {
                                    notdisDID.push(y.did);
                                    notdisDIDid.push(y.iddid);
                                }
                            }
                        }
                        if (disDIDid.length > 0) {
                            arrStr = disDIDid;
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid` IN(" + arrStr + ")";
                            obj2.prepare();
                            obj2.execute((errorin, data) => {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully!", disdata: disDID, notdisDID: notdisDID });
                                objv.execute();
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, error: 0, message: "DID Not Disconnected Successfully!", disdata: '', notdisDID: '' });
                            objv.execute();
                        }
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    //disconnectSelectedDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((err: any, sessdata: any) => {
    //         var disconnectedDID: any = [];
    //         disconnectedDID.length = 0;
    //         disconnectedDID.splice(0, disconnectedDID.length);
    //         let disLen: any = '';
    //         var notDisconnectedDID: any = [];
    //         notDisconnectedDID.length = 0;
    //         notDisconnectedDID.splice(0, notDisconnectedDID.length);
    //         let notdisLen: any = '';
    //         if (err == 1) {
    //             let sdata: any = req.body.data;
    //             let dislength = "";
    //             let i = 0;
    //             let j = 0;
    //             //var promise = new Promise((resolve: any, reject: any) => {
    //                 sdata.forEach((el: any, idx: any, dids: any) => {
    //                     i++;
    //                     console.log('idxidxidxidx',idx, 'iiiiiiiiiiiiiiiii', i , 'dids.length',dids.length-1, 'sdata.length', sdata.length);
    //                     let obj1 = new ModelRawQuery(req, res);
    //                     obj1.qrysql = "SELECT t.day_num,d.iddid FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid='" + el.iddid + "'";
    //                     obj1.prepare();
    //                     obj1.execute((errday: any, resday: any) => {
    //                         if (errday == 1 && resday.length > 0) {
    //                             let number = new Number();
    //                             number.countDays(req, res, el.did.trim(), (err: any, countdays: any) => {
    //                                 if (countdays) {
    //                                     if (countdays > resday[0].day_num) {
    //                                         let obj2 = new ModelRawQuery(req, res);
    //                                         obj2.qrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid`= '" + el.iddid + "'";
    //                                         obj2.prepare();
    //                                         obj2.execute((error: any, data: any) => {
    //                                             j++;
    //                                             disconnectedDID.push(el.did);
    //                                             disLen = disconnectedDID.length;
    //                                             console.log('disLen top',disLen);
    //                                         });
    //                                     } else {
    //                                         notDisconnectedDID.push(el.did);
    //                                         notdisLen = notDisconnectedDID.length;
    //                                     }
    //                                     console.log('disLen mid',disLen);
    //                                     console.log('notdisLen mid',notdisLen);
    //                                     console.log('disLen out ',disLen);
    //                                     console.log('notdisLen out',notdisLen);
    //                                     console.log('iiiiiiiiiiiiiiii',i);
    //                                     console.log('sdata.length',sdata.length);
    //                                 }
    //                             });
    //                         }
    //                     });
    //                 });
    //             //})
    //             // let objv = new RawView(res);
    //             // //objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully! Disconnect Did : " + disLen + " Not Disconnect Did : " + notdisLen })
    //             // objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully!" })
    //             // objv.execute();
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }
    RetrievOsr(req, res, next) {
        const sdata = req.query;
        if (sdata.DID) {
            console.log("sdata==>" + sdata);
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let osr = new Osr_1.OsrApi('', sessdata);
                    osr.retrieveOsrEntry(req, res, (error, resp) => {
                        if (resp) {
                            let obj1 = new RawView_1.RawView(res);
                            obj1.prepare({ status: 200, message: "OSR Details Find Successfully", result: resp });
                            obj1.execute();
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 404, message: "OSR Details Not Found", result: error });
                            obj.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    RetrievOsrNotification(req, res, next) {
        const sdata = req.query;
        console.log("sdata==>" + sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let osr = new Osr_1.OsrApi('', sessdata);
                osr.retrieveOsrNotifications(req, res, (error, resp) => {
                    if (resp) {
                        let obj1 = new RawView_1.RawView(res);
                        obj1.prepare({ status: 200, message: "OSR Details Find Successfully", result: resp });
                        obj1.execute();
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 404, message: "OSR Details Not Found", result: error });
                        obj.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    DeleteNumber(req, res, next) {
        const sdata = req.query;
        if (sdata.DID) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((_error, sessdata) => {
                if (_error == 1) {
                    let osr = new Osr_1.OsrApi('', sessdata);
                    osr.deleteNumber(req, res, (error, resp) => {
                        if (!error) {
                            let obj1 = new RawView_1.RawView(res);
                            obj1.prepare({ status: 200, message: "DID Successfully Disabled.", result: resp });
                            obj1.execute();
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 400, error: error });
                            obj.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    DeleteSinchNumber(req, res, next) {
        const sdata = req.query;
        console.log("sdata==>" + sdata);
        if (sdata.DID) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let osr = new SinchSubmitNumber_1.SinchApi('', sessdata);
                    osr.deleteNumber(req, res, (error, resp) => {
                        if (resp) {
                            let obj1 = new RawView_1.RawView(res);
                            obj1.prepare({ status: 201, message: "DID Delete From SInch successfully", result: resp });
                            obj1.execute();
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 502, message: "Somthing went Wrong", result: error });
                            obj.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    /*  public NetworkOperators(req: Request, res: Response, next: NextFunction) {
         const sdata = req.query;
         if (sdata.DID) {
             let number: any = sdata.DID;
             console.log("sdata==>" + sdata);
             let session = new SessionManagment(req, res, next);
             session.GetSession((error: any, sessdata: any) => {
                 if (error == 1) {
                     var headers = {
                         'accept': 'application/json'
                     };
                     var options = {
                         url: 'https://api-iplink.peeredge.com/api/v1/users/sign_in?user[email]=' + email + '&user[password]=' + password,
                         method: 'POST',
                         headers: headers
                     };
                     request(options, (error: any, responce: any) => {
                         if (!error) {
                             let data = JSON.parse(responce.body);
                             let auth_token = data.auth_token;
                             var headers = {
                                 'accept': 'application/json',
                                 'Token': auth_token
                             };
                             var options = {
                                 url: 'https://api-iplink.peeredge.com/api/v1/reportings/get_lrn?lrn=' + number,
                                 method: 'GET',
                                 headers: headers
                             };
                             console.log("options", options);
                             request(options, (error: any, responce: any) => {
                                 if (!error) {
                                     let lrn_detail = JSON.parse(responce.body);
                                     console.log("lrn_detail", lrn_detail);
                                     if (lrn_detail.hasOwnProperty('errors')) {
                                         if (lrn_detail.errors[0] == "LRN Not Found.") {
                                             let did: any = "" + number + "";
                                             let len: any = did.length - 10;
                                             let number1 = did.slice(len, did.length);
                                             let npa = number1.slice(0, 3);
                                             let nxx = number1.slice(3, 6);
                                             let obj1 = new ModelRawQuery(req, res);
                                             obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`,   `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                                             obj1.prepare()
                                             obj1.execute((lrn_err, lrn_details) => {
                                                 if (lrn_err == 1) {
                                                     if (lrn_details.length > 0) {
                                                         let objv = new RawView(res);
                                                         objv.prepare({ status: 200, message: lrn_details });
                                                         objv.execute();
                                                     } else {
                                                         let objv = new RawView(res);
                                                         objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                         objv.execute();
                                                     }
                                                 } else {
                                                     let objv = new RawView(res);
                                                     objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                     objv.execute();
                                                 }
                                             });
                                         }
                                     } else {
                                         let did: any = "" + lrn_detail.lnp + "";
                                         let len: any = did.length - 10;
                                         let number1 = did.slice(len, did.length);
                                         let npa = number1.slice(0, 3);
                                         let nxx = number1.slice(3, 6);
                                         let obj1 = new ModelRawQuery(req, res);
                                         obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`,   `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                                         obj1.prepare()
                                         obj1.execute((lrn_err, lrn_details) => {
                                             if (lrn_err == 1) {
                                                 if (lrn_details.length > 0) {
                                                     let objv = new RawView(res);
                                                     objv.prepare({ status: 200, message: lrn_details });
                                                     objv.execute();
                                                 } else {
                                                     let objv = new RawView(res);
                                                     objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                     objv.execute();
                                                 }
                                             } else {
                                                 let objv = new RawView(res);
                                                 objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                 objv.execute();
                                             }
                                         });
                                     }
                                 } else {
                                     let Error = JSON.parse(error);
                                     let objv = new RawView(res);
                                     objv.prepare({ status: 502, message: "Something went wrong!", error: Error });
                                     objv.execute();
                                 }
                             });
                         } else {
                             let objv = new RawView(res);
                             objv.prepare({ status: 502, message: "Something went wrong!", error: error });
                             objv.execute();
                         }
                     });
                 }
                 else {
                     let objv = new Res406(res);
                     objv.prepare("No session data there");
                     objv.execute();
                 }
             });
         } else {
             let objv = new RawView(res);
             objv.prepare({ status: 500, message: "DID are required" });
             objv.execute();
         }
     } */
    NetworkOperators(req, res, next) {
        const sdata = req.query;
        if (sdata.DID) {
            let number = sdata.DID;
            console.log("Number::", number);
            console.log("sdata==>" + sdata);
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                console.log("Test:", sessdata);
                if (error == 1) {
                    if (number.length >= 10) {
                        // To check the LRN details
                        let PayLoad = {
                            TO: number
                        };
                        let lerg = new lrnApi_1.LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : number;
                            let num = ToNumber;
                            let did = "" + num + "";
                            let len = did.length - 10;
                            let number1 = did.slice(len, did.length);
                            let npa = number1.slice(0, 3);
                            let nxx = number1.slice(3, 6);
                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`,   `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                            obj1.prepare();
                            obj1.execute((lrn_err, lrn_details) => {
                                if (lrn_err == 1) {
                                    if (lrn_details.length > 0) {
                                        /*let lrn_details2: any = {}
                                        for (const item of Object.entries(lrn_details[0])) {
                                            item[1] = item[0].replace("\r", "").replace("\n", "")
                                            lrn_details2[item[0]] = item[1]
                                        }
                                        lrn_details = [lrn_details2]*/
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 200, message: lrn_details });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                    objv.execute();
                                }
                            });
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 400, message: "Invalid Number! Number should be 10 digit!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    GetMdr(req, res, next) {
        const sdata = req.query;
        console.log("sdata==>" + sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `to_number`,`from_number`,`messsage_body` , `npa`,`state`,`MO_rates`,`MT_rates`,`ocn`,`lata`,`category`, created_at, message_accepted_by_signalmash, message_delivered_to_operator, delivery_receipt_delivered FROM mdr WHERE `iduser` = '" + sessdata.iduser + "' AND `batch_id`='" + sdata.SessionId + "' ORDER BY `created_at` LIMIT 1000";
                obj.prepare();
                obj.execute((mdr_error, result) => {
                    if (mdr_error == 1) {
                        console.log(result);
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, message: "MDR Find successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!", data: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    GetCdr(req, res, next) {
        const sdata = req.query;
        console.log("sdata==>" + sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `caller_id_number`, `dialed_number`,  `direction` ,`hangup_cause`, `start_stamp`, `answer_stamp`, `end_stamp`, `duration`,`billsec`,`npa`,`state`,`invite_failure_phrase`,`ocn`,`lata`,`category` FROM cdr WHERE `iduser` = '" + sessdata.iduser + "' ORDER BY `idcdr` LIMIT 1000";
                obj.prepare();
                obj.execute((cdr_error, result) => {
                    if (cdr_error == 1) {
                        console.log(result);
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, message: "CDR Find successfully!", result: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!", result: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    onAddToCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "INSERT into did_cart (`idaccount`, `iduser`, `did`, `provider`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + rdata.phone_number + "', '" + rdata.provider + "')";
                obj3.execute((cart_error, result) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: cart_error, message: result.sqlMessage });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    addAllToCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let rdata = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into did_cart (`idaccount`,`iduser`, `did`, `provider`) VALUES ";
                rdata.forEach((element) => {
                    tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element.phone_number + "', '" + element.provider + "'),";
                });
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = tmpqurty.slice(0, -1);
                obj3.execute((cart_error, result) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: cart_error, message: result.sqlMessage });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    getCart(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM did_cart where iduser = '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((cart_error, result) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: msg });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteCart(req, res, next) {
        console.log(req.query);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE id_cart = '" + req.query.id + "'";
                obj.prepare();
                obj.execute((cart_error, lastid) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "DID removed Successfully!", data: lastid[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    deleteItems(req, res, next) {
        let qData = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                qData.forEach((el, idx, dids) => {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM did_cart WHERE did = '" + el.did + "'";
                    obj.prepare();
                    obj.execute((error, lastid) => {
                        if (idx == (dids.length - 1)) {
                            let objv = new RawView_1.RawView(res);
                            obj.prepare();
                            objv.prepare({
                                status: 201, message: "Cart Items Removed!", data: lastid
                            });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    clearCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((error1, lastid) => {
                    if (lastid) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "Cart Cleared!", data: lastid[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: error1, message: "Something went wrong" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    verifyDid(req, res, callback) {
        let sdata = req.body;
        let didNumber = sdata.FROM;
        let session = new Session_1.SessionManagment(req, res, () => { });
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                    callback('', 1);
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT * FROM `did_buy` WHERE `did`='" + didNumber + "' AND `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((err, data) => {
                        if (data.length > 0) {
                            callback('', 1);
                        }
                        else {
                            callback('', -1);
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    countDays(req, res, did, callback) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT created_at FROM `did_buy` WHERE `did`='" + did + "'";
        obj.prepare();
        obj.execute((err, did_days) => {
            let TotalDays;
            if (did_days.length > 0) {
                let did_buy_date = did_days[0].created_at;
                let today_date = new Date();
                const oneDay = 1000 * 60 * 60 * 24;
                const diffInTime = today_date.getTime() - did_buy_date.getTime();
                TotalDays = Math.round(diffInTime / oneDay);
                console.log("Remaining days::", TotalDays);
                callback('', TotalDays);
            }
            else {
                callback("Data Not Found", 0);
            }
        });
    }
    onGetDIDs(req, res, next) {
        let sdata = [];
        sdata = req.query;
        let iduser = sdata.selectedUser.split("-")[0];
        let idaccount = sdata.selectedUser.split("-")[1];
        let condition = "";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // for Admin account
                if (sessdata.type == 1) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS || sdata.selectedUser || sdata.connectionKey || sdata.campaignKey || (sdata.fromDate && sdata.toDate)) {
                        if (sdata.selectedUser) {
                            condition += 'd.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                        }
                        if (sdata.selectSMS == 'enabled') {
                            //condition += "(d.`osr_status`='register' AND d.`sinch_status`=1 AND (d.`camp_registry`!='' AND d.`camp_registry` != 'undefined')) AND ";
                            condition += "d.`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            //condition += "(d.`osr_status`!='register' AND d.`sinch_status`!=1 AND (d.`camp_registry`='' OR d.`camp_registry` = 'undefined')) AND ";
                            condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                        }
                        if (sdata.didnpa) {
                            condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        if (sdata.selectState) {
                            condition += 'd.`state`="' + sdata.selectState + '" AND ';
                        }
                        if (sdata.connectionKey) {
                            condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                        }
                        if (sdata.campaignKey) {
                            condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                        }
                        if (sdata.fromDate && sdata.toDate) {
                            condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                        }
                        obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                    else {
                        obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName,DATE_FORMAT(d.`created_at`, '%d %b,%Y %h:%i %p') `created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                }
                //for sub customer account
                else if (sessdata.type == 22) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS || sdata.connectionKey || sdata.campaignKey || (sdata.fromDate && sdata.toDate)) {
                        if (sdata.selectSMS == 'enabled') {
                            //condition += "(d.`osr_status`='register' AND d.`sinch_status`=1 AND (d.`camp_registry`!='' AND d.`camp_registry` != 'undefined')) AND ";
                            condition += "d.`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            //condition += "(d.`osr_status`!='register' AND d.`sinch_status`!=1 AND (d.`camp_registry`='' OR d.`camp_registry` = 'undefined')) AND ";
                            condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                        }
                        if (sdata.didnpa) {
                            condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        //if (sdata.selectState && !(sdata.didnumber && sdata.didnpa)) {
                        if (sdata.selectState) {
                            condition += 'd.`state`="' + sdata.selectState + '" AND ';
                        }
                        if (sdata.connectionKey) {
                            condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                        }
                        if (sdata.campaignKey) {
                            condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                        }
                        if (sdata.fromDate && sdata.toDate) {
                            condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                        }
                        condition += 'd.`iduser`="' + sessdata.iduser + '" AND ';
                        obj2.qrysql = "SELECT d.iddid,d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                    else {
                        obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName,DATE_FORMAT(d.`created_at`, '%d %b,%Y %h:%i %p') `created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE disconnect_did_status = '1' AND d.iduser = '" + sessdata.iduser + "' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                }
                // for customer account
                else {
                    if (sdata.selectSMS == 'enabled') {
                        // condition += "d.`osr_status`='register' AND d.`sinch_status`=1 AND d.`camp_registry`!='' AND d.`camp_registry` != 'undefined' AND ";
                        condition += "d.`sinch_status`='1' AND ";
                    }
                    if (sdata.selectSMS == 'disabled') {
                        //condition += "d.`osr_status`!='register' AND d.`sinch_status`!=1 AND d.`camp_registry`='' OR d.`camp_registry` = 'undefined' AND ";
                        condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                    }
                    if (sdata.didnpa) {
                        condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                    }
                    if (sdata.didnumber) {
                        condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                    }
                    if (sdata.selectState) {
                        condition += 'd.`state`="' + sdata.selectState + '" AND ';
                    }
                    if (sdata.connectionKey) {
                        condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                    }
                    if (sdata.campaignKey) {
                        condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                    }
                    if (sdata.fromDate && sdata.toDate) {
                        condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                    }
                    obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000;";
                }
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    onExportDID(req, res, next) {
        let sdata = req.body.data;
        let condition = "";
        let idaccount = sdata.selectedUser.split("-")[1];
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // for Admin account
                if (sessdata.type == 1) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS || sdata.selectedUser) {
                        if (sdata.selectedUser) {
                            condition += '`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                        }
                        if (sdata.selectSMS == 'enabled') {
                            //condition += "`osr_status`='register' AND `sinch_status`=1 AND `camp_registry`!='' AND `camp_registry` != 'undefined' AND ";
                            condition += "`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            //condition += "`osr_status`!='register' AND `sinch_status`!=1 AND (`camp_registry`='' OR `camp_registry` = 'undefined') AND ";
                            condition += "(`sinch_status` !='1' OR `sinch_status` IS NULL OR `sinch_status`='' OR `sinch_status` ='0') AND ";
                        }
                        if (sdata.didnpa) {
                            condition += '`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += '`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        if (sdata.selectState) {
                            condition += '`state`="' + sdata.selectState + '" AND ';
                        }
                        obj2.qrysql = "SELECT REPLACE(REPLACE(did, CHAR(10),''), CHAR(13),'') AS did, npa, nxx, state, ratecenter,  DATE_FORMAT(`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy` WHERE disconnect_did_status = '1' AND " + condition + " disconnect_did_status = '1';";
                    }
                    else {
                        obj2.qrysql = "SELECT REPLACE(REPLACE(did, CHAR(10),''), CHAR(13),'') AS did, npa, nxx, state, ratecenter,  DATE_FORMAT(`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy` WHERE disconnect_did_status = '1'";
                    }
                }
                else if (sessdata.type == 22) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS) {
                        if (sdata.selectSMS == 'enabled') {
                            condition += "`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            condition += "(`sinch_status` !='1' OR `sinch_status` IS NULL OR `sinch_status`='' OR `sinch_status` ='0') AND ";
                        }
                        if (sdata.didnpa) {
                            condition += '`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += '`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        if (sdata.selectState) {
                            condition += '`state`="' + sdata.selectState + '" AND ';
                        }
                        condition += ' `iduser`="' + sessdata.iduser + '" AND ';
                        obj2.qrysql = "SELECT REPLACE(REPLACE(did, CHAR(10),''), CHAR(13),'') AS did, npa, nxx, state, ratecenter,  DATE_FORMAT(`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy` WHERE disconnect_did_status = '1' AND " + condition + " disconnect_did_status = '1';";
                    }
                    else {
                        obj2.qrysql = "SELECT REPLACE(REPLACE(did, CHAR(10),''), CHAR(13),'') AS did, npa, nxx, state, ratecenter,  DATE_FORMAT(`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy` WHERE disconnect_did_status = '1' AND iduser = '" + sessdata.iduser + "'";
                    }
                }
                else {
                    if (sdata.selectSMS == 'enabled') {
                        //condition += "`osr_status`='register' AND `sinch_status`=1 AND `camp_registry`!='' AND `camp_registry` != 'undefined' AND ";
                        condition += "`sinch_status`='1' AND ";
                    }
                    if (sdata.selectSMS == 'disabled') {
                        //condition += "`osr_status`!='register' AND `sinch_status`!=1 AND `camp_registry`='' OR `camp_registry` = 'undefined' AND ";
                        condition += "(`sinch_status` !='1' OR `sinch_status` IS NULL OR `sinch_status`='' OR `sinch_status` ='0') AND ";
                    }
                    if (sdata.didnpa) {
                        condition += '`npa`="' + sdata.didnpa + '" AND ';
                    }
                    if (sdata.didnumber) {
                        condition += '`did` LIKE "%' + sdata.didnumber + '%" AND ';
                    }
                    if (sdata.selectState) {
                        condition += '`state`="' + sdata.selectState + '" AND ';
                    }
                    obj2.qrysql = "SELECT REPLACE(REPLACE(did, CHAR(10),''), CHAR(13),'') AS did, npa, nxx, state, ratecenter,  DATE_FORMAT(`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy` WHERE disconnect_did_status = '1' AND " + condition + " `iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "')";
                }
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Expoting!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    onExportOrderDID(req, res, next) {
        let sdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT DISTINCT REPLACE(REPLACE(dd.did, CHAR(10),''), CHAR(13),'') AS did,SUBSTRING(dd.did,'1','3')`npa`,SUBSTRING(dd.did,'4','3')`nxx`,IFNULL(d.state,'')`state`,IFNULL(d.ratecenter,'')`ratecenter`, DATE_FORMAT(dg.`date`, '%Y-%m-%d') date,IF(IFNULL(d.did,'')='','Failed','Success')AS OrderStatus FROM `did_group_order` dg INNER JOIN `did_order` dd ON dg.id_grouporder=dd.id_grouporder LEFT JOIN `did_buy` d ON dd.did=d.did WHERE  dg.id_grouporder='" + sdata.group_id + "' AND dg.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "')";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Exported Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Export!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    customerDidsCount(req, res, next) {
        let sdata = [];
        sdata = req.query;
        let iduser = sdata.selectedUser.split("-")[0];
        let idaccount = sdata.selectedUser.split("-")[1];
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // for customer account
                obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + idaccount + "') AND disconnect_did_status = '1'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    DidLocationInfo(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM did_location_info";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, data: result, message: "Did Location fatched successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // updateDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj2 = new ModelRawQuery(req, res);
    //             let rdata = [];
    //             rdata = req.body.data;
    //             obj2.filter = null;
    //             var cols = "";
    //             if (rdata.connection_key != "" || rdata.outboundKey != undefined) {
    //                 cols += "`connection_key`='" + rdata.connection_key + "',";
    //             }
    //             if (rdata.inboundKey != "" || rdata.outboundKey != undefined) {
    //                 cols += "`inbound_key`='" + rdata.inboundKey + "',";
    //             }
    //             if (rdata.outboundKey != "" || rdata.outboundKey != undefined) {
    //                 cols += "`outbound_key`='" + rdata.outboundKey + "',";
    //             }
    //             if (rdata.campaign != "" || rdata.outboundKey != undefined) {
    //                 cols += "`camp_registry`='" + rdata.campaign + "',";
    //             }
    //             cols = cols.substring(0, cols.length - 1);
    //             obj2.qrysql = "UPDATE `did_buy` SET " + cols + " WHERE `iddid`= '" + rdata.iddid + "'";
    //             obj2.prepare();
    //             obj2.execute((error: any, data: any) => {
    //                 let objv = new RawView(res)
    //                 obj2.prepare();
    //                 objv.prepare({
    //                     status: 201,
    //                     error: 0,
    //                     data: data,
    //                     message: "DID Updated Successfully!"
    //                 })
    //                 objv.execute();
    //             });
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }
    updateDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = req.body.data;
                let connection_key;
                let inboundKey;
                let outboundKey;
                if (rdata.connection_key) {
                    connection_key = rdata.connection_key;
                }
                else {
                    connection_key = '';
                }
                if (rdata.inboundKey) {
                    inboundKey = rdata.inboundKey;
                }
                else {
                    inboundKey = '';
                }
                if (rdata.outboundKey) {
                    outboundKey = rdata.outboundKey;
                }
                else {
                    outboundKey = '';
                }
                obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `iddid`= '" + rdata.iddid + "'";
                obj2.prepare();
                obj2.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    obj2.prepare();
                    objv.prepare({ status: 201, error: 0, data: data, message: "DID Updated Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    didEnableDisable(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = req.body.data;
                let isEnable = rdata.isEnable == 'Enabled' ? true : false;
                obj2.nonqrysql = "UPDATE `did_buy` SET `subscription_auto_renew`='" + isEnable + "' WHERE `iddid`= '" + rdata.iddid + "'";
                obj2.prepare();
                obj2.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    obj2.prepare();
                    objv.prepare({ status: 201, error: 0, data: data, message: "DID Successfully " + rdata.isEnable + "!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data available!");
                objv.execute();
            }
        });
    }
    updateSelectedDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((el, idx, dids) => {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let connection_key;
                    let inboundKey;
                    let outboundKey;
                    if (el.connection_key) {
                        connection_key = el.connection_key;
                    }
                    else {
                        connection_key = '';
                    }
                    if (el.inboundKey) {
                        inboundKey = el.inboundKey;
                    }
                    else {
                        inboundKey = '';
                    }
                    if (el.outboundKey) {
                        outboundKey = el.outboundKey;
                    }
                    else {
                        outboundKey = '';
                    }
                    obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `iddid`= '" + el.iddid + "'";
                    obj2.prepare();
                    obj2.execute((error, data) => {
                        if (idx == (dids.length - 1)) {
                            let objv = new RawView_1.RawView(res);
                            obj2.prepare();
                            objv.prepare({ status: 201, error: 0, data: "update", message: "DID Updated  Successfully!" });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // updateSelectedDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((err: any, sessdata: any) => {
    //         if (err == 1) {
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             rdata.forEach((el: any, idx: any, dids: any) => {
    //                 let obj2 = new ModelRawQuery(req, res);
    //                 var cols = "";
    //                 if (el.connection_key) {
    //                     cols += "`connection_key`='" + el.connection_key + "',";
    //                 }
    //                 if (el.inboundKey) {
    //                     cols += "`inbound_key`='" + el.inboundKey + "',";
    //                 }
    //                 if (el.outboundKey) {
    //                     cols += "`outbound_key`='" + el.outboundKey + "',";
    //                 }
    //                 if (el.campaign) {
    //                     cols += "`camp_registry`='" + el.campaign + "',";
    //                 }
    //                 cols = cols.substring(0, cols.length - 1);
    //                 obj2.qrysql = "UPDATE `did_buy` SET " + cols + " WHERE `iddid`= '" + el.iddid + "'";
    //                 obj2.prepare();
    //                 obj2.execute((error: any, data: any) => {
    //                     if (idx == (dids.length - 1)) {
    //                         let objv = new RawView(res)
    //                         obj2.prepare();
    //                         objv.prepare({
    //                             status: 201,
    //                             error: 0,
    //                             data: "update",
    //                             message: "DID Updated Successfully!"
    //                         })
    //                         objv.execute();
    //                     }
    //                 });
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }
    GetState(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT DISTINCT loc_state FROM did_location_info";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, data: result, message: "State Find successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    GetRateCenter(req, res, next) {
        let sdata = req.query;
        if (sdata.State) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  rc_abbre FROM did_location_info WHERE `loc_state` = '" + req.query.State + "' ORDER BY rc_abbre ASC";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            console.log(result);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, data: result, message: "Rate Center Find successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "State are required" });
            objv.execute();
        }
    }
    GetNPA(req, res, next) {
        let sdata = req.query;
        if (sdata.State) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  npa FROM did_location_info WHERE `loc_state` = '" + req.query.State + "'";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, data: result, message: "NPA Find successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "State are required" });
            objv.execute();
        }
    }
    GetNXX(req, res, next) {
        let sdata = req.query;
        if (sdata.NPA) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  nxx FROM did_location_info WHERE `npa` = '" + req.query.NPA + "'";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            console.log(result);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, data: result, message: "NXX Find successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "NPA are required" });
            objv.execute();
        }
    }
    AddCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "INSERT into did_cart (`idaccount`, `phone_number`, `provider`) VALUES('" + sessdata.idaccount + "', '" + rdata.phone_number + "', '" + rdata.provider + "')";
                obj3.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: error, message: "Something went wrong" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    getStates(req, res, next) {
        let qdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT id,name,abbrev FROM states ORDER BY abbrev ASC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "States Fetched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateConnectionOnDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body;
                obj2.nonqrysql = "UPDATE `did_buy` SET connection_key='" + rdata.ConnectionKey + "' WHERE `did`= '" + rdata.DID + "'";
                obj2.prepare();
                obj2.execute((error1, data) => {
                    if (error1 == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: data, message: "Connection Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: error1, message: "Connection not updated Successfully!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "No session data there" });
                objv.execute();
            }
        });
    }
    /**
     * Other modules
     */
    PurchaseAllDIDs(req, res, next) {
        const sdata = req.body;
        console.log("sdata::", sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (sessdata.type == 2 || sessdata.type == 22) {
                if (error == 1) {
                    let PI = 0;
                    let iQry = "";
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    let objN = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let objv = new RawView_1.RawView(res);
                    // Iterate DID numbers to create the pending orders
                    if (Array.isArray(sdata.DID) && sdata.DID.length > 0) {
                        sdata.DID.forEach((ele) => {
                            iQry += "INSERT INTO `did_order` SET `iduser`=" + sessdata.iduser + ", `idaccount`=" + sessdata.idaccount + ", `did`='" + ele + "', `id_grouporder`=" + sdata.id_grouporder + ", status='102';\n";
                            PI++;
                        });
                    }
                    if (PI > 0) {
                        objN.nonqrysql = iQry;
                        objN.prepare();
                        objN.execute((error, result) => {
                            console.log("Order preparing::\n", result);
                            if (error == 1) {
                                // To delete the selected DID from cart
                                iQry = "DELETE FROM did_cart WHERE did IN(" + sdata.DID + ");";
                                objN.nonqrysql = iQry;
                                objN.prepare();
                                objN.execute((error, result) => {
                                    objv.prepare({
                                        error: 0,
                                        status: 200,
                                        message: "DIDs successfully processed for bulk order purchase."
                                    });
                                    objv.execute();
                                });
                                // let __exeCommand: string = "/opt/lampp/bin/php /home/sanee/projects/signalmash/trunk/php/BulkDIDPurchase.php " + sdata.id_grouporder
                                // console.log("execution:: ", __exeCommand)
                                // let objexec = new Exec()
                                // objexec.execute(__exeCommand, (result: any) => {
                                //     console.log("CMD execution results::", result)
                                // })
                            }
                            else {
                                objv.prepare({
                                    error: 1,
                                    status: 400,
                                    message: "DIDs did not processed for bulk order purchase!"
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 1,
                            status: 500,
                            message: "There are no DIDs in cart!"
                        });
                        objv.execute();
                    }
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 404, message: "Not Permitted" });
                objv.execute();
            }
        });
    }
    /**
     * To create the group of did orders
     */
    CreateGroupOrder(req, res, next) {
        const sdata = req.body.data;
        console.log("sdata::", sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let process_dids = sdata.total_dids <= 10 ? sdata.total_dids : 0;
                    obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + sdata.name + "', total_dids=" + sdata.total_dids + ", process_dids=" + process_dids + ", numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "', campaign='" + sdata.campaign + "';";
                    obj.prepare();
                    obj.execute((error, result) => {
                        let objv = new RawView_1.RawView(res);
                        if (error == 1) {
                            objv.prepare({
                                error: 0,
                                status: 200,
                                message: "Group successfully created.",
                                data: {
                                    id_grouporder: result.insertId
                                }
                            });
                            objv.execute();
                        }
                        else {
                            objv.prepare({
                                error: 1,
                                status: 502,
                                message: "Something went wrong with connection!"
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    /**
     * To get the customer's DID list for sms test
     */
    getSMSTextDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `did` FROM `did_buy` WHERE `iduser` = '" + sessData.iduser + "' AND `sinch_status` = '1' AND `disconnect_did_status` = '1'";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'DID Fatched', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /**
     * To get the orders history
     */
    GetOrdersHistory(req, res, next) {
        let sdata = [];
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let objv = new RawView_1.RawView(res);
                obj2.qrysql = "SELECT `id_grouporder`, `name`, total_dids, process_dids, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `date` FROM `did_group_order` WHERE iduser=" + sessdata.iduser + " ORDER BY id_grouporder DESC;";
                obj2.prepare();
                obj2.execute((error, result) => {
                    if (error == 1) {
                        let Result = result ? result : [];
                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: Result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "No data found!",
                            data: []
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    /**
     * To view the order history
     */
    ViewOrderHistory(req, res, next) {
        let sdata = [];
        sdata = req.query;
        console.log("QRY::", sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let objv = new RawView_1.RawView(res);
                let iQry = "SELECT *, CASE WHEN is_process=0 THEN 'In Process' WHEN error_code=2 THEN 'Completed' WHEN error_code=4 THEN 'Failed' ELSE 'N/A' END order_status, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `created_date` FROM `did_order`\n";
                iQry += "WHERE iduser=" + sessdata.iduser + " AND id_grouporder=" + sdata.id_grouporder + " ORDER BY id_order DESC;";
                obj2.qrysql = iQry;
                obj2.prepare();
                obj2.execute((error, result) => {
                    if (error == 1) {
                        let Result = result ? result : [];
                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: Result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "No data found!",
                            data: []
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    getDisconnectedDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // for Admin account
                if (sessdata.type == 1) {
                    obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key WHERE disconnect_did_status = '2'";
                }
                //for sub customer account
                else if (sessdata.type == 22) {
                    obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key WHERE disconnect_did_status = '2' AND d.iduser = '" + sessdata.iduser + "'";
                }
                // for customer account
                else {
                    obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key WHERE  d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND disconnect_did_status = '2'";
                }
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Disconnected DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    // getDisconnectedDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "SELECT * FROM `did_buy` WHERE `iduser` = '" + sessData.iduser + "' AND `disconnect_did_status` = '2'";
    //             obj.prepare();
    //             obj.execute((err: any, result: any) => {
    //                 if (err == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: 'DID Fatched', data: result, status: 200 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
    //                     objv.execute();
    //                 }
    //             })
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Authorization!", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    restoreDisconnectDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let sdata = req.body.data;
                    let count = 0;
                    sdata.forEach((el, idx, dids) => {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE  `did_buy` SET disconnect_did_status='1' WHERE disconnect_did_status='2' AND `did`='" + el.did + "'";
                        obj.prepare();
                        obj.execute((err, result) => {
                            if (err == 1) {
                                count++;
                                console.log("Count ::" + count);
                                if (count == sdata.length) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: 'DID Restored Successfully!', status: 200 });
                                    objv.execute();
                                }
                            }
                        });
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getSmsProvider(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT p.`priority`, u.`username` as `sms_provider` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sdata.type + "') AND p.type='sms'";
                obj1.prepare();
                obj1.execute((error, responce) => {
                    console.log('sdata.type', sdata.type);
                    console.log("responce", responce);
                    if (error == 1) {
                        if (responce.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, message: "Provider fetched successfully", data: responce });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: "No provider found" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new _404_1.Res404(res);
                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}
exports.Number = Number;
/**
 * Other class
 */
class DIDManager {
    constructor() { }
    /**
     * To create the group order for single DID
     */
    CreateGroupOrder(req, res, sessdata, data, callback) {
        const sdata = data;
        if (sdata.via_panel == 0) {
            let oname = "SOD" + String(new Date().getTime());
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + oname + "', total_dids=1, process_dids=1, numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "', campaign='" + sdata.campaign + "';";
            obj.prepare();
            obj.execute((error, result) => {
                let objv = new RawView_1.RawView(res);
                if (error == 1) {
                    callback(1, {
                        id_grouporder: result.insertId
                    });
                }
                else {
                    callback(1, {
                        id_grouporder: 0
                    });
                }
            });
        }
        else {
            let id_grouporder = (typeof req.body.id_grouporder != 'undefined' && req.body.id_grouporder > 0) ? req.body.id_grouporder : 0;
            callback(1, {
                id_grouporder: id_grouporder
            });
        }
    }
}
exports.DIDManager = DIDManager;
