"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeApi = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _404_1 = require("../lib/view/404");
const stripepay = require("stripe");
const AppRoute_1 = require("../lib/AppRoute");
const secret_key = "sk_test_51HAL9TGdXmhCeqBzWbxBTiVUDlCqizGP8NWwxDC8zIRKuef4i9kerhyixCqVZPw5Ik3fmfUe7BR2Wy2cUqrOZdWx00IQ2MEmbO";
//    const secret_key = "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";
class StripeApi extends AppRoute_1.AppRoute {
    constructor() {
        super();
    }
    RechargeByAdmin(req, res, next) {
        let sdata = req.body;
        let CRate = typeof sdata.amount != 'undefined' && sdata.amount > 0 ? sdata.amount : 0;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (CRate > 0) {
                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`=" + sdata.idaccount;
                    obj2.prepare();
                    obj2.execute((_error, customer) => {
                        if (_error == 1) {
                            if (customer.length > 0) {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                if (sdata.paymentType == "3") {
                                    obj.nonqrysql = "UPDATE wallet SET `balance`=`balance`-" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                }
                                else {
                                    obj.nonqrysql = "UPDATE wallet SET `balance`=`balance`+" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                }
                                obj.prepare();
                                obj.execute((werror, _result) => {
                                    if (werror == 1) {
                                        let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                        iQry += "`idaccount`=" + sdata.idaccount + ", ";
                                        if (sdata.paymentType == "3") {
                                            iQry += "`amount`='-" + CRate + "', ";
                                        }
                                        else {
                                            iQry += "`amount`='+" + CRate + "', ";
                                        }
                                        iQry += "`purpose`='Wallet successfully recharged by Admin', ";
                                        iQry += "`description`='" + sdata.description + "', ";
                                        iQry += "`payment_type`='" + sdata.paymentType + "', ";
                                        iQry += "`status`=1;";
                                        let pType = "Direct";
                                        if (sdata.paymentType == 1) {
                                            pType = "Portal Payment";
                                        }
                                        else if (sdata.paymentType == 2) {
                                            pType = "Manual Credit";
                                        }
                                        else if (sdata.paymentType == 3) {
                                            pType = "Manual Debit";
                                        }
                                        else if (sdata.paymentType == 4) {
                                            pType = "Bank Payment";
                                        }
                                        else if (sdata.paymentType == 5) {
                                            pType = "Credit Card Payment";
                                        }
                                        let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        objWL.nonqrysql = iQry;
                                        objWL.prepare();
                                        objWL.execute((error, result) => {
                                            console.log("Transaction response::", result);
                                        });
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `amount`, `created`, `description`, `type`) VALUE('" + sdata.idaccount + "', '" + sdata.email + "', '" + sdata.amount + "', '" + sdata.currentDateTime + "', '" + sdata.description + "', '" + pType + "')";
                                        obj1.prepare();
                                        obj1.execute((__error, result) => {
                                            if (__error == 1) {
                                                let objv1 = new RawView_1.RawView(res);
                                                let message;
                                                if (sdata.paymentType == "4") {
                                                    message = "Balance Deduct Successfully!";
                                                }
                                                else {
                                                    message = "Balance Added Successfully!";
                                                }
                                                objv1.prepare({ data: result, message: message, status: 201 });
                                                objv1.execute();
                                            }
                                            else {
                                                let objv1 = new RawView_1.RawView(res);
                                                objv1.prepare({ message: "Balance Added Error With Log!", status: 502, error: result });
                                                objv1.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv1 = new RawView_1.RawView(res);
                                        objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: _result });
                                        objv1.execute();
                                    }
                                });
                            }
                            else {
                                let objv1 = new RawView_1.RawView(res);
                                objv1.prepare({ message: "Customer Detail Not Found!", error: customer, status: 502 });
                                objv1.execute();
                            }
                        }
                        else {
                            let objv1 = new RawView_1.RawView(res);
                            objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv1.execute();
                        }
                    });
                }
                else {
                    let objv1 = new RawView_1.RawView(res);
                    objv1.prepare({
                        message: "Balance amount should be greater then 0!",
                        status: 502,
                        error: ""
                    });
                    objv1.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Auth Key!", status: 401 });
                objv.execute();
            }
        });
    }
    getBalance(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                //obj.qrysql = "SELECT * FROM `wallet` WHERE idaccount=" + sessdata.idaccount;
                obj.qrysql = "SELECT `idwallet`,`balance`,`min_balance`,`topup_amount`,`webhook_url`,`credit_limit`,`status`,`isEmail`,`isWebhook` FROM `wallet` WHERE idaccount=" + sessdata.idaccount;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getcustBalance(req, res, next) {
        let sdata = req.query;
        // console.log('sdata',sdata);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `wallet` WHERE idaccount=" + sdata.idaccount;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    addBalance(req, res, next) {
        let spdata = JSON.parse(req.body.data);
        let stipedata = spdata.pdata;
        let stripeToken = spdata.token;
        const stripe = stripepay(secret_key);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((__error, sessdata) => {
            if (__error == 1) {
                stripe.customers.create({
                    email: stripeToken.email,
                    source: stripeToken.id,
                    metadata: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        contact: stipedata.contact,
                        city: stipedata.city
                    },
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    },
                    address: {
                        line1: stipedata.address1,
                        city: stipedata.city,
                        country: stipedata.country,
                        state: stipedata.state,
                        postal_code: stipedata.postal_code
                    }
                }, (err, customer) => {
                    if (err) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
                        objv.execute();
                    }
                    else {
                        stripe.charges.create({
                            customer: customer.id,
                            amount: stipedata.amount * 100,
                            currency: 'USD',
                            description: 'Live Mode',
                            shipping: {
                                name: stipedata.first_name + " " + stipedata.last_name,
                                phone: stipedata.contact,
                                address: {
                                    line1: stipedata.address1,
                                    city: stipedata.city,
                                    country: stipedata.country,
                                    state: stipedata.state,
                                    postal_code: stipedata.postal_code
                                }
                            }
                        }, (err, charge) => {
                            if (err) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Wrong Billing Information!", status: 404 });
                                objv.execute();
                            }
                            else {
                                let obj10 = new RawQuery_1.ModelRawQuery(req, res);
                                obj10.qrysql = "SELECT * FROM `wallet` WHERE idaccount='" + sessdata.idaccount + "'";
                                obj10.prepare();
                                obj10.execute((__werror, __wresult) => {
                                    if (__werror == 1) {
                                        if (__wresult.length > 0) {
                                            if (__wresult[0].customer_id) {
                                                const amount = stipedata.amount;
                                                let CAmount = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0;
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CAmount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                obj1.prepare();
                                                obj1.execute((__error, __result) => {
                                                    if (__error == 1) {
                                                        let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", ";
                                                        iQry += "`amount`='+" + CAmount + "', ";
                                                        iQry += "`purpose`='Wallet successfully recharged by customer', ";
                                                        iQry += "`status`=1;";
                                                        let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry;
                                                        objWL.prepare();
                                                        objWL.execute((error, result) => {
                                                            console.log("Transaction response::", result);
                                                        });
                                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`,`charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stripeToken.email + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                                        obj2.prepare();
                                                        obj2.execute((___error, result) => {
                                                            if (___error == 1) {
                                                                let key = stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4;
                                                                let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                                obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key`= '" + key + "'";
                                                                obj3.prepare();
                                                                obj3.execute((____error, stripeCard) => {
                                                                    if (____error == 1) {
                                                                        if (stripeCard.length > 0) {
                                                                            let objv1 = new RawView_1.RawView(res);
                                                                            objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                            objv1.execute();
                                                                        }
                                                                        else {
                                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'false')";
                                                                            obj4.prepare();
                                                                            obj4.execute((__werror, ___result) => {
                                                                                if (__werror == 1) {
                                                                                    let objv1 = new RawView_1.RawView(res);
                                                                                    objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                    objv1.execute();
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                    }
                                                                    else {
                                                                        let objv1 = new RawView_1.RawView(res);
                                                                        objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                        objv1.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: __result });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                const amount = stipedata.amount;
                                                let CAmount = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0;
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CAmount + ", `customer_id`='" + charge.customer + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                obj1.prepare();
                                                obj1.execute((__error, __result) => {
                                                    if (__error == 1) {
                                                        let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", ";
                                                        iQry += "`amount`='+" + CAmount + "', ";
                                                        iQry += "`purpose`='Wallet successfully recharged by customer', ";
                                                        iQry += "`status`=1;";
                                                        let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry;
                                                        objWL.prepare();
                                                        objWL.execute((error, result) => {
                                                            console.log("Transaction response::", result);
                                                        });
                                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stripeToken.email + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                                        obj2.prepare();
                                                        obj2.execute((___error, result) => {
                                                            if (___error == 1) {
                                                                let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                                obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key` = '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "'";
                                                                obj3.prepare();
                                                                obj3.execute((____error, stripeCard) => {
                                                                    if (____error == 1) {
                                                                        if (stripeCard.length > 0) {
                                                                            let objv1 = new RawView_1.RawView(res);
                                                                            objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                            objv1.execute();
                                                                        }
                                                                        else {
                                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";
                                                                            obj4.prepare();
                                                                            obj4.execute((__werror, ___result) => {
                                                                                if (__werror == 1) {
                                                                                    let objv1 = new RawView_1.RawView(res);
                                                                                    objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                    objv1.execute();
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                    }
                                                                    else {
                                                                        let objv1 = new RawView_1.RawView(res);
                                                                        objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                        objv1.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: __result });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                        else {
                                            const amount = stipedata.amount;
                                            let CAmount = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0;
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `wallet` (`idaccount`, `balance`, `customer_id`) VALUES('" + sessdata.idaccount + "', '" + CAmount + "', '" + charge.customer + "')";
                                            obj1.prepare();
                                            obj1.execute((__error, __result) => {
                                                if (__error == 1) {
                                                    let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", ";
                                                    iQry += "`amount`='+" + CAmount + "', ";
                                                    iQry += "`purpose`='Wallet successfully recharged by customer', ";
                                                    iQry += "`status`=1;";
                                                    let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry;
                                                    objWL.prepare();
                                                    objWL.execute((error, result) => {
                                                        console.log("Transaction response::", result);
                                                    });
                                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stripeToken.email + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                                    obj2.prepare();
                                                    obj2.execute((___error, result) => {
                                                        if (___error == 1) {
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";
                                                            obj4.prepare();
                                                            obj4.execute((__werror, ___result) => {
                                                                if (__werror == 1) {
                                                                    let objv1 = new RawView_1.RawView(res);
                                                                    objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                    objv1.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: __result });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 404 });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    updateBalance(req, res, next) {
        let spdata = JSON.parse(req.body.data);
        let stipedata = spdata.pdata;
        const stripe = stripepay(secret_key);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                stripe.charges.create({
                    customer: stipedata.customer_id,
                    amount: stipedata.amount * 100,
                    currency: 'USD',
                    description: 'Live Mode',
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }
                }, (err, charge) => {
                    if (err) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
                        objv.execute();
                    }
                    else {
                        const amount = charge.amount / 100;
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE wallet SET `balance`= `balance`+ " + stipedata.amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                        obj.prepare();
                        obj.execute((_error, wallet) => {
                            if (_error == 1) {
                                let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                iQry += "`idaccount`=" + sessdata.idaccount + ", ";
                                iQry += "`amount`='+" + amount + "', ";
                                iQry += "`purpose`='Wallet amount successfully updated by customer', ";
                                iQry += "`status`=1;";
                                let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                objWL.nonqrysql = iQry;
                                objWL.prepare();
                                objWL.execute((error, result) => {
                                    console.log("Transaction response::", result);
                                });
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stipedata.email + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                obj.prepare();
                                obj.execute((serror, result) => {
                                    if (serror == 1) {
                                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount;
                                        obj1.prepare();
                                        obj1.execute((____error, _result) => {
                                            if (____error == 1) {
                                                let objv1 = new RawView_1.RawView(res);
                                                objv1.prepare({ data: _result, message: "Balance Updated Successfully!", status: 201 });
                                                objv1.execute();
                                            }
                                            else {
                                                let objv1 = new RawView_1.RawView(res);
                                                objv1.prepare({ message: "Balance Updated Error With Connection!", status: 502, error: _result });
                                                objv1.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Balance Updated Error With Connection!", err: error, status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Error With Updating Balance!", err: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    updatePaymentSetting(req, res, next) {
        let spdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let str = '';
                if (spdata.isAutoPayment === "true" || spdata.isAutoPayment === "false") {
                    obj2.nonqrysql = "UPDATE `wallet` SET `status`='" + spdata.isAutoPayment + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Setting Changed!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else if (spdata.isAutoEmail === "true" || spdata.isAutoEmail === "false") {
                    obj2.nonqrysql = "UPDATE `wallet` SET `isEmail`='" + spdata.isAutoEmail + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Setting Changed!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else if (spdata.isAutowebhook === "true" || spdata.isAutowebhook === "false") {
                    obj2.nonqrysql = "UPDATE `wallet` SET `isWebhook`='" + spdata.isAutowebhook + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Setting Changed!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else if (spdata.defaultamt || spdata.topup_amount || spdata.webhook_url) {
                    obj2.nonqrysql = "UPDATE `wallet` SET `min_balance`='" + spdata.defaultamt + "', `topup_amount`='" + spdata.topup_amount + "', `webhook_url` = '" + spdata.webhook_url + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((upError, result) => {
                        if (upError == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Payment Setting Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new _404_1.Res404(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    paymentHistory(req, res, next) {
        let sdata = req.query;
        console.log(sdata);
        let condition = "";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                if (sessdata.type == 1) {
                    if (sdata.selectedUser || (sdata.toDate && sdata.fromDate)) {
                        if (sdata.fromDate && sdata.toDate && !sdata.selectedUser) {
                            condition += 's.`timestamp` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                        }
                        if (sdata.selectedUser && !(sdata.toDate && sdata.fromDate)) {
                            condition += 's.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        if (sdata.selectedUser && sdata.fromDate && sdata.toDate) {
                            condition += 's.timestamp BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND s.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id`, `balance_transaction`,  s.`status`, s.`created` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  left JOIN `account`acc ON acc.idaccount=b.account_id WHERE " + condition + " GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                    else {
                        obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status`, s.`created` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  LEFT JOIN `account`acc ON acc.idaccount=b.account_id GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                }
                else {
                    obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status`, s.`created` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  LEFT JOIN `account`acc ON acc.idaccount=b.account_id WHERE s.idaccount='" + sessdata.idaccount + "'GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                }
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Payment History Fetched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCards(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((serr, sessdata) => {
            if (serr == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result == null || result.length < 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCardForAddBalance(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((serr, sessdata) => {
            if (serr == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'AND `default`='true'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result == null || result.length < 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            const stripe = stripepay(secret_key);
                            stripe.paymentMethods.list({
                                customer: result[0].customer_id,
                                type: 'card',
                            }, (_err, success) => {
                                if (!_err) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Card Details Fetched Succesfully!", data: success, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    createCustomerCard(req, res, next) {
        let token = req.body.token;
        const stripe = stripepay(secret_key);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT  u.iduser, u.idaccount,  u.username, u.password, up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser='" + sessdata.iduser + "'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        console.log(result);
                        stripe.customers.create({
                            email: token.email,
                            name: token.card.name,
                            source: token.id,
                            address: {
                                line1: token.card.address_line1,
                                city: token.card.address_city,
                                country: token.card.country,
                                state: token.card.address_state,
                                postal_code: token.card.address_zip
                            },
                            metadata: {
                                name: token.card.name,
                                contact: result[0].phone,
                                city: token.card.address_city
                            },
                            // metadata: {
                            //     name: result[0].firstname + " " + result[0].lastname,
                            //     contact: result[0].phone,
                            //     city: result[0].city
                            // },
                            shipping: {
                                name: token.card.name,
                                phone: result[0].contact,
                                address: {
                                    line1: token.card.address_line1,
                                    city: token.card.address_city,
                                    country: token.card.country,
                                    state: token.card.address_state,
                                    postal_code: token.card.address_zip
                                }
                            },
                            // shipping: {
                            //     name: result[0].firstname + " " + result[0].lastname,
                            //     phone: result[0].contact,
                            //     address: {
                            //         line1: result[0].address1,
                            //         city: result[0].city,
                            //         country: result[0].country,
                            //         state: result[0].state,
                            //         postal_code: result[0].postal_code
                            //     }
                            // },
                        }, (err, customer) => {
                            if (!err) {
                                let obj10 = new RawQuery_1.ModelRawQuery(req, res);
                                obj10.qrysql = "SELECT * FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                                obj10.prepare();
                                obj10.execute((_werror, __result) => {
                                    if (_werror == 1) {
                                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key` = '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "'";
                                        obj3.prepare();
                                        obj3.execute((____error, stripeCard) => {
                                            if (____error == 1) {
                                                if (stripeCard.length > 0) {
                                                    let objv1 = new RawView_1.RawView(res);
                                                    objv1.prepare({ data: result, message: "This Card Already Saved!", status: 401 });
                                                    objv1.execute();
                                                }
                                                else {
                                                    var defaultCard;
                                                    if (__result.length > 0) {
                                                        if (__result[0].customer_id) {
                                                            defaultCard = 'false';
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                            obj1.prepare();
                                                            obj1.execute((__werror, ___result) => {
                                                                if (__werror == 1) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            defaultCard = 'true';
                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                            obj.prepare();
                                                            obj.execute((werror, _result) => {
                                                                if (werror == 1) {
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                    obj1.prepare();
                                                                    obj1.execute((__werror, ___result) => {
                                                                        if (__werror == 1) {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                    }
                                                    else {
                                                        let objv1 = new RawView_1.RawView(res);
                                                        objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                        objv1.execute();
                                                    }
                                                }
                                            }
                                            else {
                                                let objv1 = new RawView_1.RawView(res);
                                                objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                                objv1.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Please Update Billing Address!", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    setDfaultCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + req.body.customer_id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_err, result) => {
                    if (_err == 1) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `stripe_card` SET `default`= 'false' WHERE idaccount='" + sessdata.idaccount + "'";
                        obj1.prepare();
                        obj1.execute((___err, wallet) => {
                            if (___err == 1) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `stripe_card` SET `default`= 'true' WHERE customer_id='" + req.body.customer_id + "'";
                                obj1.prepare();
                                obj1.execute((__err, card) => {
                                    if (__err == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Default Card Changed Successfully!", status: 201, data: card });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: card });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: wallet });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    deleteCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `stripe_card` WHERE `customer_id`='" + req.query.customer_id + "'";
                obj.prepare();
                obj.execute((_err, result) => {
                    if (_err == 1) {
                        obj.nonqrysql = "UPDATE `wallet` SET `customer_id`=NULL WHERE `customer_id`='" + req.query.customer_id + "'";
                        obj.prepare();
                        obj.execute((_err, rescard) => { });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
}
exports.StripeApi = StripeApi;
