"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TierManagement = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const ModelPdfUpload_1 = require("../lib/model/ModelPdfUpload");
const AppRoute_1 = require("../lib/AppRoute");
class TierManagement extends AppRoute_1.AppRoute {
    constructor() {
        super();
    }
    // get Tariffs
    getTraiffs(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT tr.* FROM `tariff_seller`ts INNER JOIN `tariff`tr ON ts.idtariff=tr.idtariff WHERE ts.`iduser`='" + sessdata.iduser + "';";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    // Get Tariff Via Type
    // get Tariffs
    getTypesTraiffs(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idaccount` = '" + sessdata.idaccount + "' AND `type`= '" + req.query.type + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    // get Tariffs
    getTraiff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idtariff` = '" + req.query.type + "' ";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: allcamp, message: "Data Fetched Succesfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    // Save Tariff 
    saveTariff(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM tariff where name = '" + rdata.name + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Tariff Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.filter = null;
                        // obj2.qrysql = "INSERT into tariff (`idaccount`,`name`, `description`, `type`) VALUES('"+sessdata.idaccount+"', '" + rdata.name + "', '" + rdata.description + "', '"+rdata.type+"')";
                        obj2.qrysql = "Call AddTariff('" + sessdata.idaccount + "', 'Registered', '" + rdata.name + "', '" + rdata.description + "', '" + rdata.day_num + "')";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: allcamp[0], message: "Tariff Saved Successfully", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                        // });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    updateTariff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let sdata = [];
                sdata = req.body.data;
                obj.nonqrysql = "UPDATE tariff SET name='" + sdata.name + "', description='" + sdata.description + "' WHERE idtariff = '" + sdata.id + "'";
                obj.prepare();
                obj.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "select * from tariff where idaccount = '" + sessdata.idaccount + "'";
                        obj1.prepare();
                        obj1.execute((__error, resResult) => {
                            if (__error == 1) {
                                let objv2 = new RawView_1.RawView(res);
                                objv2.prepare({ message: "Rate Plan Update Successfully!", data: resResult, status: 201 });
                                objv2.execute();
                            }
                            else {
                                let objv2 = new RawView_1.RawView(res);
                                objv2.prepare({ message: "Rate Plan Updated Connection break with fetch data!", data: resResult, status: 502 });
                                objv2.execute();
                            }
                        });
                    }
                    else {
                        let objv2 = new RawView_1.RawView(res);
                        objv2.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv2.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    deleteTariff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from tariff WHERE idtariff = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error, lastid) => {
                if (_error == 10) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Tariff is already mapped to some accounts!", status: 401 });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Tariff Deleted Successfully", data: lastid[0], status: 201 });
                    objv.execute();
                }
            });
        });
    }
    // Save Tariff 
    saveSurcharge(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM surcharge where name = '" + rdata.name + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Surcharge Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.filter = null;
                        obj2.nonqrysql = "INSERT into surcharge (`idaccount`,`name`, `description`) VALUES ('" + sessdata.idaccount + "', '" + rdata.name + "', '" + rdata.description + "')";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: allcamp, message: "Surcharge Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    updateTariffDay(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `tariff` SET `day_num`='" + rdata.day_num + "' WHERE `idtariff` = '" + rdata.idtariff + "'";
                obj2.prepare();
                obj2.execute((errorr, allcamp) => {
                    if (errorr == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "(" + rdata.day_num + ") Days Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Days Not Updated!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateProRate(req, res, next) {
        let spdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (spdata.proration === "true" || spdata.proration === "false") {
                    obj2.nonqrysql = "UPDATE `tariff` SET `proration`='" + spdata.proration + "' WHERE `idtariff` = '" + spdata.idtariff + "'";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Proration Successfully Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Prorate!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Pro-rate!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    // Save Service Profile
    saveServiceProfile(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM service where name = '" + rdata.name + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Service Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.filter = null;
                        obj2.nonqrysql = "INSERT into `service` (`iduser`,`name`, `description`) VALUES ('" + sessdata.iduser + "', '" + rdata.name + "', '" + rdata.description + "')";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: allcamp, message: "Service Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    savePreference(req, res, next) {
        let sdata = {};
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = JSON.parse(req.body.data);
                let tmpqurty = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `description`, `type`) VALUES  ";
                rdata.forEach((element) => {
                    tmpqurty += "('" + sessdata.idaccount + "', '" + element.idservice + "', '" + element.idsupplier + "','" + element.priority + "','" + 'Description' + "', '" + element.type + "'),";
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Preference Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updatePreference(req, res, next) {
        let sdata = {};
        sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                sdata.forEach((result) => {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `type`, `key`) VALUE ('" + sessdata.idaccount + "','" + result.idservice + "', '" + result.idsupplier + "','" + result.priority + "', '" + result.type + "', '" + sessdata.idaccount + "-" + result.idservice + "-" + result.type + "-" + result.priority + "' ) ON DUPLICATE KEY UPDATE `idservice`='" + result.idservice + "', `idsupplier`='" + result.idsupplier + "',`priority`='" + result.priority + "', `key`='" + sessdata.idaccount + "-" + result.idservice + "-" + result.type + "-" + result.priority + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Preference Update Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getPreference(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `preference` WHERE `type` = '" + sdata.type + "' AND `idservice`='" + sdata.idservice + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }
    updatePreferenceService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            let sdata = [];
            sdata = req.body.data;
            obj.nonqrysql = "UPDATE service SET name='" + sdata.name + "', description='" + sdata.description + "' WHERE idservice = '" + sdata.idservice + "'";
            obj.prepare();
            obj.execute((_error, allcamp) => {
                if (allcamp) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "select * from service where iduser = '" + sessdata.iduser + "'";
                    obj1.prepare();
                    obj1.execute((_error, resResult) => {
                        let objv2 = new RawView_1.RawView(res);
                        objv2.prepare({ message: "Service Profile Update Successfully!", data: resResult });
                        objv2.execute();
                    });
                }
                else {
                    let objv2 = new RawView_1.RawView(res);
                    objv2.prepare({ message: "Something Went Wrong!" });
                    objv2.execute();
                }
            });
        });
    }
    getServiceProfiles(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `service` WHERE `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }
    getServiceProfile(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `service` WHERE `idservice`='" + sdata.idservice + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }
    deletePreferenceService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from `service` WHERE `idservice` = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error, lastid) => {
                if (_error == 10) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Profile Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }
    // get Tariff
    getSurcharges(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM `surcharge` where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    getTariffList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM tariff";
                obj.prepare();
                obj.execute((error, data) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Tariff Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    getSingleTraiff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        let trfid = req.query.type;
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idtariff` = '" + trfid + "' AND `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    deleteSurcharge(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from surcharge WHERE idsurcharge = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error, lastid) => {
                if (_error == 10) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Surcharge is already mapped to some Tariff!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Surcharge Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }
    // public SaveRate(req: Request, res: Response, next: NextFunction) {
    //     console.log("Data===>"+req.body.data);
    //     console.log("req.query", req.query);
    //     let sdata: any;
    //     try {
    //         sdata = req.body.data;
    //     } catch (e) {
    //         sdata =  req.body.data;
    //     }
    //     console.log(sdata);
    //     let session = new SessionManagment(req, res, next);
    //     let msg = "";
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "CALL AddBilling('" + sessdata.iduser + "', '"+sdata+"', '20')";
    //             obj.prepare();
    //             obj.execute((error: any, result: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: result[0], message: msg });
    //                 objv.execute();
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    SaveRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error, sessdata) => {
            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
            var result = [];
            obj2.filter = null;
            let rdata = req.body.data;
            rdata.forEach((element) => {
                element.forEach((ele) => {
                    result[ele.field] = ele.value;
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `billing_rate` (`id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc`) VALUES('" + result.idtariff + "', '" + result.idpriority + "' , '" + result.feature + "', '" + result.usage + "' ,'" + result.disconnect + "', '" + result.setup + "', '" + result.recurringmrc + "', '" + result.portinnrc + "', '" + result.portoutnrc + "')";
                obj.prepare();
                obj.execute((error, data) => {
                });
            });
            let objv = new RawView_1.RawView(res);
            objv.prepare({ message: "Rate Saved Successfully!" });
            objv.execute();
        });
    }
    updateData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `billing_rate` SET `feature`='" + result.feature + "', `usage`='" + result.usage + "', `disconnect`='" + result.disconnect + "', `setup`='" + result.setup + "', `recurring_mrc`='" + result.recurringmrc + "', `port_in_nrc`='" + result.portinnrc + "', `port_out_nrc`='" + result.portoutnrc + "' WHERE `idbilling_rate`= '" + result.idbillingrate + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    UploadCSV(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let sdata = {};
        let session = new Session_1.SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var sdata = req.body;
                let objfile = new ModelPdfUpload_1.ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let tier_csv = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'");
                obj.nonqrysql = "INSERT INTO `upload` (`FileName`,`DestinationPath`,`FileType`,`UserID`)	VALUES ('" + tier_csv + "', '" + req.file.destination + "', '" + req.body.filetype + "','" + req.body.sessionid + "')";
                obj.prepare();
                obj.execute((error, lastid) => {
                    let objv = new RawView_1.RawView(res);
                    let filepath = req.file.destination + tier_csv;
                    objv.prepare({ message: "Rate CSV Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getTierFeature(req, res, next) {
        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
        obj2.qrysql = "SELECT idinbound_rates, feature FROM billing_feature";
        obj2.prepare();
        obj2.execute((error, allcamp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                error: 0,
                data: allcamp,
                message: "Data Fetched Successfully"
            });
            objv.execute();
        });
    }
    getBillingRatename(req, res, next) {
        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            obj2.qrysql = "SELECT * FROM billing_ratename";
            obj2.prepare();
            obj2.execute((error, allcamp) => {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error: 0,
                    data: allcamp,
                    message: "Data Fetched Succesfully"
                });
                objv.execute();
            });
        });
    }
    getBillingRate(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select `idbilling_rate`, `id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc` from `billing_rate` where `id_tariff` = '" + req.query.type + "' ORDER BY `idinbound_rates` ASC";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: msg });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // public USA_SMS_Rates(req: Request, res: Response, next: NextFunction) {
    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES('"+sessdata.idaccount+"', '"+result.idtariff+"', '"+result.priority+"' ,'"+result.category+"', '"+result.MO+"', '"+result.MT+"', '"+result.subCategory+"', '"+result.categoryValue+"')";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //              });
    //         });
    //         let objv = new RawView(res);
    //         objv.prepare({ message: "Rate Saved Successfully!" });
    //         objv.execute();
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    Add10DLCA2P(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `10DLC_A2P_surcharge` (`idaccount`, `id_tariff`, `priority` ,`category`, `a`, `b`, `c`, `d`, `e`, `inbound_A2P_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "','" + result.category + "', '" + result.a + "', '" + result.b + "', '" + result.c + "', '" + result.d + "', '" + result.e + "', '" + result.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    TollFreeA2p(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `surcharge_rates` (`idaccount`, `id_tariff`, `type` ,`operator`, `direction`, `sms1`, `sms2`, `mms1`, `mms2`,`a`,`b`,`c`,`d`,`e`,`Inbound_a2p_surcharge`) VALUES('" + sessdata.idaccount + "', '" + element.idtariff + "', '" + element.type + "', '" + element.operator + "', '" + element.direction + "', '" + element.sms1 + "', '" + element.sms2 + "','" + element.sms1 + "', '" + element.sms2 + "', '" + element.a + "', '" + element.b + "','" + element.c + "','" + element.d + "','" + element.e + "', '" + element.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    ShortCodeRate(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `short_code_rates` (`idaccount`, `id_tariff`, `priority` ,`category`, `outbound_message_surcharge`, `inbound_message_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "' ,'" + result.category + "', '" + result.outboundSurcharge + "', '" + result.inboundSurcharge + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    VoiceRates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = [];
                result = req.body.data;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `voice_rates` (`idaccount`, `id_tariff`, `usa_rate`, `canada_rate`) VALUES('" + sessdata.idaccount + "', '" + result.id_tariff + "', '" + result.cvoicerate + "', '" + result.uvoicerate + "')";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Rate Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Get rates 
    GetUSA_SMS_Rates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "select * from `sms_rate` where `id_tariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetCampaignSur_Rates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "select  `displayName`,`rate`,`nrc_rates` from `campaign_cases`";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    Get10DLCA2P(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select * from `10DLC_A2P_surcharge` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetTollFreeA2p(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select * from `tollfree_a2p_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetShortCodeRate(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select * from `short_code_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetVoiceRates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select `id_voicerate`, `id_tariff`, `usa_rate`, `canada_rate` from `voice_rates` where `id_tariff` = '" + req.query.type + "'";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data[0], message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Update Rates
    update10DLCRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `10DLC_A2P_surcharge` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_dlc_a2p` = '" + result.iddlca2p + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateTollFreeRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `tollfree_a2p_rates` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_tollfree` = '" + result.idtollfree + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateSMSRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let idsrt;
                    if (result.idsmsratenew !== null) {
                        idsrt = result.idsmsratenew;
                    }
                    else {
                        idsrt = result.idsmsrate;
                    }
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `sms_rate` SET `MO_rates`='" + result.MO + "', `MT_rates` = '" + result.MT + "' WHERE `idsmsrate` = '" + idsrt + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateShortCodeRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `short_code_rates` SET `outbound_message_surcharge`='" + result.outboundSurcharge + "', `inbound_message_surcharge`='" + result.inboundSurcharge + "' WHERE `idshort_code` = '" + result.idshortcode + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateVoiceRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "update `voice_rates` SET `usa_rate`='" + rdata.uvoicerate + "', `canada_rate`='" + rdata.cvoicerate + "' where `id_voicerate` = '" + rdata.id_voicerate + "'";
                obj2.prepare();
                obj2.execute((error, allcamp) => {
                    if (allcamp) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: allcamp,
                            message: "Rates Updated successfully!"
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: error,
                            message: "Something went wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // Unregistered Rates 
    addvoiceRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `mo`, `mt`, `category`) VALUES ";
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "', '" + result.type + "', '" + result.subtype + "', '" + result.price + "', '" + result.mo + "','" + result.mt + "', '" + result.category + "' ),";
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // addiVoiceApiRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // addDepthVoiceRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // addNumberRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // onSipRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.mo + "', '"+result.mt+"','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // sipNumberPrice(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate` , `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // onDepthVoiceRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"','" + result.mo + "', '" + result.mt + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    onSmsRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `type`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES ";
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "' ,'" + result.category + "', '" + result.type + "' ,'" + result.MO + "', '" + result.MT + "', '" + result.subCategory + "', '" + result.categoryValue + "'),";
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // numberActivationRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"','"+result.priority+"', '"+result.type+"', '"+result.subtype+"','" + result.price + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    //  Get Rates For Customers
    // subCustomerRates(req: Request, res: Response, next: NextFunction) {
    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "select * from `voice_rates` where `idtariff` = '"+sessdata.idtariff+"' AND `type`='"+req.query.type+"' AND `subtype`='"+req.query.subtype+"' ORDER BY `priority` ASC";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
    //                 objv.execute();
    //              });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // Get Single Unregistered rates
    voiceApiRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "select * from `voice_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' AND `subtype`='" + req.query.subtype + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Update Unregistered rates
    unregisteredRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let idrt;
                    if (result.idratesnew !== null) {
                        idrt = result.idratesnew;
                    }
                    else {
                        idrt = result.idrates;
                    }
                    obj2.nonqrysql = "UPDATE `voice_rates` SET `rate`='" + result.price + "', `mo` = '" + result.mo + "', `mt` = '" + result.mt + "' WHERE `idrates` = '" + idrt + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => { });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id
    getSurcharge(req, res, next) {
        console.log(req.query);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id";
                obj.prepare();
                obj.execute((error, data) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    getresellerTraiff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT tr.* FROM `tariff_seller`ts INNER JOIN `tariff`tr ON ts.idtariff=tr.idtariff WHERE ts.`iduser`='" + sessdata.iduser + "';";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    lookupRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select idrates,idaccount,iduser,idtariff,type,rate,category,description,priority from `lookup_api_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Lookup Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    CampaignReviewRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select campaign_rate_id,idaccount,iduser,idtariff,type,rate,category,priority,mrc from `campaign_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Campaign Review Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    get_activatemsg(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select idrates,idaccount,idtariff,type,mrc,nrc,category,priority from `message_activation_pricing` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "'";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Activate Message Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.TierManagement = TierManagement;
