"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppRoute = void 0;
const MysqlManager_1 = require("./model/MysqlManager");
const server_1 = require("../server");
const module_config_1 = require("../config/module.config");
const _404_1 = require("./view/404");
const _405_1 = require("./view/405");
const Management_1 = require("./Management");
class AppRoute {
    sessdata;
    connection;
    filtered;
    constructor() {
        console.log("Calling the management class");
        this.connection = new MysqlManager_1.MysqlManager();
        this.connection.Open();
        let config = new module_config_1.modSession();
        this.connection.sql = "SELECT ?? FROM `" + config.data.table + "`";
        config.data.field.push("authkey");
        this.connection.data = [config.data.field];
        this.connection.Execute((err, data) => {
            if (err == 1) {
                for (let i = 0; i < data.length; i++) {
                    server_1.sessiondata.set(data[i].authkey, data[i]);
                }
            }
            this.connection.Close();
        });
    }
    getMethod(req, res, next) {
        let operation;
        let url = req.url.split("?");
        if (url[0] == "/login") {
            operation = new Management_1.Management(req, res, next);
            operation.UserLogout();
            return;
        }
        else {
            console.log("Current in get Method request with url " + url[0]);
            let modfilter = server_1.getMod.Search(url[0]);
            if (!server_1.getMod.status) {
                let objv = new _404_1.Res404(res);
                objv.prepare({ error: "No routing is set for current request" });
                objv.execute();
                return;
            }
            let filtered = modfilter[0];
            if (modfilter.length > 1) {
                if (req.query.hasOwnProperty("type")) {
                    if (req.query.type != undefined)
                        filtered = server_1.getMod.Type(req.query.type.toString(), modfilter);
                    else {
                        let objv = new _405_1.Res405(res);
                        objv.prepare({ error: "Multiple route define and type is missing in request" });
                        objv.execute();
                        return;
                    }
                }
                else {
                    let objv = new _405_1.Res405(res);
                    objv.prepare({ error: "Multiple route define and type is missing in request" });
                    objv.execute();
                    return;
                }
            }
            console.log(filtered);
            if (filtered.path.length == 0) {
                let objv = new _404_1.Res404(res);
                objv.prepare({ error: "No config found for request" });
                objv.execute();
                return;
            }
            if (filtered.label != undefined) {
                operation = new Management_1.Management(req, res, next);
                operation.filtered = filtered;
                operation.sessdata = server_1.cursess;
                operation.OptionList();
                return;
            }
            else {
                if (filtered.sqlqry != undefined) {
                    operation = new Management_1.Management(req, res, next);
                    operation.filtered = filtered;
                    operation.sessdata = server_1.cursess;
                    operation.RawQryList();
                    return;
                }
                if (filtered.table != undefined) {
                    operation = new Management_1.Management(req, res, next);
                    operation.filtered = filtered;
                    operation.sessdata = server_1.cursess;
                    operation.ListView();
                    return;
                }
                if (filtered.procedure != undefined) {
                    operation = new Management_1.Management(req, res, next);
                    operation.filtered = filtered;
                    operation.sessdata = server_1.cursess;
                    operation.RawProcedureList();
                    return;
                }
            }
        }
    }
    postMethod(req, res, next) {
        let operation;
        let url = req.url.split("?");
        if (url[0] == "/login") {
            operation = new Management_1.Management(req, res, next);
            operation.UserLogin();
            return;
        }
        console.log("Current in post Method request with url " + url[0]);
        let modfilter = server_1.getMod.Search(url[0]);
        if (!server_1.getMod.status) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No routing is set for current request" });
            objv.execute();
            return;
        }
        let filtered = modfilter[0];
        console.log(filtered);
        if (modfilter.length > 1) {
            if (req.query.hasOwnProperty("type")) {
                if (req.query.type != undefined)
                    filtered = server_1.getMod.Type(req.query.type.toString(), modfilter);
                else {
                    let objv = new _405_1.Res405(res);
                    objv.prepare({ error: "Multiple route define and type is missing in request" });
                    objv.execute();
                    return;
                }
            }
            else {
                let objv = new _405_1.Res405(res);
                objv.prepare({ error: "Multiple route define and type is missing in request" });
                objv.execute();
                return;
            }
        }
        if (filtered.path.length == 0) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No config found for request" });
            objv.execute();
            return;
        }
        if (filtered.table != undefined) {
            operation = new Management_1.Management(req, res, next);
            operation.filtered = filtered;
            operation.sessdata = server_1.cursess;
            operation.Save();
        }
    }
    putMethod(req, res, next) {
        let operation;
        let url = req.url.split("?");
        console.log("Current in put method request with url " + url[0]);
        let modfilter = server_1.getMod.Search(url[0]);
        if (!server_1.getMod.status) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No routing is set for current request" });
            objv.execute();
            return;
        }
        let filtered = modfilter[0];
        if (modfilter.length > 1) {
            if (req.query.hasOwnProperty("type")) {
                if (req.query.type != undefined)
                    filtered = server_1.getMod.Type(req.query.type.toString(), modfilter);
                else {
                    let objv = new _405_1.Res405(res);
                    objv.prepare({ error: "Multiple route define and type is missing in request" });
                    objv.execute();
                    return;
                }
            }
            else {
                let objv = new _405_1.Res405(res);
                objv.prepare({ error: "Multiple route define and type is missing in request" });
                objv.execute();
                return;
            }
        }
        console.log(filtered);
        if (filtered.path.length == 0) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No config found for request" });
            objv.execute();
            return;
        }
        if (filtered.table != undefined) {
            operation = new Management_1.Management(req, res, next);
            operation.filtered = filtered;
            operation.sessdata = server_1.cursess;
            operation.Update();
        }
    }
    deleteMethod(req, res, next) {
        let operation;
        let url = req.url.split("?");
        console.log("Current in delete method request with url " + url[0]);
        let modfilter = server_1.getMod.Search(url[0]);
        if (!server_1.getMod.status) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No routing is set for current request" });
            objv.execute();
            return;
        }
        let filtered = modfilter[0];
        if (modfilter.length > 1) {
            if (req.query.hasOwnProperty("type")) {
                if (req.query.type != undefined)
                    filtered = server_1.getMod.Type(req.query.type.toString(), modfilter);
                else {
                    let objv = new _405_1.Res405(res);
                    objv.prepare({ error: "Multiple route define and type is missing in request" });
                    objv.execute();
                    return;
                }
            }
            else {
                let objv = new _405_1.Res405(res);
                objv.prepare({ error: "Multiple route define and type is missing in request" });
                objv.execute();
                return;
            }
        }
        if (filtered.path.length == 0) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No config found for request" });
            objv.execute();
            return;
        }
        if (filtered.table != undefined) {
            operation = new Management_1.Management(req, res, next);
            operation.filtered = filtered;
            operation.sessdata = server_1.cursess;
            operation.Delete();
        }
    }
    patchMethod(req, res, next) {
        console.log(req.query);
        let operation;
        let url = req.url.split("?");
        console.log("Current in patch method request with url " + url[0]);
        let modfilter = server_1.getMod.Search(url[0]);
        if (!server_1.getMod.status) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No routing is set for current request" });
            objv.execute();
            return;
        }
        let filtered = modfilter[0];
        console.log(filtered);
        if (modfilter.length > 1) {
            if (req.query.hasOwnProperty("type")) {
                if (req.query.type != undefined)
                    filtered = server_1.getMod.Type(req.query.type.toString(), modfilter);
                else {
                    let objv = new _405_1.Res405(res);
                    objv.prepare({ error: "Multiple route define and type is missing in request" });
                    objv.execute();
                    return;
                }
            }
            else {
                let objv = new _405_1.Res405(res);
                objv.prepare({ error: "Multiple route define and type is missing in request" });
                objv.execute();
                return;
            }
        }
        if (filtered.path.length == 0) {
            let objv = new _404_1.Res404(res);
            objv.prepare({ error: "No config found for request" });
            objv.execute();
            return;
        }
        /* if(filtered.label !=undefined)
        {
            operation=new Management(req, res, next);
            operation.filtered=filtered;
            operation.sessdata=cursess;
            return;
        } */
        if (filtered.table != undefined) {
            operation = new Management_1.Management(req, res, next);
            operation.filtered = filtered;
            operation.sessdata = server_1.cursess;
            operation.Update();
            return;
        }
        else {
            if (filtered.sqlqry != undefined) {
                operation = new Management_1.Management(req, res, next);
                operation.filtered = filtered;
                operation.sessdata = server_1.cursess;
                operation.RawQryList();
                return;
            }
        }
    }
}
exports.AppRoute = AppRoute;
