"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelLogin = void 0;
const ModelObject_1 = require("./ModelObject");
const module_config_1 = require("../../config/module.config");
const _403_1 = require("../view/403");
const md5_1 = __importDefault(require("md5"));
class ModelLogin extends ModelObject_1.ModelObject {
    prepare(config) {
        var ret = true;
        if (config == undefined)
            config = new module_config_1.modLogin();
        let paramdata;
        if (this.req.body.data == undefined) {
            try {
                paramdata = this.req.body;
            }
            catch (error) {
                ;
                paramdata = this.req.body;
            }
        }
        else {
            try {
                paramdata = JSON.parse(this.req.body.data);
            }
            catch (error) {
                paramdata = this.req.body.data;
            }
        }
        this.table = config.data.table;
        this.query.field = config.data.selectfield;
        let uname = "", passwd = "";
        if (paramdata.hasOwnProperty(config.data.postfield[0].field)) {
            uname = paramdata[config.data.postfield[0].field];
        }
        else {
            let objv = new _403_1.Res403(this.res);
            objv.prepare({ error: "Invalid Username/Password, Kindly check again." });
            objv.execute();
            return false;
        }
        if (paramdata.hasOwnProperty(config.data.postfield[1].field)) {
            if (config.data.md5)
                passwd = (0, md5_1.default)(paramdata[config.data.postfield[1].field]);
            else
                passwd = paramdata[config.data.postfield[1].field];
        }
        else {
            let objv = new _403_1.Res403(this.res);
            objv.prepare({ error: "Invalid Username/Password, Kindly check again." });
            objv.execute();
            return false;
        }
        this.query.isfilter = true;
        let dbfield = config.data.tablefield;
        let filter = {};
        if (config.data.filter == undefined)
            filter = "{\"" + dbfield[0] + "\":\"" + uname + "\", \"" + dbfield[1] + "\":\"" + passwd + "\"}";
        else {
            filter = config.data.filter;
            filter[dbfield[0]] = uname;
            filter[dbfield[1]] = passwd;
        }
        try {
            this.query.filter = JSON.parse(filter);
        }
        catch (e) {
            this.query.filter = filter;
        }
        this.query.isfilter = true;
        return ret;
    }
    execute(callback) {
        this.query.prepare();
        this.query.Row((err, data) => {
            if (err > 1)
                err = 8;
            if (err == 1)
                err = 2;
            this.respond(err, data, callback);
        });
    }
}
exports.ModelLogin = ModelLogin;
