"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonQuery = void 0;
const MysqlManager_1 = require("./MysqlManager");
const log_1 = require("./log");
class NonQuery {
    connection;
    log;
    _name;
    _data;
    _table;
    _type;
    _filter;
    _isfilter = false;
    constructor() {
        this.connection = new MysqlManager_1.MysqlManager();
        this.log = new log_1.Log();
        this._table = "";
        this._type = "";
    }
    get data() {
        return this._data;
    }
    set data(val) {
        this._data = val;
    }
    get name() {
        return this._name;
    }
    set name(val) {
        this._name = val;
    }
    get table() {
        return this._table;
    }
    set table(val) {
        this._table = val;
    }
    get type() {
        return this._type;
    }
    set type(val) {
        this._type = val;
    }
    get filter() {
        return this._filter;
    }
    set filter(val) {
        this._filter = val;
    }
    get isfilter() {
        return this._isfilter;
    }
    set isfilter(val) {
        this._isfilter = val;
    }
    get sql() {
        return this.connection.sql;
    }
    // public set sql(val){
    // 	this.connection.sql=val;
    // }
    set sql(val) {
        this.connection.sql = val.replace(/undefined/g, "").replace(/null/g, "");
    }
    get last() {
        return this.last;
    }
    prepare() {
        this.log.Debug("Your table is set to :" + this._table);
        var sql = "";
        var tmp3 = "";
        if (this._table.toString().length > 0) {
            switch (this._type.toUpperCase()) {
                case 'INSERT':
                    {
                        sql = "INSERT INTO `" + this._table + "` SET ? ";
                        this.connection.data = this._data;
                        break;
                    }
                case 'UPDATE':
                    {
                        if (this._isfilter) {
                            Object.entries(this._filter).forEach(([key, value]) => { console.log(key, value); tmp3 += "`" + key + "`='" + value + "' AND "; });
                            tmp3 = tmp3.replace(/ AND\s*$/, "");
                            this.log.Debug("Called with data and filter");
                            sql = "UPDATE `" + this._table + "` SET ? WHERE " + tmp3;
                            //this.connection.data=[this._data, this._filter];
                            this.connection.data = [this._data];
                        }
                        else {
                            this.log.Debug("Called with only data");
                            sql = "UPDATE `" + this._table + "` SET ?";
                            this.connection.data = this._data;
                        }
                        console.log(this.connection);
                        break;
                    }
                case 'DELETE':
                    {
                        if (this._isfilter) {
                            Object.entries(this._filter).forEach(([key, value]) => { console.log(key, value); tmp3 += "`" + key + "`='" + value + "' AND "; });
                            tmp3 = tmp3.replace(/ AND\s*$/, "");
                            sql = "DELETE FROM `" + this._table + "` WHERE " + tmp3;
                            //this.connection.data=this._filter;
                        }
                    }
                case 'PROCEDURE': {
                    if (this._isfilter) {
                        Object.entries(this._filter).forEach(([key, value]) => { tmp3 += "'" + value + "', "; });
                        tmp3 = tmp3.substring(1, tmp3.length - 2);
                        sql = "CALL `" + this._name + "` (" + tmp3 + ")";
                        console.log(sql);
                        //this.connection.data=this._filter;
                    }
                }
                default:
                    this.log.Debug("Request type is not defined(INSERT/UPDATE/DELETE) properly.");
            }
        }
        else {
            this.log.Debug("Table is not defined properly.");
            return;
        }
        console.log(sql);
        this.connection.sql = sql;
    }
    raw_prepare() {
        this.log.Debug(this.connection.sql);
        //this.connection.sql=sql;
    }
    Raw_Execute(callback) {
        this.log.Debug("Calling Raw Execute function in NonQuery");
        this.connection.Open();
        this.connection.RawExecute((err, data) => {
            callback(err, data);
        });
        this.connection.Close();
        /*delete this.connection.sql;
        delete this._type;
        delete this._filter;
        delete this._table;*/
        this.log.Debug("End of Calling Raw Execute function in NonQuery");
    }
    Execute(callback) {
        this.log.Debug("Calling Execute function in NonQuery");
        this.connection.Open();
        this.connection.NonExecute((err, data) => {
            callback(err, data);
        });
        this.connection.Close();
        /*delete this.connection.sql;
        delete this._type;
        delete this._filter;
        delete this._table;*/
        this.log.Debug("End of Calling Execute function in NonQuery");
    }
    LoadFileExecute(callback) {
        this.log.Debug("Calling Raw Execute function in NonQuery");
        this.connection.Open();
        this.connection.LoadFile((err, data) => {
            callback(err, data);
        });
        this.connection.Close();
        /*delete this.connection.sql;
        delete this._type;
        delete this._filter;
        delete this._table;*/
        this.log.Debug("End of Calling Raw Execute function in NonQuery");
    }
}
exports.NonQuery = NonQuery;
