"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Query = void 0;
const MysqlManager_1 = require("./MysqlManager");
const log_1 = require("./log");
class Query {
    connection;
    data;
    log;
    _status;
    _filter;
    _table;
    _field;
    _group;
    _order;
    _isgroup = false;
    _isorder = false;
    _isfilter = false;
    _isSQL = false;
    _limit = -1;
    _where = false;
    constructor() {
        this.log = new log_1.Log();
        this.connection = new MysqlManager_1.MysqlManager();
        this._status = false;
        this._table = "";
        this._field = [];
        this._group = [];
        this._order = [];
    }
    get field() {
        return this._field;
    }
    set field(val) {
        this._field = val;
    }
    get table() {
        return this._table;
    }
    set table(val) {
        this._table = val;
    }
    get where() {
        return this._where;
    }
    set where(val) {
        this._where = val;
    }
    get isSQL() {
        return this._isSQL;
    }
    set isSQL(val) {
        this._isSQL = val;
    }
    get isfilter() {
        return this._isfilter;
    }
    set isfilter(val) {
        this._isfilter = val;
    }
    get isgroup() {
        return this._isgroup;
    }
    set isgroup(val) {
        this._isgroup = val;
    }
    get isorder() {
        return this._isorder;
    }
    set isorder(val) {
        this._isorder = val;
    }
    get filter() {
        return this._filter;
    }
    set filter(val) {
        this._filter = val;
    }
    get sql() {
        return this.connection.sql;
    }
    // public set sql(val){
    // 	this.connection.sql=val;
    // }
    set sql(val) {
        this.connection.sql = val.replace(/undefined/g, "").replace(/null/g, "");
    }
    get status() {
        return this._status;
    }
    set group(val) {
        this._group = val;
    }
    get group() {
        return this._group;
    }
    set order(val) {
        this._order = val;
    }
    get order() {
        return this._order;
    }
    set limit(val) {
        this._limit = val;
    }
    get limit() {
        return this._limit;
    }
    prepare() {
        this.log.Debug("Query table is set to :" + this._table);
        let sql;
        if (this._isSQL) {
            sql = this.connection.sql;
        }
        else
            sql = "SELECT ?? FROM `" + this._table + "`";
        var tmp3 = "";
        if (this._isfilter) {
            console.log(this._filter);
            Object.entries(this._filter).forEach(([key, value]) => { console.log(key, value); tmp3 += "`" + key + "`='" + value + "' AND "; });
            tmp3 = tmp3.replace(/ AND\s*$/, "");
            sql = sql + " WHERE " + tmp3;
        }
        if (!this._isSQL)
            this.connection.data = [this._field];
        if (this._isgroup) {
            sql = sql + " GROUP BY " + this._group;
        }
        if (this._isorder) {
            sql = sql + " ORDER BY " + this._order;
        }
        if (this._limit > 0) {
            sql = sql + " limit " + this._limit;
        }
        this.connection.sql = sql;
        console.log(sql);
        this.log.Debug("End of Calling prepare function in Query");
    }
    rawprepare() {
        let sql = "";
        if (this._isSQL)
            sql = this.connection.sql;
        else
            return;
        var tmp3 = "";
        if (this._isfilter) {
            console.log(this._filter);
            Object.entries(this._filter).forEach(([key, value]) => { console.log(key, value); tmp3 += "" + key + "='" + value + "' AND "; });
            tmp3 = tmp3.replace(/ AND\s*$/, "");
            if (this._where)
                sql = sql + " WHERE " + tmp3;
            else
                sql = sql + tmp3;
        }
        else {
            sql = sql.replace(/ AND\s*$/, "");
        }
        if (!this._isSQL)
            this.connection.data = [this._field];
        if (this._isgroup) {
            sql = sql + " GROUP BY " + this._group;
        }
        if (this._isorder) {
            sql = sql + " ORDER BY " + this._order;
        }
        if (this._limit > 0) {
            sql = sql + " LIMIT " + this._limit;
        }
        this.connection.sql = sql;
        this.log.Debug("End of Calling prepare function in Query");
    }
    raw_prepare() {
        this.log.Debug("Raw Prepare Called :" + this.connection.sql);
        //this.connection.sql=sql;
    }
    Raw_Execute(callback) {
        if (typeof callback === 'function') {
            console.log("Query with callback function in RawExecute Function, with query :" + this.sql);
            this.connection.Open();
            this.data = this.connection.RawExecute((err, data) => {
                // console.log(data);
                callback(err, data);
                this.connection.Close();
            });
            // this.connection.Close();
            /*delete this.connection.sql;
            delete this._filter;
            delete this._table;*/
        }
        else {
            console.log("Query with Invalid callback function in RawExecute Function");
        }
    }
    Execute(callback) {
        if (typeof callback === 'function') {
            console.log("Query with callback function in Execute Function, with query :" + this.sql);
            this.connection.Open();
            this.data = this.connection.Execute((err, data) => {
                // console.log(data);
                callback(err, data);
                this.connection.Close();
            });
            //this.connection.Close();
            /*delete this.connection.sql;
            delete this._filter;
            delete this._table;	*/
        }
        else {
            console.log("Query with Invalid callback function in Execute Function");
        }
    }
    DataSet(callback) {
        if (typeof callback === 'function') {
            console.log("Query with callback function in DataSet Function, with query :" + this.sql);
            this.connection.Open();
            this.data = this.connection.DataSet((err, data) => {
                // console.log(data);
                callback(err, data);
                this.connection.Close();
            });
            //this.connection.Close();
            /*delete this.connection.sql;
            delete this._filter;
            delete this._table;*/
        }
        else {
            console.log("Query with Invalid callback function in DataSet Function.");
        }
    }
    Row(callback) {
        if (typeof callback === 'function') {
            console.log("Query with callback function in Row Function, with query :" + this.sql);
            this.connection.Open();
            this.data = this.connection.Row((err, data) => {
                // console.log(data);
                callback(err, data);
                this.connection.Close();
            });
            //this.connection.Close();
            /*delete this.connection.sql;
            delete this._filter;
            delete this._table;*/
        }
        else {
            console.log("Query with Invalid callback function in Row Function.");
        }
    }
}
exports.Query = Query;
