"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadData = void 0;
const UserInterface_1 = require("./UserInterface");
const fs_1 = __importDefault(require("fs"));
class DownloadData extends UserInterface_1.UserInterface {
    fileToSend;
    prepare(result) {
        if (result == null || result.length < 1)
            this._status = false;
        else {
            this._status = true;
            var stat = fs_1.default.statSync(result.path + result.filename + "." + result.type);
            this.fileToSend = fs_1.default.readFileSync(result.path + result.filename + "." + result.type);
            this.response.set('Content-Description', 'File Transfer');
            this.response.set('Content-Type', 'application/' + result.type);
            this.response.set('Content-Length', stat.size.toString());
            this.response.set('Content-Disposition', result.filename + "." + result.type);
            this.response.set('Expires', '0');
            /* try{
                fs.unlinkSync(result.path+result.filename+"."+result.type);
            } catch(e){
                console.log(e);
            } */
        }
    }
    execute() {
        if (this._status)
            this.response.end(this.fileToSend);
        else
            this.response.status(404).send({ error: "Data is not found" });
    }
}
exports.DownloadData = DownloadData;
