"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatData = void 0;
const UserInterface_1 = require("./UserInterface");
class ChatData extends UserInterface_1.UserInterface {
    _chartype = {};
    _stacked;
    _series = [];
    _label;
    _field;
    _xaxis;
    _size;
    _zoom;
    _yaxis = [];
    _width = [4, 4, 4, 4];
    zoomdetails;
    toolbar;
    constructor(res) {
        super(res);
        this._stacked = false;
        this._size = 200;
        this._zoom = false;
        this.zoomdetails = { type: "x", enabled: false, autoScaleYaxis: false };
    }
    get ChartType() {
        return this._chartype;
    }
    set ChartType(val) {
        this._chartype = val;
    }
    get Stacked() {
        return this._chartype;
    }
    set Stacked(val) {
        this._stacked = val;
    }
    set Xaxis(val) {
        this._xaxis = val;
    }
    get Xaxis() {
        return this._xaxis;
    }
    get Field() {
        return this._field;
    }
    set Field(val) {
        this._field = val;
    }
    get Size() {
        return this._size;
    }
    set Size(val) {
        this._size = val;
    }
    get Zoom() {
        return this._zoom;
    }
    set Zoom(val) {
        this.zoomdetails = { type: "x", enabled: val, autoScaleYaxis: val };
        this._zoom = val;
    }
    prepare(data) {
        this._data = data;
    }
    getSingleSeries(series) {
        let temp = [];
        let fld;
        //console.log(series[0]);
        Object.entries(series[0]).forEach((e) => {
            fld = e[1];
        });
        //console.log(this._data);
        this._data.forEach((ele) => {
            temp.push(ele[fld]);
        });
        //console.log(temp);
        this._series = temp;
    }
    getSingleCategory(field) {
        let temp = [];
        let fld;
        //console.log(field[0]);
        Object.entries(field[0]).forEach((e) => {
            fld = e[1];
        });
        //console.log(this._data);
        this._data.forEach((ele) => {
            temp.push(ele[fld]);
        });
        //console.log(temp);
        this._label = temp;
    }
    getConsolidatedSeries(field) {
        let series = [];
        console.log("Current fields " + field);
        console.log("Current data " + this._data);
        field.forEach((fields) => {
            if (this._data.length > 0) {
                if (this._data[0].hasOwnProperty(fields.series)) {
                    let tmp;
                    if (this._chartype == "bar" || this._chartype == "area" || this._chartype == "line") {
                        this._series = undefined;
                    }
                    else if (this._chartype == "pie" || this._chartype == "donut" || this._chartype == "radialBar") {
                        tmp = 0;
                        this._data.forEach((ele) => {
                            tmp += ele[fields.series];
                        });
                        series.push(tmp);
                    }
                    else
                        tmp = 0;
                }
            }
        });
        if (this._chartype == "radialBar") {
            let max = 0;
            series.forEach((element) => {
                if (element > max)
                    max = parseInt(element);
            });
            let tmp = [];
            series.forEach((element) => {
                tmp.push(Math.ceil(parseInt(element) * 100 / max));
            });
            series = tmp;
        }
        this._series = series;
    }
    getConsolidatedCategory(field) {
        let series = [];
        if (this._chartype == "bar" || this._chartype == "area" || this._chartype == "line") {
            this._label = undefined;
        }
        else {
            field.forEach((fields) => {
                series.push(fields.title);
            });
        }
        this._label = series;
    }
    getMax(data) {
        let max = 0;
        data.forEach((element) => {
            if (element > max)
                max = element;
        });
        return max;
    }
    getMin(data) {
        let min = 10000000000;
        data.forEach((element) => {
            if (element < min)
                min = element;
        });
        return min;
    }
    getMixedSeries(field) {
        let tmp = [];
        const color = ["#008FFB", "#00E396", "#FEB019"];
        let i = 0;
        field.forEach((element) => {
            tmp[i] = [];
            if (element.type == undefined)
                this._series.push({ name: element.title, data: [] });
            else
                this._series.push({ name: element.title, type: element.type, data: [] });
            if (element.type != undefined) {
                if (i == 0)
                    this._yaxis.push({ axisTicks: { show: true }, axisBorder: { show: true, color: color[i] }, labels: { style: { color: color[i] } }, title: { text: element.title, style: { color: color[i] } }, tooltip: { enabled: true } });
                else
                    this._yaxis.push({ seriesName: element.title, opposite: true, axisTicks: { show: true }, axisBorder: { show: true, color: color[i] }, labels: { style: { color: color[i] } }, title: { text: element.title, style: { color: color[i] } }, tooltip: { enabled: true } });
            }
            else
                this._yaxis = [{ title: { text: undefined } }];
            i++;
        });
        this._data.forEach((ele) => {
            let t = 0;
            Object.entries(ele).forEach((e) => {
                field.forEach((element) => {
                    if (e[0] == element.series) {
                        tmp[t].push(Math.ceil(e[1]));
                        t++;
                    }
                });
            });
        });
        i = 0;
        /*let tmp1:any=[];
        let fact:any=[];
        this._series.forEach((element:any) => {
            let min=Math.ceil(this.getMin(tmp[i])/100);
            console.log("Current min :"+min);
            tmp1[i]=[];
            if(min>1000000)
                fact.push(1000000);
            else if(min>100000 && min<1000000)
                fact.push(100000);
            else if(min>10000 && min<100000)
                fact.push(10000);
            else if(min>1000 && min<10000)
                fact.push(1000);
            else if(min>100 && min<1000)
                fact.push(100);
            else
                fact.push(element);

            tmp[i].forEach((element:any) => {
                if(min>1000000)
                    tmp1[i].push(Math.ceil(element/1000000));
                else if(min>100000 && min<1000000)
                    tmp1[i].push(Math.ceil(element/100000));
                else if(min>10000 && min<100000)
                    tmp1[i].push(Math.ceil(element/10000));
                else if(min>1000 && min<10000)
                    tmp1[i].push(Math.ceil(element/1000));
                else if(min>100 && min<1000)
                    tmp1[i].push(Math.ceil(element/100));
                else
                    tmp1[i].push(element);
            });
            i++;
        });*/
        i = 0;
        this._series.forEach((element) => {
            element["data"] = tmp[i++];
        });
    }
    getMixedCategory(name) {
        let tmp = [];
        console.log(name);
        this._data.forEach((ele) => {
            Object.entries(ele).forEach((e) => {
                if (e[0] == name.series)
                    tmp.push(e[1]);
            });
        });
        this._label = tmp;
    }
    execute() {
        let options;
        if (this._series == undefined)
            this.response.status(200).send("No Data");
        if (this._chartype == "bar" || this._chartype == "area" || this._chartype == "line") {
            options = {
                series: this._series,
                chart: { type: this._chartype, height: this._size, stacked: this._stacked, zoom: this.zoomdetails, toolbar: { autoSelected: "zoom" } },
                plotOptions: { bar: { horizontal: false } },
                dataLabels: { enabled: false },
                stroke: { width: this._width },
                xaxis: { categories: this._label },
                yaxis: this._yaxis,
                tooltip: {
                    fixed: {
                        enabled: true,
                        position: "topLeft", // topRight, topLeft, bottomRight, bottomLeft
                        offsetY: 30,
                        offsetX: 60
                    }
                },
                fill: { opacity: 1 },
                legend: { position: "top", horizontalAlign: "left", offsetX: 40 }
            };
            //console.log(JSON.stringify(options));
        }
        else if (this._chartype == "pie" || this._chartype == "donut" || this._chartype == "radialBar") {
            options = {
                series: this._series,
                chart: {
                    width: this._size,
                    type: this._chartype
                },
                labels: this._label,
                responsive: [
                    {
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200
                            },
                            legend: {
                                position: "bottom",
                                show: false
                            }
                        }
                    }
                ],
                legend: { position: "bottom", horizontalAlign: 'center', show: false }
            };
            //console.log(options);
        }
        this.response.status(200).send(options);
    }
}
exports.ChatData = ChatData;
