'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var InstalledAddOnExtensionList = require(
    './installedAddOn/installedAddOnExtension').InstalledAddOnExtensionList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var InstalledAddOnList;
var InstalledAddOnPage;
var InstalledAddOnInstance;
var InstalledAddOnContext;

/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnList
 *
 * @param {Twilio.Preview.Marketplace} version - Version of the resource
 */
/* jshint ignore:end */
InstalledAddOnList = function InstalledAddOnList(version) {
  /* jshint ignore:start */
  /**
   * @function installedAddOns
   * @memberof Twilio.Preview.Marketplace#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Marketplace.InstalledAddOnContext}
   */
  /* jshint ignore:end */
  function InstalledAddOnListInstance(sid) {
    return InstalledAddOnListInstance.get(sid);
  }

  InstalledAddOnListInstance._version = version;
  // Path Solution
  InstalledAddOnListInstance._solution = {};
  InstalledAddOnListInstance._uri = `/InstalledAddOns`;
  /* jshint ignore:start */
  /**
   * create a InstalledAddOnInstance
   *
   * @function create
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.availableAddOnSid -
   *          The SID of the AvaliableAddOn to install
   * @param {boolean} opts.acceptTermsOfService -
   *          Whether the Terms of Service were accepted
   * @param {object} [opts.configuration] -
   *          The JSON object representing the configuration
   * @param {string} [opts.uniqueName] -
   *          An application-defined string that uniquely identifies the resource
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed InstalledAddOnInstance
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.availableAddOnSid)) {
      throw new Error('Required parameter "opts.availableAddOnSid" missing.');
    }
    if (_.isUndefined(opts.acceptTermsOfService)) {
      throw new Error('Required parameter "opts.acceptTermsOfService" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'AvailableAddOnSid': _.get(opts, 'availableAddOnSid'),
      'AcceptTermsOfService': serialize.bool(_.get(opts, 'acceptTermsOfService')),
      'Configuration': serialize.object(_.get(opts, 'configuration')),
      'UniqueName': _.get(opts, 'uniqueName')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new InstalledAddOnInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams InstalledAddOnInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists InstalledAddOnInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of InstalledAddOnInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new InstalledAddOnPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of InstalledAddOnInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new InstalledAddOnPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a installed_add_on
   *
   * @function get
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @param {string} sid - The SID of the InstalledAddOn resource to fetch
   *
   * @returns {Twilio.Preview.Marketplace.InstalledAddOnContext}
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.get = function get(sid) {
    return new InstalledAddOnContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  InstalledAddOnListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  InstalledAddOnListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return InstalledAddOnListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnPage
 *
 * @param {Marketplace} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {InstalledAddOnSolution} solution - Path solution
 *
 * @returns InstalledAddOnPage
 */
/* jshint ignore:end */
InstalledAddOnPage = function InstalledAddOnPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(InstalledAddOnPage.prototype, Page.prototype);
InstalledAddOnPage.prototype.constructor = InstalledAddOnPage;

/* jshint ignore:start */
/**
 * Build an instance of InstalledAddOnInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnPage#
 *
 * @param {InstalledAddOnPayload} payload - Payload response from the API
 *
 * @returns InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnPage.prototype.getInstance = function getInstance(payload) {
  return new InstalledAddOnInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
InstalledAddOnPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

InstalledAddOnPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} description -
 *          A short description of the Add-on's functionality
 * @property {object} configuration -
 *          The JSON object that represents the current configuration of installed Add-on
 * @property {string} uniqueName -
 *          An application-defined string that uniquely identifies the resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the resource
 * @property {string} links - The URLs of related resources
 *
 * @param {Marketplace} version - Version of the resource
 * @param {InstalledAddOnPayload} payload - The instance payload
 * @param {sid} sid - The SID of the InstalledAddOn resource to fetch
 */
/* jshint ignore:end */
InstalledAddOnInstance = function InstalledAddOnInstance(version, payload, sid)
                                                          {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.description = payload.description; // jshint ignore:line
  this.configuration = payload.configuration; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(InstalledAddOnInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new InstalledAddOnContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * remove a InstalledAddOnInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * fetch a InstalledAddOnInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a InstalledAddOnInstance
 *
 * @function update
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.configuration] -
 *          The JSON object representing the configuration
 * @param {string} [opts.uniqueName] -
 *          An application-defined string that uniquely identifies the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the extensions
 *
 * @function extensions
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnInstance#
 *
 * @returns {Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList}
 */
/* jshint ignore:end */
InstalledAddOnInstance.prototype.extensions = function extensions() {
  return this._proxy.extensions;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
InstalledAddOnInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

InstalledAddOnInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnContext
 *
 * @property {Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList} extensions -
 *          extensions resource
 *
 * @param {Marketplace} version - Version of the resource
 * @param {sid} sid - The SID of the InstalledAddOn resource to fetch
 */
/* jshint ignore:end */
InstalledAddOnContext = function InstalledAddOnContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/InstalledAddOns/${sid}`;

  // Dependents
  this._extensions = undefined;
};

/* jshint ignore:start */
/**
 * remove a InstalledAddOnInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a InstalledAddOnInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new InstalledAddOnInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a InstalledAddOnInstance
 *
 * @function update
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.configuration] -
 *          The JSON object representing the configuration
 * @param {string} [opts.uniqueName] -
 *          An application-defined string that uniquely identifies the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnInstance
 */
/* jshint ignore:end */
InstalledAddOnContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Configuration': serialize.object(_.get(opts, 'configuration')),
    'UniqueName': _.get(opts, 'uniqueName')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new InstalledAddOnInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(InstalledAddOnContext.prototype,
  'extensions', {
    get: function() {
      if (!this._extensions) {
        this._extensions = new InstalledAddOnExtensionList(this._version, this._solution.sid);
      }
      return this._extensions;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
InstalledAddOnContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

InstalledAddOnContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  InstalledAddOnList: InstalledAddOnList,
  InstalledAddOnPage: InstalledAddOnPage,
  InstalledAddOnInstance: InstalledAddOnInstance,
  InstalledAddOnContext: InstalledAddOnContext
};
