/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import TrustedComms = require('../../TrustedComms');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the ChannelList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param brandedChannelSid - Branded Channel Sid.
 */
declare function ChannelList(version: TrustedComms, brandedChannelSid: string): ChannelListInstance;

interface ChannelListInstance {
  /**
   * create a ChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ChannelListInstanceCreateOptions, callback?: (error: Error | null, item: ChannelInstance) => any): Promise<ChannelInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property phoneNumberSid - Phone Number Sid to be branded.
 */
interface ChannelListInstanceCreateOptions {
  phoneNumberSid: string;
}

interface ChannelPayload extends ChannelResource, Page.TwilioResponsePayload {
}

interface ChannelResource {
  account_sid: string;
  brand_sid: string;
  branded_channel_sid: string;
  business_sid: string;
  phone_number: string;
  phone_number_sid: string;
  url: string;
}

interface ChannelSolution {
  brandedChannelSid?: string;
}


declare class ChannelInstance extends SerializableClass {
  /**
   * Initialize the ChannelContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param brandedChannelSid - Branded Channel Sid.
   */
  constructor(version: TrustedComms, payload: ChannelPayload, brandedChannelSid: string);

  accountSid: string;
  brandSid: string;
  brandedChannelSid: string;
  businessSid: string;
  phoneNumber: string;
  phoneNumberSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class ChannelPage extends Page<TrustedComms, ChannelPayload, ChannelResource, ChannelInstance> {
  /**
   * Initialize the ChannelPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: ChannelSolution);

  /**
   * Build an instance of ChannelInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ChannelPayload): ChannelInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ChannelInstance, ChannelList, ChannelListInstance, ChannelListInstanceCreateOptions, ChannelPage, ChannelPayload, ChannelResource, ChannelSolution }
